/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupMultipleTextfieldTile;
import de.cni.client.gui.util.ErrorHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupMultipleTextfieldDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupMultipleTextfieldDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    PopupMultipleTextfieldTile tile = null;
    String value1;
    String value2;
    boolean onlyInfoPopup;
    int limit = 0;

    public PopupMultipleTextfieldDialog(Shell parentShell, int limit, String name1, String name2, String value1, String value2) {
        super(parentShell);
        this.value1 = value1;
        this.value2 = value2;
        this.tile = new PopupMultipleTextfieldTile(name1, name2);
        this.onlyInfoPopup = false;
        this.limit = limit;
    }

    public PopupMultipleTextfieldDialog(Shell parentShell, int limit, String name1, String name2, String value1, String value2, boolean onlyInfoPopup) {
        super(parentShell);
        this.value1 = value1;
        this.value2 = value2;
        this.tile = new PopupMultipleTextfieldTile(name1, name2);
        this.onlyInfoPopup = onlyInfoPopup;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle("Daten erfassen");
            this.setMessage("Bitte erg\u00e4nzen Sie die Daten.", 1);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite, this.limit);
            this.tile.enable(!this.onlyInfoPopup);
            this.tile.setData(this.value1, this.value2);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.value1 = null;
            this.value2 = null;
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.value1 = this.tile.getValue1();
                this.value2 = this.tile.getValue2();
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public String getValue1() {
        return this.value1;
    }

    public String getValue2() {
        return this.value2;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (!this.onlyInfoPopup) {
            this.createButton(parent, 2, "Leer", false);
            this.createButton(parent, 1, "Abbrechen", false);
        }
    }
}

