/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.pages.personendaten.PersonendatenController;
import de.cni.client.gui.popup.filter.ExchangeParameter;
import de.cni.client.gui.popup.filter.PopupPlanetenzyklusTile;
import de.cni.client.gui.popup.page.PopupPageDialog;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.DateChooserWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.calculation.Horoskop;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Formatter;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.MappingException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class PopupHoroskopUndZeitraumTile {
    private static Log log = LogFactory.getLog(PopupHoroskopUndZeitraumTile.class);
    final int layoutNumColumns = 3;
    public ExchangeParameter exchangeParameter = null;
    private ComboWrapper horoskop;
    private ComboWrapper planet1;
    private ComboWrapper zeitraum;
    private DateChooserWrapper von;
    private DateChooserWrapper bis;
    private TextWrapper person1;
    private TextWrapper person2;
    private ButtonWrapper person1Button;
    private ButtonWrapper person2Button;
    private ButtonWrapper exchangeButton;
    private DateChooserWrapper date;
    private ButtonWrapper automatischSpeichern;
    int switchCounter = 0;
    private IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    private WidgetFactory guiUtil = new WidgetFactory(1);

    protected PopupHoroskopUndZeitraumTile() {
        this.exchangeParameter = new ExchangeParameter();
        this.exchangeParameter.personendaten1 = new Personendaten();
        this.exchangeParameter.personendaten2 = new Personendaten();
    }

    protected void createContent(Composite parent) throws MappingException {
        Composite spacer = GuiContainer.newSpacer(parent);
        Composite c = GuiContainer.newComposite(spacer, 3);
        this.guiUtil.createLabel(c, "Horoskop");
        this.horoskop = this.guiUtil.createCombo(c, Horoskop.getAllNames(), "Horoskop", 90);
        Composite sub = GuiContainer.newComposite(c, 2);
        this.automatischSpeichern = this.guiUtil.createCheckbox(sub, "automatisch Speichern");
        this.guiUtil.createLabel(sub, "automatisch Speichern");
        this.guiUtil.createLabel(c, "Planet");
        this.planet1 = this.guiUtil.createCombo(c, PopupPlanetenzyklusTile.planeten, "Planet", 90);
        this.guiUtil.createLabel(c, "");
        this.guiUtil.createLabel(c, "von");
        this.von = this.guiUtil.createDateChooser(c, "von", 90);
        this.exchangeButton = this.guiUtil.createPushButton(c, "Datum \u00e4ndern\ngeb. Datum oder akt. Datum", Resources.ICON.EXCHANGE);
        this.guiUtil.createLabel(c, "bis");
        this.bis = this.guiUtil.createDateChooser(c, "bis", 90);
        this.zeitraum = this.guiUtil.createCombo(c, new String[]{"1 Jahr", "5 Jahre", "100 Jahre"}, "Zeitraum", 90);
        this.guiUtil.createLabel(c, "Person 1");
        this.person1 = this.guiUtil.createText(c, "", 180, 0);
        this.person1Button = this.guiUtil.createPushButton(c, "Person ausw\u00e4hlen", null);
        this.guiUtil.disableOneWidget(this.person1);
        this.guiUtil.createLabel(c, "Person 2");
        this.person2 = this.guiUtil.createText(c, "", 180, 0);
        this.person2Button = this.guiUtil.createPushButton(c, "Person ausw\u00e4hlen", null);
        this.guiUtil.disableOneWidget(this.person2);
        this.guiUtil.createLabel(c, "Berechnungsdatum");
        this.date = this.guiUtil.createDateChooser(c, "Ausgangsdatum", 90);
        this.guiUtil.createLabel(c, "");
        this.person1.getWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopupHoroskopUndZeitraumTile.this.setPersonendaten1(PopupHoroskopUndZeitraumTile.this.getPersonendaten(PopupHoroskopUndZeitraumTile.this.exchangeParameter.personendaten1));
            }
        });
        this.person1.getWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                PopupHoroskopUndZeitraumTile.this.setPersonendaten1(PopupHoroskopUndZeitraumTile.this.getPersonendaten(PopupHoroskopUndZeitraumTile.this.exchangeParameter.personendaten1));
            }
        });
        this.person2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopupHoroskopUndZeitraumTile.this.setPersonendaten2(PopupHoroskopUndZeitraumTile.this.getPersonendaten(PopupHoroskopUndZeitraumTile.this.exchangeParameter.personendaten2));
            }
        });
        this.person2.getWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                PopupHoroskopUndZeitraumTile.this.setPersonendaten2(PopupHoroskopUndZeitraumTile.this.getPersonendaten(PopupHoroskopUndZeitraumTile.this.exchangeParameter.personendaten2));
            }
        });
        this.exchangeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Date dateVon = null;
                Date dateBis = null;
                PopupHoroskopUndZeitraumTile.this.switchCounter = (PopupHoroskopUndZeitraumTile.this.switchCounter + 1) % 2;
                if (PopupHoroskopUndZeitraumTile.this.exchangeParameter.personendaten1 == null) {
                    return;
                }
                switch (PopupHoroskopUndZeitraumTile.this.switchCounter) {
                    case 0: {
                        dateVon = DateUtil.getToday();
                        break;
                    }
                    case 1: {
                        dateVon = PopupHoroskopUndZeitraumTile.this.exchangeParameter.personendaten1.getGeburtsdatum();
                    }
                }
                dateBis = DateUtil.dateAddYears(dateVon, 1);
                PopupHoroskopUndZeitraumTile.this.von.setValue(dateVon);
                PopupHoroskopUndZeitraumTile.this.date.setValue(dateVon);
                PopupHoroskopUndZeitraumTile.this.calculateBis();
            }
        });
        this.zeitraum.getWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopupHoroskopUndZeitraumTile.this.calculateBis();
            }
        });
    }

    private void calculateBis() {
        try {
            Date dateVon = this.von.getValue();
            int value = this.zeitraum.getSelectionIndex();
            switch (value) {
                case 0: {
                    this.bis.setValue(DateUtil.dateAddYears(dateVon, 1));
                    break;
                }
                case 1: {
                    this.bis.setValue(DateUtil.dateAddYears(dateVon, 5));
                    break;
                }
                case 2: {
                    this.bis.setValue(DateUtil.dateAddYears(dateVon, 100));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Personendaten getPersonendaten(Personendaten personendaten) {
        PopupPageDialog ppd = new PopupPageDialog(new PersonendatenController(), personendaten, MainApplicationWindow.getInstance().getShell(), PopupPageDialog.Mode.SELECT, null);
        ppd.open();
        if (ppd.getButtonPressedId() == 1) {
            personendaten = (Personendaten)ppd.getBusinessObject();
            return personendaten;
        }
        return null;
    }

    private void setPersonendaten1(Personendaten p) {
        if (p == null || p.getId() == 0) {
            this.person1.setValue("");
            this.exchangeParameter.personendaten1 = null;
        } else {
            this.person1.setValue(Formatter.append(p.getVorname(), p.getNachname(), " "));
            this.exchangeParameter.personendaten1 = p;
        }
    }

    private void setPersonendaten2(Personendaten p) {
        if (p == null || p.getId() == 0) {
            this.person2.setValue("");
            this.exchangeParameter.personendaten2 = null;
        } else {
            this.person2.setValue(Formatter.append(p.getVorname(), p.getNachname(), " "));
            this.exchangeParameter.personendaten2 = p;
        }
    }

    protected void setData(ExchangeParameter exchangeParameter) throws MappingException {
        if (exchangeParameter != null) {
            this.exchangeParameter = exchangeParameter;
            if (exchangeParameter.horoskop != null) {
                this.horoskop.setStringValue(exchangeParameter.horoskop.getName());
            } else {
                this.horoskop.setStringValue("");
            }
            this.automatischSpeichern.setValue(true);
            PopupPlanetenzyklusTile.setPlanet(this.planet1, exchangeParameter.planet1);
            this.zeitraum.setValueByIndex(0);
            this.von.setValue(exchangeParameter.von);
            this.bis.setValue(exchangeParameter.bis);
            this.date.setValue(exchangeParameter.von);
            this.setPersonendaten1(exchangeParameter.personendaten1);
            this.setPersonendaten2(exchangeParameter.personendaten2);
        }
    }

    protected ExchangeParameter getData() throws MappingException {
        this.exchangeParameter.horoskop = Horoskop.fromString(this.horoskop.getStringValue());
        this.exchangeParameter.planet1 = PopupPlanetenzyklusTile.getPlanetId(this.planet1);
        this.exchangeParameter.von = this.von.getValue();
        this.exchangeParameter.bis = this.bis.getValue();
        this.exchangeParameter.date = this.date.getValue();
        this.exchangeParameter.automatischSpeichern = this.automatischSpeichern.getValue();
        return this.exchangeParameter;
    }
}

