/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.common.core.GlobalData;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class PopupFileDialog {
    public static String openPdfFileDialog(String filename) {
        Shell shell = MainApplicationWindow.getInstance().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterNames(new String[]{"PDF Dateien", "Alle Dateien (*.*)"});
        dialog.setFilterExtensions(new String[]{"*.pdf", "*.*"});
        String workingdir = GlobalData.getInstance().getSettings().getWorkingDir();
        dialog.setFilterPath(workingdir);
        dialog.setFileName(filename);
        String dest = dialog.open();
        return dest;
    }

    public static String openSaveFileDialog(String filename, String[] extensions, String[] extensionNames) {
        Shell shell = MainApplicationWindow.getInstance().getShell();
        return PopupFileDialog.openSaveFileDialog(shell, filename, extensions, extensionNames);
    }

    public static String openSaveFileDialog(Shell shell, String filename, String[] extensions, String[] extensionNames) {
        FileDialog dialog = new FileDialog(shell, 8192);
        if (GlobalData.getInstance().getSettings() != null) {
            String workingdir = GlobalData.getInstance().getSettings().getWorkingDir();
            dialog.setFilterPath(workingdir);
        }
        dialog.setFilterNames(extensionNames);
        dialog.setFilterExtensions(extensions);
        dialog.setFileName(filename);
        String dest = dialog.open();
        return dest;
    }

    public static String openFileDialog(String text, String filename, String[] extensions, String[] filternames) {
        Shell shell = MainApplicationWindow.getInstance().getShell();
        return PopupFileDialog.openFileDialog(shell, text, filename, extensions, filternames);
    }

    public static String openFileDialog(Shell shell, String text, String filename, String[] extensions, String[] filternames) {
        FileDialog dialog = new FileDialog(shell, 8);
        dialog.setText(text);
        dialog.setFilterExtensions(extensions);
        dialog.setFilterNames(filternames);
        if (GlobalData.getInstance().getSettings() != null) {
            String workingdir = GlobalData.getInstance().getSettings().getWorkingDir();
            dialog.setFilterPath(workingdir);
        }
        dialog.setFileName(filename);
        String dest = dialog.open();
        return dest;
    }

    public static String openSaveDatabaseFileDialog(String titel, String vorgabePfad, String vorgabeDateiname) {
        Shell shell = MainApplicationWindow.getInstance().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterNames(new String[]{"Datenbank", "Alle Dateien (*.*)"});
        dialog.setFilterExtensions(new String[]{"*.db", "*.*"});
        dialog.setText(titel);
        dialog.setFilterPath(vorgabePfad);
        dialog.setFileName(vorgabeDateiname);
        String dest = dialog.open();
        return dest;
    }

    public static String openReadDatabaseFileDialog(String titel, String filename) {
        Shell shell = MainApplicationWindow.getInstance().getShell();
        FileDialog dialog = new FileDialog(shell, 32);
        dialog.setFilterNames(new String[]{"Datenbank", "Alle Dateien (*.*)"});
        dialog.setFilterExtensions(new String[]{"*.db", "*.*"});
        dialog.setText(titel);
        String workingdir = GlobalData.getInstance().getSettings().getBackupDir();
        dialog.setFilterPath(workingdir);
        dialog.setFileName(filename);
        String dest = dialog.open();
        return dest;
    }

    public static String openDirectoryDialog(String filterpath) {
        Shell shell = MainApplicationWindow.getInstance().getShell();
        DirectoryDialog dialog = new DirectoryDialog(shell, 8192);
        dialog.setFilterPath(filterpath);
        String dest = dialog.open();
        return dest;
    }

    public static String openFileDialog(String titel, String filename, String ... filter) {
        Shell shell = MainApplicationWindow.getInstance().getShell();
        FileDialog dialog = new FileDialog(shell, 32);
        String[] ext = new String[filter.length + 1];
        for (int i = 0; i < filter.length; ++i) {
            ext[i] = filter[i];
        }
        ext[filter.length] = "*.*";
        dialog.setFilterExtensions(ext);
        dialog.setText(titel);
        String workingdir = GlobalData.getInstance().getSettings().getBackupDir();
        dialog.setFilterPath(workingdir);
        dialog.setFileName(filename);
        String dest = dialog.open();
        return dest;
    }
}

