/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupAnalyseResultListDialog;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.calculation.AnalyseResult;
import de.cni.common.calculation.AnalyseSchluesselThemaList;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.Herrscher;
import de.cni.common.calculation.RadixHelper;
import de.cni.common.calculation.Tupel;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.AnalyseSchluesselThema;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class PopupAnalyseSchluesselThemaTile {
    private static Log log = LogFactory.getLog(PopupAnalyseSchluesselThemaTile.class);
    int dreiGradRegelOffset = 0;
    IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    WidgetFactory guiUtil = new WidgetFactory(1);
    TextWrapper textElement;
    List<ButtonWrapper> buttonList;
    private RadixHelper radixHelper;
    private AnalyseSchluesselThemaList analyseSchluesselThemaList;

    protected PopupAnalyseSchluesselThemaTile(AnalyseSchluesselThemaList analyseSchluesselThemaList) {
        this.radixHelper = new RadixHelper(analyseSchluesselThemaList.getHoroskopCalculator().getAstrodaten1());
        this.analyseSchluesselThemaList = analyseSchluesselThemaList;
    }

    protected void createContent(Composite parent) throws MappingException {
        this.buttonList = new ArrayList<ButtonWrapper>();
        Composite c1 = GuiContainer.newAnalyseComposite(parent);
        for (IBusinessObject obj : this.analyseSchluesselThemaList.getAnalyseSchluesselElementList()) {
            AnalyseSchluesselThema e = (AnalyseSchluesselThema)obj;
            if (e.isUeberschrift() && e.isAnzeigen()) {
                this.guiUtil.createAnalyseText(c1, e.getFrage());
                continue;
            }
            ButtonWrapper b = this.guiUtil.createAnalyseButton(c1, e.getFrage());
            this.buttonList.add(b);
            b.addSelectionListener(new AnalyseSchluesselThemaListener(e));
        }
        parent.pack();
    }

    protected void setData(AnalyseSchluesselThemaList analyse2Result) throws MappingException, DatabaseException {
        this.analyseSchluesselThemaList = analyse2Result;
    }

    protected AnalyseSchluesselThemaList getData() throws MappingException, DatabaseException {
        return null;
    }

    public void enable(boolean flag) {
    }

    List<AnalyseResult> getAnalyseSchluesselThemaResult(AnalyseSchluesselThemaList analseSchluesselThemaList) {
        ArrayList<AnalyseResult> list = new ArrayList<AnalyseResult>();
        block0: for (IBusinessObject obj : analseSchluesselThemaList.getAnalyseSchluesselElementList()) {
            AnalyseSchluesselThema analyseSchluesselThema = (AnalyseSchluesselThema)obj;
            if (analyseSchluesselThema.getDoppelzeichen() <= 0 || !this.isDoppelzeichen(analseSchluesselThemaList)) continue;
            for (IBusinessObject subObj : analseSchluesselThemaList.getAnalyseSchluesselElementList()) {
                AnalyseSchluesselThema alternativesAnalyseSchluesselThema = (AnalyseSchluesselThema)obj;
                if (alternativesAnalyseSchluesselThema.getHaus() == analyseSchluesselThema.getHaus() && alternativesAnalyseSchluesselThema.getSort() == analyseSchluesselThema.getDoppelzeichen()) {
                    analyseSchluesselThema = alternativesAnalyseSchluesselThema;
                    continue block0;
                }
                List<AnalyseResult> subList = this.getAnalyseSchluesselThemaResult(analyseSchluesselThema, analseSchluesselThemaList.getHoroskopCalculator().getAstrodaten1());
                list.addAll(subList);
            }
        }
        return list;
    }

    List<AnalyseResult> getAnalyseSchluesselThemaResult(AnalyseSchluesselThema object, Astrodaten ad) {
        String h;
        AnalyseResult result;
        List<Tupel> tkzList;
        String[] array;
        ArrayList<AnalyseResult> resultList = new ArrayList<AnalyseResult>();
        if (!Util.isEmpty(object.getHaeuser())) {
            for (String h2 : array = object.getHaeuser().split(":")) {
                if (Util.equalsIgnoreCase("AKTUELL", h2 = h2.trim())) {
                    double winkel = this.radixHelper.getPersonenalterWinkel(ad.date, new Date());
                    h2 = Converter.intToString(this.radixHelper.getIntFirstHausByWinkel(winkel, this.dreiGradRegelOffset));
                }
                tkzList = this.radixHelper.getTkzByHaus(h2);
                for (Tupel tupel : tkzList) {
                    AnalyseResult result2 = new AnalyseResult();
                    result2.setHausFlag(true);
                    result2.setHaus(h2);
                    result2.setTkz(tupel.name);
                    result2.setClickKoordinaten(this.analyseSchluesselThemaList.getClickKoordinaten());
                    resultList.add(result2);
                }
                List<String> pArray = this.radixHelper.getPlanetenByHaus(h2, this.dreiGradRegelOffset);
                for (String planet : pArray) {
                    result = new AnalyseResult();
                    result.setHausFlag(true);
                    result.setHaus(h2);
                    result.setPlanet(planet);
                    result.setTkz(this.radixHelper.getTkzByPlanet(planet));
                    result.setClickKoordinaten(this.analyseSchluesselThemaList.getClickKoordinaten());
                    resultList.add(result);
                }
            }
        }
        if (!Util.isEmpty(object.getTkzs())) {
            for (String tkz : array = object.getTkzs().split(":")) {
                tkz = tkz.trim();
                List<String> pArray = this.radixHelper.getPlanetenByTkz(tkz);
                List<Tupel> hausList = this.radixHelper.getHausByTkz(tkz);
                for (Tupel t : hausList) {
                    result = new AnalyseResult();
                    result.setTkzFlag(true);
                    result.setTkz(tkz);
                    result.setHaus(t.name);
                    result.setClickKoordinaten(this.analyseSchluesselThemaList.getClickKoordinaten());
                    resultList.add(result);
                }
                for (String planet : pArray) {
                    result = new AnalyseResult();
                    result.setTkzFlag(true);
                    result.setTkz(tkz);
                    h = this.radixHelper.getHausByPlanet(planet, this.dreiGradRegelOffset);
                    result.setHaus(h);
                    result.setPlanet(planet);
                    result.setClickKoordinaten(this.analyseSchluesselThemaList.getClickKoordinaten());
                    resultList.add(result);
                }
            }
        }
        if (!Util.isEmpty(object.getPlaneten())) {
            for (String planet : array = object.getPlaneten().split(":")) {
                planet = planet.trim();
                AnalyseResult result3 = new AnalyseResult();
                result3.setPlanetFlag(true);
                result3.setPlanet(planet);
                String h3 = this.radixHelper.getHausByPlanet(planet, this.dreiGradRegelOffset);
                result3.setHaus(h3);
                result3.setPlanet(planet);
                result3.setTkz(this.radixHelper.getTkzByPlanet(planet));
                result3.setClickKoordinaten(this.analyseSchluesselThemaList.getClickKoordinaten());
                resultList.add(result3);
            }
        }
        if (!Util.isEmpty(object.getHerrscher())) {
            for (String herrscher : array = object.getHerrscher().split(":")) {
                herrscher = herrscher.trim();
                tkzList = new ArrayList<Tupel>();
                if (Util.isInt(herrscher)) {
                    List<Tupel> tupelList = this.radixHelper.getTkzByHaus(Converter.stringToInt(herrscher));
                    for (Tupel tupel : tupelList) {
                        tkzList.add((Tupel)((Object)tupel.name));
                    }
                } else {
                    String tkz = this.radixHelper.getTkzByPlanet(herrscher);
                    tkzList.add((Tupel)((Object)tkz));
                }
                for (String string : tkzList) {
                    String planet;
                    planet = Herrscher.getHerrscherPlanet(string);
                    result = new AnalyseResult();
                    result.setPlanet(planet);
                    h = this.radixHelper.getHausByPlanet(planet, this.dreiGradRegelOffset);
                    result.setHaus(h);
                    result.setPlanet(planet);
                    result.setTkz(this.radixHelper.getTkzByPlanet(planet));
                    result.setClickKoordinaten(this.analyseSchluesselThemaList.getClickKoordinaten());
                    resultList.add(result);
                }
            }
        }
        return resultList;
    }

    private boolean isDoppelzeichen(AnalyseSchluesselThemaList analseSchluesselThemaList) {
        Astrodaten ad = analseSchluesselThemaList.getHoroskopCalculator().getAstrodaten1();
        String tkzAc = this.radixHelper.getTkzByPlanet(Constants.planeten[13]);
        String tkzSonne = this.radixHelper.getTkzByPlanet(Constants.planeten[0]);
        return Util.equals(tkzAc, tkzSonne);
    }

    protected class AnalyseSchluesselThemaListener
    implements SelectionListener {
        AnalyseSchluesselThema element;

        public AnalyseSchluesselThemaListener(AnalyseSchluesselThema element) {
            this.element = element;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            List<AnalyseResult> list = PopupAnalyseSchluesselThemaTile.this.getAnalyseSchluesselThemaResult(this.element, PopupAnalyseSchluesselThemaTile.this.analyseSchluesselThemaList.getHoroskopCalculator().getAstrodaten1());
            PopupAnalyseResultListDialog dialog = new PopupAnalyseResultListDialog(MainApplicationWindow.getInstance().getShell(), this.element.getFrage() + "\n" + this.element.getAntwort(), list, true);
            dialog.open();
        }
    }
}

