/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.texte;

import de.cni.client.gui.pages.texte.TexteController;
import de.cni.client.gui.templates.filter.AbstractFilterHeaderTile;
import de.cni.client.gui.templates.filter.IFilterController;
import de.cni.client.gui.util.TextWrapper;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.CoreTexte;
import de.cni.common.datamodel.admin.CustomTexte;
import de.cni.common.datamodel.admin.Texte;
import de.cni.common.exceptions.MappingException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TexteFilterTile
extends AbstractFilterHeaderTile {
    private static Log log = LogFactory.getLog(TexteFilterTile.class);
    private boolean core;
    private TextWrapper key;
    private TextWrapper stufe;
    private TextWrapper klasse;
    private TextWrapper url;
    private TextWrapper text;

    protected TexteFilterTile(IFilterController controller, int[] weights) throws NamingException {
        super(controller, weights, PAGE_FILTER);
        log.debug((Object)"TexteFilterTile - M1");
        this.core = ((TexteController)controller).isCore();
        log.debug((Object)"TexteFilterTile - M2");
    }

    @Override
    public void createGuiFilterElements(Composite parent) throws MappingException {
        log.debug((Object)"TexteFilterTile - M3");
        RowLayout filterRowLayout = new RowLayout();
        filterRowLayout.pack = true;
        Composite filterComposite = new Composite(parent, 0);
        filterComposite.setLayout((Layout)filterRowLayout);
        Composite c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "Key");
        this.key = this.guiUtil.createText(c, "Key", 90, 200);
        this.key.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        this.guiUtil.createLabel(c, "Klasse");
        this.klasse = this.guiUtil.createText(c, "Key", 90, 100);
        this.klasse.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        this.guiUtil.createLabel(c, "Stufe");
        this.stufe = this.guiUtil.createLeftNumberText(c, "Stufe", 90, 1);
        this.stufe.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "URL");
        this.url = this.guiUtil.createText(c, "URL", 0, 0);
        this.url.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        this.guiUtil.createLabel(c, "Text");
        this.text = this.guiUtil.createText(c, "Key", 180, 100);
        this.text.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        log.debug((Object)"TexteFilterTile - M4");
    }

    @Override
    public IBusinessObject getPageFilterData() throws MappingException {
        log.debug((Object)"TexteFilterTile - M5");
        Texte object = this.core ? new CoreTexte() : new CustomTexte();
        log.debug((Object)"TexteFilterTile - M6");
        object.setKey(this.key.getValue());
        object.setKlasse(this.klasse.getValue());
        object.setStufe(this.stufe.getIntValue());
        object.setUrl(this.url.getValue());
        object.setText(this.text.getValue());
        log.debug((Object)"TexteFilterTile - M7");
        return object;
    }

    @Override
    public void setPageFilterData(IBusinessObject filterObject) throws MappingException {
        log.debug((Object)"TexteFilterTile - M8");
        Texte object = (Texte)filterObject;
        this.key.setValue(object.getKey());
        this.klasse.setValue(object.getKlasse());
        this.stufe.setValue(object.getStufe());
        this.url.setValue(object.getUrl());
        this.text.setValue(object.getText());
        log.debug((Object)"TexteFilterTile - M9");
    }
}

