/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.texte;

import de.cni.client.gui.action.toolbar.ISyncable;
import de.cni.client.gui.action.toolbar.IWerkseinstellungen;
import de.cni.client.gui.action.toolbar.SyncAction;
import de.cni.client.gui.action.toolbar.WerkseinstellungenAction;
import de.cni.client.gui.pageflow.Page;
import de.cni.client.gui.pages.texte.TextePage;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPage;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPageController;
import de.cni.client.gui.templates.tableAndDetail.TableDetailPageController;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.Formatter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.ServerConnection;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.CoreTexte;
import de.cni.common.datamodel.admin.CustomTexte;
import de.cni.common.datamodel.admin.Texte;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.io.ImportTexte;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;

public class TexteController
extends TableDetailPageController
implements ISyncable,
IWerkseinstellungen {
    private static Log log = LogFactory.getLog(TexteController.class);
    private boolean core = true;

    public TexteController(boolean core) {
        super(DO_LOAD_ALL_DATA_DURING_INITIALIZATION);
        log.debug((Object)"TexteController - M1");
        this.core = core;
        this.addToolbarItem(new ActionContributionItem((IAction)new SyncAction(this)), this.withText);
        log.debug((Object)"TexteController - M2");
        if (!core) {
            this.addToolbarItem(new ActionContributionItem((IAction)new WerkseinstellungenAction(this)), this.withText);
        }
        log.debug((Object)"TexteController - M3");
    }

    @Override
    public Page getPage() {
        return this.core ? Page.coreTexte : Page.customTexte;
    }

    @Override
    protected IBusinessObject createNewBusinessObject() {
        log.debug((Object)"TexteController - M4");
        Texte object = this.core ? new CoreTexte() : new CustomTexte();
        log.debug((Object)"TexteController - M5");
        return object;
    }

    @Override
    protected ITableDetailPage createNewTableDetailPage(ITableDetailPageController controller) {
        log.debug((Object)"TexteController - M6");
        return new TextePage(controller);
    }

    protected IBusinessObjectVerwaltung getServerBean() {
        log.debug((Object)"TexteController - M7");
        ServerConnection serverConnection = ServerConnection.getInstance();
        IBusinessObjectVerwaltung<IBusinessObject> gv = serverConnection.getObjectVerwaltung();
        log.debug((Object)"TexteController - M8");
        return gv;
    }

    @Override
    public void sync() {
        try {
            if (!Popup.question("M\u00f6chten Sie neue Texte-Daten einlesen?\nAchtung: der vorhandene Bestand an Text-Daten wird dabei gel\u00f6scht.")) {
                return;
            }
            ImportTexte.doImport(this.core);
            this.refresh();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public boolean isCore() {
        log.debug((Object)"TexteController - M9");
        return this.core;
    }

    @Override
    public void werkseinstellungen() {
        try {
            SqLiteDatabase db = new SqLiteDatabase();
            db.texteCore2Custom();
            this.refresh();
            Popup.info("Die Analyse-Texte wurden erfolgreich auf Werkseinstellungen zur\u00fcckgesetzt.");
            String texteDir = GlobalData.getInstance().getSettings().getTexteDir();
            if (Util.isEmpty(texteDir)) {
                Popup.warning("Sie habe keine Pfad f\u00fcr Ihre 'eigenen Texte' definiert.\n Unter 'Administration-->Einstellungen, Reiter 'administrative Daten' k\u00f6nnen Sie ein Verzeichnis festlegen, in dem Sie ihre Texte ablegen.");
                return;
            }
            boolean doCopy = Popup.question("Sollen auch leere die Html-Dateih\u00fcllen erzeugt werden?");
            if (!doCopy) {
                return;
            }
            int n = this.generateHtmlFiles(texteDir);
            Popup.info("Es wurde " + Formatter.pReportNumber(n) + " Dateien im Verzeichnis " + texteDir + " erzeugt");
        }
        catch (Exception e) {
            Popup.error("Fehler beim Zur\u00fccksetzen auf Werkseinstellungen. " + e.getMessage());
        }
    }

    private int generateHtmlFiles(String path) {
        int n = 0;
        try {
            SqLiteDatabase db = new SqLiteDatabase();
            Texte filter = Texte.newInstance(false);
            List<IBusinessObject> texteList = db.select(filter, false);
            for (IBusinessObject obj : texteList) {
                Texte t = (Texte)obj;
                String url = t.getUrl();
                String key = t.getKey();
                String text = t.getText();
                if (Util.isEmpty(url) || Util.isEmpty(key)) continue;
                this.generateFile(path + "/" + url, key, text);
                ++n;
            }
            return n;
        }
        catch (Exception e) {
            Popup.error("Fehler beim Erzeugen der leeren Html-Dateih\u00fcllen. " + e.getMessage());
            return n;
        }
    }

    private void generateFile(String filename, String key, String ueberschrift) throws IOException {
        try {
            String s = "<Body>";
            s = s + "<u1>" + ueberschrift + "</u1>";
            s = s + "</Body>";
            FileUtils.writeStringToFile((File)new File(filename), (String)s);
        }
        catch (Exception e) {
            throw new IOException("Dateiname: " + filename + " ( key=" + key + ") , Fehler: " + e.getClass() + " / " + e.getMessage());
        }
    }
}

