/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.settings;

import de.cni.client.gui.action.toolbar.SaveAction;
import de.cni.client.gui.pageflow.IPageController;
import de.cni.client.gui.pages.settings.SettingsController;
import de.cni.client.gui.popup.filter.PopupFileDialog;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.OrbisMediator;
import de.cni.client.gui.util.Popup;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.OrbisPresettings;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.Domain;
import de.cni.common.core.GlobalData;
import de.cni.common.core.LicenseHandler;
import de.cni.common.core.Mappings;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Settings;
import de.cni.common.exceptions.MappingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class SettingsTile {
    private static Log log = LogFactory.getLog(SettingsTile.class);
    private Settings object;
    protected final int layoutNumColumns = 3;
    protected IPageController controller;
    protected WidgetFactory guiUtil = new WidgetFactory(2);
    protected Mappings mapping = Mappings.getInstance();
    CTabFolder tabFolder;
    private TextWrapper name;
    private TextWrapper adresse1;
    private TextWrapper adresse2;
    private TextWrapper adresse3;
    private TextWrapper adresse4;
    private TextWrapper email;
    private TextWrapper kopfzeile;
    private TextWrapper kopfzeileKurz;
    private TextWrapper fusszeile;
    private ComboWrapper haussystem;
    private ComboWrapper iconType;
    private ComboWrapper iconSize;
    private ComboWrapper reporttyp;
    private TextWrapper lineWidth;
    private TextWrapper stufe1;
    private TextWrapper stufe2;
    private TextWrapper kontinent;
    private TextWrapper lkz;
    private ButtonWrapper webservice;
    private ButtonWrapper datenbank;
    private TextWrapper backupDir;
    private TextWrapper userDir;
    private TextWrapper texteDir;
    private TextWrapper logoFile;
    private ButtonWrapper automatischeSicherung;
    private TextWrapper sicherungTage;
    private TextWrapper letzteSicherung;
    private ButtonWrapper gradzahlen;
    private ButtonWrapper zwischenskala;
    private ButtonWrapper jahresring;
    private ButtonWrapper hauslinien;
    private ButtonWrapper zeiger;
    private ButtonWrapper horoskop1;
    private ButtonWrapper horoskop2;
    private ButtonWrapper aspekte1;
    private ButtonWrapper aspekte2;
    private ButtonWrapper interAspekte;
    private ButtonWrapper zweiterAcMc;
    private ButtonWrapper eigeneAnalysetexte;
    private ButtonWrapper konjunktion;
    private ButtonWrapper sextil;
    private ButtonWrapper quadrat;
    private ButtonWrapper trigon;
    private ButtonWrapper opposition;
    private ButtonWrapper quinkunx;
    private ButtonWrapper backupDirButton;
    private ButtonWrapper userDirButton;
    private ButtonWrapper texteDirButton;
    private ButtonWrapper logoFileButton;
    private OrbisMediator orbisMediator = new OrbisMediator();
    private OrbisMediator interOrbisMediator = new OrbisMediator();
    private OrbisMediator copySourceMediator;
    private OrbisMediator copyDestMediator;
    private Horoskop copySourceHoroskop = null;
    private Horoskop copyDestHoroskop = null;
    private TextWrapper steuersatz;
    private TextWrapper header1;
    private TextWrapper header2;
    private TextWrapper header3;
    private TextWrapper absender;
    private TextWrapper rechnungsdaten;
    private TextWrapper rechnungsnummer;
    private TextWrapper betreff;
    private TextWrapper text1;
    private TextWrapper text2;
    private TextWrapper text3;
    private TextWrapper footer1;
    private TextWrapper footer2;
    private TextWrapper footer3;
    private TextWrapper rand1;
    private TextWrapper rand2;
    private TextWrapper rand3;

    public SettingsTile(IPageController controller) {
        this.controller = controller;
    }

    public Composite createContent(Composite parent) throws MappingException {
        Group master = GuiContainer.newFillGroup(parent, "Einstellungen", 1, 1);
        this.tabFolder = GuiContainer.newCTabFolder((Composite)master);
        CTabItem tabItemStamm = new CTabItem(this.tabFolder, 0);
        tabItemStamm.setText("pers\u00f6nliche Daten");
        Composite tabStamm = GuiContainer.newCTabItemComposite(this.tabFolder, tabItemStamm, 3);
        ScrolledComposite sc = GuiContainer.newScrolledComposite(tabStamm);
        Composite spacer = GuiContainer.newSpacer((Composite)sc, false, 10);
        Composite main = GuiContainer.newComposite(spacer, 2, 1, false, 1808);
        this.createContentEinstellungen(main);
        GuiContainer.configureScrolledComposite(sc, spacer);
        CTabItem tabItemAdmin = new CTabItem(this.tabFolder, 0);
        tabItemAdmin.setText("administrative Daten");
        Composite tabAdmin = GuiContainer.newCTabItemComposite(this.tabFolder, tabItemAdmin, 3);
        sc = GuiContainer.newScrolledComposite(tabAdmin);
        spacer = GuiContainer.newSpacer((Composite)sc, false, 10);
        main = GuiContainer.newComposite(spacer, 2, 1, false, 1808);
        this.createContentAdmin(main);
        GuiContainer.configureScrolledComposite(sc, spacer);
        if (LicenseHandler.getInstance().isAllowed(LicenseHandler.LicenseType.ADMIN)) {
            CTabItem tabItemRechnung = new CTabItem(this.tabFolder, 0);
            tabItemRechnung.setText("Rechnung");
            Composite tabRechnung = GuiContainer.newCTabItemComposite(this.tabFolder, tabItemRechnung, 3);
            sc = GuiContainer.newScrolledComposite(tabRechnung);
            spacer = GuiContainer.newSpacer((Composite)sc, false, 10);
            main = GuiContainer.newComposite(spacer, 2, 1, false, 1808);
            this.createContentRechnung(main);
            GuiContainer.configureScrolledComposite(sc, spacer);
            for (Horoskop h : Horoskop.values()) {
                CTabItem tabItemOrben = new CTabItem(this.tabFolder, 0);
                tabItemOrben.setText(h.getName() + " Orben");
                Composite tabOrben = GuiContainer.newCTabItemComposite(this.tabFolder, tabItemOrben, 3);
                ScrolledComposite sc2 = GuiContainer.newScrolledComposite(tabOrben);
                Composite spacer2 = GuiContainer.newSpacer((Composite)sc2, false, 10);
                Composite main2 = GuiContainer.newComposite(spacer2, 1, 1, false, 1808);
                this.createContentOrben(main2, h);
                GuiContainer.configureScrolledComposite(sc2, spacer2);
            }
        }
        this.tabFolder.setFocus();
        return master;
    }

    private Composite createContentEinstellungen(Composite parent) throws MappingException {
        Composite main = GuiContainer.newCompositeEqualWidth(parent, 2, 1);
        this.createContentPersoenlicheEinstellungen(main);
        Composite right = GuiContainer.newFillComposite(main, 2);
        this.createContentVoreinstellungen(right);
        this.createContentAnsicht(right);
        this.createAspekte(right);
        this.createRegion(right);
        return main;
    }

    private Composite createContentAdmin(Composite parent) throws MappingException {
        Composite main = GuiContainer.newCompositeEqualWidth(parent, 2, 1);
        Group c = GuiContainer.newFillGroup(main, "administrative Daten", 3, 2);
        this.guiUtil.createLabel((Composite)c, "Ablageort f\u00fcr die Datensicherungen");
        this.backupDir = this.guiUtil.createTextSpan((Composite)c, "Ablageort f\u00fcr die Datensicherungen", 0, 1024, 1, 0);
        this.backupDirButton = this.guiUtil.createPushButton((Composite)c, "Ablageort ausw\u00e4hlen", null);
        this.guiUtil.createLabel((Composite)c, "Ablageort f\u00fcr eigene Text");
        this.texteDir = this.guiUtil.createTextSpan((Composite)c, "Ablageort f\u00fcr eigene Text", 0, 1024, 1, 0);
        this.texteDirButton = this.guiUtil.createPushButton((Composite)c, "Ablageort ausw\u00e4hlen", null);
        this.guiUtil.createLabel((Composite)c, "Ablageort f\u00fcr PDF Ausdrucke");
        this.userDir = this.guiUtil.createTextSpan((Composite)c, "Ablageort f\u00fcr PDF Ausdrucke", 0, 1024, 1, 0);
        this.userDirButton = this.guiUtil.createPushButton((Composite)c, "Ablageort ausw\u00e4hlen", null);
        this.guiUtil.createLabel((Composite)c, "eigenes Logo");
        this.logoFile = this.guiUtil.createTextSpan((Composite)c, "eigenes Logo", 0, 1024, 1, 0);
        this.logoFileButton = this.guiUtil.createPushButton((Composite)c, "eigenes Logo ausw\u00e4hlen", null);
        Group c2 = GuiContainer.newFillGroup(main, "automatische Datensicherung", 1, 2);
        Composite row1 = this.guiUtil.createRowComposite((Composite)c2, 4);
        this.automatischeSicherung = this.guiUtil.createCheckbox(row1, "immer beim Beenden des Programms, alle", null);
        this.sicherungTage = this.guiUtil.createLeftNumberTextSpan(row1, "Sicherung alle", 20, 3, 1);
        this.guiUtil.createLeftAllignedLabel(row1, "Tage");
        Composite row2 = this.guiUtil.createRowComposite((Composite)c2, 4);
        this.letzteSicherung = this.guiUtil.createLabelAndText(row2, "die letzte automatische Sicherung war am ", 90, 19);
        this.guiUtil.disableOneWidget(this.letzteSicherung);
        Group c3 = GuiContainer.newFillGroup(main, "Buchhaltung", 3, 2);
        this.steuersatz = this.guiUtil.createLabelAndLeftNumberText((Composite)c3, "Steuersatz (%)", 20, 2);
        this.rechnungsnummer = this.guiUtil.createLabelAndText((Composite)c3, "letzte Rechnungsnummer", 90, 20);
        this.texteDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = SettingsTile.this.texteDir.getValue();
                if (!Util.isEmpty(s = SettingsTile.this.getDir(s))) {
                    SettingsTile.this.texteDir.setValue(s);
                }
            }
        });
        this.userDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = SettingsTile.this.userDir.getValue();
                if (!Util.isEmpty(s = SettingsTile.this.getDir(s))) {
                    SettingsTile.this.userDir.setValue(s);
                }
            }
        });
        this.backupDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = SettingsTile.this.backupDir.getValue();
                if (!Util.isEmpty(s = SettingsTile.this.getDir(s))) {
                    SettingsTile.this.backupDir.setValue(s);
                }
            }
        });
        this.logoFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = SettingsTile.this.getLogoFile("");
                if (!Util.isEmpty(s)) {
                    SettingsTile.this.logoFile.setValue(s);
                }
            }
        });
        return c;
    }

    private Composite createContentRechnung(Composite parent) throws MappingException {
        Composite main = GuiContainer.newComposite(parent, 6, 1);
        this.header1 = this.guiUtil.createTextBlock(main, "Kopfzeile (links)");
        this.header2 = this.guiUtil.createTextBlock(main, "Kopfzeile (mitte)");
        this.header3 = this.guiUtil.createTextBlock(main, "Kopfzeile (rechts)");
        this.absender = this.guiUtil.createTextBlock(main, "Absender", WidgetFactory.TEXTBLOCKHIGHT / 3, 6, 0);
        this.guiUtil.createLabel(main, "");
        this.guiUtil.createLabel(main, "");
        this.guiUtil.createLabel(main, "");
        this.guiUtil.createLabel(main, "");
        this.rechnungsdaten = this.guiUtil.createTextBlock(main, "Rechnungsdaten", WidgetFactory.TEXTBLOCKHIGHT, 2, 0);
        this.betreff = this.guiUtil.createTextBlock(main, "Betreff", WidgetFactory.TEXTBLOCKHIGHT / 2, 6, 0);
        this.text1 = this.guiUtil.createTextBlock(main, "Text 1", WidgetFactory.TEXTBLOCKHIGHT, 4, 0);
        this.rand1 = this.guiUtil.createTextBlock(main, "Rand 1", WidgetFactory.TEXTBLOCKHIGHT, 2, 0);
        this.text2 = this.guiUtil.createTextBlock(main, "Text 2", WidgetFactory.TEXTBLOCKHIGHT, 4, 0);
        this.rand2 = this.guiUtil.createTextBlock(main, "Rand 2", WidgetFactory.TEXTBLOCKHIGHT, 2, 0);
        this.text3 = this.guiUtil.createTextBlock(main, "Text 3", WidgetFactory.TEXTBLOCKHIGHT, 4, 0);
        this.rand3 = this.guiUtil.createTextBlock(main, "Rand 3", WidgetFactory.TEXTBLOCKHIGHT, 2, 0);
        this.footer1 = this.guiUtil.createTextBlock(main, "Fu\u00dfzeile  (links)");
        this.footer2 = this.guiUtil.createTextBlock(main, "Fu\u00dfzeile  (mitte)");
        this.footer3 = this.guiUtil.createTextBlock(main, "Fu\u00dfzeile  (rechts)");
        return main;
    }

    private String getDir(String vorgabe) {
        vorgabe = PopupFileDialog.openDirectoryDialog(vorgabe);
        return vorgabe;
    }

    private String getLogoFile(String vorgabe) {
        vorgabe = PopupFileDialog.openFileDialog("W\u00e4hlen Sie Ihr Logo aus", vorgabe, new String[]{"*.png;*.jpg", "*.png", "*.jpg"}, new String[]{"png oder jpg", "png", "jpg"});
        return vorgabe;
    }

    private Composite createContentPersoenlicheEinstellungen(Composite parent) throws MappingException {
        Group c = GuiContainer.newFillGroup(parent, "pers\u00f6nliche Daten", 3, 1);
        this.guiUtil.createLabel((Composite)c, "Name");
        this.name = this.guiUtil.createText((Composite)c, "Name", 0, 60);
        this.guiUtil.disableOneWidget(this.name);
        this.guiUtil.createLabel((Composite)c, "Adresse Zeile 1");
        this.adresse1 = this.guiUtil.createText((Composite)c, "Adresse Zeile 1", 0, 60);
        this.guiUtil.createLabel((Composite)c, "Adresse Zeile 2");
        this.adresse2 = this.guiUtil.createText((Composite)c, "Adresse Zeile 2", 0, 60);
        this.guiUtil.createLabel((Composite)c, "Adresse Zeile 3");
        this.adresse3 = this.guiUtil.createText((Composite)c, "Adresse Zeile 3", 0, 60);
        this.guiUtil.createLabel((Composite)c, "Adresse Zeile 4");
        this.adresse4 = this.guiUtil.createText((Composite)c, "Adresse Zeile 4", 0, 60);
        this.guiUtil.createLabel((Composite)c, "E-Mail");
        this.email = this.guiUtil.createText((Composite)c, "E-Mail", 0, 200);
        this.guiUtil.createLabel((Composite)c, "Kopfzeile");
        this.kopfzeile = this.guiUtil.createTextBlock((Composite)c, "", 80, 0, 0);
        this.guiUtil.createLabel((Composite)c, "");
        this.guiUtil.createLabel((Composite)c, "Kopfzeile\n(Kurzbericht)");
        this.kopfzeileKurz = this.guiUtil.createTextBlock((Composite)c, "", 60, 0, 0);
        this.guiUtil.createLabel((Composite)c, "");
        this.guiUtil.createLabel((Composite)c, "Fu\u00dfzeile");
        this.fusszeile = this.guiUtil.createText((Composite)c, "Fusszeile", 0, 200);
        this.guiUtil.disableOneWidget(this.fusszeile);
        return c;
    }

    public Composite createContentAnsicht(Composite parent) throws MappingException {
        Group c = GuiContainer.newFillGroup(parent, "Ansicht", 3, 1);
        this.guiUtil.createLabel((Composite)c, "Horoskop 1");
        this.horoskop1 = this.guiUtil.createCheckbox((Composite)c, "Horoskop1");
        this.guiUtil.createLabel((Composite)c, "Horoskop 2");
        this.horoskop2 = this.guiUtil.createCheckbox((Composite)c, "Horoskop2");
        this.guiUtil.createLabel((Composite)c, "Aspekte 1");
        this.aspekte1 = this.guiUtil.createCheckbox((Composite)c, "Aspekte1");
        this.guiUtil.createLabel((Composite)c, "Aspekte 2");
        this.aspekte2 = this.guiUtil.createCheckbox((Composite)c, "Aspekte2");
        this.guiUtil.createLabel((Composite)c, "Inter-Aspekte");
        this.interAspekte = this.guiUtil.createCheckbox((Composite)c, "Inter-Aspekte");
        this.guiUtil.createLabel((Composite)c, "Zweiter AC/MC");
        this.zweiterAcMc = this.guiUtil.createCheckbox((Composite)c, "Zweiter AC/MC");
        this.guiUtil.createLabel((Composite)c, "Eigene Texte");
        this.eigeneAnalysetexte = this.guiUtil.createCheckbox((Composite)c, "Eigene Analyse-Text");
        this.guiUtil.createLabel((Composite)c, "");
        this.guiUtil.createLabel((Composite)c, "");
        this.guiUtil.createLabel((Composite)c, "");
        return c;
    }

    public Composite createContentVoreinstellungen(Composite parent) throws MappingException {
        Group c = GuiContainer.newFillGroup(parent, "Voreinstellungen", 3, 1);
        this.guiUtil.createLabel((Composite)c, "Symbol-Typ");
        this.iconType = this.guiUtil.createCombo((Composite)c, Domain.IconType, "Darstellungsart der grafischen Symbole", 0, 0);
        this.guiUtil.createLabel((Composite)c, "Symbol-Gr\u00f6\u00dfe");
        this.iconSize = this.guiUtil.createCombo((Composite)c, Domain.IconSize, "Gr\u00f6\u00dfe der grafischen Symbole", 0, 0);
        this.guiUtil.createLabel((Composite)c, "Dokument-Typ");
        this.reporttyp = this.guiUtil.createCombo((Composite)c, Domain.Reporttyp, "Typ des gedruckten Dokuments", 0, 0);
        this.guiUtil.createLabel((Composite)c, "Strichst\u00e4rke");
        this.lineWidth = this.guiUtil.createLeftNumberText((Composite)c, "Strichst\u00e4rke", 10, 1);
        this.guiUtil.createLabel((Composite)c, "Skala-TKZ");
        this.gradzahlen = this.guiUtil.createCheckbox((Composite)c, "Skala-TKZ");
        this.guiUtil.createLabel((Composite)c, "Skala-AC");
        this.zwischenskala = this.guiUtil.createCheckbox((Composite)c, "Skala-AC");
        this.guiUtil.createLabel((Composite)c, "Jahresring");
        this.jahresring = this.guiUtil.createCheckbox((Composite)c, "Jahresring");
        this.guiUtil.createLabel((Composite)c, "H\u00e4user-Segmente");
        this.hauslinien = this.guiUtil.createCheckbox((Composite)c, "H\u00e4user-Segmente");
        this.guiUtil.createLabel((Composite)c, "Zeiger");
        this.zeiger = this.guiUtil.createCheckbox((Composite)c, "Zeiger");
        this.guiUtil.createLabel((Composite)c, "Stufe1");
        this.stufe1 = this.guiUtil.createLeftNumberText((Composite)c, "Stufe", 10, 1);
        this.guiUtil.createLabel((Composite)c, "Stufe2");
        this.stufe2 = this.guiUtil.createLeftNumberText((Composite)c, "Stufe", 10, 1);
        this.guiUtil.createLabel((Composite)c, "");
        this.guiUtil.createLabel((Composite)c, "");
        this.guiUtil.createLabel((Composite)c, "");
        return c;
    }

    public Composite createRegion(Composite parent) {
        this.guiUtil.setDefaultSpan(2);
        Composite c = GuiContainer.newFillComposite(parent, 1);
        Group c1 = GuiContainer.newFillGroup(c, "bevorzugte Region", 3, 1);
        this.guiUtil.createLabel((Composite)c1, "Kontinent");
        this.kontinent = this.guiUtil.createText((Composite)c1, "Kontinent-Kennzeichen (2stellig)", 20, 10);
        this.guiUtil.createLabel((Composite)c1, "LKZ");
        this.lkz = this.guiUtil.createText((Composite)c1, "LKZ", 20, 2);
        Group c2 = GuiContainer.newFillGroup(c, "bevorzugte Suche", 3, 1);
        this.guiUtil.createLabel((Composite)c2, "Web-Service");
        this.webservice = this.guiUtil.createRadiobox((Composite)c2, "Suche \u00fcber eine Wewb-Service (Internet-Verbindung erforderlich)");
        this.guiUtil.createLabel((Composite)c2, "Datenbank");
        this.datenbank = this.guiUtil.createRadiobox((Composite)c2, "Suche in der Datenbank");
        return parent;
    }

    public Composite createAspekte(Composite parent) throws MappingException {
        Group c = GuiContainer.newFillGroup(parent, "Aspekte", 2, 1);
        this.guiUtil.setDefaultSpan(1);
        this.guiUtil.createLabel((Composite)c, "Aspekt");
        this.guiUtil.createLabel((Composite)c, "Anzeigen");
        this.guiUtil.createLabel((Composite)c, "Konjunktion");
        this.konjunktion = this.guiUtil.createCheckbox((Composite)c, "Konjunktion anzeigen");
        this.guiUtil.createLabel((Composite)c, "Sextil");
        this.sextil = this.guiUtil.createCheckbox((Composite)c, "Sextil anzeigen");
        this.guiUtil.createLabel((Composite)c, "Quadrat");
        this.quadrat = this.guiUtil.createCheckbox((Composite)c, "Quadrat anzeigen");
        this.guiUtil.createLabel((Composite)c, "Trigon");
        this.trigon = this.guiUtil.createCheckbox((Composite)c, "Trigon anzeigen");
        this.guiUtil.createLabel((Composite)c, "Opposition");
        this.opposition = this.guiUtil.createCheckbox((Composite)c, "Opposition anzeigen");
        this.guiUtil.createLabel((Composite)c, "Quinkunx");
        this.quinkunx = this.guiUtil.createCheckbox((Composite)c, "Quinkunx anzeigen");
        this.guiUtil.setDefaultSpan(2);
        return c;
    }

    public Settings getData() throws MappingException {
        this.object.setBackupDir(this.backupDir.getValue());
        this.object.setTexteDir(this.texteDir.getValue());
        this.object.setWorkingDir(this.userDir.getValue());
        this.object.setLogoFile(this.logoFile.getValue());
        this.object.setAutomatischeSicherung(this.automatischeSicherung.getValue());
        this.object.setSicherungTage(this.sicherungTage.getIntValue());
        this.sicherungTage.setValue(this.sicherungTage.getValue());
        this.object.setName(this.name.getValue());
        this.object.setAdresse1(this.adresse1.getValue());
        this.object.setAdresse2(this.adresse2.getValue());
        this.object.setAdresse3(this.adresse3.getValue());
        this.object.setAdresse4(this.adresse4.getValue());
        this.object.setEmail(this.email.getValue());
        this.object.setKopfzeile(this.kopfzeile.getValue());
        this.object.setKopfzeileKurz(this.kopfzeileKurz.getValue());
        this.object.setFusszeile(this.fusszeile.getValue());
        this.object.setKontinent(this.kontinent.getValue());
        this.object.setLkz(this.lkz.getValue());
        this.object.setWebservice(this.webservice.getValue());
        this.object.setKonjunktion(this.konjunktion.getValue());
        this.object.setSextil(this.sextil.getValue());
        this.object.setQuadrat(this.quadrat.getValue());
        this.object.setTrigon(this.trigon.getValue());
        this.object.setOpposition(this.opposition.getValue());
        this.object.setQuinkunx(this.quinkunx.getValue());
        this.object.setGradzahlen(this.gradzahlen.getValue());
        this.object.setZwischenskala(this.zwischenskala.getValue());
        this.object.setJahresring(this.jahresring.getValue());
        this.object.setHauslinien(this.hauslinien.getValue());
        this.object.setZeiger(this.zeiger.getValue());
        this.object.setHoroskop1(this.horoskop1.getValue());
        this.object.setHoroskop2(this.horoskop2.getValue());
        this.object.setAspekte1(this.aspekte1.getValue());
        this.object.setAspekte2(this.aspekte2.getValue());
        this.object.setInterAspekte(this.interAspekte.getValue());
        this.object.setZweiterAcMc(this.zweiterAcMc.getValue());
        this.object.setEigeneAnalysetexte(this.eigeneAnalysetexte.getValue());
        this.object.setIconTypeId(this.iconType.getValue());
        this.object.setIconSizeId(this.iconSize.getValue());
        this.object.setReporttypId(this.reporttyp.getValue());
        this.object.setLineWidth(this.lineWidth.getIntValue());
        this.object.setStufe1(this.stufe1.getIntValue());
        this.object.setStufe2(this.stufe2.getIntValue());
        if (LicenseHandler.getInstance().isAllowed(LicenseHandler.LicenseType.ADMIN)) {
            this.object.setSteuersatz(this.steuersatz.getIntValue());
            this.object.setRechnungsnummer(this.rechnungsnummer.getValue());
            this.object.setHeader1(this.header1.getValue());
            this.object.setHeader2(this.header2.getValue());
            this.object.setHeader3(this.header3.getValue());
            this.object.setAbsender(this.absender.getValue());
            this.object.setRechnungsdaten(this.rechnungsdaten.getValue());
            this.object.setBetreff(this.betreff.getValue());
            this.object.setText1(this.text1.getValue());
            this.object.setText2(this.text2.getValue());
            this.object.setText3(this.text3.getValue());
            this.object.setFooter1(this.footer1.getValue());
            this.object.setFooter2(this.footer2.getValue());
            this.object.setFooter3(this.footer3.getValue());
            this.object.setRand1(this.rand1.getValue());
            this.object.setRand2(this.rand2.getValue());
            this.object.setRand3(this.rand3.getValue());
            if (Util.isEmpty(this.object.getKopfzeileKurz()) && !Util.isEmpty(this.object.getName())) {
                this.object.setKopfzeileKurz(this.object.generateKopfzeile());
            }
            if (Util.isEmpty(this.object.getKopfzeile()) && !Util.isEmpty(this.object.getName())) {
                this.object.setKopfzeile(this.object.generateKopfzeile());
            }
            if (Util.isEmpty(this.object.getFusszeile())) {
                this.object.generateFusszeile();
            }
            this.object.setOrbisArrayString(this.orbisMediator.getValue());
            this.object.setInterOrbisArrayString(this.interOrbisMediator.getValue());
        }
        return this.object;
    }

    public void setData(IBusinessObject businessObject) throws MappingException {
        Settings object;
        if (businessObject == null) {
            businessObject = new Settings();
        }
        this.object = object = (Settings)businessObject;
        this.backupDir.setValue(object.getBackupDir());
        this.texteDir.setValue(object.getTexteDir());
        this.userDir.setValue(object.getWorkingDir());
        this.logoFile.setValue(object.getLogoFile());
        this.automatischeSicherung.setValue(object.isAutomatischeSicherung());
        this.sicherungTage.setValue(object.getSicherungTage());
        this.letzteSicherung.setValue(Converter.datetimeToHHmmString(object.getLetzteSicherung(), null));
        this.name.setValue(object.getName());
        this.adresse1.setValue(object.getAdresse1());
        this.adresse2.setValue(object.getAdresse2());
        this.adresse3.setValue(object.getAdresse3());
        this.adresse4.setValue(object.getAdresse4());
        this.email.setValue(object.getEmail());
        this.kopfzeile.setValue(object.getKopfzeile());
        this.kopfzeileKurz.setValue(object.getKopfzeileKurz());
        this.fusszeile.setValue(object.getFusszeile());
        this.kontinent.setValue(object.getKontinent());
        this.lkz.setValue(object.getLkz());
        this.webservice.setValue(object.isWebservice());
        this.datenbank.setValue(!object.isWebservice());
        this.konjunktion.setValue(object.isKonjunktion());
        this.sextil.setValue(object.isSextil());
        this.quadrat.setValue(object.isQuadrat());
        this.trigon.setValue(object.isTrigon());
        this.opposition.setValue(object.isOpposition());
        this.quinkunx.setValue(object.isQuinkunx());
        this.gradzahlen.setValue(object.isGradzahlen());
        this.zwischenskala.setValue(object.isZwischenskala());
        this.jahresring.setValue(object.isJahresring());
        this.hauslinien.setValue(object.isHauslinien());
        this.zeiger.setValue(object.isZeiger());
        this.horoskop1.setValue(object.isHoroskop1());
        this.horoskop2.setValue(object.isHoroskop2());
        this.aspekte1.setValue(object.isAspekte1());
        this.aspekte2.setValue(object.isAspekte2());
        this.interAspekte.setValue(object.isInterAspekte());
        this.zweiterAcMc.setValue(object.isZweiterAcMc());
        this.eigeneAnalysetexte.setValue(object.isEigeneAnalysetexte());
        this.iconType.setValue(object.getIconTypeId());
        this.iconSize.setValue(object.getIconSizeId());
        this.reporttyp.setValue(object.getReporttypId());
        this.lineWidth.setValue(object.getLineWidth());
        this.stufe1.setValue(object.getStufe1());
        this.stufe2.setValue(object.getStufe2());
        if (LicenseHandler.getInstance().isAllowed(LicenseHandler.LicenseType.ADMIN)) {
            this.orbisMediator.setValue(object.getOrbisArrayString());
            this.interOrbisMediator.setValue(object.getInterOrbisArrayString());
            this.steuersatz.setValue(object.getSteuersatz());
            this.rechnungsnummer.setValue(object.getRechnungsnummer());
            this.header1.setValue(object.getHeader1());
            this.header2.setValue(object.getHeader2());
            this.header3.setValue(object.getHeader3());
            this.absender.setValue(object.getAbsender());
            this.betreff.setValue(object.getBetreff());
            this.rechnungsdaten.setValue(object.getRechnungsdaten());
            this.text1.setValue(object.getText1());
            this.text2.setValue(object.getText2());
            this.text3.setValue(object.getText3());
            this.footer1.setValue(object.getFooter1());
            this.footer2.setValue(object.getFooter2());
            this.footer3.setValue(object.getFooter3());
            this.rand1.setValue(object.getRand1());
            this.rand2.setValue(object.getRand2());
            this.rand3.setValue(object.getRand3());
        }
        this.guiUtil.setChanged(false);
    }

    public void setFocus() {
        this.name.setFocus();
        this.tabFolder.setFocus();
    }

    public boolean isDataChanged() {
        return this.guiUtil.isChanged();
    }

    public void enableButtons(boolean enable) {
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            this.guiUtil.enableAllWidgets();
        } else {
            this.guiUtil.disableAllWidgets();
        }
    }

    public void handleEditChanged() {
        if (this.controller.isPopupMode()) {
            this.setEnabled(false);
            return;
        }
        SettingsController controller = (SettingsController)this.controller;
        if (controller.getPageEditStatus() == IPageController.PageEditStatus.disabled) {
            this.setEnabled(GlobalData.getInstance().isAlwaysEnabled());
            controller.getToolbarWrapper().setEnabled(SaveAction.id, GlobalData.getInstance().isAlwaysEnabled());
        } else if (controller.getPageEditStatus() == IPageController.PageEditStatus.enabledforNew || controller.getPageEditStatus() == IPageController.PageEditStatus.enabledforUpdate) {
            this.setEnabled(true);
            controller.getToolbarWrapper().setEnabled(SaveAction.id, true);
            this.enableButtons(true);
        }
    }

    private Composite createContentOrben(Composite parent, Horoskop h) {
        this.createContentOrben(parent, h, this.orbisMediator, false);
        if (h.getPlanetenSaetze() > 1) {
            this.createContentOrben(parent, h, this.interOrbisMediator, true);
        }
        return parent;
    }

    private Composite createContentOrben(Composite parent, final Horoskop h, final OrbisMediator om, final boolean interAspekte) {
        int i;
        String name = interAspekte ? "Inter-Aspekte" : "Aspekte";
        this.guiUtil.setDefaultSpan(1);
        int spalten = Constants.planeten.length;
        if (interAspekte) {
            // empty if block
        }
        Group c = GuiContainer.newGroup(parent, name, spalten + 1, 1);
        this.guiUtil.createLabel((Composite)c, "");
        for (i = 0; i < spalten; ++i) {
            this.guiUtil.createLeftAllignedLabel((Composite)c, Constants.planeten[i]);
        }
        for (i = 1; i < Constants.aspekt.length; ++i) {
            this.guiUtil.createLabel((Composite)c, Constants.aspekt[i]);
            for (int j = 0; j < spalten; ++j) {
                TextWrapper t = this.guiUtil.createRightNumberText((Composite)c, "", 20, 1);
                om.setOrbisTextWrapper(h.ordinal(), i, j, t);
            }
        }
        this.guiUtil.setDefaultSpan(2);
        Composite buttonRow = this.guiUtil.createRowComposite(parent, 6);
        ButtonWrapper resetButton = this.guiUtil.createPushButton(buttonRow, "Zur\u00fccksetzen auf Werkseinstellungen", "Zur\u00fccksetzen auf Werkseinstellungen", Resources.ICON.SMALL_UNDO);
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ret = Popup.question("Achtung: Ihre pers\u00f6nlichen Einstellungen gehen dabei verloren.\n\nM\u00f6chten Sie die Orben wieder auf die Werkseinstellungen zur\u00fccksetzen?");
                if (ret) {
                    if (interAspekte) {
                        OrbisPresettings.setInterOrben(om.getOrbisCache(), h);
                    } else {
                        OrbisPresettings.setOrben(om.getOrbisCache(), h);
                    }
                    om.refreshGui();
                }
            }
        });
        ButtonWrapper copyButton = this.guiUtil.createUnregisteredPushButton(buttonRow, "Kopieren", "Kopieren", Resources.ICON.COPY);
        copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SettingsTile.this.guiUtil.isChanged()) {
                    Popup.info("Sie m\u00fcssen Ihre \u00c4nderungen zun\u00e4chst speichern");
                    return;
                }
                SettingsTile.this.copySourceHoroskop = h;
                SettingsTile.this.copySourceMediator = om;
            }
        });
        ButtonWrapper pasteButton = this.guiUtil.createUnregisteredPushButton(buttonRow, "Einf\u00fcgen", "Einf\u00fcgen", Resources.ICON.PASTE);
        pasteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SettingsTile.this.guiUtil.isChanged()) {
                    Popup.info("Sie m\u00fcssen Ihre \u00c4nderungen zun\u00e4chst speichern");
                    return;
                }
                SettingsTile.this.copyDestHoroskop = h;
                SettingsTile.this.copyDestMediator = om;
                if (SettingsTile.this.copySourceHoroskop == null || SettingsTile.this.copyDestHoroskop == null || SettingsTile.this.copySourceMediator == null) {
                    return;
                }
                om.getOrbisCache().copyOrben(SettingsTile.this.copySourceHoroskop, SettingsTile.this.copySourceMediator.getOrbisCache(), SettingsTile.this.copyDestHoroskop);
                om.refreshGui();
            }
        });
        ButtonWrapper replaceButton = this.guiUtil.createUnregisteredPushButton(buttonRow, "Suchen/Ersetzen", "Suchen/Ersetzen", Resources.ICON.EXCHANGE);
        replaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    om.getOrbisCache().string2object(om.getValue());
                    String[] s = Popup.searchReplacePopup("", "", true);
                    if (s != null && s.length == 2) {
                        int von = Util.isEmpty(s[0]) ? -1 : Converter.stringToInt(s[0]);
                        int nach = Converter.stringToInt(s[1]);
                        om.getOrbisCache().replace(h, von, nach);
                        om.refreshGui();
                    }
                }
                catch (Exception ex) {
                    ErrorHandler.handleError(log, ex);
                }
            }
        });
        ButtonWrapper minusButton = this.guiUtil.createUnregisteredPushButton(buttonRow, "-", "-", Resources.ICON.MINUS);
        minusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    om.getOrbisCache().string2object(om.getValue());
                    om.getOrbisCache().add(h, -1);
                    om.refreshGui();
                }
                catch (Exception ex) {
                    ErrorHandler.handleError(log, ex);
                }
            }
        });
        ButtonWrapper plusButton = this.guiUtil.createUnregisteredPushButton(buttonRow, "+", "+", Resources.ICON.PLUS);
        plusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    om.getOrbisCache().string2object(om.getValue());
                    om.getOrbisCache().add(h, 1);
                    om.refreshGui();
                }
                catch (Exception ex) {
                    ErrorHandler.handleError(log, ex);
                }
            }
        });
        return parent;
    }
}

