/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.personendaten;

import de.cni.client.gui.pages.personendaten.PersonendatenController;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.reporting.JasperClientFacade;
import de.cni.common.datamodel.admin.JobParameter;
import de.cni.common.datamodel.admin.Reportinfo;
import de.cni.common.datamodel.batch.ReportSpec;
import de.cni.common.datamodel.enumtypes.ReportParameter;
import de.cni.common.exceptions.DatabaseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportjobController {
    private static Log log = LogFactory.getLog(PersonendatenController.class);

    public void startBatch(int dokumenttypId, boolean clientJob, Map<String, Object> presetParameters, boolean show, String filename) {
        try {
            log.debug((Object)"Start Client Batch - Beginn");
            if (dokumenttypId == 0) {
                ErrorHandler.handleError(log, "Sie m\u00fcssen zun\u00e4chste einen Dokumenten-Typ ausw\u00e4hlen.");
                return;
            }
            ReportSpec reportSpec = new ReportSpec();
            reportSpec.setFilename(filename);
            Reportinfo reportinfo = this.getReportinfo(dokumenttypId);
            if (reportinfo == null) {
                ErrorHandler.handleError(log, "Zu diesem Dokumenten-Typ sind keine Details spezifiziert.");
                return;
            }
            if (presetParameters != null) {
                reportSpec.getParameters().putAll(presetParameters);
            }
            reportSpec.setDokumentname(reportinfo.getBeschreibung());
            reportSpec.setReportinfo(reportinfo);
            reportSpec.getParameters().put("REPORTNAME", reportinfo.getBeschreibung());
            reportSpec.setShow(show);
            reportSpec.setSave(!show);
            JasperClientFacade reportClientFacade = new JasperClientFacade();
            if (show) {
                reportClientFacade.runOnlineJdbcReport(reportSpec);
            }
            if (!show) {
                reportClientFacade.saveReport(reportSpec);
            }
            log.debug((Object)"Start Client Batch - Ende");
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.handleError(log, e);
        }
    }

    public Reportinfo getReportinfo(int dokumenttypId) throws DatabaseException {
        Reportinfo r = new Reportinfo();
        r.setArchiv(false);
        r.setDokumenttypId(dokumenttypId);
        if (dokumenttypId == 1 || dokumenttypId == 2) {
            r.setArchivname("CosmicCompass");
            r.setBeschreibung("CosmicCompass");
            r.setVorlage("master");
        } else if (dokumenttypId == 3) {
            r.setArchivname("CosmicCompass_Rohdaten");
            r.setBeschreibung("CosmicCompass_Rohdaten");
            r.setVorlage("rohdaten");
        } else if (dokumenttypId == 4) {
            r.setArchivname("CosmicCompass_Rechnung");
            r.setBeschreibung("CosmicCompass_Rechnung");
            r.setVorlage("rechnung");
        }
        return r;
    }

    public Map<String, Object> getParameterMap(List<JobParameter> jobParameterList) {
        String where = "";
        String having = "";
        String orderby = "";
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (JobParameter jobParameter : jobParameterList) {
            String key = jobParameter.getParameterName();
            Object value = jobParameter.getValue();
            parameterMap.put(key, value);
        }
        parameterMap.put(ReportParameter.WHERE.getName(), where);
        parameterMap.put(ReportParameter.HAVING.getName(), having);
        parameterMap.put(ReportParameter.ORDERBY.getName(), orderby);
        return parameterMap;
    }

    private void removePresetParametersFromreportinfo(List<JobParameter> jobParameterList, Map<String, Object> presetParameters) {
        if (jobParameterList == null || presetParameters == null) {
            return;
        }
        Iterator<JobParameter> i = jobParameterList.iterator();
        while (i.hasNext()) {
            JobParameter jobParameter = i.next();
            if (!presetParameters.containsKey(jobParameter.getParameterName())) continue;
            i.remove();
            log.debug((Object)("gel\u00f6scht:" + jobParameter.getParameterName()));
        }
    }
}

