/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.personendaten;

import de.cni.client.gui.action.toolbar.CalculatorAction;
import de.cni.client.gui.action.toolbar.HoroskopAction;
import de.cni.client.gui.action.toolbar.IAnalyse;
import de.cni.client.gui.action.toolbar.IBatch;
import de.cni.client.gui.action.toolbar.ICalculator;
import de.cni.client.gui.action.toolbar.IPrintable;
import de.cni.client.gui.action.toolbar.IRechnung;
import de.cni.client.gui.action.toolbar.PrintAction;
import de.cni.client.gui.pageflow.Page;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.pages.personendaten.PersonendatenPage;
import de.cni.client.gui.pages.personendaten.PersonendatenTile;
import de.cni.client.gui.popup.filter.ExchangeParameter;
import de.cni.client.gui.popup.filter.PopupGruppe;
import de.cni.client.gui.popup.filter.PopupHoroskopUndZeitraum;
import de.cni.client.gui.popup.filter.PopupPersonendatenAndHausDialog;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPage;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPageController;
import de.cni.client.gui.templates.tableAndDetail.TableDetailPageController;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.client.gui.util.PopupRohdaten;
import de.cni.client.paint.Controlpanel;
import de.cni.client.paint.DocumentCreator;
import de.cni.client.paint.RechnungCreator;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.BatchjobTransitzeiten;
import de.cni.common.calculation.HerrscherCalculator;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.TextanalyseCalculator;
import de.cni.common.calculation.ZusatzfilterCalculator;
import de.cni.common.core.DateUtil;
import de.cni.common.core.GlobalData;
import de.cni.common.core.LicenseHandler;
import de.cni.common.core.ServerConnection;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;

public class PersonendatenController
extends TableDetailPageController
implements ICalculator,
IPrintable,
IAnalyse,
IRechnung,
IBatch {
    private static Log log = LogFactory.getLog(PersonendatenController.class);
    public PersonendatenPage personendatenPage = null;

    public PersonendatenController() {
        super(DO_LOAD_ALL_DATA_DURING_INITIALIZATION);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new CalculatorAction(this)), this.withText);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new PrintAction(this)), this.withText);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new HoroskopAction(this, Horoskop.Radix)), this.withText);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new HoroskopAction(this, Horoskop.Solar)), this.withText);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new HoroskopAction(this, Horoskop.Septar)), this.withText);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new HoroskopAction(this, Horoskop.Synastrie)), this.withText);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new HoroskopAction(this, Horoskop.Komposit)), this.withText);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new HoroskopAction(this, Horoskop.Transit)), this.withText);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new HoroskopAction(this, Horoskop.Aktualitaet)), this.withText);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new HoroskopAction(this, Horoskop.Combine)), this.withText);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new HoroskopAction(this, Horoskop.Progression)), this.withText);
        this.addToolbarItem(LicenseHandler.LicenseType.BASIC, new ActionContributionItem((IAction)new HoroskopAction(this, Horoskop.Direktion)), this.withText);
    }

    @Override
    public Page getPage() {
        return Page.personendaten;
    }

    @Override
    public void initializeValue(Object initObject) {
        super.initializeValue(initObject);
    }

    @Override
    protected IBusinessObject createNewBusinessObject() {
        Personendaten object = new Personendaten();
        return object;
    }

    @Override
    protected ITableDetailPage createNewTableDetailPage(ITableDetailPageController controller) {
        this.personendatenPage = new PersonendatenPage(controller);
        return this.personendatenPage;
    }

    protected IBusinessObjectVerwaltung getServerBean() {
        ServerConnection serverConnection = ServerConnection.getInstance();
        IBusinessObjectVerwaltung<IBusinessObject> gv = serverConnection.getObjectVerwaltung();
        return gv;
    }

    @Override
    public void tableDetailToogle(Object object) {
        boolean tableVisible = this.personendatenPage.toogle();
        System.out.println("Fired!!!");
    }

    private boolean isActionAllowed() {
        Personendaten pd = (Personendaten)this.getCurrentBusinessObject();
        if (pd == null) {
            Popup.info("Bitte zun\u00e4chst die Personenaten erfassen und speichern.");
            return false;
        }
        if (pd.getId() == 0) {
            Popup.info("Bitte zun\u00e4chst die \u00c4nderungen speichern.");
            return false;
        }
        if (this.isDataChanged()) {
            Popup.info("Sie m\u00fcssen Ihre \u00c4nderungen zun\u00e4chst speichern!");
            return false;
        }
        return true;
    }

    @Override
    public void print() {
        try {
            if (!this.isActionAllowed()) {
                return;
            }
            Controlpanel controlpanel = new Controlpanel(GlobalData.getInstance().getSettings());
            Personendaten pd = (Personendaten)this.getCurrentBusinessObject();
            HoroskopCalculator hc = new HoroskopCalculator();
            hc.calculateRadix(pd);
            DocumentCreator dc = new DocumentCreator(hc, controlpanel).setSize(1000, 1000).createDocument();
            if (controlpanel.getReporttypId() == 2) {
                dc.popupJasperViewer(1);
            } else {
                dc.popupJasperViewer(2);
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    public void calculate() {
        try {
            if (!this.isActionAllowed()) {
                return;
            }
            Personendaten pd = (Personendaten)this.getCurrentBusinessObject();
            PopupRohdaten.popupRadixdaten(pd);
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    public void analyseKonstellation() {
        if (!this.isActionAllowed()) {
            return;
        }
        Personendaten pd = (Personendaten)this.getCurrentBusinessObject();
        Astrodaten ad = new Astrodaten(pd.getLongitude(), pd.getLatitude(), pd.getGeburtsdatum());
        Controlpanel controlpanel = new Controlpanel(GlobalData.getInstance().getSettings());
        TextanalyseCalculator ac = new TextanalyseCalculator(controlpanel, ad);
        String result1 = ac.calculateKonstellation(3).toString();
        String result2 = ac.calculateKonstellation(0).toString();
        Popup.infoPopup("Analyse (3-Grad Regel)", "Analyse", result1, result2, 0);
    }

    @Override
    public void analyseHerrscher() {
        if (!this.isActionAllowed()) {
            return;
        }
        Personendaten pd = (Personendaten)this.getCurrentBusinessObject();
        Astrodaten ad = new Astrodaten(pd.getLongitude(), pd.getLatitude(), pd.getGeburtsdatum());
        HerrscherCalculator hc = new HerrscherCalculator(Horoskop.Radix.getName(), ad);
        String resultClassic = hc.calculateHerrscherAnalyseClassic(0);
        String resultClassic3GradRegel = hc.calculateHerrscherAnalyseClassic(3);
        String resultNachRandolf = hc.calculateHerrscherAnalyseNachRandolf(0);
        String resultNachRandolf3GradRegel = hc.calculateHerrscherAnalyseNachRandolf(3);
        Popup.tabInfoPopup("Analyse-Herrscher (3-Grad Regel)", "Analyse-Herrscher", "Analyse-Herrscher (3-Grad Regel)", "Analyse-Herrscher", resultNachRandolf3GradRegel, resultNachRandolf, resultClassic3GradRegel, resultClassic, 0);
    }

    @Override
    public void horoskop(Horoskop horoskop) {
        try {
            DocumentCreator creator;
            Date date;
            DocumentCreator creator2;
            HoroskopCalculator hc;
            Personendaten pd2;
            Personendaten pd1;
            ExchangeParameter exchangeParameter;
            DocumentCreator creator3;
            HoroskopCalculator hc2;
            if (!this.isActionAllowed()) {
                return;
            }
            Personendaten pd = (Personendaten)this.getCurrentBusinessObject();
            Controlpanel controlpanel = new Controlpanel(GlobalData.getInstance().getSettings());
            if (horoskop == Horoskop.Radix) {
                hc2 = new HoroskopCalculator();
                hc2.calculateRadix(pd);
                creator3 = new DocumentCreator(hc2, controlpanel).createDocument();
                creator3.popupHoroskop();
            }
            if (horoskop == Horoskop.Solar) {
                hc2 = new HoroskopCalculator();
                hc2.calculateSolar(pd);
                creator3 = new DocumentCreator(hc2, controlpanel).createDocument();
                creator3.popupHoroskop();
            }
            if (horoskop == Horoskop.Septar) {
                exchangeParameter = this.popupExchangeParameter(horoskop, pd);
                if (exchangeParameter == null) {
                    return;
                }
                HoroskopCalculator hc3 = new HoroskopCalculator();
                Date date2 = new Date();
                hc3.calculateSeptar(pd, exchangeParameter.haus, date2);
                DocumentCreator creator4 = new DocumentCreator(hc3, controlpanel).createDocument();
                creator4.popupHoroskop();
            }
            if (horoskop == Horoskop.Komposit) {
                exchangeParameter = this.popupExchangeParameter(horoskop, pd);
                if (exchangeParameter == null) {
                    return;
                }
                pd1 = exchangeParameter.personendaten1;
                pd2 = exchangeParameter.personendaten2;
                hc = new HoroskopCalculator();
                hc.calculateKomposit(pd1, pd2);
                creator2 = new DocumentCreator(hc, controlpanel).createDocument();
                creator2.popupHoroskop();
            }
            if (horoskop == Horoskop.MultiKomposit) {
                PopupGruppe popup = new PopupGruppe();
                String gruppe = popup.getGruppe();
                if (Util.isEmpty(gruppe)) {
                    return;
                }
                List<IBusinessObject> personenList = popup.getPersonList(gruppe);
                if (personenList == null) {
                    return;
                }
                hc = new HoroskopCalculator();
                hc.calculateMultiKomposit(gruppe, personenList);
                creator2 = new DocumentCreator(hc, controlpanel).createDocument();
                creator2.popupHoroskop();
            }
            if (horoskop == Horoskop.KompositTransit) {
                exchangeParameter = this.popupExchangeParameter(horoskop, pd);
                if (exchangeParameter == null) {
                    return;
                }
                pd1 = exchangeParameter.personendaten1;
                pd2 = exchangeParameter.personendaten2;
                hc = new HoroskopCalculator();
                hc.calculateKompoTransit(pd1, pd2, new Date());
                creator2 = new DocumentCreator(hc, controlpanel).createDocument();
                creator2.popupHoroskop();
            }
            if (horoskop == Horoskop.KompositSeptar) {
                exchangeParameter = this.popupExchangeParameter(horoskop, pd);
                if (exchangeParameter == null) {
                    return;
                }
                pd1 = exchangeParameter.personendaten1;
                pd2 = exchangeParameter.personendaten2;
                int haus = exchangeParameter.haus;
                HoroskopCalculator hc4 = new HoroskopCalculator();
                hc4.calculateKompositSeptar(pd1, pd2, haus);
                DocumentCreator creator5 = new DocumentCreator(hc4, controlpanel).createDocument();
                creator5.popupHoroskop();
            }
            if (horoskop == Horoskop.Temposit) {
                hc2 = new HoroskopCalculator();
                hc2.calculateTemposit(pd);
                creator3 = new DocumentCreator(hc2, controlpanel).createDocument();
                creator3.popupHoroskop();
            }
            if (horoskop == Horoskop.Septosit) {
                hc2 = new HoroskopCalculator();
                hc2.calculateSeptosit(pd, new Date());
                creator3 = new DocumentCreator(hc2, controlpanel).createDocument();
                creator3.popupHoroskop();
            }
            if (horoskop == Horoskop.Transit) {
                hc2 = new HoroskopCalculator();
                date = new Date();
                hc2.calculateTransit(pd, date);
                creator = new DocumentCreator(hc2, controlpanel).createDocument();
                creator.popupHoroskop();
            }
            if (horoskop == Horoskop.Aktualitaet) {
                hc2 = new HoroskopCalculator();
                date = new Date();
                hc2.calculateAktualitaet(pd, date);
                creator = new DocumentCreator(hc2, controlpanel).createDocument();
                creator.popupHoroskop();
            }
            if (horoskop == Horoskop.Synastrie) {
                exchangeParameter = this.popupExchangeParameter(horoskop, pd);
                if (exchangeParameter == null) {
                    return;
                }
                pd1 = exchangeParameter.personendaten1;
                pd2 = exchangeParameter.personendaten2;
                HoroskopCalculator hc5 = new HoroskopCalculator();
                hc5.calculateSynastrie(pd1, pd2);
                creator2 = new DocumentCreator(hc5, controlpanel);
                creator2.popupHoroskop();
            }
            if (horoskop == Horoskop.Combine) {
                exchangeParameter = this.popupExchangeParameter(horoskop, pd);
                if (exchangeParameter == null) {
                    return;
                }
                pd1 = exchangeParameter.personendaten1;
                pd2 = exchangeParameter.personendaten2;
                HoroskopCalculator hc6 = new HoroskopCalculator();
                hc6.calculateCombine(pd1, pd2);
                creator2 = new DocumentCreator(hc6, controlpanel).createDocument();
                creator2.popupHoroskop();
            }
            if (horoskop == Horoskop.Progression) {
                hc2 = new HoroskopCalculator();
                date = new Date();
                hc2.calculateProgression(pd, date);
                creator = new DocumentCreator(hc2, controlpanel).createDocument();
                creator.popupHoroskop();
            }
            if (horoskop == Horoskop.Direktion) {
                hc2 = new HoroskopCalculator();
                date = new Date();
                hc2.calculateDirektion(pd, date);
                creator = new DocumentCreator(hc2, controlpanel).createDocument();
                creator.popupHoroskop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.handleError(log, e);
        }
    }

    private ExchangeParameter popupExchangeParameter(Horoskop horoskop, Personendaten pd1) {
        switch (horoskop) {
            case Septar: {
                return this.popupExchangeParameterWorker(horoskop, pd1, PopupPersonendatenAndHausDialog.Selection.Haus);
            }
            case KompositSeptar: {
                return this.popupExchangeParameterWorker(horoskop, pd1, PopupPersonendatenAndHausDialog.Selection.PersonenUndHaus);
            }
            case Komposit: {
                return this.popupExchangeParameterWorker(horoskop, pd1, PopupPersonendatenAndHausDialog.Selection.Personen);
            }
            case Combine: {
                return this.popupExchangeParameterWorker(horoskop, pd1, PopupPersonendatenAndHausDialog.Selection.Personen);
            }
            case KompositTransit: {
                return this.popupExchangeParameterWorker(horoskop, pd1, PopupPersonendatenAndHausDialog.Selection.Personen);
            }
            case Synastrie: {
                return this.popupExchangeParameterWorker(horoskop, pd1, PopupPersonendatenAndHausDialog.Selection.Personen);
            }
        }
        return null;
    }

    private ExchangeParameter popupExchangeParameterWorker(Horoskop horoskop, Personendaten pd1, PopupPersonendatenAndHausDialog.Selection selection) {
        ExchangeParameter vorgabe = new ExchangeParameter();
        vorgabe.personendaten1 = pd1;
        PopupPersonendatenAndHausDialog prvDialog = new PopupPersonendatenAndHausDialog(MainApplicationWindow.getInstance().getShell(), horoskop, selection);
        prvDialog.setValue(vorgabe);
        prvDialog.open();
        if (prvDialog.getReturnCode() != 0) {
            return null;
        }
        ExchangeParameter retValue = prvDialog.getValue();
        return retValue;
    }

    @Override
    public void setFocusOnFilterHeader() {
        ((PersonendatenTile)this.tableDetailPage.getIDetailTile()).setFocus();
    }

    @Override
    public boolean preSave() {
        ((PersonendatenTile)this.tableDetailPage.getIDetailTile()).checkNoAutomatism();
        return true;
    }

    @Override
    protected List<IBusinessObject> postSelect(IBusinessObject filter, List<IBusinessObject> selectedList) {
        Personendaten myFilter = (Personendaten)filter;
        if (myFilter != null && myFilter.getPersonendatenZusatzfilter() != null && myFilter.getPersonendatenZusatzfilter().isSet() && selectedList != null && selectedList.size() > 0) {
            ZusatzfilterCalculator calc = new ZusatzfilterCalculator(myFilter.getPersonendatenZusatzfilter().getAnalyse(), !GlobalData.getInstance().getSettings().isEigeneAnalysetexte());
            selectedList = calc.getFilteredPersonendatenList(selectedList);
        }
        return selectedList;
    }

    @Override
    public void rechnung() {
        try {
            Personendaten pd = (Personendaten)this.getCurrentBusinessObject();
            RechnungCreator creator = new RechnungCreator(pd);
            creator.popupJasperViewer();
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    public void batch() {
        try {
            if (!this.isActionAllowed()) {
                return;
            }
            Personendaten pd1 = (Personendaten)this.getCurrentBusinessObject();
            Date today = new Date();
            ExchangeParameter exchangeParameter = new ExchangeParameter();
            exchangeParameter.horoskop = Horoskop.Transit;
            exchangeParameter.personendaten1 = pd1;
            exchangeParameter.von = today;
            exchangeParameter.bis = DateUtil.dateAddYears(exchangeParameter.von, 1);
            exchangeParameter.date = today;
            PopupHoroskopUndZeitraum popup = new PopupHoroskopUndZeitraum(MainApplicationWindow.getInstance().getShell());
            popup.setValue(exchangeParameter);
            popup.open();
            if (popup.getReturnCode() != 0) {
                return;
            }
            exchangeParameter = popup.getValue();
            BatchjobTransitzeiten batch = new BatchjobTransitzeiten();
            batch.runBatch(exchangeParameter);
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }
}

