/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.personendaten;

import de.cni.client.gui.pages.personendaten.PersonendatenTile;
import de.cni.client.gui.popup.filter.PopupGruppe;
import de.cni.client.gui.tiles.table.PersonGruppeTableController;
import de.cni.client.gui.tiles.table.templates.ITableListener;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.datamodel.admin.PersonGruppe;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersonGruppeTableListener
implements ITableListener {
    private static Log log = LogFactory.getLog(PersonGruppeTableListener.class);
    PersonGruppeTableController personGruppeTableController;
    private PersonendatenTile personendatenTile;

    public PersonGruppeTableListener(PersonGruppeTableController personGruppeTableController, PersonendatenTile personendatenTile) {
        this.personGruppeTableController = personGruppeTableController;
        this.personendatenTile = personendatenTile;
    }

    @Override
    public void selectionChanged(Object firstObject, int cnt) {
    }

    @Override
    public boolean deleteLine() {
        try {
            SqLiteDatabase db = new SqLiteDatabase();
            List<Object> l = this.personGruppeTableController.getSelectedObjects();
            if (l != null && l.size() > 0) {
                for (Object obj : l) {
                    db.delete((PersonGruppe)obj);
                }
            }
            return true;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return false;
        }
    }

    @Override
    public boolean newLine() {
        try {
            Personendaten personendaten = this.personendatenTile.getData();
            if (personendaten.getId() == 0) {
                Popup.warning("Sie m\u00fcssen eine neue Person zun\u00e4chst einmal speichern, bevor Sie sie einer Gruppe zuordnen k\u00f6nnen.");
                return false;
            }
            PopupGruppe popup = new PopupGruppe();
            PersonGruppe pg = popup.getPersonGruppe(personendaten);
            if (pg != null) {
                personendaten.getPersonGruppeList().add(pg);
                this.personGruppeTableController.setObjectList(personendaten.getPersonGruppeList());
            }
            return true;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return false;
        }
    }

    @Override
    public void doubleClick(Object object) {
    }
}

