/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.main;

import de.cni.client.gui.action.AboutAction;
import de.cni.client.gui.action.PageAction;
import de.cni.client.gui.action.ShowFileAction;
import de.cni.client.gui.pageflow.Page;
import de.cni.common.core.Brand;
import de.cni.common.core.GlobalData;
import de.cni.common.core.LicenseHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;

public class MainMenuBar {
    private static MenuManager newMenuManager(String name, Brand brand) {
        if (GlobalData.getInstance().hasBrand(brand)) {
            return new MenuManager(name);
        }
        return null;
    }

    private static MenuManager newMenuManager(String name) {
        return new MenuManager(name);
    }

    private static void addMenuItem(LicenseHandler.LicenseType minLicenseType, MenuManager menu, Action action, Brand brand) {
        if (GlobalData.getInstance().hasBrand(brand) && menu != null && LicenseHandler.getInstance().isAllowed(minLicenseType)) {
            menu.add((IAction)action);
        }
    }

    private static void addMenuItem(LicenseHandler.LicenseType minLicenseType, MenuManager menu, Action action) {
        if (LicenseHandler.getInstance().isAllowed(minLicenseType)) {
            MainMenuBar.addMenuItem(menu, action);
        }
    }

    private static void addMenuItem(MenuManager menu, Action action) {
        if (menu != null && action != null) {
            menu.add((IAction)action);
        }
    }

    private static void addMenuItem(LicenseHandler.LicenseType minLicenseType, MenuManager menuBar, MenuManager item) {
        if (LicenseHandler.getInstance().isAllowed(minLicenseType)) {
            MainMenuBar.addMenuItem(menuBar, item);
        }
    }

    private static void addMenuItem(MenuManager menuBar, MenuManager item) {
        if (menuBar != null && item != null) {
            menuBar.add((IContributionItem)item);
        }
    }

    private static void addMenuItem(LicenseHandler.LicenseType minLicenseType, MenuManager menuBar, MenuManager item, Brand brand) {
        if (LicenseHandler.getInstance().isAllowed(minLicenseType)) {
            MainMenuBar.addMenuItem(menuBar, item, brand);
        }
    }

    private static void addMenuItem(MenuManager menuBar, MenuManager item, Brand brand) {
        if (GlobalData.getInstance().hasBrand(brand) && menuBar != null && item != null) {
            menuBar.add((IContributionItem)item);
        }
    }

    public static MenuManager getMenuBar() {
        MenuManager menuBar = new MenuManager();
        MenuManager partnerMenu = new MenuManager("Personen-Daten");
        MainMenuBar.addMenuItem(partnerMenu, new PageAction(Page.personendaten));
        MainMenuBar.addMenuItem(LicenseHandler.LicenseType.STANDARD, partnerMenu, new PageAction(Page.gruppe));
        MainMenuBar.addMenuItem(LicenseHandler.LicenseType.PROFESSIONAL, partnerMenu, new PageAction(Page.exportPersonendaten));
        MainMenuBar.addMenuItem(LicenseHandler.LicenseType.PROFESSIONAL, partnerMenu, new PageAction(Page.importPersonendaten));
        MenuManager adminMenu = MainMenuBar.newMenuManager("Administration");
        MainMenuBar.addMenuItem(LicenseHandler.LicenseType.BASIC, adminMenu, new PageAction(Page.settings));
        MainMenuBar.addMenuItem(LicenseHandler.LicenseType.BASIC, adminMenu, new PageAction(Page.geodaten));
        MainMenuBar.addMenuItem(LicenseHandler.LicenseType.BASIC, adminMenu, new PageAction(Page.exportDb));
        MainMenuBar.addMenuItem(LicenseHandler.LicenseType.BASIC, adminMenu, new PageAction(Page.importDb));
        MenuManager hilfeMenu = MainMenuBar.newMenuManager("Hilfe");
        MainMenuBar.addMenuItem(hilfeMenu, new ShowFileAction(Page.handbuch, "Handbuch", "Handbuch.pdf"));
        MainMenuBar.addMenuItem(hilfeMenu, new PageAction(Page.exchangeLicense));
        MainMenuBar.addMenuItem(hilfeMenu, new AboutAction());
        MainMenuBar.addMenuItem(menuBar, partnerMenu);
        MainMenuBar.addMenuItem(menuBar, adminMenu);
        MainMenuBar.addMenuItem(menuBar, hilfeMenu);
        menuBar.setVisible(true);
        return menuBar;
    }
}

