/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.action.toolbar;

import de.cni.client.gui.action.ILongRunningAction;
import de.cni.client.gui.action.toolbar.ActionThread;
import de.cni.client.gui.action.toolbar.ISaveable;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.Resources;
import de.cni.common.exceptions.ValidationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.custom.BusyIndicator;

public class SaveAction
extends Action
implements ILongRunningAction {
    private static Log log = LogFactory.getLog(SaveAction.class);
    public static String id = SaveAction.class.getSimpleName();
    ISaveable object;

    public SaveAction(ISaveable object) {
        super("Daten speichern");
        super.setId(id);
        this.setToolTipText("Daten speichern");
        this.setText("Speichern");
        this.setImageDescriptor(Resources.getInstance().getImageDescriptor(Resources.ICON.BIG_SAVE));
        this.object = object;
    }

    public void run() {
        BusyIndicator.showWhile(null, (Runnable)new ActionThread(this));
    }

    @Override
    public void doRun() {
        log.debug((Object)"SaveAction - Start");
        try {
            this.save();
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
        log.debug((Object)"SaveAction - Ende");
    }

    public void save() throws Exception {
        GuiContainer.finalizeChanges();
        if (this.object.isSaveable()) {
            if (this.object.preSave()) {
                this.object.save();
            }
        } else {
            throw new ValidationException(this.object.getSaveableValidationError());
        }
    }
}

