/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.datechooser;

import de.jaret.util.date.holidayenumerator.HolidayEnumerator;
import de.jaret.util.swt.SwtGraphicsHelper;
import de.jaret.util.ui.datechooser.IAdditionalDayInformationProvider;
import de.jaret.util.ui.datechooser.IDateChooserListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DateChooserPanel
extends Composite
implements MouseListener {
    protected Date _date;
    protected static DateFormatSymbols _dateFormatSymbols;
    protected static Calendar _calendar;
    protected static final Color DEFAULTMARKERCOLOR;
    protected static final Color DEFAULTHOLIDAYCOLOR;
    protected static final Color DEFAULTSPECIALDAYCOLOR;
    protected Color _markerColor = DEFAULTMARKERCOLOR;
    protected Color _holidayColor = DEFAULTHOLIDAYCOLOR;
    protected Color _specialDayColor = DEFAULTSPECIALDAYCOLOR;
    protected boolean _displayWeeks = false;
    protected boolean _oneClickSelection;
    protected HolidayEnumerator _holidayEnumerator;
    protected IAdditionalDayInformationProvider _dayInformationProvider;
    protected Label _monthLabel;
    protected Label _todayLabel;
    protected Button _incMonthButton;
    protected Button _decMonthButton;
    protected DayGrid _dayGrid;
    protected List<IDateChooserListener> _listenerList;
    protected Locale _locale;
    private Font _weekdayFont;
    private Font _weekNumberFont;

    public DateChooserPanel(Composite parent, int style, boolean oneClickSelection, boolean displayWeeks, Locale locale) {
        super(parent, style);
        this._oneClickSelection = oneClickSelection;
        this._displayWeeks = displayWeeks;
        this._locale = locale;
        _dateFormatSymbols = new DateFormatSymbols(this._locale);
        _calendar = new GregorianCalendar(this._locale);
        this.createControls();
        this.setDate(new Date());
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                DateChooserPanel.this.handleKeyPressed(event);
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 37: {
                        int count = -event.count / 3;
                        if ((event.stateMask & 0x20000) != 0) {
                            DateChooserPanel.this.rollMonth(count);
                            break;
                        }
                        DateChooserPanel.this.rollDay(count);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unsupported event");
                    }
                }
            }
        };
        this.addListener(37, listener);
    }

    public DateChooserPanel(Composite parent, int style) {
        this(parent, style, false, true, Locale.getDefault());
    }

    public void dispose() {
        super.dispose();
        if (this._weekdayFont != null) {
            this._weekdayFont.dispose();
        }
        if (this._weekNumberFont != null) {
            this._weekNumberFont.dispose();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this._monthLabel.setBackground(color);
        this._todayLabel.setBackground(color);
        this._dayGrid.setBackground(color);
    }

    private void handleKeyPressed(KeyEvent event) {
        if ((event.stateMask & 0x20000) != 0) {
            switch (event.keyCode) {
                case 0x1000004: {
                    this.incMonth();
                    break;
                }
                case 0x1000003: {
                    this.decMonth();
                    break;
                }
            }
        } else {
            switch (event.keyCode) {
                case 27: {
                    this.fireChoosingCanceled();
                    break;
                }
                case 13: {
                    this.fireDateChosen(this.getDate());
                    break;
                }
                case 0x1000004: {
                    this.incDay();
                    break;
                }
                case 0x1000003: {
                    this.decDay();
                    break;
                }
                case 0x1000002: {
                    this.incWeek();
                    break;
                }
                case 0x1000001: {
                    this.decWeek();
                    break;
                }
                case 84: 
                case 116: {
                    this.today();
                    break;
                }
            }
        }
    }

    private void incMonth() {
        _calendar.add(2, 1);
        this.intermediateChange();
    }

    private void decMonth() {
        _calendar.add(2, -1);
        this.intermediateChange();
    }

    private void rollMonth(int count) {
        _calendar.add(2, count);
        this.intermediateChange();
    }

    private void incDay() {
        _calendar.add(5, 1);
        this.intermediateChange();
    }

    private void decDay() {
        _calendar.add(5, -1);
        this.intermediateChange();
    }

    private void rollDay(int count) {
        _calendar.add(5, count);
        this.intermediateChange();
    }

    private void incWeek() {
        _calendar.add(5, 7);
        this.intermediateChange();
    }

    private void decWeek() {
        _calendar.add(5, -7);
        this.intermediateChange();
    }

    private void today() {
        this.setDate(new Date());
        this.fireIntermediateChange(this.getDate());
    }

    private void intermediateChange() {
        this.updateMonthLabel();
        this.redraw();
        this.fireIntermediateChange(this.getDate());
        this.forceFocus();
    }

    public void setDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        if (!date.equals(this._date)) {
            this._date = date;
            _calendar.setTime(this._date);
            this.updateMonthLabel();
            this.redraw();
        }
    }

    public Date getDate() {
        this._date = _calendar.getTime();
        return this._date;
    }

    public void redraw() {
        super.redraw();
        this._dayGrid.redraw();
    }

    private void createControls() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        this._decMonthButton = new Button((Composite)this, 16388);
        GridData gd = new GridData();
        this._decMonthButton.setLayoutData((Object)gd);
        this._decMonthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DateChooserPanel.this.decMonth();
            }
        });
        this._monthLabel = new Label((Composite)this, 0x1000000);
        this._monthLabel.setText(this.getMonthText());
        gd = new GridData(768);
        this._monthLabel.setLayoutData((Object)gd);
        this._monthLabel.setBackground(this.getBackground());
        this._incMonthButton = new Button((Composite)this, 131076);
        gd = new GridData(128);
        this._incMonthButton.setLayoutData((Object)gd);
        this._incMonthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DateChooserPanel.this.incMonth();
            }
        });
        this._dayGrid = new DayGrid(this, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this._dayGrid.setLayoutData(gd);
        this._dayGrid.addMouseListener(this);
        this._dayGrid.setBackground(this.getBackground());
        this._todayLabel = new Label((Composite)this, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this._todayLabel.setLayoutData((Object)gd);
        this._todayLabel.setBackground(this.getBackground());
        DateFormat df = DateFormat.getDateInstance(0, this._locale);
        this._todayLabel.setText(df.format(new Date()));
        this._todayLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DateChooserPanel.this.today();
            }
        });
    }

    private void updateMonthLabel() {
        this._monthLabel.setText(this.getMonthText());
    }

    private String getMonthText() {
        int month = _calendar.get(2);
        int year = _calendar.get(1);
        String monthShort = _dateFormatSymbols.getShortMonths()[month];
        return monthShort + " " + year;
    }

    public void mouseDoubleClick(MouseEvent event) {
        boolean success = this.setDateByLocation(event.x, event.y);
        if (success) {
            this.fireDateChosen(this.getDate());
        }
    }

    public void mouseDown(MouseEvent event) {
        boolean success = this.setDateByLocation(event.x, event.y);
        if (this._oneClickSelection && success) {
            this.fireDateChosen(this.getDate());
        } else {
            this.fireIntermediateChange(this.getDate());
        }
    }

    public void mouseUp(MouseEvent event) {
    }

    protected boolean setDateByLocation(int x, int y) {
        int day = this._dayGrid.dayForLocation(x, y);
        if (day > 0) {
            _calendar.set(5, day);
            this._dayGrid.redraw();
            return true;
        }
        return false;
    }

    public synchronized void addDateChooserListener(IDateChooserListener listener) {
        if (this._listenerList == null) {
            this._listenerList = new Vector<IDateChooserListener>();
        }
        this._listenerList.add(listener);
    }

    public synchronized void remDateChooserListener(IDateChooserListener listener) {
        if (this._listenerList == null) {
            return;
        }
        this._listenerList.remove(listener);
    }

    protected void fireDateChosen(Date date) {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.dateChosen(date);
            }
        }
    }

    protected void fireIntermediateChange(Date date) {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.dateIntermediateChange(date);
            }
        }
    }

    protected void fireChoosingCanceled() {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.choosingCanceled();
            }
        }
    }

    public HolidayEnumerator getHolidayEnumerator() {
        return this._holidayEnumerator;
    }

    public void setHolidayEnumerator(HolidayEnumerator holidayEnumerator) {
        this._holidayEnumerator = holidayEnumerator;
        this.redraw();
    }

    public IAdditionalDayInformationProvider getAdditionalDayInformationProvider() {
        return this._dayInformationProvider;
    }

    public void setAdditionalDayInformationProvider(IAdditionalDayInformationProvider informationProvider) {
        this._dayInformationProvider = informationProvider;
        this.redraw();
    }

    public boolean isDisplayWeeks() {
        return this._displayWeeks;
    }

    public void setDisplayWeeks(boolean displayWeeks) {
        this._displayWeeks = displayWeeks;
        this.redraw();
    }

    public boolean isOneClickSelection() {
        return this._oneClickSelection;
    }

    public void setOneClickSelection(boolean oneClickSelection) {
        this._oneClickSelection = oneClickSelection;
    }

    public Color getMarkerColor() {
        return this._markerColor;
    }

    public void setMarkerColor(Color markerColor) {
        this._markerColor = markerColor;
    }

    public Color getHolidayColor() {
        return this._holidayColor;
    }

    public void setHolidayColor(Color holidayColor) {
        this._holidayColor = holidayColor;
    }

    public Color getSpecialDayColor() {
        return this._specialDayColor;
    }

    public void setSpecialDayColor(Color specialDayColor) {
        this._specialDayColor = specialDayColor;
    }

    static {
        DEFAULTMARKERCOLOR = Display.getCurrent().getSystemColor(9);
        DEFAULTHOLIDAYCOLOR = Display.getCurrent().getSystemColor(3);
        DEFAULTSPECIALDAYCOLOR = Display.getCurrent().getSystemColor(7);
    }

    class DayGrid
    extends Canvas {
        int width;
        int height;
        int columnWidth;
        int rowHeight;
        int posOfFirstInMonth;
        int daysInMonth;
        int day;
        int month;
        int weekColumnWidth;

        public DayGrid(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    DayGrid.this.onPaint(event);
                }
            });
            this.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    DayGrid.this.handleTraverse(event);
                }
            });
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseHover(MouseEvent event) {
                    Date date = DayGrid.this.dateForLocation(event.x, event.y);
                    if (date == null) {
                        DayGrid.this.setToolTipText(null);
                    } else {
                        DayGrid.this.setToolTipText(DayGrid.this.getTooltipText(date));
                    }
                }
            });
        }

        protected String getTooltipText(Date date) {
            String text;
            if (date == null) {
                return null;
            }
            if (DateChooserPanel.this._dayInformationProvider != null && (text = DateChooserPanel.this._dayInformationProvider.getToolTipText(date)) != null) {
                return text;
            }
            if (DateChooserPanel.this._holidayEnumerator != null && (text = DateChooserPanel.this._holidayEnumerator.getDayName(date)) != null) {
                return text;
            }
            return null;
        }

        public Point computeSize(int arg0, int arg1, boolean arg2) {
            return new Point(200, 150);
        }

        void handleTraverse(Event event) {
        }

        public void updateInternals() {
            this.width = this.getClientArea().width;
            this.height = this.getClientArea().height;
            this.daysInMonth = _calendar.getActualMaximum(5);
            this.day = _calendar.get(5);
            this.month = _calendar.get(2);
            Calendar tmpCalendar = (Calendar)_calendar.clone();
            tmpCalendar.set(5, 1);
            this.posOfFirstInMonth = this.getWeekdayPos(tmpCalendar.get(7));
            this.weekColumnWidth = DateChooserPanel.this._displayWeeks ? this.width / 8 : 0;
            this.columnWidth = (this.width - this.weekColumnWidth) / 7;
            this.rowHeight = this.height / 7;
        }

        protected Font getWeekdayFont(GC gc) {
            if (DateChooserPanel.this._weekdayFont == null) {
                DateChooserPanel.this._weekdayFont = new Font((Device)Display.getCurrent(), gc.getFont().getFontData()[0].getName(), gc.getFont().getFontData()[0].getHeight(), 1);
            }
            return DateChooserPanel.this._weekdayFont;
        }

        protected Font getWeekNumberFont(GC gc) {
            if (DateChooserPanel.this._weekNumberFont == null) {
                DateChooserPanel.this._weekNumberFont = new Font((Device)Display.getCurrent(), gc.getFont().getFontData()[0].getName(), (int)((double)gc.getFont().getFontData()[0].getHeight() * 0.9), 0);
            }
            return DateChooserPanel.this._weekNumberFont;
        }

        private void onPaint(PaintEvent event) {
            int dy;
            this.updateInternals();
            GC gc = event.gc;
            Font oldFont = gc.getFont();
            gc.setFont(this.getWeekdayFont(gc));
            for (int weekday = 1; weekday < 8; ++weekday) {
                int pos = this.getWeekdayPos(weekday);
                boolean isWeekend = false;
                if (weekday == 7 || weekday == 1) {
                    isWeekend = true;
                }
                Color color = isWeekend ? Display.getCurrent().getSystemColor(3) : Display.getCurrent().getSystemColor(2);
                this.drawCell(gc, pos, 0, this.getWeekdayString(weekday), color, false);
            }
            gc.setFont(oldFont);
            int[] weeks = new int[6];
            GregorianCalendar tmpCalendar = new GregorianCalendar();
            tmpCalendar.setTime(DateChooserPanel.this._date);
            tmpCalendar.set(5, 1);
            ((Calendar)tmpCalendar).add(5, -this.posOfFirstInMonth);
            for (dy = 0; dy < 6; ++dy) {
                weeks[dy] = tmpCalendar.get(3);
                for (int dx = 0; dx < 7; ++dx) {
                    int paintDay = tmpCalendar.get(5);
                    int paintMonth = tmpCalendar.get(2);
                    Color color = Display.getCurrent().getSystemColor(2);
                    if (paintMonth != this.month) {
                        color = Display.getCurrent().getSystemColor(16);
                    } else if (DateChooserPanel.this._holidayEnumerator != null) {
                        if (DateChooserPanel.this._holidayEnumerator.isHoliday(tmpCalendar.getTime())) {
                            color = DateChooserPanel.this._holidayColor;
                        } else if (DateChooserPanel.this._holidayEnumerator.isSpecialDay(tmpCalendar.getTime())) {
                            color = DateChooserPanel.this._specialDayColor;
                        }
                    }
                    Font normalFont = gc.getFont();
                    if (DateChooserPanel.this._dayInformationProvider != null && DateChooserPanel.this._dayInformationProvider.renderBold(tmpCalendar.getTime())) {
                        gc.setFont(this.getWeekdayFont(gc));
                    } else {
                        gc.setFont(normalFont);
                    }
                    this.drawCell(gc, dx, dy + 1, Integer.toString(paintDay), color, paintDay == this.day && paintMonth == this.month);
                    ((Calendar)tmpCalendar).add(5, 1);
                    gc.setFont(normalFont);
                }
            }
            oldFont = gc.getFont();
            gc.setForeground(Display.getCurrent().getSystemColor(16));
            gc.setFont(this.getWeekNumberFont(gc));
            for (dy = 0; dy < 6; ++dy) {
                int y = (dy + 1) * this.rowHeight;
                int rx = this.columnWidth - (int)((double)this.columnWidth * 0.2);
                SwtGraphicsHelper.drawStringRightAlignedVCenter((GC)gc, (String)Integer.toString(weeks[dy]), (int)rx, (int)(y + this.rowHeight / 2));
            }
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.setFont(oldFont);
        }

        private void drawCell(GC gc, int pos, int row, String string, Color foreground, boolean mark) {
            int x = pos * this.columnWidth + this.weekColumnWidth;
            int y = row * this.rowHeight;
            Color oldFG = gc.getForeground();
            Color oldBG = gc.getBackground();
            gc.setForeground(foreground);
            if (mark) {
                gc.setBackground(DateChooserPanel.this._markerColor);
                gc.fillRectangle(x, y, this.columnWidth - 1, this.rowHeight - 1);
            }
            SwtGraphicsHelper.drawStringCenteredVCenter((GC)gc, (String)string, (int)x, (int)(x + this.columnWidth), (int)(y + this.rowHeight / 2));
            gc.setForeground(oldFG);
            gc.setBackground(oldBG);
        }

        protected int dayForLocation(int x, int y) {
            int row = y / this.rowHeight - 1;
            int col = (x - this.weekColumnWidth) / this.columnWidth;
            int day = row * 7 + col + 1;
            if ((day -= this.posOfFirstInMonth) < 1 || day > _calendar.getActualMaximum(5)) {
                day = -1;
            }
            return day;
        }

        protected Date dateForLocation(int x, int y) {
            int row = y / this.rowHeight - 1;
            int col = (x - this.weekColumnWidth) / this.columnWidth;
            int day = row * 7 + col + 1;
            GregorianCalendar tmpCalendar = new GregorianCalendar();
            tmpCalendar.setTime(DateChooserPanel.this.getDate());
            tmpCalendar.set(5, 1);
            ((Calendar)tmpCalendar).add(5, (day -= this.posOfFirstInMonth) - 1);
            return tmpCalendar.getTime();
        }

        private String getWeekdayString(int weekday) {
            return _dateFormatSymbols.getShortWeekdays()[weekday];
        }

        private int getWeekdayPos(int weekday) {
            int firstDay = _calendar.getFirstDayOfWeek();
            int pos = weekday - firstDay;
            if (pos < 0) {
                pos += 7;
            }
            return pos;
        }
    }
}

