/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax0.license3j.Feature;
import javax0.license3j.crypto.LicenseKeyPair;

public class License {
    private static final int MAGIC = 567168606;
    private static final String LICENSE_ID = "licenseId";
    private static final String SIGNATURE_KEY = "licenseSignature";
    private static final String DIGEST_KEY = "signatureDigest";
    private static final String EXPIRATION_DATE = "expiryDate";
    private final Map<String, Feature> features = new HashMap<String, Feature>();

    public License() {
    }

    protected License(License license) {
        this.features.putAll(license.features);
    }

    public Feature get(String name) {
        return this.features.get(name);
    }

    public boolean isExpired() {
        Date expiryDate = this.get(EXPIRATION_DATE).getDate();
        Date today = new Date();
        return today.getTime() > expiryDate.getTime();
    }

    public void setExpiry(Date expiryDate) {
        this.add(Feature.Create.dateFeature(EXPIRATION_DATE, expiryDate));
    }

    public void sign(PrivateKey key, String digest) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        this.add(Feature.Create.stringFeature(DIGEST_KEY, digest));
        MessageDigest digester = MessageDigest.getInstance(digest);
        byte[] ser = this.unsigned();
        byte[] digestValue = digester.digest(ser);
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(1, key);
        byte[] signature = cipher.doFinal(digestValue);
        this.add(signature);
    }

    public boolean isOK(byte[] key) {
        try {
            return this.isOK(LicenseKeyPair.Create.from(key, 1).getPair().getPublic());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isOK(PublicKey key) {
        try {
            MessageDigest digester = MessageDigest.getInstance(this.get(DIGEST_KEY).getString());
            byte[] ser = this.unsigned();
            byte[] digestValue = digester.digest(ser);
            Cipher cipher = Cipher.getInstance(key.getAlgorithm());
            cipher.init(2, key);
            byte[] sigDigest = cipher.doFinal(this.getSignature());
            return Arrays.equals(digestValue, sigDigest);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Feature add(Feature feature) {
        if (feature.name().equals(SIGNATURE_KEY) && !feature.isBinary()) {
            throw new IllegalArgumentException("Signature of a license has to be binary.");
        }
        return this.features.put(feature.name(), feature);
    }

    public String toString() {
        Feature[] features;
        StringBuilder sb = new StringBuilder();
        for (Feature feature : features = this.featuresSorted(Collections.emptySet())) {
            String valueString = feature.valueString();
            String value = valueString.contains("\n") || valueString.startsWith("<<") ? this.multilineValueString(valueString) : valueString;
            sb.append(feature.toStringWith(value)).append("\n");
        }
        return sb.toString();
    }

    private Feature[] featuresSorted(Set<String> excluded) {
        return (Feature[])this.features.values().stream().filter(f -> !excluded.contains(f.name())).sorted(Comparator.comparing(Feature::name)).toArray(Feature[]::new);
    }

    public Map<String, Feature> getFeatures() {
        Feature[] features;
        LinkedHashMap<String, Feature> result = new LinkedHashMap<String, Feature>();
        for (Feature feature : features = this.featuresSorted(new HashSet<String>(Arrays.asList(new String[0])))) {
            result.put(feature.name(), feature);
        }
        return Collections.unmodifiableMap(result);
    }

    private String multilineValueString(String s) {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(s.split("\n")));
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String line : lines) {
            sb.append((char)(line.length() <= i || line.charAt(i) == 'A' ? 66 : 65));
            ++i;
        }
        String delimiter = sb.toString();
        String shortDelimiter = null;
        for (int j = 1; j < delimiter.length(); ++j) {
            if (lines.contains(delimiter.substring(0, j))) continue;
            shortDelimiter = delimiter.substring(0, j);
            break;
        }
        lines.add(0, "<<" + shortDelimiter);
        lines.add(shortDelimiter);
        return String.join((CharSequence)"\n", lines);
    }

    public UUID setLicenseId() {
        UUID uuid = UUID.randomUUID();
        this.setLicenseId(uuid);
        return uuid;
    }

    public UUID getLicenseId() {
        try {
            return this.get(LICENSE_ID).getUUID();
        }
        catch (Exception e) {
            return null;
        }
    }

    public UUID fingerprint() {
        try {
            ByteBuffer bb = ByteBuffer.wrap(MessageDigest.getInstance("MD5").digest(this.serialized(new HashSet<String>(Arrays.asList(SIGNATURE_KEY, DIGEST_KEY)))));
            long ms = bb.getLong();
            long ls = bb.getLong();
            return new UUID(ms, ls);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setLicenseId(UUID licenseId) {
        this.add(Feature.Create.uuidFeature(LICENSE_ID, licenseId));
    }

    public byte[] serialized() {
        return this.serialized(Collections.emptySet());
    }

    public byte[] unsigned() {
        return this.serialized(new HashSet<String>(Arrays.asList(SIGNATURE_KEY)));
    }

    public void add(byte[] signature) {
        this.add(Feature.Create.binaryFeature(SIGNATURE_KEY, signature));
    }

    public byte[] getSignature() {
        return this.get(SIGNATURE_KEY).getBinary();
    }

    private byte[] serialized(Set<String> excluded) {
        Feature[] includedFeatures = this.featuresSorted(excluded);
        int featureNr = includedFeatures.length;
        byte[][] featuresSerialized = new byte[featureNr][];
        int i = 0;
        int size = 0;
        for (Feature feature : includedFeatures) {
            featuresSerialized[i] = feature.serialized();
            size += featuresSerialized[i].length;
            ++i;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size + 4 * (featureNr + 1));
        buffer.putInt(567168606);
        for (byte[] featureSerialized : featuresSerialized) {
            buffer.putInt(featureSerialized.length);
            buffer.put(featureSerialized);
        }
        return buffer.array();
    }

    public static class Create {
        public static License from(byte[] array) {
            if (array.length < 4) {
                throw new IllegalArgumentException("serialized license is too short");
            }
            License license = new License();
            ByteBuffer buffer = ByteBuffer.wrap(array);
            int magic = buffer.getInt();
            if (magic != 567168606) {
                throw new IllegalArgumentException("serialized license is corrupt");
            }
            while (buffer.hasRemaining()) {
                try {
                    int featureLength = buffer.getInt();
                    byte[] featureSerialized = new byte[featureLength];
                    buffer.get(featureSerialized);
                    Feature feature = Feature.Create.from(featureSerialized);
                    license.add(feature);
                }
                catch (BufferUnderflowException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return license;
        }

        public static License from(String text) {
            License license;
            License license2 = new License();
            BufferedReader reader = new BufferedReader(new StringReader(text));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts = Feature.splitString(line);
                    String name = parts[0];
                    String typeString = parts[1];
                    String valueString = Create.getValueString(reader, parts[2]);
                    license2.add(Feature.getFeature(name, typeString, valueString));
                }
                license = license2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            reader.close();
            return license;
        }

        private static String getValueString(BufferedReader reader, String valueString) throws IOException {
            if (valueString.startsWith("<<")) {
                String valueNextLine;
                String endLine = valueString.substring(2).trim();
                StringBuilder sb = new StringBuilder();
                while ((valueNextLine = reader.readLine()) != null) {
                    if (valueNextLine.trim().equals(endLine)) {
                        return sb.toString();
                    }
                    sb.append(valueNextLine);
                }
                throw new IllegalArgumentException("Multiline value string was not terminated before EOF.");
            }
            return valueString;
        }
    }
}

