/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax0.license3j.hardware.Network;
import javax0.license3j.hardware.UUIDCalculator;

public class HardwareBinder {
    private final Network.Interface.Selector selector = new Network.Interface.Selector();
    private final UUIDCalculator calculator = new UUIDCalculator(this.selector);
    private boolean useHostName = true;
    private boolean useNetwork = true;
    private boolean useArchitecture = true;
    public final Ignore ignore = new Ignore();

    public static void main(String[] args) throws NoSuchAlgorithmException, SocketException, UnknownHostException {
        HardwareBinder hb = new HardwareBinder();
        System.out.println("The UUID of the machine is:\n" + hb.getMachineIdString() + "\n");
    }

    public HardwareBinder allowed(String regex) {
        this.selector.interfaceAllowed(regex);
        return this;
    }

    public HardwareBinder denied(String regex) {
        this.selector.interfaceDenied(regex);
        return this;
    }

    public UUID getMachineId() throws NoSuchAlgorithmException, SocketException, UnknownHostException {
        return this.calculator.getMachineId(this.useNetwork, this.useHostName, this.useArchitecture);
    }

    public String getMachineIdString() throws NoSuchAlgorithmException, SocketException, UnknownHostException {
        return this.calculator.getMachineIdString(this.useNetwork, this.useHostName, this.useArchitecture);
    }

    public boolean assertUUID(UUID uuid) throws NoSuchAlgorithmException, SocketException, UnknownHostException {
        return this.calculator.assertUUID(uuid, this.useNetwork, this.useHostName, this.useArchitecture);
    }

    public boolean assertUUID(String uuid) {
        return this.calculator.assertUUID(uuid, this.useNetwork, this.useHostName, this.useArchitecture);
    }

    public class Ignore {
        public HardwareBinder hostName() {
            HardwareBinder.this.useHostName = false;
            return HardwareBinder.this;
        }

        public HardwareBinder network() {
            HardwareBinder.this.useNetwork = false;
            return HardwareBinder.this;
        }

        public HardwareBinder architecture() {
            HardwareBinder.this.useArchitecture = false;
            return HardwareBinder.this;
        }
    }
}

