/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.Serializable;
import java.util.Random;
import swisseph.SMath;
import swisseph.SwephData;
import swisseph.SwissEph;
import swisseph.SwissLib;
import swisseph.SwissephException;
import swisseph.TransitCalculator;

public class TCPlanet
extends TransitCalculator
implements Serializable {
    private int planet;
    private int idx = 0;
    private int tflags = 0;
    private int flags = 0;
    private double min = 0.0;
    private double max = 0.0;
    private double offset = 0.0;
    double minVal = 0.0;
    double maxVal = 0.0;

    public TCPlanet(SwissEph swissEph, int n, int n2, double d) {
        this(swissEph, n, n2, d, 200, 1.4);
    }

    public TCPlanet(SwissEph swissEph, int n, int n2, double d, int n3, double d2) {
        this.tflags = n2;
        int n4 = 2067999;
        if ((n2 & 8) != 0) {
            n4 |= 0x600;
        }
        if ((n2 & ~n4) != 0) {
            throw new IllegalArgumentException("Invalid flag(s): " + (n2 & ~n4));
        }
        int n5 = n2 & 0xE0000;
        if (n5 != 131072 && n5 != 262144 && n5 != 524288) {
            throw new IllegalArgumentException("Invalid flag combination '" + n2 + "': specify exactly one of SEFLG_TRANSIT_LONGITUDE (" + 131072 + "), SEFLG_TRANSIT_LATITUDE (" + 262144 + "), SEFLG_TRANSIT_DISTANCE (" + 524288 + ").");
        }
        if ((n2 & 8) != 0 && (n == 12 || n == 13 || n == 10 || n == 11)) {
            throw new IllegalArgumentException("Unsupported planet number " + n + " (" + swissEph.swe_get_planet_name(n) + ") for heliocentric calculations");
        }
        this.planet = n;
        this.sw = swissEph;
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        if ((n2 & 0x40000) != 0) {
            this.idx = 1;
        } else if ((n2 & 0x80000) != 0) {
            this.idx = 2;
        }
        if ((n2 & 0x100000) != 0) {
            this.idx += 3;
            n2 |= 0x100;
        }
        this.flags = n2 &= 0xFFE1FFFF;
        this.rollover = this.idx == 0;
        this.offset = this.checkOffset(d);
        this.max = this.getSpeed(false);
        this.min = this.getSpeed(true);
        if ((Double.isInfinite(this.max) || Double.isInfinite(this.min)) && this.idx < 3) {
            double[] dArray = this.getTestspeed(n, this.idx, n3, d2);
            this.min = dArray[0];
            this.max = dArray[1];
        }
        if (Double.isInfinite(this.max) || Double.isInfinite(this.min)) {
            int n6 = n > 10000 ? n - 10000 : n;
            throw new IllegalArgumentException(((n2 & 0x8000) != 0 ? "Topo" : ((n2 & 8) != 0 ? "Helio" : "Geo")) + "centric transit calculations of planet number " + n6 + " (" + swissEph.swe_get_planet_name(n) + ") not possible: (extreme) " + ((n2 & 0x100) != 0 ? "accelerations" : "speeds") + " of the planet " + ((n2 & 0x800) != 0 ? "in equatorial system " : "") + "not available.");
        }
    }

    @Override
    public boolean getRollover() {
        return this.rollover;
    }

    @Override
    public double getMinOffset() {
        if ((this.tflags & 0x100000) != 0) {
            return this.getSpeed(true, false);
        }
        return 0.0;
    }

    @Override
    public double getMaxOffset() {
        if ((this.tflags & 0x100000) != 0) {
            return this.getSpeed(false, false);
        }
        return 360.0;
    }

    @Override
    public void setOffset(double d) {
        this.offset = this.checkOffset(d);
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public Object[] getObjectIdentifiers() {
        return new Integer[]{this.planet};
    }

    @Override
    protected double calc(double d) {
        double[] dArray = new double[6];
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.sw.swe_calc(d, this.planet, this.flags, dArray, stringBuffer);
        if (n < 0) {
            int n2 = 0;
            if (stringBuffer.toString().matches("jd 2488117.1708818264 > Swiss Eph. upper limit 2487932.5;")) {
                n2 = 786432;
            }
            throw new SwissephException(d, n2, "Calculation failed with return code " + n + ":\n" + stringBuffer.toString());
        }
        return dArray[this.idx];
    }

    @Override
    protected double getMaxSpeed() {
        return this.max;
    }

    @Override
    protected double getMinSpeed() {
        return this.min;
    }

    @Override
    protected double getTimePrecision(double d) {
        double d2 = SMath.max(SMath.abs(this.min), SMath.abs(this.max));
        if (d2 != 0.0) {
            return d / d2;
        }
        return 1.0E-9;
    }

    @Override
    protected double getDegreePrecision(double d) {
        double d2 = 0.005;
        if (this.idx > 2) {
            d2 = 0.002;
        } else if (this.planet >= 0 && this.planet <= 5) {
            if (d < 1980.0 || d > 2099.0) {
                d2 = 0.08;
            }
        } else if (d >= 1900.0 && d < 1980.0) {
            d2 = 0.08;
        } else if (d < 1900.0 || d > 2099.0) {
            d2 = 1.0;
        }
        d2 /= 3600.0;
        d2 *= 0.5;
        switch (this.idx) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: 
            case 5: {
                if (this.planet >= this.sw.ext.maxBaryDist.length) {
                    d2 *= 0.05;
                    break;
                }
                d2 *= this.sw.ext.maxBaryDist[this.planet];
            }
        }
        return d2;
    }

    private double checkOffset(double d) {
        if (this.rollover) {
            while (d < 0.0) {
                d += 360.0;
            }
            d %= 360.0;
            this.minVal = 0.0;
            this.maxVal = 360.0;
        } else if (this.idx == 1) {
            while (d < -90.0) {
                d += 180.0;
            }
            while (d > 90.0) {
                d -= 180.0;
            }
            this.minVal = -90.0;
            this.maxVal = 90.0;
        }
        return d;
    }

    private double getSpeed(boolean bl) {
        boolean bl2 = (this.tflags & 0x100000) != 0;
        return this.getSpeed(bl, bl2);
    }

    private double getSpeed(boolean bl, boolean bl2) {
        boolean bl3 = (this.tflags & 0x20000) != 0;
        boolean bl4 = (this.tflags & 0x40000) != 0;
        boolean bl5 = (this.tflags & 0x80000) != 0;
        boolean bl6 = (this.tflags & 0x8000) != 0;
        boolean bl7 = (this.tflags & 8) != 0;
        boolean bl8 = (this.tflags & 0x800) != 0 && !bl4 && !bl5;
        boolean bl9 = (this.tflags & 0x800) != 0 && bl4;
        try {
            if (bl6) {
                if (!this.sw.swed.geopos_is_set) {
                    throw new IllegalArgumentException("Geographic position is not set for requested topocentric calculations.");
                }
                if (this.sw.swed.topd.geoalt > 50000.0 || this.sw.swed.topd.geoalt < -1.2E7) {
                    return Double.POSITIVE_INFINITY;
                }
                if (bl2) {
                    if (bl8) {
                        return bl ? SwephData.minTopoRectAccel[this.planet] : SwephData.maxTopoRectAccel[this.planet];
                    }
                    if (bl9) {
                        return bl ? SwephData.minTopoDeclAccel[this.planet] : SwephData.maxTopoDeclAccel[this.planet];
                    }
                    if (bl4) {
                        return bl ? SwephData.minTopoLatAccel[this.planet] : SwephData.maxTopoLatAccel[this.planet];
                    }
                    if (bl5) {
                        return bl ? SwephData.minTopoDistAccel[this.planet] : SwephData.maxTopoDistAccel[this.planet];
                    }
                    if (bl3) {
                        return bl ? SwephData.minTopoLonAccel[this.planet] : SwephData.maxTopoLonAccel[this.planet];
                    }
                } else {
                    if (bl8) {
                        return bl ? SwephData.minTopoRectSpeed[this.planet] : SwephData.maxTopoRectSpeed[this.planet];
                    }
                    if (bl9) {
                        return bl ? SwephData.minTopoDeclSpeed[this.planet] : SwephData.maxTopoDeclSpeed[this.planet];
                    }
                    if (bl4) {
                        return bl ? SwephData.minTopoLatSpeed[this.planet] : SwephData.maxTopoLatSpeed[this.planet];
                    }
                    if (bl5) {
                        return bl ? SwephData.minTopoDistSpeed[this.planet] : SwephData.maxTopoDistSpeed[this.planet];
                    }
                    if (bl3) {
                        return bl ? SwephData.minTopoLonSpeed[this.planet] : SwephData.maxTopoLonSpeed[this.planet];
                    }
                }
            }
            if (bl7) {
                if (bl2) {
                    if (bl8) {
                        return bl ? SwephData.minHelioRectAccel[this.planet] : SwephData.maxHelioRectAccel[this.planet];
                    }
                    if (bl9) {
                        return bl ? SwephData.minHelioDeclAccel[this.planet] : SwephData.maxHelioDeclAccel[this.planet];
                    }
                    if (bl4) {
                        return bl ? SwephData.minHelioLatAccel[this.planet] : SwephData.maxHelioLatAccel[this.planet];
                    }
                    if (bl5) {
                        return bl ? SwephData.minHelioDistAccel[this.planet] : SwephData.maxHelioDistAccel[this.planet];
                    }
                    if (bl3) {
                        return bl ? SwephData.minHelioLonAccel[this.planet] : SwephData.maxHelioLonAccel[this.planet];
                    }
                } else {
                    if (bl8) {
                        return bl ? SwephData.minHelioRectSpeed[this.planet] : SwephData.maxHelioRectSpeed[this.planet];
                    }
                    if (bl9) {
                        return bl ? SwephData.minHelioDeclSpeed[this.planet] : SwephData.maxHelioDeclSpeed[this.planet];
                    }
                    if (bl4) {
                        return bl ? SwephData.minHelioLatSpeed[this.planet] : SwephData.maxHelioLatSpeed[this.planet];
                    }
                    if (bl5) {
                        return bl ? SwephData.minHelioDistSpeed[this.planet] : SwephData.maxHelioDistSpeed[this.planet];
                    }
                    if (bl3) {
                        return bl ? SwephData.minHelioLonSpeed[this.planet] : SwephData.maxHelioLonSpeed[this.planet];
                    }
                }
            }
            if (bl2) {
                if (bl8) {
                    return bl ? SwephData.minRectAccel[this.planet] : SwephData.maxRectAccel[this.planet];
                }
                if (bl9) {
                    return bl ? SwephData.minDeclAccel[this.planet] : SwephData.maxDeclAccel[this.planet];
                }
                if (bl4) {
                    return bl ? SwephData.minLatAccel[this.planet] : SwephData.maxLatAccel[this.planet];
                }
                if (bl5) {
                    return bl ? SwephData.minDistAccel[this.planet] : SwephData.maxDistAccel[this.planet];
                }
                if (bl3) {
                    return bl ? SwephData.minLonAccel[this.planet] : SwephData.maxLonAccel[this.planet];
                }
            } else {
                if (bl8) {
                    return bl ? SwephData.minRectSpeed[this.planet] : SwephData.maxRectSpeed[this.planet];
                }
                if (bl9) {
                    return bl ? SwephData.minDeclSpeed[this.planet] : SwephData.maxDeclSpeed[this.planet];
                }
                if (bl4) {
                    return bl ? SwephData.minLatSpeed[this.planet] : SwephData.maxLatSpeed[this.planet];
                }
                if (bl5) {
                    return bl ? SwephData.minDistSpeed[this.planet] : SwephData.maxDistSpeed[this.planet];
                }
                if (bl3) {
                    return bl ? SwephData.minLonSpeed[this.planet] : SwephData.maxLonSpeed[this.planet];
                }
            }
            return Double.POSITIVE_INFINITY;
        }
        catch (Exception exception) {
            return Double.POSITIVE_INFINITY;
        }
    }

    double[] getTestspeed(int n, int n2, int n3, double d) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double[] dArray = new double[]{625000.5, 2818000.5};
        if (n > 10000) {
            object2 = SwissLib.swi_gen_filename(2457264.5, n);
            object = null;
            SwissephException swissephException = null;
            try {
                object = this.sw.swi_fopen(3, (String)object2, this.sw.swed.ephepath, stringBuffer);
            }
            catch (SwissephException swissephException2) {
                swissephException = swissephException2;
            }
            if (object == null) {
                if (((String)object2).indexOf("s.") <= 0) {
                    object2 = ((String)object2).substring(0, ((String)object2).indexOf(".")) + "s." + "se1";
                }
                try {
                    object = this.sw.swi_fopen(3, (String)object2, this.sw.swed.ephepath, stringBuffer);
                }
                catch (SwissephException swissephException3) {
                    swissephException = swissephException3;
                }
            }
            if (object == null) {
                throw swissephException;
            }
            try {
                object.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dArray = this.sw.getDatafileTimerange((String)object2);
            }
            catch (SwissephException swissephException4) {
                // empty catch block
            }
        }
        object2 = new Random();
        object = new double[6];
        for (int i = 0; i < n3; ++i) {
            double d4 = ((Random)object2).nextDouble();
            int n4 = this.sw.swe_calc(d4 = d4 * (dArray[1] - dArray[0]) + dArray[0], n, this.flags | 0x100, (double[])object, stringBuffer);
            if (n4 < 0) continue;
            if (d2 > object[n2 + 3]) {
                d2 = object[n2 + 3];
            }
            if (!(d3 < object[n2 + 3])) continue;
            d3 = object[n2 + 3];
        }
        if (d2 == d3 || d2 == Double.MAX_VALUE || d3 == -1.7976931348623157E308) {
            d2 = Double.POSITIVE_INFINITY;
        } else {
            switch ((int)Math.signum(d2)) {
                case -1: {
                    d2 *= d;
                    break;
                }
                case 0: {
                    d2 = -0.1;
                    break;
                }
                case 1: {
                    d2 /= d;
                }
            }
            switch ((int)Math.signum(d3)) {
                case -1: {
                    d3 /= d;
                    break;
                }
                case 0: {
                    d3 = 0.1;
                    break;
                }
                case 1: {
                    d3 *= d;
                }
            }
        }
        return new double[]{d2, d3};
    }

    public String toString() {
        return "[Planet:" + this.planet + "];Offset:" + this.getOffset();
    }
}

