/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.Serializable;
import swisseph.DblObj;
import swisseph.PlanData;
import swisseph.SMath;
import swisseph.SwissData;
import swisseph.SwissLib;

class Swemmoon
implements Serializable {
    SwissData swed;
    SwissLib sl;
    static final double[] z = new double[]{-13.12045233711, -0.00113821591258, -9.646018347184E-6, 31.46734198839, 0.0476835758578, -3.421689790404E-4, -6.84707090541, -0.005834100476561, -2.905334122698E-4, -5.663161722088, 0.005722859298199, -8.466472828815E-5, -84.29817796435, -207.2552484689, 7.876842214863, 1.836463749022, -15.57471855361, -20.06969124724, 21.52670284757, -6.179946916139, -0.9070028191196, -12.70848233038, -2.145589319058, 13.81936399935, -1.999840061168};
    static final int NLR = 118;
    static final short[] LR = new short[]{0, 0, 1, 0, 22639, 5858, -20905, -3550, 2, 0, -1, 0, 4586, 4383, -3699, -1109, 2, 0, 0, 0, 2369, 9139, -2955, -9676, 0, 0, 2, 0, 769, 257, -569, -9251, 0, 1, 0, 0, -666, -4171, 48, 8883, 0, 0, 0, 2, -411, -5957, -3, -1483, 2, 0, -2, 0, 211, 6556, 246, 1585, 2, -1, -1, 0, 205, 4358, -152, -1377, 2, 0, 1, 0, 191, 9562, -170, -7331, 2, -1, 0, 0, 164, 7285, -204, -5860, 0, 1, -1, 0, -147, -3213, -129, -6201, 1, 0, 0, 0, -124, -9881, 108, 7427, 0, 1, 1, 0, -109, -3803, 104, 7552, 2, 0, 0, -2, 55, 1771, 10, 3211, 0, 0, 1, 2, -45, -996, 0, 0, 0, 0, 1, -2, 39, 5333, 79, 6606, 4, 0, -1, 0, 38, 4298, -34, -7825, 0, 0, 3, 0, 36, 1238, -23, -2104, 4, 0, -2, 0, 30, 7726, -21, -6363, 2, 1, -1, 0, -28, -3971, 24, 2085, 2, 1, 0, 0, -24, -3582, 30, 8238, 1, 0, -1, 0, -18, -5847, -8, -3791, 1, 1, 0, 0, 17, 9545, -16, -6747, 2, -1, 1, 0, 14, 5303, -12, -8314, 2, 0, 2, 0, 14, 3797, -10, -4448, 4, 0, 0, 0, 13, 8991, -11, -6500, 2, 0, -3, 0, 13, 1941, 14, 4027, 0, 1, -2, 0, -9, -6791, -7, -27, 2, 0, -1, 2, -9, -3659, 0, 7740, 2, -1, -2, 0, 8, 6055, 10, 562, 1, 0, 1, 0, -8, -4531, 6, 3220, 2, -2, 0, 0, 8, 502, -9, -8845, 0, 1, 2, 0, -7, -6302, 5, 7509, 0, 2, 0, 0, -7, -4475, 1, 657, 2, -2, -1, 0, 7, 3712, -4, -9501, 2, 0, 1, -2, -6, -3832, 4, 1311, 2, 0, 0, 2, -5, -7416, 0, 0, 4, -1, -1, 0, 4, 3740, -3, -9580, 0, 0, 2, 2, -3, -9976, 0, 0, 3, 0, -1, 0, -3, -2097, 3, 2582, 2, 1, 1, 0, -2, -9145, 2, 6164, 4, -1, -2, 0, 2, 7319, -1, -8970, 0, 2, -1, 0, -2, -5679, -2, -1171, 2, 2, -1, 0, -2, -5212, 2, 3536, 2, 1, -2, 0, 2, 4889, 0, 1437, 2, -1, 0, -2, 2, 1461, 0, 6571, 4, 0, 1, 0, 1, 9777, -1, -4226, 0, 0, 4, 0, 1, 9337, -1, -1169, 4, -1, 0, 0, 1, 8708, -1, -5714, 1, 0, -2, 0, -1, -7530, -1, -7385, 2, 1, 0, -2, -1, -4372, 0, -1357, 0, 0, 2, -2, -1, -3726, -4, -4212, 1, 1, 1, 0, 1, 2618, 0, -9333, 3, 0, -2, 0, -1, -2241, 0, 8624, 4, 0, -3, 0, 1, 1868, 0, -5142, 2, -1, 2, 0, 1, 1770, 0, -8488, 0, 2, 1, 0, -1, -1617, 1, 1655, 1, 1, -1, 0, 1, 777, 0, 8512, 2, 0, 3, 0, 1, 595, 0, -6697, 2, 0, 1, 2, 0, -9902, 0, 0, 2, 0, -4, 0, 0, 9483, 0, 7785, 2, -2, 1, 0, 0, 7517, 0, -6575, 0, 1, -3, 0, 0, -6694, 0, -4224, 4, 1, -1, 0, 0, -6352, 0, 5788, 1, 0, 2, 0, 0, -5840, 0, 3785, 1, 0, 0, -2, 0, -5833, 0, -7956, 6, 0, -2, 0, 0, 5716, 0, -4225, 2, 0, -2, -2, 0, -5606, 0, 4726, 1, -1, 0, 0, 0, -5569, 0, 4976, 0, 1, 3, 0, 0, -5459, 0, 3551, 2, 0, -2, 2, 0, -5357, 0, 7740, 2, 0, -1, -2, 0, 1790, 8, 7516, 3, 0, 0, 0, 0, 4042, -1, -4189, 2, -1, -3, 0, 0, 4784, 0, 4950, 2, -1, 3, 0, 0, 932, 0, -585, 2, 0, 2, -2, 0, -4538, 0, 2840, 2, -1, -1, 2, 0, -4262, 0, 373, 0, 0, 0, 4, 0, 4203, 0, 0, 0, 1, 0, 2, 0, 4134, 0, -1580, 6, 0, -1, 0, 0, 3945, 0, -2866, 2, -1, 0, 2, 0, -3821, 0, 0, 2, -1, 1, -2, 0, -3745, 0, 2094, 4, 1, -2, 0, 0, -3576, 0, 2370, 1, 1, -2, 0, 0, 3497, 0, 3323, 2, -3, 0, 0, 0, 3398, 0, -4107, 0, 0, 3, 2, 0, -3286, 0, 0, 4, -2, -1, 0, 0, -3087, 0, -2790, 0, 1, -1, -2, 0, 3015, 0, 0, 4, 0, -1, -2, 0, 3009, 0, -3218, 2, -2, -2, 0, 0, 2942, 0, 3430, 6, 0, -3, 0, 0, 2925, 0, -1832, 2, 1, 2, 0, 0, -2902, 0, 2125, 4, 1, 0, 0, 0, -2891, 0, 2445, 4, -1, 1, 0, 0, 2825, 0, -2029, 3, 1, -1, 0, 0, 2737, 0, -2126, 0, 1, 1, 2, 0, 2634, 0, 0, 1, 0, 0, 2, 0, 2543, 0, 0, 3, 0, 0, -2, 0, -2530, 0, 2010, 2, 2, -2, 0, 0, -2499, 0, -1089, 2, -3, -1, 0, 0, 2469, 0, -1481, 3, -1, -1, 0, 0, -2314, 0, 2556, 4, 0, 2, 0, 0, 2185, 0, -1392, 4, 0, -1, 2, 0, -2013, 0, 0, 0, 2, -2, 0, 0, -1931, 0, 0, 2, 2, 0, 0, 0, -1858, 0, 0, 2, 1, -3, 0, 0, 1762, 0, 0, 4, 0, -2, 2, 0, -1698, 0, 0, 4, -2, -2, 0, 0, 1578, 0, -1083, 4, -2, 0, 0, 0, 1522, 0, -1281, 3, 1, 0, 0, 0, 1499, 0, -1077, 1, -1, -1, 0, 0, -1364, 0, 1141, 1, -3, 0, 0, 0, -1281, 0, 0, 6, 0, 0, 0, 0, 1261, 0, -859, 2, 0, 2, 2, 0, -1239, 0, 0, 1, -1, 1, 0, 0, -1207, 0, 1100, 0, 0, 5, 0, 0, 1110, 0, -589, 0, 3, 0, 0, 0, -1013, 0, 213, 4, -1, -3, 0, 0, 998, 0, 0};
    static final int NMB = 77;
    static final short[] MB = new short[]{0, 0, 0, 1, 18461, 2387, 0, 0, 1, 1, 1010, 1671, 0, 0, 1, -1, 999, 6936, 2, 0, 0, -1, 623, 6524, 2, 0, -1, 1, 199, 4837, 2, 0, -1, -1, 166, 5741, 2, 0, 0, 1, 117, 2607, 0, 0, 2, 1, 61, 9120, 2, 0, 1, -1, 33, 3572, 0, 0, 2, -1, 31, 7597, 2, -1, 0, -1, 29, 5766, 2, 0, -2, -1, 15, 5663, 2, 0, 1, 1, 15, 1216, 2, 1, 0, -1, -12, -941, 2, -1, -1, 1, 8, 8681, 2, -1, 0, 1, 7, 9586, 2, -1, -1, -1, 7, 4346, 0, 1, -1, -1, -6, -7314, 4, 0, -1, -1, 6, 5796, 0, 1, 0, 1, -6, -4601, 0, 0, 0, 3, -6, -2965, 0, 1, -1, 1, -5, -6324, 1, 0, 0, 1, -5, -3684, 0, 1, 1, 1, -5, -3113, 0, 1, 1, -1, -5, -759, 0, 1, 0, -1, -4, -8396, 1, 0, 0, -1, -4, -8057, 0, 0, 3, 1, 3, 9841, 4, 0, 0, -1, 3, 6745, 4, 0, -1, 1, 2, 9985, 0, 0, 1, -3, 2, 7986, 4, 0, -2, 1, 2, 4139, 2, 0, 0, -3, 2, 1863, 2, 0, 2, -1, 2, 1462, 2, -1, 1, -1, 1, 7660, 2, 0, -2, 1, -1, -6244, 0, 0, 3, -1, 1, 5813, 2, 0, 2, 1, 1, 5198, 2, 0, -3, -1, 1, 5156, 2, 1, -1, 1, -1, -3178, 2, 1, 0, 1, -1, -2643, 4, 0, 0, 1, 1, 1919, 2, -1, 1, 1, 1, 1346, 2, -2, 0, -1, 1, 859, 0, 0, 1, 3, -1, -194, 2, 1, 1, -1, 0, -8227, 1, 1, 0, -1, 0, 8042, 1, 1, 0, 1, 0, 8026, 0, 1, -2, -1, 0, -7932, 2, 1, -1, -1, 0, -7910, 1, 0, 1, 1, 0, -6674, 2, -1, -2, -1, 0, 6502, 0, 1, 2, 1, 0, -6388, 4, 0, -2, -1, 0, 6337, 4, -1, -1, -1, 0, 5958, 1, 0, 1, -1, 0, -5889, 4, 0, 1, -1, 0, 4734, 1, 0, -1, -1, 0, -4299, 4, -1, 0, -1, 0, 4149, 2, -2, 0, 1, 0, 3835, 3, 0, 0, -1, 0, -3518, 4, -1, -1, 1, 0, 3388, 2, 0, -1, -3, 0, 3291, 2, -2, -1, 1, 0, 3147, 0, 1, 2, -1, 0, -3129, 3, 0, -1, -1, 0, -3052, 0, 1, -2, 1, 0, -3013, 2, 0, 1, -3, 0, -2912, 2, -2, -1, -1, 0, 2686, 0, 0, 4, 1, 0, 2633, 2, 0, -3, 1, 0, 2541, 2, 0, -1, 3, 0, -2448, 2, 1, 1, 1, 0, -2370, 4, -1, -2, 1, 0, 2138, 4, 0, 1, 1, 0, 2126, 3, 0, -1, 1, 0, -2059, 4, 1, -1, -1, 0, -1719};
    static final int NLRT = 38;
    static final short[] LRT = new short[]{0, 1, 0, 0, 16, 7680, -1, -2302, 2, -1, -1, 0, -5, -1642, 3, 8245, 2, -1, 0, 0, -4, -1383, 5, 1395, 0, 1, -1, 0, 3, 7115, 3, 2654, 0, 1, 1, 0, 2, 7560, -2, -6396, 2, 1, -1, 0, 0, 7118, 0, -6068, 2, 1, 0, 0, 0, 6128, 0, -7754, 1, 1, 0, 0, 0, -4516, 0, 4194, 2, -2, 0, 0, 0, -4048, 0, 4970, 0, 2, 0, 0, 0, 3747, 0, -540, 2, -2, -1, 0, 0, -3707, 0, 2490, 2, -1, 1, 0, 0, -3649, 0, 3222, 0, 1, -2, 0, 0, 2438, 0, 1760, 2, -1, -2, 0, 0, -2165, 0, -2530, 0, 1, 2, 0, 0, 1923, 0, -1450, 0, 2, -1, 0, 0, 1292, 0, 1070, 2, 2, -1, 0, 0, 1271, 0, -6070, 4, -1, -1, 0, 0, -1098, 0, 990, 2, 0, 0, 0, 0, 1073, 0, -1360, 2, 0, -1, 0, 0, 839, 0, -630, 2, 1, 1, 0, 0, 734, 0, -660, 4, -1, -2, 0, 0, -688, 0, 480, 2, 1, -2, 0, 0, -630, 0, 0, 0, 2, 1, 0, 0, 587, 0, -590, 2, -1, 0, -2, 0, -540, 0, -170, 4, -1, 0, 0, 0, -468, 0, 390, 2, -2, 1, 0, 0, -378, 0, 330, 2, 1, 0, -2, 0, 364, 0, 0, 1, 1, 1, 0, 0, -317, 0, 240, 2, -1, 2, 0, 0, -295, 0, 210, 1, 1, -1, 0, 0, -270, 0, -210, 2, -3, 0, 0, 0, -256, 0, 310, 2, -3, -1, 0, 0, -187, 0, 110, 0, 1, -3, 0, 0, 169, 0, 110, 4, 1, -1, 0, 0, 158, 0, -150, 4, -2, -1, 0, 0, -155, 0, 140, 0, 0, 1, 0, 0, 155, 0, -250, 2, -2, -2, 0, 0, -148, 0, -170};
    static final int NBT = 16;
    static final short[] BT = new short[]{2, -1, 0, -1, -7430, 2, 1, 0, -1, 3043, 2, -1, -1, 1, -2229, 2, -1, 0, 1, -1999, 2, -1, -1, -1, -1869, 0, 1, -1, -1, 1696, 0, 1, 0, 1, 1623, 0, 1, -1, 1, 1418, 0, 1, 1, 1, 1339, 0, 1, 1, -1, 1278, 0, 1, 0, -1, 1217, 2, -2, 0, -1, -547, 2, -1, 1, -1, -443, 2, 1, -1, 1, 331, 2, 1, 0, 1, 317, 2, 0, 0, -1, 295};
    static final int NLRT2 = 25;
    static final short[] LRT2 = new short[]{0, 1, 0, 0, 487, -36, 2, -1, -1, 0, -150, 111, 2, -1, 0, 0, -120, 149, 0, 1, -1, 0, 108, 95, 0, 1, 1, 0, 80, -77, 2, 1, -1, 0, 21, -18, 2, 1, 0, 0, 20, -23, 1, 1, 0, 0, -13, 12, 2, -2, 0, 0, -12, 14, 2, -1, 1, 0, -11, 9, 2, -2, -1, 0, -11, 7, 0, 2, 0, 0, 11, 0, 2, -1, -2, 0, -6, -7, 0, 1, -2, 0, 7, 5, 0, 1, 2, 0, 6, -4, 2, 2, -1, 0, 5, -3, 0, 2, -1, 0, 5, 3, 4, -1, -1, 0, -3, 3, 2, 0, 0, 0, 3, -4, 4, -1, -2, 0, -2, 0, 2, 1, -2, 0, -2, 0, 2, -1, 0, -2, -2, 0, 2, 1, 1, 0, 2, -2, 2, 0, -1, 0, 2, 0, 0, 2, 1, 0, 2, 0};
    static final int NBT2 = 12;
    static final short[] BT2 = new short[]{2, -1, 0, -1, -22, 2, 1, 0, -1, 9, 2, -1, 0, 1, -6, 2, -1, -1, 1, -6, 2, -1, -1, -1, -5, 0, 1, 0, 1, 5, 0, 1, -1, -1, 5, 0, 1, 1, 1, 4, 0, 1, 1, -1, 4, 0, 1, 0, -1, 4, 0, 1, -1, 1, 4, 2, -2, 0, -1, -2};
    private double[] mean_node_corr = new double[]{-2.56, -2.473, -2.392347, -2.316425, -2.239639, -2.167764, -2.0951, -2.02481, -1.957622, -1.890097, -1.826389, -1.763335, -1.701047, -1.643016, -1.584186, -1.527309, -1.473352, -1.418917, -1.367736, -1.317202, -1.267269, -1.221121, -1.174218, -1.128862, -1.086214, -1.042998, -1.002491, -0.962635, -0.923176, -0.887191, -0.850403, -0.814929, -0.782117, -0.748462, -0.717241, -0.686598, -0.656013, -0.628726, -0.60046, -0.573219, -0.548634, -0.522931, -0.499285, -0.476273, -0.452978, -0.432663, -0.411386, -0.390788, -0.372825, -0.353681, -0.33623, -0.31952, -0.302343, -0.287794, -0.272262, -0.257166, -0.244534, -0.230635, -0.218126, -0.206365, -0.194, -0.183876, -0.172782, -0.161877, -0.153254, -0.143371, -0.134501, -0.126552, -0.117932, -0.111199, -0.103716, -0.09616, -0.090718, -0.084046, -0.078007, -0.072959, -0.067235, -0.06299, -0.058102, -0.05307, -0.049786, -0.045381, -0.041317, -0.038165, -0.034501, -0.031871, -0.028844, -0.025701, -0.024018, -0.021427, -0.018881, -0.017291, -0.015186, -0.013755, -0.012098, -0.010261, -0.009688, -0.008218, -0.00667, -0.005979, -0.004756, -0.003991, -0.002996, -0.001974, -0.001975, -0.001213, -3.77E-4, -3.56E-4, 5.779E-5, 3.78E-4, 7.1E-4, 0.001092, 7.67E-4, 9.85E-4, 0.001443, 0.001069, 0.001141, 0.001321, 0.001462, 0.001695, 0.001319, 0.001567, 0.001873, 0.001376, 0.001336, 0.001347, 0.00133, 0.001256, 8.13E-4, 9.46E-4, 0.001079, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.64E-4, -4.52E-4, -0.001091, -0.001159, -0.001136, -0.001798, -0.002249, -0.002622, -0.00299, -0.003555, -0.004425, -0.004758, -0.005134, -0.006065, -0.006839, -0.007474, -0.008283, -0.009411, -0.010786, -0.01181, -0.012989, -0.014825, -0.016426, -0.017922, -0.019774, -0.021881, -0.024194, -0.02619, -0.02844, -0.031285, -0.033817, -0.036318, -0.039212, -0.042456, -0.045799, -0.048994, -0.05271, -0.056948, -0.061017, -0.065181, -0.069843, -0.074922, -0.079976, -0.085052, -0.090755, -0.09684, -0.102797, -0.108939, -0.115568, -0.122636, -0.129593, -0.136683, -0.144641, -0.152825, -0.161044, -0.169758, -0.178916, -0.188712, -0.198401, -0.208312, -0.219395, -0.230407, -0.241577, -0.253508, -0.26564, -0.278556, -0.29133, -0.304353, -0.318815, -0.332882, -0.347316, -0.362895, -0.378421, -0.395061, -0.411748, -0.428666, -0.447477, -0.465636, -0.484277, -0.5046, -0.524405, -0.545533, -0.56702, -0.588404, -0.612099, -0.634965, -0.658262, -0.683866, -0.708526, -0.734719, -0.7618, -0.788562, -0.818092, -0.846885, -0.876177, -0.908385, -0.939371, -0.972027, -1.006149, -1.039634, -1.076135, -1.112156, -1.14849, -1.188312, -1.226761, -1.266821, -1.309156, -1.350583, -1.395223, -1.440028, -1.485047, -1.534104, -1.582023, -1.631506, -1.684031, -1.735687, -1.790421, -1.846039, -1.901951, -1.961872, -2.021179, -2.081987, -2.146259, -2.210031, -2.276609, -2.344904, -2.413795, -2.486559, -2.559564, -2.634215, -2.712692, -2.791289, -2.872533, -2.956217, -3.040965, -3.129234, -3.218545, -3.309805, -3.404827, -3.5008, -3.601, -3.7, -3.8};
    private double[] mean_apsis_corr = new double[]{7.525, 7.29, 7.057295, 6.830813, 6.611723, 6.396775, 6.189569, 5.985968, 5.788342, 5.597304, 5.410167, 5.229946, 5.053389, 4.882187, 4.716494, 4.553532, 4.396734, 4.243718, 4.094282, 3.950865, 3.810366, 3.674978, 3.543284, 3.41427, 3.290526, 3.168775, 3.050904, 2.937541, 2.826189, 2.719822, 2.616193, 2.515431, 2.419193, 2.323782, 2.232545, 2.143635, 2.056803, 1.974913, 1.893874, 1.816201, 1.741957, 1.668083, 1.598335, 1.529645, 1.463016, 1.399693, 1.336905, 1.278097, 1.220965, 1.165092, 1.113071, 1.060858, 1.011007, 0.963701, 0.916523, 0.872887, 0.829596, 0.788486, 0.750017, 0.711177, 0.675589, 0.640303, 0.605303, 0.57349, 0.541113, 0.511482, 0.483159, 0.45521, 0.430305, 0.404643, 0.380782, 0.358524, 0.335405, 0.315244, 0.295131, 0.275766, 0.259223, 0.241586, 0.22589, 0.210404, 0.194775, 0.181573, 0.167246, 0.154514, 0.143435, 0.131131, 0.121648, 0.111835, 0.102474, 0.094284, 0.085204, 0.07824, 0.070697, 0.063696, 0.058894, 0.05239, 0.047632, 0.043129, 0.037823, 0.034143, 0.029188, 0.025648, 0.021972, 0.018348, 0.017127, 0.013989, 0.011967, 0.011003, 0.007865, 0.007033, 0.005574, 0.00406, 0.003699, 0.002465, 0.002889, 0.002144, 0.001018, 0.001757, -9.67E-5, -7.34E-4, -3.92E-4, -0.001546, -8.63E-4, -0.001266, -9.33E-4, -5.03E-4, -0.001304, 2.38E-4, -5.07E-4, -8.97E-4, 6.47E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.14E-4, 6.83E-4, 0.002228, 0.001974, 0.003485, 0.00428, 0.005409, 0.007468, 0.007938, 0.011012, 0.012525, 0.013757, 0.016757, 0.017932, 0.02078, 0.023416, 0.026386, 0.030428, 0.033512, 0.038789, 0.043126, 0.047778, 0.054175, 0.058891, 0.065878, 0.072345, 0.079668, 0.088238, 0.095307, 0.104873, 0.113533, 0.122336, 0.133205, 0.142922, 0.154871, 0.166488, 0.179234, 0.193928, 0.207262, 0.223089, 0.238736, 0.254907, 0.273232, 0.291085, 0.311046, 0.331025, 0.351955, 0.374422, 0.396341, 0.420772, 0.444867, 0.469984, 0.497448, 0.524717, 0.554752, 0.584581, 0.616272, 0.649744, 0.682947, 0.719405, 0.755834, 0.79378, 0.833875, 0.873893, 0.91734, 0.960429, 1.005471, 1.052384, 1.099317, 1.149508, 1.20013, 1.253038, 1.307672, 1.36348, 1.422592, 1.4819, 1.544111, 1.607982, 1.672954, 1.741025, 1.809727, 1.882038, 1.955243, 2.029956, 2.108428, 2.186805, 2.268697, 2.352071, 2.43737, 2.525903, 2.615415, 2.709082, 2.804198, 2.901704, 3.002606, 3.104412, 3.210406, 3.317733, 3.428386, 3.541634, 3.656634, 3.775988, 3.896306, 4.02048, 4.146814, 4.275356, 4.408257, 4.542282, 4.681174, 4.822524, 4.966424, 5.114948, 5.264973, 5.419906, 5.577056, 5.737688, 5.902347, 6.069138, 6.241065, 6.415155, 6.593317, 6.774853, 6.959322, 7.148845, 7.340334, 7.537156, 7.737358, 7.940882, 8.149932, 8.361576, 8.57915, 8.799591, 9.024378, 9.254584, 9.487362, 9.726535, 9.968784, 10.216089, 10.467716, 10.725293, 10.986, 11.25, 11.52};
    double[][] ss = new double[5][8];
    double[][] cc = new double[5][8];
    double l;
    double B;
    double[] moonpol = new double[3];
    double SWELP;
    double M;
    double MP;
    double D;
    double NF;
    double T;
    double T2;
    static double T3;
    static double T4;
    static double f;
    static double g;
    static double Ve;
    static double Ea;
    static double Ma;
    static double Ju;
    static double Sa;
    static double cg;
    static double sg;
    static double l1;
    static double l2;
    static double l3;
    static double l4;
    static final double CORR_MNODE_JD_T0GREG = -3063616.5;
    static final double CORR_MNODE_JD_T1GREG = 844477.5;
    static final double CORR_MNODE_JD_T2GREG = 2780263.5;
    static final double CORR_MNODE_JD_T3GREG = 7930182.5;
    static final double CORR_MAPOG_JD_T0GREG = -3063616.5;
    static final double CORR_MAPOG_JD_T1GREG = 1209720.5;
    static final double CORR_MAPOG_JD_T2GREG = 2780263.5;
    static final double CORR_MAPOG_JD_T3GREG = 7930182.5;

    Swemmoon() {
        this(null, null);
    }

    Swemmoon(SwissData swissData, SwissLib swissLib) {
        this.swed = swissData;
        this.sl = swissLib;
        if (this.swed == null) {
            this.swed = new SwissData();
        }
        if (this.sl == null) {
            this.sl = new SwissLib();
        }
    }

    int swi_moshmoon2(double d, double[] dArray) {
        this.T = (d - 2451545.0) / 36525.0;
        this.T2 = this.T * this.T;
        this.mean_elements();
        this.mean_elements_pl();
        this.moon1();
        this.moon2();
        this.moon3();
        this.moon4();
        for (int i = 0; i < 3; ++i) {
            dArray[i] = this.moonpol[i];
        }
        return 0;
    }

    int swi_moshmoon(double d, boolean bl, double[] dArray, StringBuffer stringBuffer) {
        int n;
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        PlanData planData = this.swed.pldat[1];
        double[] dArray5 = bl ? planData.x : dArray4;
        if (d < 625000.3 || d > 2818000.7) {
            if (stringBuffer != null) {
                String string = "jd " + d + " outside Moshier's Moon range " + 625000.5 + " .. " + 2818000.5 + " ";
                if (stringBuffer.length() + string.length() < 256) {
                    stringBuffer.append(string);
                }
            }
            return -1;
        }
        if (d == planData.teval && planData.iephe == 4) {
            if (dArray != null) {
                for (int i = 0; i <= 5; ++i) {
                    dArray[i] = planData.x[i];
                }
            }
            return 0;
        }
        this.swi_moshmoon2(d, dArray5);
        if (bl) {
            planData.teval = d;
            planData.xflgs = -1;
            planData.iephe = 4;
        }
        this.ecldat_equ2000(d, dArray5);
        double d2 = d + 5.0E-5;
        this.swi_moshmoon2(d2, dArray2);
        this.ecldat_equ2000(d2, dArray2);
        d2 = d - 5.0E-5;
        this.swi_moshmoon2(d2, dArray3);
        this.ecldat_equ2000(d2, dArray3);
        for (n = 0; n <= 2; ++n) {
            double d3 = (dArray2[n] - dArray3[n]) / 2.0;
            double d4 = (dArray2[n] + dArray3[n]) / 2.0 - dArray5[n];
            dArray5[n + 3] = (2.0 * d4 + d3) / 5.0E-5;
        }
        if (dArray != null) {
            for (n = 0; n <= 5; ++n) {
                dArray[n] = dArray5[n];
            }
        }
        return 0;
    }

    private void moon1() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.ss[i][j] = 0.0;
                this.cc[i][j] = 0.0;
            }
        }
        this.sscc(0, 4.84813681109536E-6 * this.D, 6);
        this.sscc(1, 4.84813681109536E-6 * this.M, 4);
        this.sscc(2, 4.84813681109536E-6 * this.MP, 4);
        this.sscc(3, 4.84813681109536E-6 * this.NF, 4);
        this.moonpol[0] = 0.0;
        this.moonpol[1] = 0.0;
        this.moonpol[2] = 0.0;
        this.chewm(LRT2, 25, 4, 2, this.moonpol);
        this.chewm(BT2, 12, 4, 4, this.moonpol);
        f = 18.0 * Ve - 16.0 * Ea;
        g = 4.84813681109536E-6 * (f - this.MP);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l = 6.367278 * cg + 12.747036 * sg;
        l1 = 23123.7 * cg - 10570.02 * sg;
        l2 = z[12] * cg + z[13] * sg;
        this.moonpol[2] = this.moonpol[2] + (5.01 * cg + 2.72 * sg);
        g = 4.84813681109536E-6 * (10.0 * Ve - 3.0 * Ea - this.MP);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += -0.253102 * cg + 0.503359 * sg;
        l1 += 1258.46 * cg + 707.29 * sg;
        l2 += z[14] * cg + z[15] * sg;
        g = 4.84813681109536E-6 * (8.0 * Ve - 13.0 * Ea);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += -0.187231 * cg - 0.127481 * sg;
        l1 += -319.87 * cg - 18.34 * sg;
        l2 += z[16] * cg + z[17] * sg;
        double d = 4.0 * Ea - 8.0 * Ma + 3.0 * Ju;
        g = 4.84813681109536E-6 * d;
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += -0.866287 * cg + 0.248192 * sg;
        l1 += 41.87 * cg + 1053.97 * sg;
        l2 += z[18] * cg + z[19] * sg;
        g = 4.84813681109536E-6 * (d - this.MP);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += -0.165009 * cg + 0.044176 * sg;
        l1 += 4.67 * cg + 201.55 * sg;
        g = 4.84813681109536E-6 * f;
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += 0.330401 * cg + 0.661362 * sg;
        l1 += 1202.67 * cg - 555.59 * sg;
        l2 += z[20] * cg + z[21] * sg;
        g = 4.84813681109536E-6 * (f - 2.0 * this.MP);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += 0.352185 * cg + 0.705041 * sg;
        l1 += 1283.59 * cg - 586.43 * sg;
        g = 4.84813681109536E-6 * (2.0 * Ju - 5.0 * Sa);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += -0.0347 * cg + 0.160041 * sg;
        l2 += z[22] * cg + z[23] * sg;
        g = 4.84813681109536E-6 * (this.SWELP - this.NF);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += 1.16E-4 * cg + 7.06304 * sg;
        l1 += 298.8 * sg;
        sg = SMath.sin(4.84813681109536E-6 * this.M);
        l3 = z[24] * sg;
        l4 = 0.0;
        g = 4.84813681109536E-6 * (2.0 * this.D - this.M);
        sg = SMath.sin(g);
        cg = SMath.cos(g);
        this.moonpol[2] = this.moonpol[2] + -0.2655 * cg * this.T;
        g = 4.84813681109536E-6 * (this.M - this.MP);
        this.moonpol[2] = this.moonpol[2] + -0.1568 * SMath.cos(g) * this.T;
        g = 4.84813681109536E-6 * (this.M + this.MP);
        this.moonpol[2] = this.moonpol[2] + 0.1309 * SMath.cos(g) * this.T;
        g = 4.84813681109536E-6 * (2.0 * (this.D + this.M) - this.MP);
        sg = SMath.sin(g);
        cg = SMath.cos(g);
        this.moonpol[2] = this.moonpol[2] + 0.5568 * cg * this.T;
        l2 += this.moonpol[0];
        g = 4.84813681109536E-6 * (2.0 * this.D - this.M - this.MP);
        this.moonpol[2] = this.moonpol[2] + -0.191 * SMath.cos(g) * this.T;
        this.moonpol[1] = this.moonpol[1] * this.T;
        this.moonpol[2] = this.moonpol[2] * this.T;
        this.moonpol[0] = 0.0;
        this.chewm(BT, 16, 4, 4, this.moonpol);
        this.chewm(LRT, 38, 4, 1, this.moonpol);
        g = 4.84813681109536E-6 * (f - this.MP - this.NF - 2355767.6);
        this.moonpol[1] = this.moonpol[1] + -1127.0 * SMath.sin(g);
        g = 4.84813681109536E-6 * (f - this.MP + this.NF - 235353.6);
        this.moonpol[1] = this.moonpol[1] + -1123.0 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ea + this.D + 51987.6);
        this.moonpol[1] = this.moonpol[1] + 1303.0 * SMath.sin(g);
        g = 4.84813681109536E-6 * this.SWELP;
        this.moonpol[1] = this.moonpol[1] + 342.0 * SMath.sin(g);
        g = 4.84813681109536E-6 * (2.0 * Ve - 3.0 * Ea);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += -0.34355 * cg - 2.76E-4 * sg;
        l1 += 105.9 * cg + 336.53 * sg;
        g = 4.84813681109536E-6 * (f - 2.0 * this.D);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += 0.074668 * cg + 0.149501 * sg;
        l1 += 271.77 * cg - 124.2 * sg;
        g = 4.84813681109536E-6 * (f - 2.0 * this.D - this.MP);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += 0.073444 * cg + 0.147094 * sg;
        l1 += 265.24 * cg - 121.16 * sg;
        g = 4.84813681109536E-6 * (f + 2.0 * this.D - this.MP);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += 0.072844 * cg + 0.145829 * sg;
        l1 += 265.18 * cg - 121.29 * sg;
        g = 4.84813681109536E-6 * (f + 2.0 * (this.D - this.MP));
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += 0.070201 * cg + 0.140542 * sg;
        l1 += 255.36 * cg - 116.79 * sg;
        g = 4.84813681109536E-6 * (Ea + this.D - this.NF);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += 0.288209 * cg - 0.025901 * sg;
        l1 += -63.51 * cg - 240.14 * sg;
        g = 4.84813681109536E-6 * (2.0 * Ea - 3.0 * Ju + 2.0 * this.D - this.MP);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += 0.077865 * cg + 0.43846 * sg;
        l1 += 210.57 * cg + 124.84 * sg;
        g = 4.84813681109536E-6 * (Ea - 2.0 * Ma);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += -0.216579 * cg + 0.241702 * sg;
        l1 += 197.67 * cg + 125.23 * sg;
        g = 4.84813681109536E-6 * (d + this.MP);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += -0.165009 * cg + 0.044176 * sg;
        l1 += 4.67 * cg + 201.55 * sg;
        g = 4.84813681109536E-6 * (d + 2.0 * this.D - this.MP);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += -0.133533 * cg + 0.041116 * sg;
        l1 += 6.95 * cg + 187.07 * sg;
        g = 4.84813681109536E-6 * (d - 2.0 * this.D + this.MP);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += -0.13343 * cg + 0.041079 * sg;
        l1 += 6.28 * cg + 169.08 * sg;
        g = 4.84813681109536E-6 * (3.0 * Ve - 4.0 * Ea);
        cg = SMath.cos(g);
        sg = SMath.sin(g);
        this.l += -0.175074 * cg + 0.003035 * sg;
        l1 += 49.17 * cg + 150.57 * sg;
        g = 4.84813681109536E-6 * (2.0 * (Ea + this.D - this.MP) - 3.0 * Ju + 213534.0);
        l1 += 158.4 * SMath.sin(g);
        l1 += this.moonpol[0];
        d = 0.1 * this.T;
        this.moonpol[1] = this.moonpol[1] * d;
        this.moonpol[2] = this.moonpol[2] * d;
    }

    void moon2() {
        g = 4.84813681109536E-6 * (2.0 * (Ea - Ju + this.D) - this.MP + 648431.172);
        this.l += 1.14307 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ve - Ea + 648035.568);
        this.l += 0.82155 * SMath.sin(g);
        g = 4.84813681109536E-6 * (3.0 * (Ve - Ea) + 2.0 * this.D - this.MP + 647933.184);
        this.l += 0.64371 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ea - Ju + 4424.04);
        this.l += 0.6388 * SMath.sin(g);
        g = 4.84813681109536E-6 * (this.SWELP + this.MP - this.NF + 4.68);
        this.l += 0.49331 * SMath.sin(g);
        g = 4.84813681109536E-6 * (this.SWELP - this.MP - this.NF + 4.68);
        this.l += 0.4914 * SMath.sin(g);
        g = 4.84813681109536E-6 * (this.SWELP + this.NF + 2.52);
        this.l += 0.36061 * SMath.sin(g);
        g = 4.84813681109536E-6 * (2.0 * Ve - 2.0 * Ea + 736.2);
        this.l += 0.30154 * SMath.sin(g);
        g = 4.84813681109536E-6 * (2.0 * Ea - 3.0 * Ju + 2.0 * this.D - 2.0 * this.MP + 36138.2);
        this.l += 0.28282 * SMath.sin(g);
        g = 4.84813681109536E-6 * (2.0 * Ea - 2.0 * Ju + 2.0 * this.D - 2.0 * this.MP + 311.0);
        this.l += 0.24516 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ea - Ju - 2.0 * this.D + this.MP + 6275.88);
        this.l += 0.21117 * SMath.sin(g);
        g = 4.84813681109536E-6 * (2.0 * (Ea - Ma) - 846.36);
        this.l += 0.19444 * SMath.sin(g);
        g = 4.84813681109536E-6 * (2.0 * (Ea - Ju) + 1569.96);
        this.l -= 0.18457 * SMath.sin(g);
        g = 4.84813681109536E-6 * (2.0 * (Ea - Ju) - this.MP - 55.8);
        this.l += 0.18256 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ea - Ju - 2.0 * this.D + 6490.08);
        this.l += 0.16499 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ea - 2.0 * Ju - 212378.4);
        this.l += 0.16427 * SMath.sin(g);
        g = 4.84813681109536E-6 * (2.0 * (Ve - Ea - this.D) + this.MP + 1122.48);
        this.l += 0.16088 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ve - Ea - this.MP + 32.04);
        this.l -= 0.1535 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ea - Ju - this.MP + 4488.88);
        this.l += 0.14346 * SMath.sin(g);
        g = 4.84813681109536E-6 * (2.0 * (Ve - Ea + this.D) - this.MP - 8.64);
        this.l += 0.13594 * SMath.sin(g);
        g = 4.84813681109536E-6 * (2.0 * (Ve - Ea - this.D) + 1319.76);
        this.l += 0.13432 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ve - Ea - 2.0 * this.D + this.MP - 56.16);
        this.l -= 0.13122 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ve - Ea + this.MP + 54.36);
        this.l -= 0.12722 * SMath.sin(g);
        g = 4.84813681109536E-6 * (3.0 * (Ve - Ea) - this.MP + 433.8);
        this.l += 0.12539 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ea - Ju + this.MP + 4002.12);
        this.l += 0.10994 * SMath.sin(g);
        g = 4.84813681109536E-6 * (20.0 * Ve - 21.0 * Ea - 2.0 * this.D + this.MP - 317511.72);
        this.l += 0.10652 * SMath.sin(g);
        g = 4.84813681109536E-6 * (26.0 * Ve - 29.0 * Ea - this.MP + 270002.52);
        this.l += 0.1049 * SMath.sin(g);
        g = 4.84813681109536E-6 * (3.0 * Ve - 4.0 * Ea + this.D - this.MP - 322765.56);
        this.l += 0.10386 * SMath.sin(g);
        g = 4.84813681109536E-6 * (this.SWELP + 648002.556);
        this.B = 8.04508 * SMath.sin(g);
        g = 4.84813681109536E-6 * (Ea + this.D + 996048.252);
        this.B += 1.51021 * SMath.sin(g);
        g = 4.84813681109536E-6 * (f - this.MP + this.NF + 95554.332);
        this.B += 0.63037 * SMath.sin(g);
        g = 4.84813681109536E-6 * (f - this.MP - this.NF + 95553.792);
        this.B += 0.63014 * SMath.sin(g);
        g = 4.84813681109536E-6 * (this.SWELP - this.MP + 2.9);
        this.B += 0.45587 * SMath.sin(g);
        g = 4.84813681109536E-6 * (this.SWELP + this.MP + 2.5);
        this.B += -0.41573 * SMath.sin(g);
        g = 4.84813681109536E-6 * (this.SWELP - 2.0 * this.NF + 3.2);
        this.B += 0.32623 * SMath.sin(g);
        g = 4.84813681109536E-6 * (this.SWELP - 2.0 * this.D + 2.5);
        this.B += 0.29855 * SMath.sin(g);
    }

    void moon3() {
        this.moonpol[0] = 0.0;
        this.chewm(LR, 118, 4, 1, this.moonpol);
        this.chewm(MB, 77, 4, 3, this.moonpol);
        this.l += (((l4 * this.T + l3) * this.T + l2) * this.T + l1) * this.T * 1.0E-5;
        this.moonpol[0] = this.SWELP + this.l + 1.0E-4 * this.moonpol[0];
        this.moonpol[1] = 1.0E-4 * this.moonpol[1] + this.B;
        this.moonpol[2] = 1.0E-4 * this.moonpol[2] + 385000.52899;
    }

    void moon4() {
        this.moonpol[2] = this.moonpol[2] / 1.4959787066E8;
        this.moonpol[0] = 4.84813681109536E-6 * this.mods3600(this.moonpol[0]);
        this.moonpol[1] = 4.84813681109536E-6 * this.moonpol[1];
        this.B = this.moonpol[1];
    }

    private double corr_mean_node(double d) {
        double d2 = -3063616.5;
        double d3 = 36524.25;
        if (d < -3027215.5) {
            return 0.0;
        }
        if (d > 7930192.5) {
            return 0.0;
        }
        double d4 = d - d2;
        int n = (int)SMath.floor(d4 / d3);
        double d5 = (d4 - (double)n * d3) / d3;
        double d6 = this.mean_node_corr[n];
        double d7 = this.mean_node_corr[n + 1];
        double d8 = d6 + d5 * (d7 - d6);
        return d8;
    }

    int swi_mean_node(double d, double[] dArray, StringBuffer stringBuffer) {
        return this.swi_mean_node(d, dArray, 0, stringBuffer);
    }

    int swi_mean_node(double d, double[] dArray, int n, StringBuffer stringBuffer) {
        this.T = (d - 2451545.0) / 36525.0;
        this.T2 = this.T * this.T;
        T3 = this.T * this.T2;
        T4 = this.T2 * this.T2;
        if (d < -3100015.5 || d > 8000016.5) {
            if (stringBuffer != null) {
                String string = "jd " + d + " outside mean node range " + -3100015.5 + " .. " + 8000016.5 + " ";
                stringBuffer.append(string);
            }
            return -1;
        }
        this.mean_elements();
        double d2 = this.corr_mean_node(d) * 3600.0;
        dArray[n] = this.sl.swi_mod2PI((this.SWELP - this.NF - d2) * 4.84813681109536E-6);
        dArray[n + 1] = 0.0;
        dArray[n + 2] = 0.002569555290487047;
        return 0;
    }

    private double corr_mean_apog(double d) {
        double d2 = -3063616.5;
        double d3 = 36524.25;
        if (d < -3027215.5) {
            return 0.0;
        }
        if (d > 7930192.5) {
            return 0.0;
        }
        double d4 = d - d2;
        int n = (int)SMath.floor(d4 / d3);
        double d5 = (d4 - (double)n * d3) / d3;
        double d6 = this.mean_apsis_corr[n];
        double d7 = this.mean_apsis_corr[n + 1];
        double d8 = d6 + d5 * (d7 - d6);
        return d8;
    }

    int swi_mean_apog(double d, double[] dArray, StringBuffer stringBuffer) {
        return this.swi_mean_apog(d, dArray, 0, stringBuffer);
    }

    int swi_mean_apog(double d, double[] dArray, int n, StringBuffer stringBuffer) {
        this.T = (d - 2451545.0) / 36525.0;
        this.T2 = this.T * this.T;
        T3 = this.T * this.T2;
        T4 = this.T2 * this.T2;
        if (d < -3100015.5 || d > 8000016.5) {
            if (stringBuffer != null) {
                String string = "jd " + d + " outside mean apogee range " + -3100015.5 + " .. " + 8000016.5 + " ";
                if (stringBuffer.length() + string.length() < 256) {
                    stringBuffer.append(string);
                }
            }
            return -1;
        }
        this.mean_elements();
        dArray[n] = this.sl.swi_mod2PI((this.SWELP - this.MP) * 4.84813681109536E-6 + Math.PI);
        dArray[n + 1] = 0.0;
        dArray[n + 2] = 0.002710625132447323;
        double d2 = this.corr_mean_apog(d) * 0.0174532925199433;
        dArray[n] = this.sl.swi_mod2PI(dArray[n] - d2);
        double d3 = (this.SWELP - this.NF) * 4.84813681109536E-6;
        d2 = this.corr_mean_node(d) * 0.0174532925199433;
        d3 = this.sl.swi_mod2PI(d3 - d2);
        dArray[n] = this.sl.swi_mod2PI(dArray[n] - d3);
        this.sl.swi_polcart(dArray, n, dArray, n);
        this.sl.swi_coortrf(dArray, n, dArray, n, -0.08980410850026319);
        this.sl.swi_cartpol(dArray, n, dArray, n);
        dArray[n] = this.sl.swi_mod2PI(dArray[n] + d3);
        return 0;
    }

    void chewm(short[] sArray, int n, int n2, int n3, double[] dArray) {
        int n4 = 0;
        block6: for (int i = 0; i < n; ++i) {
            short s;
            short s2;
            boolean bl = false;
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j < n2; ++j) {
                if ((s2 = sArray[n4++]) == 0) continue;
                s = s2;
                if (s2 < 0) {
                    s = -s;
                }
                double d3 = this.ss[j][s - 1];
                double d4 = this.cc[j][s - 1];
                if (s2 < 0) {
                    d3 = -d3;
                }
                if (!bl) {
                    d = d3;
                    d2 = d4;
                    bl = true;
                    continue;
                }
                double d5 = d3 * d2 + d4 * d;
                d2 = d4 * d2 - d3 * d;
                d = d5;
            }
            switch (n3) {
                case 1: {
                    s2 = sArray[n4++];
                    s = sArray[n4++];
                    dArray[0] = dArray[0] + (10000.0 * (double)s2 + (double)s) * d;
                    s2 = sArray[n4++];
                    s = sArray[n4++];
                    if (s == 0) continue block6;
                    dArray[2] = dArray[2] + (10000.0 * (double)s2 + (double)s) * d2;
                    continue block6;
                }
                case 2: {
                    s2 = sArray[n4++];
                    s = sArray[n4++];
                    dArray[0] = dArray[0] + (double)s2 * d;
                    dArray[2] = dArray[2] + (double)s * d2;
                    continue block6;
                }
                case 3: {
                    s2 = sArray[n4++];
                    s = sArray[n4++];
                    dArray[1] = dArray[1] + (10000.0 * (double)s2 + (double)s) * d;
                    continue block6;
                }
                case 4: {
                    s2 = sArray[n4++];
                    dArray[1] = dArray[1] + (double)s2 * d;
                }
            }
        }
    }

    void sscc(int n, double d, int n2) {
        double d2 = SMath.sin(d);
        double d3 = SMath.cos(d);
        this.ss[n][0] = d2;
        this.cc[n][0] = d3;
        double d4 = 2.0 * d2 * d3;
        double d5 = d3 * d3 - d2 * d2;
        this.ss[n][1] = d4;
        this.cc[n][1] = d5;
        for (int i = 2; i < n2; ++i) {
            double d6 = d2 * d5 + d3 * d4;
            d5 = d3 * d5 - d2 * d4;
            this.ss[n][i] = d4 = d6;
            this.cc[n][i] = d5;
        }
    }

    void ecldat_equ2000(double d, double[] dArray) {
        this.sl.swi_polcart(dArray, dArray);
        this.sl.swi_coortrf2(dArray, dArray, -this.swed.oec.seps, this.swed.oec.ceps);
        this.sl.swi_precess(dArray, d, 0, 1);
    }

    double mods3600(double d) {
        double d2 = d;
        d2 -= 1296000.0 * SMath.floor(d2 / 1296000.0);
        return d2;
    }

    void swi_mean_lunar_elements(double d, DblObj dblObj, DblObj dblObj2, DblObj dblObj3, DblObj dblObj4) {
        this.T = (d - 2451545.0) / 36525.0;
        this.T2 = this.T * this.T;
        this.mean_elements();
        dblObj.val = this.sl.swe_degnorm((this.SWELP - this.NF) * 4.84813681109536E-6 * 57.2957795130823);
        dblObj3.val = this.sl.swe_degnorm((this.SWELP - this.MP) * 4.84813681109536E-6 * 57.2957795130823);
        this.T -= 2.7378507871321012E-5;
        this.mean_elements();
        dblObj2.val = this.sl.swe_degnorm(dblObj.val - (this.SWELP - this.NF) * 4.84813681109536E-6 * 57.2957795130823);
        dblObj2.val -= 360.0;
        dblObj4.val = this.sl.swe_degnorm(dblObj3.val - (this.SWELP - this.MP) * 4.84813681109536E-6 * 57.2957795130823);
        double d2 = this.corr_mean_node(d);
        dblObj.val = this.sl.swe_degnorm(dblObj.val - d2);
        d2 = this.corr_mean_apog(d);
        dblObj3.val = this.sl.swe_degnorm(dblObj3.val - d2);
    }

    void mean_elements() {
        double d = this.T % 1.0;
        this.M = this.mods3600(1.296E8 * d - 3418.961646 * this.T + 1287104.76154);
        this.M += ((((((((1.62E-20 * this.T - 1.039E-17) * this.T - 3.83508E-15) * this.T + 4.237343E-13) * this.T + 8.8555011E-11) * this.T - 4.77258489E-8) * this.T - 1.1297037031E-5) * this.T + 1.4732069041E-4) * this.T - 0.552891801772) * this.T2;
        this.NF = this.mods3600(1.739232E9 * d + 295263.0983 * this.T - 0.207941990176 * this.T + 335779.55755);
        this.MP = this.mods3600(1.7172E9 * d + 715923.4728 * this.T - 0.2035946368532 * this.T + 485868.28096);
        this.D = this.mods3600(1.601856E9 * d + 1105601.4603 * this.T + 0.3962893294503 * this.T + 1072260.73512);
        this.SWELP = this.mods3600(1.731456E9 * d + 1108372.83264 * this.T - 0.6784914260953 * this.T + 785939.95571);
        this.NF += ((z[2] * this.T + z[1]) * this.T + z[0]) * this.T2;
        this.MP += ((z[5] * this.T + z[4]) * this.T + z[3]) * this.T2;
        this.D += ((z[8] * this.T + z[7]) * this.T + z[6]) * this.T2;
        this.SWELP += ((z[11] * this.T + z[10]) * this.T + z[9]) * this.T2;
    }

    void mean_elements_pl() {
        Ve = this.mods3600(2.106641364335482E8 * this.T + 655127.283046);
        Ve += ((((((((-9.36E-23 * this.T - 1.95E-20) * this.T + 6.097E-18) * this.T + 4.43201E-15) * this.T + 2.509418E-13) * this.T - 3.0622898E-10) * this.T - 2.26602516E-9) * this.T - 1.4244812531E-5) * this.T + 0.005871373088) * this.T2;
        Ea = this.mods3600(1.2959774226669231E8 * this.T + 361679.214649);
        Ea += ((((((((-1.16E-22 * this.T + 2.976E-19) * this.T + 2.846E-17) * this.T - 1.08402E-14) * this.T - 1.226182E-12) * this.T + 1.7228268E-10) * this.T + 1.515912254E-7) * this.T + 8.863982531E-6) * this.T - 0.020199859001) * this.T2;
        Ma = this.mods3600(6.890507759284E7 * this.T + 1279559.78866);
        Ma += (-1.043E-5 * this.T + 0.00938012) * this.T2;
        Ju = this.mods3600(1.0925660428608E7 * this.T + 123665.34212);
        Ju += (1.543273E-5 * this.T - 0.306037836351) * this.T2;
        Sa = this.mods3600(4399609.65932 * this.T + 180278.89694);
        Sa += ((4.475946E-8 * this.T - 6.874806E-5) * this.T + 0.756161437443) * this.T2;
    }

    int swi_intp_apsides(double d, double[] dArray, int n) {
        double[] dArray2 = new double[3];
        int n2 = 4;
        int n3 = 1;
        double d2 = 27.55454988;
        double d3 = 27.212220817 / d2;
        double d4 = 29.530588835 / d2;
        double d5 = 27.321582 / d2;
        double d6 = 365.2596359 / d2;
        double d7 = 224.7008001 / d2;
        double d8 = 365.2563629 / d2;
        double d9 = 686.9798519 / d2;
        double d10 = 4332.589348 / d2;
        double d11 = 10759.22722 / d2;
        this.T = (d - 2451545.0) / 36525.0;
        this.T2 = this.T * this.T;
        T4 = this.T2 * this.T2;
        this.mean_elements();
        this.mean_elements_pl();
        double d12 = this.NF;
        double d13 = this.D;
        double d14 = this.SWELP;
        double d15 = this.MP;
        double d16 = this.M;
        double d17 = Ve;
        double d18 = Ea;
        double d19 = Ma;
        double d20 = Ju;
        double d21 = Sa;
        d12 = this.mods3600(this.NF);
        d13 = this.mods3600(this.D);
        d14 = this.mods3600(this.SWELP);
        d15 = this.mods3600(this.MP);
        if (n == 5) {
            this.MP = 0.0;
            n2 = 5;
        }
        if (n == 4) {
            this.MP = 648000.0;
            n2 = 4;
        }
        double d22 = 0.0;
        double d23 = 18000.0;
        for (int i = 0; i <= n2; ++i) {
            double d24 = d15 - this.MP;
            double d25 = d14 - d24;
            double d26 = d12 - d24;
            double d27 = d13 - d24;
            double d28 = d15 - d24;
            for (n3 = 0; n3 <= 2; ++n3) {
                this.MP = d28 + (double)(n3 - 1) * d23;
                this.NF = d26 + (double)(n3 - 1) * d23 / d3;
                this.D = d27 + (double)(n3 - 1) * d23 / d4;
                this.SWELP = d25 + (double)(n3 - 1) * d23 / d5;
                this.M = d16 + (double)(n3 - 1) * d23 / d6;
                Ve = d17 + (double)(n3 - 1) * d23 / d7;
                Ea = d18 + (double)(n3 - 1) * d23 / d8;
                Ma = d19 + (double)(n3 - 1) * d23 / d9;
                Ju = d20 + (double)(n3 - 1) * d23 / d10;
                Sa = d21 + (double)(n3 - 1) * d23 / d11;
                this.moon1();
                this.moon2();
                this.moon3();
                this.moon4();
                if (n3 == 1) {
                    for (int j = 0; j < 3; ++j) {
                        dArray[j] = this.moonpol[j];
                    }
                }
                dArray2[n3] = this.moonpol[2];
            }
            d22 = (1.5 * dArray2[0] - 2.0 * dArray2[1] + 0.5 * dArray2[2]) / (dArray2[0] + dArray2[2] - 2.0 * dArray2[1]);
            d22 *= d23;
            this.MP = d28 += (d22 -= d23);
            d23 /= 10.0;
        }
        return 0;
    }
}

