/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.Serializable;
import swisseph.DblObj;
import swisseph.Epsilon;
import swisseph.PlanData;
import swisseph.SMath;
import swisseph.SarosData;
import swisseph.SweDate;
import swisseph.Swemmoon;
import swisseph.SwephData;
import swisseph.SwissData;
import swisseph.SwissEph;
import swisseph.SwissLib;

class Swecl
implements Serializable {
    SwissEph sw = null;
    SwissLib sl = null;
    Swemmoon sm = null;
    SwissData swed = null;
    private double const_lapse_rate = 0.0065;
    private static final double DSUN = 0.009304945276685664;
    private static final double DMOON = 2.3237630219355155E-5;
    private static final double DEARTH = 8.527046503885043E-5;
    private static final double RSUN = 0.004652472638342832;
    private static final double RMOON = 1.1618815109677577E-5;
    private static final double REARTH = 4.263523251942522E-5;
    private static final double lnlog = SMath.log(10.0);
    static final double SAROS_CYCLE = 6585.3213;
    static final SarosData[] saros_data_solar = new SarosData[]{new SarosData(0, 641886.5), new SarosData(1, 672214.5), new SarosData(2, 676200.5), new SarosData(3, 693357.5), new SarosData(4, 723685.5), new SarosData(5, 727671.5), new SarosData(6, 744829.5), new SarosData(7, 775157.5), new SarosData(8, 779143.5), new SarosData(9, 783131.5), new SarosData(10, 820044.5), new SarosData(11, 810859.5), new SarosData(12, 748993.5), new SarosData(13, 792492.5), new SarosData(14, 789892.5), new SarosData(15, 787294.5), new SarosData(16, 824207.5), new SarosData(17, 834779.5), new SarosData(18, 838766.5), new SarosData(19, 869094.5), new SarosData(20, 886251.5), new SarosData(21, 890238.5), new SarosData(22, 927151.5), new SarosData(23, 937722.5), new SarosData(24, 941709.5), new SarosData(25, 978623.5), new SarosData(26, 989194.5), new SarosData(27, 993181.5), new SarosData(28, 1023510.5), new SarosData(29, 1034081.5), new SarosData(30, 972214.5), new SarosData(31, 1061811.5), new SarosData(32, 1006529.5), new SarosData(33, 997345.5), new SarosData(34, 1021088.5), new SarosData(35, 1038245.5), new SarosData(36, 1042231.5), new SarosData(37, 1065974.5), new SarosData(38, 1089716.5), new SarosData(39, 1093703.5), new SarosData(40, 1117446.5), new SarosData(41, 1141188.5), new SarosData(42, 1145175.5), new SarosData(43, 1168918.5), new SarosData(44, 1192660.5), new SarosData(45, 1196647.5), new SarosData(46, 1220390.5), new SarosData(47, 1244132.5), new SarosData(48, 1234948.5), new SarosData(49, 1265277.5), new SarosData(50, 1282433.5), new SarosData(51, 1207395.5), new SarosData(52, 1217968.5), new SarosData(53, 1254881.5), new SarosData(54, 1252282.5), new SarosData(55, 1262855.5), new SarosData(56, 1293182.5), new SarosData(57, 1297169.5), new SarosData(58, 1314326.5), new SarosData(59, 1344654.5), new SarosData(60, 1348640.5), new SarosData(61, 1365798.5), new SarosData(62, 1396126.5), new SarosData(63, 1400112.5), new SarosData(64, 1417270.5), new SarosData(65, 1447598.5), new SarosData(66, 1444999.5), new SarosData(67, 1462157.5), new SarosData(68, 1492485.5), new SarosData(69, 1456959.5), new SarosData(70, 1421434.5), new SarosData(71, 1471518.5), new SarosData(72, 1455748.5), new SarosData(73, 1466320.5), new SarosData(74, 1496648.5), new SarosData(75, 1500634.5), new SarosData(76, 1511207.5), new SarosData(77, 1548120.5), new SarosData(78, 1552106.5), new SarosData(79, 1562679.5), new SarosData(80, 1599592.5), new SarosData(81, 1603578.5), new SarosData(82, 1614150.5), new SarosData(83, 1644479.5), new SarosData(84, 1655050.5), new SarosData(85, 1659037.5), new SarosData(86, 1695950.5), new SarosData(87, 1693351.5), new SarosData(88, 1631484.5), new SarosData(89, 1727666.5), new SarosData(90, 1672384.5), new SarosData(91, 1663200.5), new SarosData(92, 1693529.5), new SarosData(93, 1710685.5), new SarosData(94, 1714672.5), new SarosData(95, 1738415.5), new SarosData(96, 1755572.5), new SarosData(97, 1766144.5), new SarosData(98, 1789887.5), new SarosData(99, 1807044.5), new SarosData(100, 1817616.5), new SarosData(101, 1841359.5), new SarosData(102, 1858516.5), new SarosData(103, 1862502.5), new SarosData(104, 1892831.5), new SarosData(105, 1903402.5), new SarosData(106, 1887633.5), new SarosData(107, 1924547.5), new SarosData(108, 1921948.5), new SarosData(109, 1873251.5), new SarosData(110, 1890409.5), new SarosData(111, 1914151.5), new SarosData(112, 1918138.5), new SarosData(113, 1935296.5), new SarosData(114, 1959038.5), new SarosData(115, 1963024.5), new SarosData(116, 1986767.5), new SarosData(117, 2010510.5), new SarosData(118, 2014496.5), new SarosData(119, 2031654.5), new SarosData(120, 2061982.5), new SarosData(121, 2065968.5), new SarosData(122, 2083126.5), new SarosData(123, 2113454.5), new SarosData(124, 2104269.5), new SarosData(125, 2108256.5), new SarosData(126, 2151755.5), new SarosData(127, 2083302.5), new SarosData(128, 2080704.5), new SarosData(129, 2124203.5), new SarosData(130, 2121603.5), new SarosData(131, 2132176.5), new SarosData(132, 2162504.5), new SarosData(133, 2166490.5), new SarosData(134, 2177062.5), new SarosData(135, 2207390.5), new SarosData(136, 2217962.5), new SarosData(137, 2228534.5), new SarosData(138, 2258862.5), new SarosData(139, 2269434.5), new SarosData(140, 2273421.5), new SarosData(141, 2310334.5), new SarosData(142, 2314320.5), new SarosData(143, 2311722.5), new SarosData(144, 2355221.5), new SarosData(145, 2319695.5), new SarosData(146, 2284169.5), new SarosData(147, 2314498.5), new SarosData(148, 2325069.5), new SarosData(149, 2329056.5), new SarosData(150, 2352799.5), new SarosData(151, 2369956.5), new SarosData(152, 2380528.5), new SarosData(153, 2404271.5), new SarosData(154, 2421428.5), new SarosData(155, 2425414.5), new SarosData(156, 2455743.5), new SarosData(157, 2472900.5), new SarosData(158, 2476886.5), new SarosData(159, 2500629.5), new SarosData(160, 2517786.5), new SarosData(161, 2515187.5), new SarosData(162, 2545516.5), new SarosData(163, 2556087.5), new SarosData(164, 2487635.5), new SarosData(165, 2504793.5), new SarosData(166, 2535121.5), new SarosData(167, 2525936.5), new SarosData(168, 2543094.5), new SarosData(169, 2573422.5), new SarosData(170, 2577408.5), new SarosData(171, 2594566.5), new SarosData(172, 2624894.5), new SarosData(173, 2628880.5), new SarosData(174, 2646038.5), new SarosData(175, 2669780.5), new SarosData(176, 2673766.5), new SarosData(177, 2690924.5), new SarosData(178, 2721252.5), new SarosData(179, 2718653.5), new SarosData(180, 2729226.5)};
    static final int NSAROS_SOLAR = saros_data_solar.length;
    static final SarosData[] saros_data_lunar = new SarosData[]{new SarosData(1, 782437.5), new SarosData(2, 799593.5), new SarosData(3, 783824.5), new SarosData(4, 754884.5), new SarosData(5, 824724.5), new SarosData(6, 762857.5), new SarosData(7, 773430.5), new SarosData(8, 810343.5), new SarosData(9, 807743.5), new SarosData(10, 824901.5), new SarosData(11, 855229.5), new SarosData(12, 859215.5), new SarosData(13, 876373.5), new SarosData(14, 906701.5), new SarosData(15, 910687.5), new SarosData(16, 927845.5), new SarosData(17, 958173.5), new SarosData(18, 962159.5), new SarosData(19, 979317.5), new SarosData(20, 1009645.5), new SarosData(21, 1007046.5), new SarosData(22, 1017618.5), new SarosData(23, 1054531.5), new SarosData(24, 979493.5), new SarosData(25, 976895.5), new SarosData(26, 1020394.5), new SarosData(27, 1017794.5), new SarosData(28, 1028367.5), new SarosData(29, 1058695.5), new SarosData(30, 1062681.5), new SarosData(31, 1073253.5), new SarosData(32, 1110167.5), new SarosData(33, 1114153.5), new SarosData(34, 1131311.5), new SarosData(35, 1161639.5), new SarosData(36, 1165625.5), new SarosData(37, 1176197.5), new SarosData(38, 1213111.5), new SarosData(39, 1217097.5), new SarosData(40, 1221084.5), new SarosData(41, 1257997.5), new SarosData(42, 1255398.5), new SarosData(43, 1186946.5), new SarosData(44, 1283128.5), new SarosData(45, 1227845.5), new SarosData(46, 1225247.5), new SarosData(47, 1255575.5), new SarosData(48, 1272732.5), new SarosData(49, 1276719.5), new SarosData(50, 1307047.5), new SarosData(51, 1317619.5), new SarosData(52, 1328191.5), new SarosData(53, 1358519.5), new SarosData(54, 1375676.5), new SarosData(55, 1379663.5), new SarosData(56, 1409991.5), new SarosData(57, 1420562.5), new SarosData(58, 1424549.5), new SarosData(59, 1461463.5), new SarosData(60, 1465449.5), new SarosData(61, 1436509.5), new SarosData(62, 1493179.5), new SarosData(63, 1457653.5), new SarosData(64, 1435298.5), new SarosData(65, 1452456.5), new SarosData(66, 1476198.5), new SarosData(67, 1480184.5), new SarosData(68, 1503928.5), new SarosData(69, 1527670.5), new SarosData(70, 1531656.5), new SarosData(71, 1548814.5), new SarosData(72, 1579142.5), new SarosData(73, 1583128.5), new SarosData(74, 1600286.5), new SarosData(75, 1624028.5), new SarosData(76, 1628015.5), new SarosData(77, 1651758.5), new SarosData(78, 1675500.5), new SarosData(79, 1672901.5), new SarosData(80, 1683474.5), new SarosData(81, 1713801.5), new SarosData(82, 1645349.5), new SarosData(83, 1649336.5), new SarosData(84, 1686249.5), new SarosData(85, 1683650.5), new SarosData(86, 1694222.5), new SarosData(87, 1731136.5), new SarosData(88, 1735122.5), new SarosData(89, 1745694.5), new SarosData(90, 1776022.5), new SarosData(91, 1786594.5), new SarosData(92, 1797166.5), new SarosData(93, 1827494.5), new SarosData(94, 1838066.5), new SarosData(95, 1848638.5), new SarosData(96, 1878966.5), new SarosData(97, 1882952.5), new SarosData(98, 1880354.5), new SarosData(99, 1923853.5), new SarosData(100, 1881741.5), new SarosData(101, 1852801.5), new SarosData(102, 1889715.5), new SarosData(103, 1893701.5), new SarosData(104, 1897688.5), new SarosData(105, 1928016.5), new SarosData(106, 1938588.5), new SarosData(107, 1942575.5), new SarosData(108, 1972903.5), new SarosData(109, 1990059.5), new SarosData(110, 1994046.5), new SarosData(111, 2024375.5), new SarosData(112, 2034946.5), new SarosData(113, 2045518.5), new SarosData(114, 2075847.5), new SarosData(115, 2086418.5), new SarosData(116, 2083820.5), new SarosData(117, 2120733.5), new SarosData(118, 2124719.5), new SarosData(119, 2062852.5), new SarosData(120, 2086596.5), new SarosData(121, 2103752.5), new SarosData(122, 2094568.5), new SarosData(123, 2118311.5), new SarosData(124, 2142054.5), new SarosData(125, 2146040.5), new SarosData(126, 2169783.5), new SarosData(127, 2186940.5), new SarosData(128, 2197512.5), new SarosData(129, 2214670.5), new SarosData(130, 2238412.5), new SarosData(131, 2242398.5), new SarosData(132, 2266142.5), new SarosData(133, 2289884.5), new SarosData(134, 2287285.5), new SarosData(135, 2311028.5), new SarosData(136, 2334770.5), new SarosData(137, 2292659.5), new SarosData(138, 2276890.5), new SarosData(139, 2326974.5), new SarosData(140, 2304619.5), new SarosData(141, 2308606.5), new SarosData(142, 2345520.5), new SarosData(143, 2349506.5), new SarosData(144, 2360078.5), new SarosData(145, 2390406.5), new SarosData(146, 2394392.5), new SarosData(147, 2411550.5), new SarosData(148, 2441878.5), new SarosData(149, 2445864.5), new SarosData(150, 2456437.5), new SarosData(151, 2486765.5), new SarosData(152, 2490751.5), new SarosData(153, 2501323.5), new SarosData(154, 2538236.5), new SarosData(155, 2529052.5), new SarosData(156, 2473771.5), new SarosData(157, 2563367.5), new SarosData(158, 2508085.5), new SarosData(159, 2505486.5), new SarosData(160, 2542400.5), new SarosData(161, 2546386.5), new SarosData(162, 2556958.5), new SarosData(163, 2587287.5), new SarosData(164, 2597858.5), new SarosData(165, 2601845.5), new SarosData(166, 2632173.5), new SarosData(167, 2649330.5), new SarosData(168, 2653317.5), new SarosData(169, 2683645.5), new SarosData(170, 2694217.5), new SarosData(171, 2698203.5), new SarosData(172, 2728532.5), new SarosData(173, 2739103.5), new SarosData(174, 2683822.5), new SarosData(175, 2740492.5), new SarosData(176, 2724722.5), new SarosData(177, 2708952.5), new SarosData(178, 2732695.5), new SarosData(179, 2749852.5), new SarosData(180, 2753839.5)};
    static final int NSAROS_LUNAR = saros_data_lunar.length;
    private static final double EULER = 2.718281828459;
    private static final int NMAG_ELEM = 21;
    private static final double[][] mag_elem = new double[][]{{-26.86, 0.0, 0.0, 0.0}, {-12.55, 0.0, 0.0, 0.0}, {-0.42, 3.8, -2.73, 2.0}, {-4.4, 0.09, 2.39, -0.65}, {-1.52, 1.6, 0.0, 0.0}, {-9.4, 0.5, 0.0, 0.0}, {-8.88, -2.6, 1.25, 0.044}, {-7.19, 0.0, 0.0, 0.0}, {-6.87, 0.0, 0.0, 0.0}, {-1.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {6.5, 0.15, 0.0, 0.0}, {7.0, 0.15, 0.0, 0.0}, {3.34, 0.12, 0.0, 0.0}, {4.13, 0.11, 0.0, 0.0}, {5.33, 0.32, 0.0, 0.0}, {3.2, 0.32, 0.0, 0.0}};
    private static final double[][] el_node = new double[][]{{48.330893, 1.186189, 1.7587E-4, 2.11E-7}, {76.67992, 0.901119, 4.0665E-4, -8.0E-8}, {0.0, 0.0, 0.0, 0.0}, {49.558093, 0.7720923, 1.605E-5, 2.325E-6}, {100.464441, 1.020955, 4.0117E-4, 5.69E-7}, {113.665524, 0.877097, -1.2067E-4, -2.38E-6}, {74.005947, 0.5211258, 0.00133982, 1.8516E-5}, {131.784057, 1.1022057, 2.6006E-4, -6.36E-7}};
    private static final double[][] el_peri = new double[][]{{77.456119, 1.5564775, 2.9589E-4, 5.6E-8}, {131.563707, 1.4022188, -0.00107337, -5.315E-6}, {102.937348, 1.7195269, 4.5962E-4, 4.99E-7}, {336.060234, 1.8410331, 1.3515E-4, 3.18E-7}, {14.331309, 1.6126668, 0.00103127, -4.569E-6}, {93.056787, 1.9637694, 8.3757E-4, 4.899E-6}, {173.005159, 1.4863784, 2.145E-4, 4.33E-7}, {48.123691, 1.4262677, 3.7918E-4, -3.0E-9}};
    private static final double[][] el_incl = new double[][]{{7.004986, 0.0018215, -1.809E-5, 5.3E-8}, {3.394662, 0.0010037, -8.8E-7, -7.0E-9}, {0.0, 0.0, 0.0, 0.0}, {1.849726, -6.01E-4, 1.276E-5, -6.0E-9}, {1.30327, -0.0054966, 4.65E-6, -4.0E-9}, {2.488878, -0.0037363, -1.516E-5, 8.9E-8}, {0.773196, 7.744E-4, 3.749E-5, -9.2E-8}, {1.769952, -0.0093082, -7.08E-6, 2.8E-8}};
    private static final double[][] el_ecce = new double[][]{{0.20563175, 2.0406E-5, -2.84E-8, -1.7E-10}, {0.00677188, -4.7766E-5, 9.75E-8, 4.4E-10}, {0.01670862, -4.2037E-5, -1.236E-7, 4.0E-11}, {0.09340062, 9.0483E-5, -8.06E-8, -3.5E-10}, {0.04849485, 1.63244E-4, -4.719E-7, -1.97E-9}, {0.05550862, -3.46818E-4, -6.456E-7, 3.38E-9}, {0.0462959, -2.7337E-5, 7.9E-8, 2.5E-10}, {0.00898809, 6.408E-6, -8.0E-10, -5.0E-11}};
    private static final double[][] el_sema = new double[][]{{0.38709831, 0.0, 0.0, 0.0}, {0.72332982, 0.0, 0.0, 0.0}, {1.000001018, 0.0, 0.0, 0.0}, {1.523679342, 0.0, 0.0, 0.0}, {5.202603191, 1.913E-7, 0.0, 0.0}, {9.554909596, 2.1389E-6, 0.0, 0.0}, {19.218446062, -3.72E-8, 9.8E-10, 0.0}, {30.110386869, -1.663E-7, 6.9E-10, 0.0}};
    private static final double[] plmass = new double[]{6023600.0, 408523.5, 328900.5, 3098710.0, 1047.35, 3498.0, 22960.0, 19314.0, 1.3E8};
    private static final int[] ipl_to_elem = new int[]{2, 0, 0, 1, 3, 4, 5, 6, 7, 0, 0, 0, 0, 0, 2};

    private double log10(double d) {
        return SMath.log(d) / lnlog;
    }

    Swecl() {
        this(null, null, null, null);
    }

    Swecl(SwissEph swissEph, SwissLib swissLib, Swemmoon swemmoon, SwissData swissData) {
        this.sw = swissEph;
        this.sl = swissLib;
        this.sm = swemmoon;
        this.swed = swissData;
        if (swissEph == null) {
            this.sw = new SwissEph();
        }
        if (swissLib == null) {
            this.sl = new SwissLib();
        }
        if (swemmoon == null) {
            this.sm = new Swemmoon();
        }
        if (swissData == null) {
            this.swed = new SwissData();
        }
    }

    int swe_sol_eclipse_where(double d, int n, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        double[] dArray3 = new double[10];
        SweDate.swi_set_tid_acc(d, n &= 7, 0);
        int n2 = this.eclipse_where(d, 0, null, n, dArray, dArray3, stringBuffer);
        if (n2 < 0) {
            return n2;
        }
        int n3 = this.eclipse_how(d, 0, null, n, dArray[0], dArray[1], 0.0, dArray2, stringBuffer);
        if (n3 == -1) {
            return n3;
        }
        dArray2[3] = dArray3[0];
        return n2;
    }

    int swe_lun_occult_where(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, double[] dArray2, StringBuffer stringBuffer2) {
        int n3;
        double[] dArray3 = new double[10];
        if (n < 0) {
            n = 0;
        }
        SweDate.swi_set_tid_acc(d, n2 &= 7, 0);
        if (n == 144340) {
            n = 9;
        }
        if ((n3 = this.eclipse_where(d, n, stringBuffer, n2, dArray, dArray3, stringBuffer2)) < 0) {
            return n3;
        }
        int n4 = this.eclipse_how(d, n, stringBuffer, n2, dArray[0], dArray[1], 0.0, dArray2, stringBuffer2);
        if (n4 == -1) {
            return n4;
        }
        dArray2[3] = dArray3[0];
        return n3;
    }

    private int eclipse_where(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, double[] dArray2, StringBuffer stringBuffer2) {
        int n3;
        block26: {
            double d2;
            double d3;
            double d4;
            double d5;
            int n4;
            n3 = 0;
            int n5 = 0;
            double[] dArray3 = new double[6];
            double[] dArray4 = new double[6];
            double[] dArray5 = new double[6];
            double[] dArray6 = new double[6];
            double[] dArray7 = new double[6];
            double[] dArray8 = new double[6];
            double[] dArray9 = new double[6];
            double[] dArray10 = new double[6];
            double[] dArray11 = new double[6];
            double[] dArray12 = new double[6];
            double[] dArray13 = new double[6];
            double[] dArray14 = new double[6];
            double d6 = 4.263523251942522E-5;
            double d7 = 0.9966471803021038;
            double d8 = 1.1618815109677577E-5;
            double d9 = 2.0 * d8;
            boolean bl = false;
            Epsilon epsilon = this.swed.oec;
            for (n4 = 0; n4 < 10; ++n4) {
                dArray2[n4] = 0.0;
            }
            int n6 = 0x900 | n2;
            int n7 = n6 | 0x2000;
            double d10 = SweDate.getDeltaT(d);
            double d11 = d + d10;
            n3 = this.sw.swe_calc(d11, 1, n6 |= 0x1000, dArray5, stringBuffer2);
            if (n3 == -1) {
                return n3;
            }
            n3 = this.sw.swe_calc(d11, 1, n7, dArray12, stringBuffer2);
            if (n3 == -1) {
                return n3;
            }
            n3 = this.calc_planet_star(d11, n, stringBuffer, n6, dArray6, stringBuffer2);
            if (n3 == -1) {
                return n3;
            }
            n3 = this.calc_planet_star(d11, n, stringBuffer, n7, dArray13, stringBuffer2);
            if (n3 == -1) {
                return n3;
            }
            for (n4 = 0; n4 <= 2; ++n4) {
                dArray8[n4] = dArray6[n4];
            }
            for (n4 = 0; n4 <= 2; ++n4) {
                dArray7[n4] = dArray5[n4];
            }
            double d12 = (n6 & 0x40) != 0 ? this.sl.swe_sidtime0(d, epsilon.eps * 57.2957795130823, 0.0) * 15.0 * 0.0174532925199433 : this.sl.swe_sidtime(d) * 15.0 * 0.0174532925199433;
            double d13 = stringBuffer != null && stringBuffer.length() > 0 ? 0.0 : (n < 21 ? SwephData.pla_diam[n] / 2.0 / 1.4959787066E11 : (n > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
            while (true) {
                double d14;
                double d15;
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray6[n4] = dArray8[n4];
                    dArray5[n4] = dArray7[n4];
                }
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray14[n4] = dArray12[n4];
                }
                this.sl.swi_polcart(dArray14, dArray5);
                dArray5[2] = dArray5[2] / d7;
                double d16 = SMath.sqrt(this.sl.square_sum(dArray5));
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray14[n4] = dArray13[n4];
                }
                this.sl.swi_polcart(dArray14, dArray6);
                dArray6[2] = dArray6[2] / d7;
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray3[n4] = dArray5[n4] - dArray6[n4];
                    dArray4[n4] = dArray7[n4] - dArray8[n4];
                }
                double d17 = SMath.sqrt(this.sl.square_sum(dArray3));
                d5 = SMath.sqrt(this.sl.square_sum(dArray4));
                n4 = 0;
                while (n4 <= 2) {
                    int n8 = n4;
                    dArray3[n8] = dArray3[n8] / d17;
                    int n9 = n4++;
                    dArray4[n9] = dArray4[n9] / d5;
                }
                double d18 = (d13 - d8) / d17;
                d4 = SMath.sqrt(1.0 - d18 * d18);
                double d19 = (d13 + d8) / d17;
                d3 = SMath.sqrt(1.0 - d19 * d19);
                double d20 = -this.sw.dot_prod(dArray5, dArray3);
                double d21 = SMath.sqrt(d16 * d16 - d20 * d20);
                double d22 = (d20 / d17 * (d13 * 2.0 - d9) - d9) / d4;
                double d23 = (d20 / d17 * (d13 * 2.0 + d9) + d9) / d3;
                dArray2[2] = d21;
                dArray2[3] = d22;
                dArray2[4] = d23;
                dArray2[5] = d4;
                dArray2[6] = d3;
                n4 = 2;
                while (n4 < 5) {
                    int n10 = n4++;
                    dArray2[n10] = dArray2[n10] * 1.4959787066E8;
                }
                n3 = 0;
                if (d6 * d4 >= d21) {
                    n3 |= 1;
                } else if (d21 <= d6 * d4 + SMath.abs(d22) / 2.0) {
                    n3 |= 2;
                } else if (d21 <= d6 * d3 + d23 / 2.0) {
                    n3 |= 0x12;
                } else {
                    if (stringBuffer2 != null) {
                        stringBuffer2.setLength(0);
                        stringBuffer2.append("no solar eclipse at tjd = " + d11);
                    }
                    for (n4 = 0; n4 < 10; ++n4) {
                        dArray[n4] = 0.0;
                    }
                    dArray2[0] = 0.0;
                    n3 = 0;
                    d15 = 0.0;
                    bl = true;
                }
                d15 = d20 * d20 + d6 * d6 - d16 * d16;
                d15 = d15 > 0.0 ? SMath.sqrt(d15) : 0.0;
                d2 = d20 - d15;
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray9[n4] = dArray5[n4] + d2 * dArray3[n4];
                }
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray10[n4] = dArray9[n4];
                }
                dArray10[2] = dArray10[2] * d7;
                this.sl.swi_cartpol(dArray10, dArray10);
                if (n5 > 0) break;
                double d24 = SMath.cos(dArray10[1]);
                double d25 = SMath.sin(dArray10[1]);
                double d26 = 0.003352819697896193;
                double d27 = 1.0 / SMath.sqrt(d24 * d24 + (1.0 - d26) * (1.0 - d26) * d25 * d25);
                d7 = d14 = (1.0 - d26) * (1.0 - d26) * d27;
                ++n5;
            }
            this.sl.swi_polcart(dArray10, dArray10);
            this.sl.swi_cartpol(dArray9, dArray9);
            dArray9[0] = dArray9[0] - d12;
            dArray9[0] = dArray9[0] * 57.2957795130823;
            dArray9[1] = dArray9[1] * 57.2957795130823;
            dArray9[0] = this.sl.swe_degnorm(dArray9[0]);
            if (dArray9[0] > 180.0) {
                dArray9[0] = dArray9[0] - 360.0;
            }
            dArray[0] = dArray9[0];
            dArray[1] = dArray9[1];
            for (n4 = 0; n4 <= 2; ++n4) {
                dArray11[n4] = dArray7[n4] - dArray10[n4];
            }
            d2 = SMath.sqrt(this.sl.square_sum(dArray11));
            dArray2[0] = (d2 / d5 * (d13 * 2.0 - d9) - d9) * d4;
            dArray2[0] = dArray2[0] * 1.4959787066E8;
            dArray2[1] = (d2 / d5 * (d13 * 2.0 + d9) + d9) * d3;
            dArray2[1] = dArray2[1] * 1.4959787066E8;
            if ((n3 & 0x10) != 0 || bl) break block26;
            n3 = dArray2[0] > 0.0 ? (n3 |= 8) : (n3 |= 4);
        }
        return n3;
    }

    private int calc_planet_star(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, StringBuffer stringBuffer2) {
        int n3 = -1;
        if (stringBuffer == null || stringBuffer.length() == 0) {
            n3 = this.sw.swe_calc(d, n, n2, dArray, stringBuffer2);
        } else {
            n3 = this.sw.swe_fixstar(stringBuffer, d, n2, dArray, stringBuffer2);
            if (n3 == 0) {
                if ((n2 & 0x1000) != 0) {
                    int n4 = 0;
                    while (n4 < 3) {
                        int n5 = n4++;
                        dArray[n5] = dArray[n5] * 1.0E8;
                    }
                } else {
                    dArray[2] = dArray[2] * 1.0E8;
                }
            }
        }
        return n3;
    }

    int swe_sol_eclipse_how(double d, int n, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        double[] dArray3 = new double[10];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[20];
        if (dArray[2] < -500.0 || dArray[2] > 25000.0) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("location for eclipses must be between -500 and 25000 m above sea");
            }
            return -1;
        }
        SweDate.swi_set_tid_acc(d, n &= 7, 0);
        int n2 = this.eclipse_how(d, 0, null, n, dArray[0], dArray[1], dArray[2], dArray2, stringBuffer);
        if (n2 == -1) {
            return n2;
        }
        int n3 = this.eclipse_where(d, 0, null, n, dArray6, dArray3, stringBuffer);
        if (n3 == -1) {
            return n3;
        }
        if (n2 != 0) {
            n2 |= n3 & 3;
        }
        dArray2[3] = dArray3[0];
        this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
        if (this.sw.swe_calc_ut(d, 0, n | 0x8000 | 0x800, dArray4, stringBuffer) == -1) {
            return -1;
        }
        this.swe_azalt(d, 1, dArray, 0.0, 10.0, dArray4, dArray5);
        dArray2[4] = dArray5[0];
        dArray2[5] = dArray5[1];
        dArray2[6] = dArray5[2];
        if (dArray5[2] <= 0.0) {
            n2 = 0;
        }
        return n2;
    }

    private int eclipse_how(double d, int n, StringBuffer stringBuffer, int n2, double d2, double d3, double d4, double[] dArray, StringBuffer stringBuffer2) {
        int n3;
        int n4 = 0;
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        int n5 = 0x8800 | n2;
        int n6 = n5 | 0x1000;
        double[] dArray8 = new double[6];
        double[] dArray9 = new double[3];
        for (n3 = 0; n3 < 10; ++n3) {
            dArray[n3] = 0.0;
        }
        dArray9[0] = d2;
        dArray9[1] = d3;
        dArray9[2] = d4;
        double d5 = d + SweDate.getDeltaT(d);
        this.sw.swe_set_topo(d2, d3, d4);
        if (this.calc_planet_star(d5, n, stringBuffer, n5, dArray4, stringBuffer2) == -1) {
            return -1;
        }
        if (this.sw.swe_calc(d5, 1, n5, dArray5, stringBuffer2) == -1) {
            return -1;
        }
        if (this.calc_planet_star(d5, n, stringBuffer, n6, dArray2, stringBuffer2) == -1) {
            return -1;
        }
        if (this.sw.swe_calc(d5, 1, n6, dArray3, stringBuffer2) == -1) {
            return -1;
        }
        double d6 = stringBuffer != null && stringBuffer.length() > 0 ? 0.0 : (n < 21 ? SwephData.pla_diam[n] / 2.0 / 1.4959787066E11 : (n > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
        this.swe_azalt(d, 1, dArray9, 0.0, 10.0, dArray4, dArray8);
        double d7 = SMath.asin(1.1618815109677577E-5 / dArray5[2]) * 57.2957795130823;
        double d8 = SMath.asin(d6 / dArray4[2]) * 57.2957795130823;
        double d9 = d8 + d7;
        double d10 = d8 - d7;
        for (n3 = 0; n3 < 3; ++n3) {
            dArray6[n3] = dArray2[n3] / dArray4[2];
            dArray7[n3] = dArray3[n3] / dArray5[2];
        }
        double d11 = SMath.acos(this.sl.swi_dot_prod_unit(dArray6, dArray7)) * 57.2957795130823;
        if (d11 < d10) {
            n4 = 8;
        } else if (d11 < SMath.abs(d10)) {
            n4 = 4;
        } else if (d11 < d9) {
            n4 = 16;
        } else {
            n4 = 0;
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("no solar eclipse at tjd = " + d);
            }
        }
        dArray[1] = d8 > 0.0 ? d7 / d8 : 0.0;
        double d12 = SMath.asin(d8 / 2.0 * 0.0174532925199433) * 2.0;
        double d13 = -d11 + d8 + d7;
        dArray[0] = d12 > 0.0 ? d13 / d8 / 2.0 : 100.0;
        d12 = d8;
        double d14 = d7;
        double d15 = d11;
        if (n4 == 0 || d12 == 0.0) {
            dArray[2] = 100.0;
        } else if (n4 == 4 || n4 == 8) {
            dArray[2] = d14 * d14 / d12 / d12;
        } else {
            double d16 = 2.0 * d15 * d14;
            double d17 = 2.0 * d15 * d12;
            if (d16 < 1.0E-9) {
                dArray[2] = d14 * d14 / d12 / d12;
            } else {
                if ((d16 = (d15 * d15 + d14 * d14 - d12 * d12) / d16) > 1.0) {
                    d16 = 1.0;
                }
                if (d16 < -1.0) {
                    d16 = -1.0;
                }
                if ((d17 = (d15 * d15 + d12 * d12 - d14 * d14) / d17) > 1.0) {
                    d17 = 1.0;
                }
                if (d17 < -1.0) {
                    d17 = -1.0;
                }
                d16 = SMath.acos(d16);
                d17 = SMath.acos(d17);
                double d18 = d16 * d14 * d14 / 2.0;
                double d19 = d17 * d12 * d12 / 2.0;
                dArray[2] = ((d18 -= SMath.cos(d16) * SMath.sin(d16) * d14 * d14 / 2.0) + (d19 -= SMath.cos(d17) * SMath.sin(d17) * d12 * d12 / 2.0)) * 2.0 / Math.PI / d12 / d12;
            }
        }
        dArray[7] = d11;
        double d20 = -(34.4556 + 2.12 * SMath.sqrt(d4)) / 60.0;
        if (dArray8[1] + d8 + SMath.abs(d20) >= 0.0 && n4 != 0) {
            n4 |= 0x80;
        }
        dArray[4] = dArray8[0];
        dArray[5] = dArray8[1];
        dArray[6] = dArray8[2];
        if (n == 0 && (stringBuffer == null || stringBuffer.length() == 0)) {
            dArray[8] = dArray[0];
            if ((n4 & 0xC) != 0) {
                dArray[8] = dArray[1];
            }
            for (n3 = 0; n3 < NSAROS_SOLAR; ++n3) {
                double d21 = (d - Swecl.saros_data_solar[n3].tstart) / 6585.3213;
                if (d21 < 0.0) continue;
                int n7 = (int)d21;
                if ((d21 - (double)n7) * 6585.3213 < 2.0) {
                    dArray[9] = Swecl.saros_data_solar[n3].series_no;
                    dArray[10] = (double)n7 + 1.0;
                    break;
                }
                int n8 = n7 + 1;
                if (!(((double)n8 - d21) * 6585.3213 < 2.0)) continue;
                dArray[9] = Swecl.saros_data_solar[n3].series_no;
                dArray[10] = (double)n8 + 1.0;
                break;
            }
            if (n3 == NSAROS_SOLAR) {
                dArray[10] = -9.9999999E7;
                dArray[9] = -9.9999999E7;
            }
        }
        return n4;
    }

    int swe_sol_eclipse_when_glob(double d, int n, int n2, double[] dArray, int n3, StringBuffer stringBuffer) {
        int n4;
        block67: {
            double d2;
            int n5;
            double d3;
            double d4;
            double d5;
            double d6;
            int n6;
            int n7 = 0;
            int n8 = 0;
            n4 = 0;
            int n9 = 0;
            double d7 = 6378.14;
            DblObj dblObj = new DblObj();
            double[] dArray2 = new double[6];
            double[] dArray3 = new double[6];
            double[] dArray4 = new double[6];
            double[] dArray5 = new double[6];
            double[] dArray6 = new double[10];
            double[] dArray7 = new double[3];
            DblObj dblObj2 = new DblObj();
            double d8 = 0.08333333333333333;
            double d9 = 0.006944444444444445;
            DblObj dblObj3 = new DblObj(0.0);
            DblObj dblObj4 = new DblObj(0.0);
            double[] dArray8 = new double[20];
            double[] dArray9 = new double[20];
            double[] dArray10 = new double[6];
            double[] dArray11 = new double[6];
            int n10 = 1;
            boolean bl = false;
            SweDate.swi_set_tid_acc(d, n &= 7, 0);
            int n11 = 0x800 | n;
            int n12 = n11 | 0x1000;
            if (n2 == 17) {
                if (stringBuffer != null) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("central partial eclipses do not exist");
                }
                return -1;
            }
            if (n2 == 0) {
                n2 = 63;
            }
            if (n3 != 0) {
                n10 = -1;
            }
            double d10 = (int)((d - 2451545.0) / 365.2425 * 12.3685);
            d10 -= (double)n10;
            while (true) {
                int n13;
                n4 = 0;
                bl = false;
                for (n6 = 0; n6 <= 9; ++n6) {
                    dArray[n6] = 0.0;
                }
                double d11 = d10 / 1236.85;
                double d12 = d11 * d11;
                double d13 = d12 * d11;
                double d14 = d13 * d11;
                double d15 = this.sl.swe_degnorm(160.7108 + 390.67050274 * d10 - 0.0016341 * d12 - 2.27E-6 * d13 + 1.1E-8 * d14);
                if (d15 > 180.0) {
                    d15 -= 180.0;
                }
                if (d15 > 21.0 && d15 < 159.0) {
                    d10 += (double)n10;
                    continue;
                }
                d6 = 2451550.09765 + 29.530588853 * d10 + 1.337E-4 * d12 - 1.5E-7 * d13 + 7.3E-10 * d14;
                double d16 = this.sl.swe_degnorm(2.5534 + 29.10535669 * d10 - 2.18E-5 * d12 - 1.1E-7 * d13);
                double d17 = this.sl.swe_degnorm(201.5643 + 385.81693528 * d10 + 0.1017438 * d12 + 1.239E-5 * d13 + 5.8E-8 * d14);
                double d18 = 1.0 - 0.002516 * d11 - 7.4E-6 * d12;
                d6 = d6 - 0.4075 * SMath.sin(d17 *= 0.0174532925199433) + 0.1721 * d18 * SMath.sin(d16 *= 0.0174532925199433);
                double d19 = 1.0;
                if (d6 < 2000000.0 || d6 > 2500000.0) {
                    d19 = 5.0;
                }
                double d20 = 4.0;
                for (d5 = d19; d5 > 1.0E-4; d5 /= d20) {
                    n6 = 0;
                    d4 = d6 - d5;
                    while (n6 <= 2) {
                        if (this.sw.swe_calc(d4, 0, n11, dArray4, stringBuffer) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(d4, 1, n11, dArray5, stringBuffer) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(d4, 0, n12, dArray2, stringBuffer) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(d4, 1, n12, dArray3, stringBuffer) == -1) {
                            return -1;
                        }
                        for (n13 = 0; n13 < 3; ++n13) {
                            dArray10[n13] = dArray2[n13] / dArray4[2];
                            dArray11[n13] = dArray3[n13] / dArray5[2];
                        }
                        dArray7[n6] = SMath.acos(this.sl.swi_dot_prod_unit(dArray10, dArray11)) * 57.2957795130823;
                        double d21 = SMath.asin(1.1618815109677577E-5 / dArray5[2]) * 57.2957795130823;
                        double d22 = SMath.asin(0.004652472638342832 / dArray4[2]) * 57.2957795130823;
                        int n14 = n6++;
                        dArray7[n14] = dArray7[n14] - (d21 + d22);
                        d4 += d5;
                    }
                    this.find_maximum(dArray7[0], dArray7[1], dArray7[2], d5, dblObj, dblObj2);
                    d6 += dblObj.val + d5;
                }
                d3 = d6 - SweDate.getDeltaT(d6);
                d3 = d6 - SweDate.getDeltaT(d3);
                d6 -= SweDate.getDeltaT(d3);
                d3 = d6;
                n4 = this.eclipse_where(d6, 0, null, n, dArray8, dArray6, stringBuffer);
                if (n4 == -1) {
                    return n4;
                }
                n9 = n4;
                n9 = this.eclipse_how(d6, 0, null, n, dArray8[0], dArray8[1], 0.0, dArray9, stringBuffer);
                if (n9 == -1) {
                    return n9;
                }
                if (n9 == 0) {
                    d10 += (double)n10;
                    continue;
                }
                dArray[0] = d6;
                if (n3 != 0 && dArray[0] >= d - 1.0E-4 || n3 == 0 && dArray[0] <= d + 1.0E-4) {
                    d10 += (double)n10;
                    continue;
                }
                n4 = this.eclipse_where(d6, 0, null, n, dArray8, dArray6, stringBuffer);
                if (n4 == -1) {
                    return n4;
                }
                if (n4 == 0) {
                    n4 = 18;
                    dArray[4] = dArray[5] = d6;
                    bl = true;
                }
                if ((n2 & 2) == 0 && (n4 & 2) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if ((n2 & 1) == 0 && (n4 & 1) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if ((n2 & 8) == 0 && (n4 & 8) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if ((n2 & 0x10) == 0 && (n4 & 0x10) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if ((n2 & 0x24) == 0 && (n4 & 4) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if (bl) break block67;
                int n15 = (n4 & 0x10) != 0 ? 0 : ((n4 & 2) != 0 ? 1 : 2);
                double d23 = d8;
                double d24 = d9 / 3.0;
                for (int i = 0; i <= n15; ++i) {
                    if (i == 0) {
                        n7 = 2;
                        n8 = 3;
                    } else if (i == 1) {
                        if ((n4 & 0x10) != 0) continue;
                        n7 = 4;
                        n8 = 5;
                    } else if (i == 2) {
                        if ((n4 & 2) != 0) continue;
                        n7 = 6;
                        n8 = 7;
                    }
                    n6 = 0;
                    d4 = d6 - d23;
                    while (n6 <= 2) {
                        n9 = this.eclipse_where(d4, 0, null, n, dArray8, dArray6, stringBuffer);
                        if (n9 == -1) {
                            return n9;
                        }
                        if (i == 0) {
                            dArray7[n6] = dArray6[4] / 2.0 + d7 / dArray6[5] - dArray6[2];
                        } else if (i == 1) {
                            dArray7[n6] = SMath.abs(dArray6[3]) / 2.0 + d7 / dArray6[6] - dArray6[2];
                        } else if (i == 2) {
                            dArray7[n6] = d7 / dArray6[6] - dArray6[2];
                        }
                        ++n6;
                        d4 += d23;
                    }
                    this.find_zero(dArray7[0], dArray7[1], dArray7[2], d23, dblObj3, dblObj4);
                    dArray[n7] = d6 + dblObj3.val + d23;
                    dArray[n8] = d6 + dblObj4.val + d23;
                    n13 = 0;
                    d5 = d24;
                    while (n13 < 3) {
                        for (n5 = n7; n5 <= n8; n5 += n8 - n7) {
                            n6 = 0;
                            d4 = dArray[n5] - d5;
                            while (n6 < 2) {
                                n9 = this.eclipse_where(d4, 0, null, n, dArray8, dArray6, stringBuffer);
                                if (n9 == -1) {
                                    return n9;
                                }
                                if (i == 0) {
                                    dArray7[n6] = dArray6[4] / 2.0 + d7 / dArray6[5] - dArray6[2];
                                } else if (i == 1) {
                                    dArray7[n6] = SMath.abs(dArray6[3]) / 2.0 + d7 / dArray6[6] - dArray6[2];
                                } else if (i == 2) {
                                    dArray7[n6] = d7 / dArray6[6] - dArray6[2];
                                }
                                ++n6;
                                d4 += d5;
                            }
                            dblObj3.val = dArray7[1] / ((dArray7[1] - dArray7[0]) / d5);
                            int n16 = n5;
                            dArray[n16] = dArray[n16] - dblObj3.val;
                        }
                        ++n13;
                        d5 /= 3.0;
                    }
                }
                if ((n4 & 4) != 0) {
                    n9 = this.eclipse_where(dArray[0], 0, null, n, dArray8, dArray6, stringBuffer);
                    if (n9 == -1) {
                        return n9;
                    }
                    dArray7[0] = dArray6[0];
                    n9 = this.eclipse_where(dArray[4], 0, null, n, dArray8, dArray6, stringBuffer);
                    if (n9 == -1) {
                        return n9;
                    }
                    dArray7[1] = dArray6[0];
                    n9 = this.eclipse_where(dArray[5], 0, null, n, dArray8, dArray6, stringBuffer);
                    if (n9 == -1) {
                        return n9;
                    }
                    dArray7[2] = dArray6[0];
                    if (dArray7[0] * dArray7[1] < 0.0 || dArray7[0] * dArray7[2] < 0.0) {
                        n4 |= 0x20;
                        n4 &= 0xFFFFFFFB;
                    }
                }
                if ((n2 & 4) == 0 && (n4 & 4) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if ((n2 & 0x20) != 0 || (n4 & 0x20) == 0) break;
                d10 += (double)n10;
            }
            int n17 = 2;
            for (n6 = 0; n6 < 2; ++n6) {
                n5 = n6 + n17;
                d2 = dArray[n5] + SweDate.getDeltaT(dArray[n5]);
                if (this.sw.swe_calc(d2, 0, n11, dArray4, stringBuffer) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(d2, 1, n11, dArray5, stringBuffer) == -1) {
                    return -1;
                }
                dArray7[n6] = this.sl.swe_degnorm(dArray4[0] - dArray5[0]);
                if (!(dArray7[n6] > 180.0)) continue;
                int n18 = n6;
                dArray7[n18] = dArray7[n18] - 360.0;
            }
            if (dArray7[0] * dArray7[1] >= 0.0) {
                dArray[1] = 0.0;
            } else {
                d6 = d3;
                d5 = 0.1;
                dblObj3.val = (dArray[3] - dArray[2]) / 2.0;
                if (dblObj3.val < d5) {
                    d5 = dblObj3.val / 2.0;
                }
                n5 = 0;
                while (d5 > 0.01) {
                    n6 = 0;
                    d4 = d6;
                    while (n6 <= 1) {
                        d2 = d4 + SweDate.getDeltaT(d4);
                        if (this.sw.swe_calc(d2, 0, n11, dArray4, stringBuffer) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(d2, 1, n11, dArray5, stringBuffer) == -1) {
                            return -1;
                        }
                        dArray7[n6] = this.sl.swe_degnorm(dArray4[0] - dArray5[0]);
                        if (dArray7[n6] > 180.0) {
                            int n19 = n6;
                            dArray7[n19] = dArray7[n19] - 360.0;
                        }
                        if (dArray7[n6] > 180.0) {
                            int n20 = n6;
                            dArray7[n20] = dArray7[n20] - 360.0;
                        }
                        ++n6;
                        d4 -= d5;
                    }
                    double d25 = (dArray7[1] - dArray7[0]) / d5;
                    if (d25 < 1.0E-10) break;
                    dblObj3.val = dArray7[0] / d25;
                    d6 += dblObj3.val;
                    ++n5;
                    d5 /= 3.0;
                }
                dArray[1] = d6;
            }
        }
        return n4;
    }

    int swe_lun_occult_when_glob(double d, int n, StringBuffer stringBuffer, int n2, int n3, double[] dArray, int n4, StringBuffer stringBuffer2) {
        double d2;
        int n5;
        double d3;
        double d4;
        double d5;
        int n6;
        boolean bl;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        double d6 = 6378.14;
        double d7 = 0.0;
        DblObj dblObj = new DblObj();
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[10];
        double[] dArray7 = new double[20];
        DblObj dblObj2 = new DblObj();
        double d8 = 0.08333333333333333;
        double d9 = 0.006944444444444445;
        DblObj dblObj3 = new DblObj(0.0);
        DblObj dblObj4 = new DblObj(0.0);
        double d10 = 1.0;
        double[] dArray8 = new double[20];
        int n11 = 1;
        boolean bl2 = false;
        boolean bl3 = bl = (n4 & 0x8000) != 0;
        if (n < 0) {
            n = 0;
        }
        if (n == 144340) {
            n = 9;
        }
        SweDate.swi_set_tid_acc(d, n2 &= 7, 0);
        int n12 = 0x800 | n2;
        int n13 = n12 | 0x1000;
        n4 = (int)((long)n4 & 1L);
        if (n3 == 17) {
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("central partial eclipses do not exist");
            }
            return -1;
        }
        if (n3 == 0) {
            n3 = 63;
        }
        n9 = 0;
        for (n6 = 0; n6 <= 9; ++n6) {
            dArray[n6] = 0.0;
        }
        if (n4 != 0) {
            n11 = -1;
        }
        d = d5 = d;
        d7 = d5;
        while (true) {
            if (this.calc_planet_star(d5, n, stringBuffer, n2, dArray4, stringBuffer2) == -1) {
                return -1;
            }
            if (SMath.abs(dArray4[1]) > 7.0 && stringBuffer != null && stringBuffer.length() > 0) {
                if (stringBuffer2 != null) {
                    stringBuffer2.setLength(0);
                    stringBuffer2.append("occultation never occurs: star " + stringBuffer + " has ecl. lat. " + dArray4[1]);
                }
                return -1;
            }
            if (this.sw.swe_calc(d5, 1, n2, dArray5, stringBuffer2) == -1) {
                return -1;
            }
            double d11 = this.sl.swe_degnorm(dArray4[0] - dArray5[0]);
            if (n11 < 0) {
                d11 -= 360.0;
            }
            while (SMath.abs(d11) > 0.1) {
                if (this.calc_planet_star(d5 += d11 / 13.0, n, stringBuffer, n2, dArray4, stringBuffer2) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(d5, 1, n2, dArray5, stringBuffer2) == -1) {
                    return -1;
                }
                d11 = this.sl.swe_degnorm(dArray4[0] - dArray5[0]);
                if (!(d11 > 180.0)) continue;
                d11 -= 360.0;
            }
            d7 = d5;
            double d12 = SMath.abs(dArray4[1] - dArray5[1]);
            if (d12 > 2.0) {
                if (bl) {
                    dArray[0] = d5 + (double)n11;
                    return 0;
                }
                d7 = d5 += (double)(n11 * 20);
                continue;
            }
            d12 = stringBuffer != null && stringBuffer.length() > 0 ? 0.0 : (n < 21 ? SwephData.pla_diam[n] / 2.0 / 1.4959787066E11 : (n > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
            double d13 = d10;
            double d14 = 3.0;
            for (d4 = d13; d4 > 1.0E-4; d4 /= d14) {
                n6 = 0;
                d5 = d7 - d4;
                while (n6 <= 2) {
                    if (this.calc_planet_star(d5, n, stringBuffer, n12, dArray4, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d5, 1, n12, dArray5, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.calc_planet_star(d5, n, stringBuffer, n13, dArray2, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d5, 1, n13, dArray3, stringBuffer2) == -1) {
                        return -1;
                    }
                    dArray7[n6] = SMath.acos(this.sl.swi_dot_prod_unit(dArray2, dArray3)) * 57.2957795130823;
                    double d15 = SMath.asin(1.1618815109677577E-5 / dArray5[2]) * 57.2957795130823;
                    double d16 = SMath.asin(d12 / dArray4[2]) * 57.2957795130823;
                    int n14 = n6++;
                    dArray7[n14] = dArray7[n14] - (d15 + d16);
                    d5 += d4;
                }
                this.find_maximum(dArray7[0], dArray7[1], dArray7[2], d4, dblObj, dblObj2);
                d7 += dblObj.val + d4;
            }
            d7 -= SweDate.getDeltaT(d7);
            d3 = d7;
            n9 = this.eclipse_where(d7, n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
            if (n9 == -1) {
                return n9;
            }
            n10 = n9;
            if (n10 == 0) {
                if (bl) {
                    dArray[0] = d7;
                    return 0;
                }
                d7 = d5 = d7 + (double)(n11 * 20);
                continue;
            }
            dArray[0] = d7;
            if (n4 != 0 && dArray[0] >= d - 1.0E-4 || n4 == 0 && dArray[0] <= d + 1.0E-4) {
                d7 = d5 = d7 + (double)(n11 * 20);
                continue;
            }
            n9 = this.eclipse_where(d7, n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
            if (n9 == -1) {
                return n9;
            }
            if (n9 == 0) {
                n9 = 18;
                dArray[4] = dArray[5] = d7;
                n9 = 18;
                dArray[4] = dArray[5] = d7;
                bl2 = true;
            }
            if ((n3 & 2) == 0 && (n9 & 2) != 0) {
                d5 = d7 + (double)(n11 * 20);
                if (bl) {
                    dArray[0] = d7;
                    return 0;
                }
                d7 = d5;
                continue;
            }
            if ((n3 & 1) == 0 && (n9 & 1) != 0) {
                d5 = d7 + (double)(n11 * 20);
                if (bl) {
                    dArray[0] = d7;
                    return 0;
                }
                d7 = d5;
                continue;
            }
            if ((n3 & 8) == 0 && (n9 & 8) != 0) {
                d5 = d7 + (double)(n11 * 20);
                if (bl) {
                    dArray[0] = d7;
                    return 0;
                }
                d7 = d5;
                continue;
            }
            if ((n3 & 0x10) == 0 && (n9 & 0x10) != 0) {
                d5 = d7 + (double)(n11 * 20);
                if (bl) {
                    dArray[0] = d7;
                    return 0;
                }
                d7 = d5;
                continue;
            }
            if ((n3 & 0x24) == 0 && (n9 & 4) != 0) {
                d5 = d7 + (double)(n11 * 20);
                if (bl) {
                    dArray[0] = d7;
                    return 0;
                }
                d7 = d5;
                continue;
            }
            if (bl2) {
                return n9;
            }
            int n15 = (n9 & 0x10) != 0 ? 0 : ((n9 & 2) != 0 ? 1 : 2);
            double d17 = d8;
            double d18 = d9;
            for (int i = 0; i <= n15; ++i) {
                if (i == 0) {
                    n7 = 2;
                    n8 = 3;
                } else if (i == 1) {
                    if ((n9 & 0x10) != 0) continue;
                    n7 = 4;
                    n8 = 5;
                } else if (i == 2) {
                    if ((n9 & 2) != 0) continue;
                    n7 = 6;
                    n8 = 7;
                }
                n6 = 0;
                d5 = d7 - d17;
                while (n6 <= 2) {
                    n10 = this.eclipse_where(d5, n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
                    if (n10 == -1) {
                        return n10;
                    }
                    if (i == 0) {
                        dArray7[n6] = dArray6[4] / 2.0 + d6 / dArray6[5] - dArray6[2];
                    } else if (i == 1) {
                        dArray7[n6] = SMath.abs(dArray6[3]) / 2.0 + d6 / dArray6[6] - dArray6[2];
                    } else if (i == 2) {
                        dArray7[n6] = d6 / dArray6[6] - dArray6[2];
                    }
                    ++n6;
                    d5 += d17;
                }
                this.find_zero(dArray7[0], dArray7[1], dArray7[2], d17, dblObj3, dblObj4);
                dArray[n7] = d7 + dblObj3.val + d17;
                dArray[n8] = d7 + dblObj4.val + d17;
                int n16 = 0;
                d4 = d18;
                while (n16 < 3) {
                    for (n5 = n7; n5 <= n8; n5 += n8 - n7) {
                        n6 = 0;
                        d5 = dArray[n5] - d4;
                        while (n6 < 2) {
                            n10 = this.eclipse_where(d5, n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
                            if (n10 == -1) {
                                return n10;
                            }
                            if (i == 0) {
                                dArray7[n6] = dArray6[4] / 2.0 + d6 / dArray6[5] - dArray6[2];
                            } else if (i == 1) {
                                dArray7[n6] = SMath.abs(dArray6[3]) / 2.0 + d6 / dArray6[6] - dArray6[2];
                            } else if (i == 2) {
                                dArray7[n6] = d6 / dArray6[6] - dArray6[2];
                            }
                            ++n6;
                            d5 += d4;
                        }
                        dblObj3.val = dArray7[1] / ((dArray7[1] - dArray7[0]) / d4);
                        int n17 = n5;
                        dArray[n17] = dArray[n17] - dblObj3.val;
                    }
                    ++n16;
                    d4 /= 3.0;
                }
            }
            if ((n9 & 4) != 0) {
                n10 = this.eclipse_where(dArray[0], n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
                if (n10 == -1) {
                    return n10;
                }
                dArray7[0] = dArray6[0];
                n10 = this.eclipse_where(dArray[4], n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
                if (n10 == -1) {
                    return n10;
                }
                dArray7[1] = dArray6[0];
                n10 = this.eclipse_where(dArray[5], n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
                if (n10 == -1) {
                    return n10;
                }
                dArray7[2] = dArray6[0];
                if (dArray7[0] * dArray7[1] < 0.0 || dArray7[0] * dArray7[2] < 0.0) {
                    n9 |= 0x20;
                    n9 &= 0xFFFFFFFB;
                }
            }
            if ((n3 & 4) == 0 && (n9 & 4) != 0) {
                d5 = d7 + (double)(n11 * 20);
                if (bl) {
                    dArray[0] = d7;
                    return 0;
                }
                d7 = d5;
                continue;
            }
            if ((n3 & 0x20) != 0 || (n9 & 0x20) == 0) break;
            d5 = d7 + (double)(n11 * 20);
            if (bl) {
                dArray[0] = d7;
                return 0;
            }
            d7 = d5;
        }
        int n18 = 2;
        for (n6 = 0; n6 < 2; ++n6) {
            n5 = n6 + n18;
            d2 = dArray[n5] + SweDate.getDeltaT(dArray[n5]);
            if (this.calc_planet_star(d2, n, stringBuffer, n12, dArray4, stringBuffer2) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d2, 1, n12, dArray5, stringBuffer2) == -1) {
                return -1;
            }
            dArray7[n6] = this.sl.swe_degnorm(dArray4[0] - dArray5[0]);
            if (!(dArray7[n6] > 180.0)) continue;
            int n19 = n6;
            dArray7[n19] = dArray7[n19] - 360.0;
        }
        if (dArray7[0] * dArray7[1] >= 0.0) {
            dArray[1] = 0.0;
        } else {
            d7 = d3;
            d4 = 0.1;
            dblObj3.val = (dArray[3] - dArray[2]) / 2.0;
            if (dblObj3.val < d4) {
                d4 = dblObj3.val / 2.0;
            }
            n5 = 0;
            while (d4 > 0.01) {
                n6 = 0;
                d5 = d7;
                while (n6 <= 1) {
                    d2 = d5 + SweDate.getDeltaT(d5);
                    if (this.calc_planet_star(d2, n, stringBuffer, n12, dArray4, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d2, 1, n12, dArray5, stringBuffer2) == -1) {
                        return -1;
                    }
                    dArray7[n6] = this.sl.swe_degnorm(dArray4[0] - dArray5[0]);
                    if (dArray7[n6] > 180.0) {
                        int n20 = n6;
                        dArray7[n20] = dArray7[n20] - 360.0;
                    }
                    if (dArray7[n6] > 180.0) {
                        int n21 = n6;
                        dArray7[n21] = dArray7[n21] - 360.0;
                    }
                    ++n6;
                    d5 -= d4;
                }
                double d19 = (dArray7[1] - dArray7[0]) / d4;
                if (d19 < 1.0E-10) break;
                dblObj3.val = dArray7[0] / d19;
                d7 += dblObj3.val;
                ++n5;
                d4 /= 3.0;
            }
            dArray[1] = d7;
        }
        return n9;
    }

    int swe_sol_eclipse_when_loc(double d, int n, double[] dArray, double[] dArray2, double[] dArray3, int n2, StringBuffer stringBuffer) {
        int n3 = 0;
        int n4 = 0;
        double[] dArray4 = new double[20];
        double[] dArray5 = new double[10];
        if (dArray[2] < -500.0 || dArray[2] > 25000.0) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("location for eclipses must be between -500 and 25000 m above sea");
            }
            return -1;
        }
        SweDate.swi_set_tid_acc(d, n &= 7, 0);
        n3 = this.eclipse_when_loc(d, n, dArray, dArray2, dArray3, n2, stringBuffer);
        if (n3 <= 0) {
            return n3;
        }
        n4 = this.eclipse_where(dArray2[0], 0, null, n, dArray4, dArray5, stringBuffer);
        if (n4 == -1) {
            return n4;
        }
        dArray3[3] = dArray5[0];
        return n3 |= n4 & 2;
    }

    int swe_lun_occult_when_loc(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, double[] dArray2, double[] dArray3, int n3, StringBuffer stringBuffer2) {
        int n4 = 0;
        int n5 = 0;
        double[] dArray4 = new double[20];
        double[] dArray5 = new double[10];
        if (dArray[2] < -500.0 || dArray[2] > 25000.0) {
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("location for occultations must be between -500 and 25000 m above sea");
            }
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n == 144340) {
            n = 9;
        }
        SweDate.swi_set_tid_acc(d, n2 &= 7, 0);
        n4 = this.occult_when_loc(d, n, stringBuffer, n2, dArray, dArray2, dArray3, n3, stringBuffer2);
        if (n4 <= 0) {
            return n4;
        }
        n5 = this.eclipse_where(dArray2[0], n, stringBuffer, n2, dArray4, dArray5, stringBuffer2);
        if (n5 == -1) {
            return n5;
        }
        dArray3[3] = dArray5[0];
        return n4 |= n5 & 2;
    }

    private int eclipse_when_loc(double d, int n, double[] dArray, double[] dArray2, double[] dArray3, int n2, StringBuffer stringBuffer) {
        int n3;
        int n4 = 0;
        DblObj dblObj = new DblObj();
        DblObj dblObj2 = new DblObj();
        DblObj dblObj3 = new DblObj();
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        double[] dArray8 = new double[6];
        double[] dArray9 = new double[6];
        double[] dArray10 = new double[3];
        DblObj dblObj4 = new DblObj();
        double d2 = 0.0013888888888888887;
        double d3 = 1.1574074074074075E-4;
        double d4 = 0.08333333333333333;
        double d5 = 0.006944444444444445;
        DblObj dblObj5 = new DblObj(0.0);
        DblObj dblObj6 = new DblObj(0.0);
        int n5 = 0x8800 | n;
        int n6 = n5 | 0x1000;
        this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
        double d6 = (int)((d - 2451545.0) / 365.2425 * 12.3685);
        d6 = n2 != 0 ? (d6 += 1.0) : (d6 -= 1.0);
        while (true) {
            int n7;
            int n8;
            int n9;
            double d7;
            double d8;
            double d9;
            int n10;
            double d10;
            double d11;
            double d12;
            double d13;
            double d14;
            double d15;
            double d16;
            if ((d16 = (d15 = this.sl.swe_degnorm(160.7108 + 390.67050274 * d6 - 0.0016341 * (d14 = (d13 = d6 / 1236.85) * d13) - 2.27E-6 * (d12 = d14 * d13) + 1.1E-8 * (d11 = d12 * d13)))) > 180.0) {
                d16 -= 180.0;
            }
            if (d16 > 21.0 && d16 < 159.0) {
                if (n2 != 0) {
                    d6 -= 1.0;
                    continue;
                }
                d6 += 1.0;
                continue;
            }
            double d17 = 2451550.09765 + 29.530588853 * d6 + 1.337E-4 * d14 - 1.5E-7 * d12 + 7.3E-10 * d11;
            double d18 = this.sl.swe_degnorm(2.5534 + 29.10535669 * d6 - 2.18E-5 * d14 - 1.1E-7 * d12);
            double d19 = this.sl.swe_degnorm(201.5643 + 385.81693528 * d6 + 0.1017438 * d14 + 1.239E-5 * d12 + 5.8E-8 * d11);
            double d20 = this.sl.swe_degnorm(124.7746 - 1.5637558 * d6 + 0.0020691 * d14 + 2.15E-6 * d12);
            double d21 = 1.0 - 0.002516 * d13 - 7.4E-6 * d14;
            double d22 = this.sl.swe_degnorm(299.77 + 0.107408 * d6 - 0.009173 * d14);
            d15 *= 0.0174532925199433;
            d20 *= 0.0174532925199433;
            d22 *= 0.0174532925199433;
            d17 = d17 - 0.4075 * SMath.sin(d19 *= 0.0174532925199433) + 0.1721 * d21 * SMath.sin(d18 *= 0.0174532925199433);
            this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
            double d23 = 2.0;
            double d24 = 0.5;
            if (d17 < 1900000.0 || d17 > 2500000.0) {
                d24 = 2.0;
            }
            for (d10 = d24; d10 > 1.0E-5; d10 /= d23) {
                if (d10 < 0.1) {
                    d23 = 3.0;
                }
                n10 = 0;
                d9 = d17 - d10;
                while (n10 <= 2) {
                    if (this.sw.swe_calc(d9, 0, n6, dArray4, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d9, 0, n5, dArray6, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d9, 1, n6, dArray5, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d9, 1, n5, dArray7, stringBuffer) == -1) {
                        return -1;
                    }
                    d8 = SMath.sqrt(this.sl.square_sum(dArray5));
                    d7 = SMath.sqrt(this.sl.square_sum(dArray4));
                    for (n9 = 0; n9 < 3; ++n9) {
                        dArray8[n9] = dArray4[n9] / d7;
                        dArray9[n9] = dArray5[n9] / d8;
                    }
                    dArray10[n10] = SMath.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                    ++n10;
                    d9 += d10;
                }
                this.find_maximum(dArray10[0], dArray10[1], dArray10[2], d10, dblObj3, dblObj4);
                d17 += dblObj3.val + d10;
            }
            if (this.sw.swe_calc(d17, 0, n6, dArray4, stringBuffer) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d17, 0, n5, dArray6, stringBuffer) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d17, 1, n6, dArray5, stringBuffer) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d17, 1, n5, dArray7, stringBuffer) == -1) {
                return -1;
            }
            dblObj4.val = SMath.acos(this.sl.swi_dot_prod_unit(dArray4, dArray5)) * 57.2957795130823;
            double d25 = SMath.asin(1.1618815109677577E-5 / dArray7[2]) * 57.2957795130823;
            double d26 = SMath.asin(0.004652472638342832 / dArray6[2]) * 57.2957795130823;
            double d27 = d26 + d25;
            double d28 = d26 - d25;
            if (dblObj4.val > d27) {
                if (n2 != 0) {
                    d6 -= 1.0;
                    continue;
                }
                d6 += 1.0;
                continue;
            }
            dArray2[0] = d17 - SweDate.getDeltaT(d17);
            dArray2[0] = d17 - SweDate.getDeltaT(dArray2[0]);
            if (n2 != 0 && dArray2[0] >= d - 1.0E-4 || n2 == 0 && dArray2[0] <= d + 1.0E-4) {
                if (n2 != 0) {
                    d6 -= 1.0;
                    continue;
                }
                d6 += 1.0;
                continue;
            }
            if (dblObj4.val < d28) {
                n4 = 8;
            } else if (dblObj4.val < SMath.abs(d28)) {
                n4 = 4;
            } else if (dblObj4.val <= d27) {
                n4 = 16;
            }
            double d29 = dblObj4.val;
            if (dblObj4.val > SMath.abs(d28)) {
                dArray2[3] = 0.0;
                dArray2[2] = 0.0;
            } else {
                dArray10[1] = SMath.abs(d28) - d29;
                d9 = d17 - d2;
                for (n10 = 0; n10 <= 2; n10 += 2) {
                    if (this.sw.swe_calc(d9, 0, n6, dArray4, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d9, 1, n6, dArray5, stringBuffer) == -1) {
                        return -1;
                    }
                    d8 = SMath.sqrt(this.sl.square_sum(dArray5));
                    d7 = SMath.sqrt(this.sl.square_sum(dArray4));
                    d25 = SMath.asin(1.1618815109677577E-5 / d8) * 57.2957795130823;
                    d26 = SMath.asin(0.004652472638342832 / d7) * 57.2957795130823;
                    d28 = d26 - (d25 *= 0.99916);
                    for (n9 = 0; n9 < 3; ++n9) {
                        dArray8[n9] = dArray4[n9] / d7;
                        dArray9[n9] = dArray5[n9] / d8;
                    }
                    dblObj4.val = SMath.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                    dArray10[n10] = SMath.abs(d28) - dblObj4.val;
                    d9 = d17 + d2;
                }
                this.find_zero(dArray10[0], dArray10[1], dArray10[2], d2, dblObj5, dblObj6);
                dArray2[2] = d17 + dblObj5.val + d2;
                dArray2[3] = d17 + dblObj6.val + d2;
                n8 = 0;
                d10 = d3;
                while (n8 < 2) {
                    n7 = 2;
                    while (n7 <= 3) {
                        if (this.sw.swe_calc(dArray2[n7], 0, n6 | 0x100, dArray4, stringBuffer) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(dArray2[n7], 1, n6 | 0x100, dArray5, stringBuffer) == -1) {
                            return -1;
                        }
                        for (n10 = 0; n10 < 2; ++n10) {
                            if (n10 == 1) {
                                for (n9 = 0; n9 < 3; ++n9) {
                                    int n11 = n9;
                                    dArray4[n11] = dArray4[n11] - dArray4[n9 + 3] * d10;
                                    int n12 = n9;
                                    dArray5[n12] = dArray5[n12] - dArray5[n9 + 3] * d10;
                                }
                            }
                            d8 = SMath.sqrt(this.sl.square_sum(dArray5));
                            d7 = SMath.sqrt(this.sl.square_sum(dArray4));
                            d25 = SMath.asin(1.1618815109677577E-5 / d8) * 57.2957795130823;
                            d26 = SMath.asin(0.004652472638342832 / d7) * 57.2957795130823;
                            d28 = d26 - (d25 *= 0.99916);
                            for (n9 = 0; n9 < 3; ++n9) {
                                dArray8[n9] = dArray4[n9] / d7;
                                dArray9[n9] = dArray5[n9] / d8;
                            }
                            dblObj4.val = SMath.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                            dArray10[n10] = SMath.abs(d28) - dblObj4.val;
                        }
                        dblObj5.val = -dArray10[0] / ((dArray10[0] - dArray10[1]) / d10);
                        int n13 = n7++;
                        dArray2[n13] = dArray2[n13] + dblObj5.val;
                    }
                    ++n8;
                    d10 /= 10.0;
                }
                dArray2[2] = dArray2[2] - SweDate.getDeltaT(dArray2[2]);
                dArray2[3] = dArray2[3] - SweDate.getDeltaT(dArray2[3]);
            }
            dArray10[1] = d27 - d29;
            d9 = d17 - d4;
            for (n10 = 0; n10 <= 2; n10 += 2) {
                if (this.sw.swe_calc(d9, 0, n6, dArray4, stringBuffer) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(d9, 1, n6, dArray5, stringBuffer) == -1) {
                    return -1;
                }
                d8 = SMath.sqrt(this.sl.square_sum(dArray5));
                d7 = SMath.sqrt(this.sl.square_sum(dArray4));
                d25 = SMath.asin(1.1618815109677577E-5 / d8) * 57.2957795130823;
                d26 = SMath.asin(0.004652472638342832 / d7) * 57.2957795130823;
                d27 = d26 + d25;
                for (n9 = 0; n9 < 3; ++n9) {
                    dArray8[n9] = dArray4[n9] / d7;
                    dArray9[n9] = dArray5[n9] / d8;
                }
                dblObj4.val = SMath.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                dArray10[n10] = d27 - dblObj4.val;
                d9 = d17 + d4;
            }
            this.find_zero(dArray10[0], dArray10[1], dArray10[2], d4, dblObj5, dblObj6);
            dArray2[1] = d17 + dblObj5.val + d4;
            dArray2[4] = d17 + dblObj6.val + d4;
            n8 = 0;
            d10 = d5;
            while (n8 < 3) {
                for (n7 = 1; n7 <= 4; n7 += 3) {
                    if (this.sw.swe_calc(dArray2[n7], 0, n6 | 0x100, dArray4, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(dArray2[n7], 1, n6 | 0x100, dArray5, stringBuffer) == -1) {
                        return -1;
                    }
                    for (n10 = 0; n10 < 2; ++n10) {
                        if (n10 == 1) {
                            for (n9 = 0; n9 < 3; ++n9) {
                                int n14 = n9;
                                dArray4[n14] = dArray4[n14] - dArray4[n9 + 3] * d10;
                                int n15 = n9;
                                dArray5[n15] = dArray5[n15] - dArray5[n9 + 3] * d10;
                            }
                        }
                        d8 = SMath.sqrt(this.sl.square_sum(dArray5));
                        d7 = SMath.sqrt(this.sl.square_sum(dArray4));
                        d25 = SMath.asin(1.1618815109677577E-5 / d8) * 57.2957795130823;
                        d26 = SMath.asin(0.004652472638342832 / d7) * 57.2957795130823;
                        d27 = d26 + d25;
                        for (n9 = 0; n9 < 3; ++n9) {
                            dArray8[n9] = dArray4[n9] / d7;
                            dArray9[n9] = dArray5[n9] / d8;
                        }
                        dblObj4.val = SMath.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                        dArray10[n10] = SMath.abs(d27) - dblObj4.val;
                    }
                    dblObj5.val = -dArray10[0] / ((dArray10[0] - dArray10[1]) / d10);
                    int n16 = n7;
                    dArray2[n16] = dArray2[n16] + dblObj5.val;
                }
                ++n8;
                d10 /= 10.0;
            }
            dArray2[1] = dArray2[1] - SweDate.getDeltaT(dArray2[1]);
            dArray2[4] = dArray2[4] - SweDate.getDeltaT(dArray2[4]);
            block25: for (n10 = 4; n10 >= 0; --n10) {
                if (dArray2[n10] == 0.0) continue;
                if (this.eclipse_how(dArray2[n10], 0, null, n, dArray[0], dArray[1], dArray[2], dArray3, stringBuffer) == -1) {
                    return -1;
                }
                if (!(dArray3[6] > 0.0)) continue;
                n4 |= 0x80;
                switch (n10) {
                    case 0: {
                        n4 |= 0x100;
                        continue block25;
                    }
                    case 1: {
                        n4 |= 0x200;
                        continue block25;
                    }
                    case 2: {
                        n4 |= 0x400;
                        continue block25;
                    }
                    case 3: {
                        n4 |= 0x800;
                        continue block25;
                    }
                    case 4: {
                        n4 |= 0x1000;
                        continue block25;
                    }
                }
            }
            if ((n4 & 0x80) == 0) {
                if (n2 != 0) {
                    d6 -= 1.0;
                    continue;
                }
                d6 += 1.0;
                continue;
            }
            if (this.swe_rise_trans(dArray2[1] - 0.001, 0, null, n5, 8193, dArray, 0.0, 0.0, dblObj, stringBuffer) == -1) {
                return -1;
            }
            if (this.swe_rise_trans(dArray2[1] - 0.001, 0, null, n5, 8194, dArray, 0.0, 0.0, dblObj2, stringBuffer) == -1) {
                return -1;
            }
            if (!(dblObj2.val < dArray2[1]) && (!(dblObj2.val > dblObj.val) || !(dblObj.val > dArray2[4]))) break;
            if (n2 != 0) {
                d6 -= 1.0;
                continue;
            }
            d6 += 1.0;
        }
        if (dblObj.val > dArray2[1] && dblObj.val < dArray2[4]) {
            dArray2[5] = dblObj.val;
            if ((n4 & 0x100) == 0) {
                dArray2[0] = dblObj.val;
                n3 = this.eclipse_how(dArray2[5], 0, null, n, dArray[0], dArray[1], dArray[2], dArray3, stringBuffer);
                if (n3 == -1) {
                    return -1;
                }
                n4 &= 0xFFFFFFE3;
                n4 |= n3 & 0x1C;
            }
        }
        if (dblObj2.val > dArray2[1] && dblObj2.val < dArray2[4]) {
            dArray2[6] = dblObj2.val;
            if ((n4 & 0x100) == 0) {
                dArray2[0] = dblObj2.val;
                n3 = this.eclipse_how(dArray2[6], 0, null, n, dArray[0], dArray[1], dArray[2], dArray3, stringBuffer);
                if (n3 == -1) {
                    return -1;
                }
                n4 &= 0xFFFFFFE3;
                n4 |= n3 & 0x1C;
            }
        }
        return n4;
    }

    private int occult_when_loc(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, double[] dArray2, double[] dArray3, int n3, StringBuffer stringBuffer2) {
        int n4;
        int n5 = 0;
        DblObj dblObj = new DblObj();
        DblObj dblObj2 = new DblObj();
        DblObj dblObj3 = new DblObj();
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        double[] dArray8 = new double[6];
        double[] dArray9 = new double[6];
        double[] dArray10 = new double[20];
        DblObj dblObj4 = new DblObj();
        double d2 = 0.0013888888888888887;
        double d3 = 1.1574074074074075E-4;
        double d4 = 0.08333333333333333;
        double d5 = 0.006944444444444445;
        DblObj dblObj5 = new DblObj(0.0);
        DblObj dblObj6 = new DblObj(0.0);
        double d6 = 1.0;
        int n6 = 0x8000 | n2;
        int n7 = n6 & 0xFFFF7FFF;
        int n8 = n6 | 0x1000;
        int n9 = 1;
        boolean bl = (n3 & 0x8000) != 0;
        boolean bl2 = false;
        n3 = (int)((long)n3 & 1L);
        n5 = 0;
        this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
        for (n4 = 0; n4 <= 9; ++n4) {
            dArray2[n4] = 0.0;
        }
        if (n3 != 0) {
            n9 = -1;
        }
        double d7 = d;
        double d8 = d;
        boolean bl3 = false;
        while (true) {
            int n10;
            int n11;
            int n12;
            double d9;
            double d10;
            double d11;
            double d12;
            double d13;
            double d14;
            bl3 = false;
            if (this.calc_planet_star(d7, n, stringBuffer, n7, dArray6, stringBuffer2) == -1) {
                return -1;
            }
            if (SMath.abs(dArray6[1]) > 7.0 && stringBuffer != null && stringBuffer.length() > 0) {
                if (stringBuffer2 != null) {
                    stringBuffer2.setLength(0);
                    stringBuffer2.append("occultation never occurs: star " + stringBuffer + " has ecl. lat. " + dArray6[1]);
                }
                return -1;
            }
            if (this.sw.swe_calc(d7, 1, n7, dArray7, stringBuffer2) == -1) {
                return -1;
            }
            double d15 = this.sl.swe_degnorm(dArray6[0] - dArray7[0]);
            if (n9 < 0) {
                d15 -= 360.0;
            }
            while (SMath.abs(d15) > 0.1) {
                if (this.calc_planet_star(d7 += d15 / 13.0, n, stringBuffer, n7, dArray6, stringBuffer2) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(d7, 1, n7, dArray7, stringBuffer2) == -1) {
                    return -1;
                }
                d15 = this.sl.swe_degnorm(dArray6[0] - dArray7[0]);
                if (!(d15 > 180.0)) continue;
                d15 -= 360.0;
            }
            d8 = d7;
            double d16 = SMath.abs(dArray6[1] - dArray7[1]);
            if (d16 > 2.0) {
                if (bl) {
                    dArray2[0] = d7 + (double)n9;
                    return 0;
                }
                d8 = d7 += (double)(n9 * 20);
                continue;
            }
            d16 = stringBuffer != null && stringBuffer.length() > 0 ? 0.0 : (n < 21 ? SwephData.pla_diam[n] / 2.0 / 1.4959787066E11 : (n > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
            double d17 = 3.0;
            for (d14 = d13 = d6; d14 > 1.0E-5; d14 /= d17) {
                if (d14 < 0.01) {
                    d17 = 2.0;
                }
                n4 = 0;
                d7 = d8 - d14;
                while (n4 <= 2) {
                    if (this.calc_planet_star(d7, n, stringBuffer, n8, dArray4, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.calc_planet_star(d7, n, stringBuffer, n6, dArray6, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d7, 1, n8, dArray5, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d7, 1, n6, dArray7, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (d14 < 0.1 && SMath.abs(dArray6[1] - dArray7[1]) > 2.0) {
                        if (bl || bl2) {
                            bl2 = true;
                        } else {
                            d8 = d7 = d8 + (double)(n9 * 20);
                            bl3 = true;
                            break;
                        }
                    }
                    dArray10[n4] = SMath.acos(this.sl.swi_dot_prod_unit(dArray4, dArray5)) * 57.2957795130823;
                    d12 = SMath.asin(1.1618815109677577E-5 / dArray7[2]) * 57.2957795130823;
                    d11 = SMath.asin(d16 / dArray6[2]) * 57.2957795130823;
                    int n13 = n4++;
                    dArray10[n13] = dArray10[n13] - (d12 + d11);
                    d7 += d14;
                }
                if (bl3) break;
                this.find_maximum(dArray10[0], dArray10[1], dArray10[2], d14, dblObj, dblObj4);
                d8 += dblObj.val + d14;
            }
            if (bl3) continue;
            if (bl2) {
                dArray2[0] = d8;
                return 0;
            }
            if (this.calc_planet_star(d8, n, stringBuffer, n8, dArray4, stringBuffer2) == -1) {
                return -1;
            }
            if (this.calc_planet_star(d8, n, stringBuffer, n6, dArray6, stringBuffer2) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d8, 1, n8, dArray5, stringBuffer2) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d8, 1, n6, dArray7, stringBuffer2) == -1) {
                return -1;
            }
            dblObj4.val = SMath.acos(this.sl.swi_dot_prod_unit(dArray4, dArray5)) * 57.2957795130823;
            d12 = SMath.asin(1.1618815109677577E-5 / dArray7[2]) * 57.2957795130823;
            d11 = SMath.asin(d16 / dArray6[2]) * 57.2957795130823;
            double d18 = d11 + d12;
            double d19 = d11 - d12;
            if (dblObj4.val > d18) {
                if (bl) {
                    dArray2[0] = d8;
                    return 0;
                }
                d8 = d7 = d8 + (double)(n9 * 20);
                continue;
            }
            dArray2[0] = d8 - SweDate.getDeltaT(d8);
            dArray2[0] = d8 - SweDate.getDeltaT(dArray2[0]);
            if (n3 != 0 && dArray2[0] >= d - 1.0E-4 || n3 == 0 && dArray2[0] <= d + 1.0E-4) {
                if (bl) {
                    dArray2[0] = d8;
                    return 0;
                }
                d8 = d7 = d8 + (double)(n9 * 20);
                continue;
            }
            if (dblObj4.val < d19) {
                n5 = 8;
            } else if (dblObj4.val < SMath.abs(d19)) {
                n5 = 4;
            } else if (dblObj4.val <= d18) {
                n5 = 16;
            }
            double d20 = dblObj4.val;
            if (dblObj4.val > SMath.abs(d19)) {
                dArray2[3] = 0.0;
                dArray2[2] = 0.0;
            } else {
                dArray10[1] = SMath.abs(d19) - d20;
                d7 = d8 - d2;
                for (n4 = 0; n4 <= 2; n4 += 2) {
                    if (this.calc_planet_star(d7, n, stringBuffer, n8, dArray4, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d7, 1, n8, dArray5, stringBuffer2) == -1) {
                        return -1;
                    }
                    d10 = SMath.sqrt(this.sl.square_sum(dArray5));
                    d9 = SMath.sqrt(this.sl.square_sum(dArray4));
                    d12 = SMath.asin(1.1618815109677577E-5 / d10) * 57.2957795130823;
                    d11 = SMath.asin(d16 / d9) * 57.2957795130823;
                    d19 = d11 - (d12 *= 0.99916);
                    for (n12 = 0; n12 < 3; ++n12) {
                        dArray8[n12] = dArray4[n12] / d9;
                        dArray9[n12] = dArray5[n12] / d10;
                    }
                    dblObj4.val = SMath.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                    dArray10[n4] = SMath.abs(d19) - dblObj4.val;
                    d7 = d8 + d2;
                }
                this.find_zero(dArray10[0], dArray10[1], dArray10[2], d2, dblObj5, dblObj6);
                dArray2[2] = d8 + dblObj5.val + d2;
                dArray2[3] = d8 + dblObj6.val + d2;
                n11 = 0;
                d14 = d3;
                while (n11 < 2) {
                    n10 = 2;
                    while (n10 <= 3) {
                        if (this.calc_planet_star(dArray2[n10], n, stringBuffer, n8 | 0x100, dArray4, stringBuffer2) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(dArray2[n10], 1, n8 | 0x100, dArray5, stringBuffer2) == -1) {
                            return -1;
                        }
                        for (n4 = 0; n4 < 2; ++n4) {
                            if (n4 == 1) {
                                for (n12 = 0; n12 < 3; ++n12) {
                                    int n14 = n12;
                                    dArray4[n14] = dArray4[n14] - dArray4[n12 + 3] * d14;
                                    int n15 = n12;
                                    dArray5[n15] = dArray5[n15] - dArray5[n12 + 3] * d14;
                                }
                            }
                            d10 = SMath.sqrt(this.sl.square_sum(dArray5));
                            d9 = SMath.sqrt(this.sl.square_sum(dArray4));
                            d12 = SMath.asin(1.1618815109677577E-5 / d10) * 57.2957795130823;
                            d11 = SMath.asin(d16 / d9) * 57.2957795130823;
                            d19 = d11 - (d12 *= 0.99916);
                            for (n12 = 0; n12 < 3; ++n12) {
                                dArray8[n12] = dArray4[n12] / d9;
                                dArray9[n12] = dArray5[n12] / d10;
                            }
                            dblObj4.val = SMath.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                            dArray10[n4] = SMath.abs(d19) - dblObj4.val;
                        }
                        dblObj5.val = -dArray10[0] / ((dArray10[0] - dArray10[1]) / d14);
                        int n16 = n10++;
                        dArray2[n16] = dArray2[n16] + dblObj5.val;
                    }
                    ++n11;
                    d14 /= 10.0;
                }
                dArray2[2] = dArray2[2] - SweDate.getDeltaT(dArray2[2]);
                dArray2[3] = dArray2[3] - SweDate.getDeltaT(dArray2[3]);
            }
            dArray10[1] = d18 - d20;
            d7 = d8 - d4;
            for (n4 = 0; n4 <= 2; n4 += 2) {
                if (this.calc_planet_star(d7, n, stringBuffer, n8, dArray4, stringBuffer2) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(d7, 1, n8, dArray5, stringBuffer2) == -1) {
                    return -1;
                }
                d10 = SMath.sqrt(this.sl.square_sum(dArray5));
                d9 = SMath.sqrt(this.sl.square_sum(dArray4));
                d12 = SMath.asin(1.1618815109677577E-5 / d10) * 57.2957795130823;
                d11 = SMath.asin(d16 / d9) * 57.2957795130823;
                d18 = d11 + d12;
                for (n12 = 0; n12 < 3; ++n12) {
                    dArray8[n12] = dArray4[n12] / d9;
                    dArray9[n12] = dArray5[n12] / d10;
                }
                dblObj4.val = SMath.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                dArray10[n4] = d18 - dblObj4.val;
                d7 = d8 + d4;
            }
            this.find_zero(dArray10[0], dArray10[1], dArray10[2], d4, dblObj5, dblObj6);
            dArray2[1] = d8 + dblObj5.val + d4;
            dArray2[4] = d8 + dblObj6.val + d4;
            n11 = 0;
            d14 = d5;
            while (n11 < 3) {
                for (n10 = 1; n10 <= 4; n10 += 3) {
                    if (this.calc_planet_star(dArray2[n10], n, stringBuffer, n8 | 0x100, dArray4, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(dArray2[n10], 1, n8 | 0x100, dArray5, stringBuffer2) == -1) {
                        return -1;
                    }
                    for (n4 = 0; n4 < 2; ++n4) {
                        if (n4 == 1) {
                            for (n12 = 0; n12 < 3; ++n12) {
                                int n17 = n12;
                                dArray4[n17] = dArray4[n17] - dArray4[n12 + 3] * d14;
                                int n18 = n12;
                                dArray5[n18] = dArray5[n18] - dArray5[n12 + 3] * d14;
                            }
                        }
                        d10 = SMath.sqrt(this.sl.square_sum(dArray5));
                        d9 = SMath.sqrt(this.sl.square_sum(dArray4));
                        d12 = SMath.asin(1.1618815109677577E-5 / d10) * 57.2957795130823;
                        d11 = SMath.asin(d16 / d9) * 57.2957795130823;
                        d18 = d11 + d12;
                        for (n12 = 0; n12 < 3; ++n12) {
                            dArray8[n12] = dArray4[n12] / d9;
                            dArray9[n12] = dArray5[n12] / d10;
                        }
                        dblObj4.val = SMath.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                        dArray10[n4] = SMath.abs(d18) - dblObj4.val;
                    }
                    dblObj5.val = -dArray10[0] / ((dArray10[0] - dArray10[1]) / d14);
                    int n19 = n10;
                    dArray2[n19] = dArray2[n19] + dblObj5.val;
                }
                ++n11;
                d14 /= 10.0;
            }
            dArray2[1] = dArray2[1] - SweDate.getDeltaT(dArray2[1]);
            dArray2[4] = dArray2[4] - SweDate.getDeltaT(dArray2[4]);
            block26: for (n4 = 4; n4 >= 0; --n4) {
                if (dArray2[n4] == 0.0) continue;
                if (this.eclipse_how(dArray2[n4], n, stringBuffer, n2, dArray[0], dArray[1], dArray[2], dArray3, stringBuffer2) == -1) {
                    return -1;
                }
                if (!(dArray3[6] > 0.0)) continue;
                n5 |= 0x80;
                switch (n4) {
                    case 0: {
                        n5 |= 0x100;
                        continue block26;
                    }
                    case 1: {
                        n5 |= 0x200;
                        continue block26;
                    }
                    case 2: {
                        n5 |= 0x400;
                        continue block26;
                    }
                    case 3: {
                        n5 |= 0x800;
                        continue block26;
                    }
                    case 4: {
                        n5 |= 0x1000;
                        continue block26;
                    }
                }
            }
            if ((n5 & 0x80) != 0) break;
            if (bl) {
                dArray2[0] = d8;
                return 0;
            }
            d8 = d7 = d8 + (double)(n9 * 20);
        }
        if (this.swe_rise_trans(dArray2[1] - 0.1, n, stringBuffer, n6, 8193, dArray, 0.0, 0.0, dblObj2, stringBuffer2) == -1) {
            return -1;
        }
        if (this.swe_rise_trans(dArray2[1] - 0.1, n, stringBuffer, n6, 8194, dArray, 0.0, 0.0, dblObj3, stringBuffer2) == -1) {
            return -1;
        }
        if (dblObj2.val > dArray2[1] && dblObj2.val < dArray2[4]) {
            dArray2[5] = dblObj2.val;
        }
        if (dblObj3.val > dArray2[1] && dblObj3.val < dArray2[4]) {
            dArray2[6] = dblObj3.val;
        }
        if (this.swe_rise_trans(dArray2[2], 0, null, n6, 1, dArray, 0.0, 0.0, dblObj2, stringBuffer2) == -1) {
            return -1;
        }
        if (this.swe_rise_trans(dArray2[2], 0, null, n6, 2, dArray, 0.0, 0.0, dblObj3, stringBuffer2) == -1) {
            return -1;
        }
        if (dblObj3.val < dblObj2.val) {
            n5 |= 0x2000;
        }
        if (this.swe_rise_trans(dArray2[3], 0, null, n6, 1, dArray, 0.0, 0.0, dblObj2, stringBuffer2) == -1) {
            return -1;
        }
        if (this.swe_rise_trans(dArray2[3], 0, null, n6, 2, dArray, 0.0, 0.0, dblObj3, stringBuffer2) == -1) {
            return -1;
        }
        if (dblObj3.val < dblObj2.val) {
            n5 |= 0x4000;
        }
        return n5;
    }

    void swe_azalt(double d, int n, double[] dArray, double d2, double d3, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[3];
        double d4 = this.sl.swe_degnorm(this.sl.swe_sidtime(d) * 15.0 + dArray[0]);
        for (int i = 0; i < 2; ++i) {
            dArray5[i] = dArray2[i];
        }
        dArray5[2] = 1.0;
        if (n == 0) {
            double d5 = d + SweDate.getDeltaT(d);
            this.sw.swe_calc(d5, -1, 0, dArray4, null);
            double d6 = dArray4[0];
            this.sl.swe_cotrans(dArray5, 0, dArray5, 0, -d6);
        }
        double d7 = this.sl.swe_degnorm(dArray5[0] - d4);
        dArray4[0] = this.sl.swe_degnorm(d7 - 90.0);
        dArray4[1] = dArray5[1];
        dArray4[2] = 1.0;
        this.sl.swe_cotrans(dArray4, 0, dArray4, 0, 90.0 - dArray[1]);
        dArray4[0] = this.sl.swe_degnorm(dArray4[0] + 90.0);
        dArray3[0] = 360.0 - dArray4[0];
        dArray3[1] = dArray4[1];
        if (d2 == 0.0) {
            d2 = 1013.25 * SMath.pow(1.0 - 0.0065 * dArray[2] / 288.0, 5.255);
        }
        dArray3[2] = this.swe_refrac_extended(dArray4[1], dArray[2], d2, d3, this.const_lapse_rate, 0, null);
    }

    void swe_azalt_rev(double d, int n, double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[3];
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = this.sl.swe_degnorm(this.sl.swe_sidtime(d) * 15.0 + d2);
        for (int i = 0; i < 2; ++i) {
            dArray5[i] = dArray2[i];
        }
        dArray5[2] = 1.0;
        dArray5[0] = 360.0 - dArray5[0];
        dArray5[0] = this.sl.swe_degnorm(dArray5[0] - 90.0);
        double d5 = d3 - 90.0;
        this.sl.swe_cotrans(dArray5, 0, dArray5, 0, d5);
        dArray5[0] = this.sl.swe_degnorm(dArray5[0] + d4 + 90.0);
        dArray3[0] = dArray5[0];
        dArray3[1] = dArray5[1];
        if (n == 0) {
            double d6 = d + SweDate.getDeltaT(d);
            this.sw.swe_calc(d6, -1, 0, dArray4, null);
            double d7 = dArray4[0];
            this.sl.swe_cotrans(dArray5, 0, dArray4, 0, d7);
            dArray3[0] = dArray4[0];
            dArray3[1] = dArray4[1];
        }
    }

    double swe_refrac(double d, double d2, double d3, int n) {
        double d4;
        double d5 = d2 / 1010.0 * 283.0 / (273.0 + d3);
        if (n == 0) {
            double d6;
            double d7 = d;
            if (d7 > 15.0) {
                double d8 = SMath.tan((90.0 - d7) * 0.0174532925199433);
                d6 = 58.276 * d8 - 0.0824 * d8 * d8 * d8;
                d6 *= d5 / 3600.0;
            } else if (d7 > -5.0) {
                double d9 = d7 + 10.3 / (d7 + 5.11);
                d6 = d9 + 1.0E-10 >= 90.0 ? 0.0 : 1.02 / SMath.tan(d9 * 0.0174532925199433);
                d6 *= d5 / 60.0;
            } else {
                d6 = 0.0;
            }
            double d10 = d7;
            if (d10 + d6 > 0.0) {
                d10 += d6;
            }
            return d10;
        }
        double d11 = d;
        double d12 = d11 + 7.31 / (d11 + 4.4);
        if (d12 + 1.0E-10 >= 90.0) {
            d4 = 0.0;
        } else {
            d4 = 1.0 / SMath.tan(d12 * 0.0174532925199433);
            d4 -= 0.06 * SMath.sin(14.7 * d4 + 13.0);
        }
        d4 *= d5 / 60.0;
        double d13 = d11;
        if (d11 - d4 > 0.0) {
            d13 = d11 - d4;
        }
        return d13;
    }

    void swe_set_lapse_rate(double d) {
        this.const_lapse_rate = d;
    }

    double swe_refrac_extended(double d, double d2, double d3, double d4, double d5, int n, double[] dArray) {
        double d6 = this.calc_dip(d2, d3, d4, d5);
        if (d > 90.0) {
            d = 180.0 - d;
        }
        if (n == 0) {
            if (d < -10.0) {
                if (dArray != null && dArray.length > 3) {
                    dArray[0] = d;
                    dArray[1] = d;
                    dArray[2] = 0.0;
                    dArray[3] = d6;
                }
                return d;
            }
            double d7 = d;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = d8;
            for (int i = 0; i < 5; ++i) {
                d8 = this.calc_astronomical_refr(d7, d3, d4);
                double d11 = d7 - d9;
                d9 = d8 - d10 - d11;
                d11 = d11 != 0.0 && d9 != 0.0 ? d7 - d11 * (d + d8 - d7) / d9 : d + d8;
                d9 = d7;
                d10 = d8;
                d7 = d11;
            }
            double d12 = d8;
            if (d + d12 < d6) {
                if (dArray != null) {
                    dArray[0] = d;
                    dArray[1] = d;
                    dArray[2] = 0.0;
                    dArray[3] = d6;
                }
                return d;
            }
            if (dArray != null) {
                dArray[0] = d;
                dArray[1] = d + d12;
                dArray[2] = d12;
                dArray[3] = d6;
            }
            return d + d12;
        }
        double d13 = this.calc_astronomical_refr(d, d3, d4);
        double d14 = d - d13;
        if (dArray != null) {
            if (d > d6) {
                dArray[0] = d14;
                dArray[1] = d;
                dArray[2] = d13;
                dArray[3] = d6;
            } else {
                dArray[0] = d;
                dArray[1] = d;
                dArray[2] = 0.0;
                dArray[3] = d6;
            }
        }
        if (d14 > d6) {
            return d14;
        }
        return d;
    }

    private double calc_astronomical_refr(double d, double d2, double d3) {
        double d4 = d > 17.904104638432 ? 0.97 / SMath.tan(d * 0.0174532925199433) : (34.46 + 4.23 * d + 0.004 * d * d) / (1.0 + 0.505 * d + 0.0845 * d * d);
        d4 = (d2 - 80.0) / 930.0 / (1.0 + 8.0E-5 * (d4 + 39.0) * (d3 - 10.0)) * d4 / 60.0;
        return d4;
    }

    private double calc_dip(double d, double d2, double d3, double d4) {
        double d5 = (0.0342 + d4) / 0.0036652000000000004;
        double d6 = 1.0 - 1.848 * d5 * d2 / (273.16 + d3) / (273.16 + d3);
        return -57.29577951308232 * SMath.acos(1.0 / (1.0 + d / 6378136.6)) * SMath.sqrt(d6);
    }

    int swe_lun_eclipse_how(double d, int n, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        double[] dArray3 = new double[10];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        if (dArray != null && (dArray[2] < -500.0 || dArray[2] > 25000.0)) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("location for eclipses must be between -500 and 25000 m above sea");
            }
            return -1;
        }
        n &= 0xFFFF7FFF;
        SweDate.swi_set_tid_acc(d, n &= 0xFFF3FFFF, 0);
        int n2 = this.lun_eclipse_how(d, n, dArray2, dArray3, stringBuffer);
        if (dArray == null) {
            return n2;
        }
        this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
        if (this.sw.swe_calc_ut(d, 1, n | 0x8000 | 0x800, dArray4, stringBuffer) == -1) {
            return -1;
        }
        this.swe_azalt(d, 1, dArray, 0.0, 10.0, dArray4, dArray5);
        dArray2[4] = dArray5[0];
        dArray2[5] = dArray5[1];
        dArray2[6] = dArray5[2];
        if (dArray5[2] <= 0.0) {
            n2 = 0;
        }
        return n2;
    }

    private int lun_eclipse_how(double d, int n, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        int n2;
        int n3 = 0;
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        double d2 = 1.1618815109677577E-5;
        double d3 = 2.0 * d2;
        for (n2 = 0; n2 < 10; ++n2) {
            dArray2[n2] = 0.0;
        }
        for (n2 = 0; n2 < 20; ++n2) {
            dArray[n2] = 0.0;
        }
        int n4 = 0x900 | n;
        double d4 = SweDate.getDeltaT(d);
        double d5 = d + d4;
        if (this.sw.swe_calc(d5, 1, n4 |= 0x1000, dArray4, stringBuffer) == -1) {
            return -1;
        }
        double d6 = SMath.sqrt(this.sl.square_sum(dArray4));
        if (this.sw.swe_calc(d5, 0, n4, dArray5, stringBuffer) == -1) {
            return -1;
        }
        double d7 = SMath.sqrt(this.sl.square_sum(dArray5));
        for (n2 = 0; n2 < 3; ++n2) {
            dArray6[n2] = dArray5[n2] / d7;
            dArray7[n2] = dArray4[n2] / d6;
        }
        double d8 = SMath.acos(this.sl.swi_dot_prod_unit(dArray6, dArray7)) * 57.2957795130823;
        for (n2 = 0; n2 <= 2; ++n2) {
            int n5 = n2;
            dArray5[n5] = dArray5[n5] - dArray4[n2];
        }
        for (n2 = 0; n2 <= 2; ++n2) {
            dArray4[n2] = -dArray4[n2];
        }
        for (n2 = 0; n2 <= 2; ++n2) {
            dArray3[n2] = dArray4[n2] - dArray5[n2];
        }
        double d9 = SMath.sqrt(this.sl.square_sum(dArray3));
        n2 = 0;
        while (n2 <= 2) {
            int n6 = n2++;
            dArray3[n6] = dArray3[n6] / d9;
        }
        double d10 = 0.004609837405823407 / d9;
        double d11 = SMath.sqrt(1.0 - d10 * d10);
        double d12 = 0.004695107870862257 / d9;
        double d13 = SMath.sqrt(1.0 - d12 * d12);
        double d14 = -this.sw.dot_prod(dArray4, dArray3);
        double d15 = SMath.sqrt(d6 * d6 - d14 * d14);
        double d16 = SMath.abs(d14 / d9 * 0.009219674811646815 - 8.527046503885043E-5) * 1.02 / d11;
        double d17 = (d14 / d9 * 0.009390215741724514 + 8.527046503885043E-5) * 1.02 / d13;
        d16 /= d11;
        d17 /= d13;
        dArray2[0] = d15;
        dArray2[1] = d16 *= 0.99405;
        dArray2[2] = d17 *= 0.98813;
        dArray2[3] = d11;
        dArray2[4] = d13;
        n3 = 0;
        if (d16 / 2.0 >= d15 + d2 / d11) {
            n3 = 4;
            dArray[0] = (d16 / 2.0 - d15 + d2) / d3;
        } else if (d16 / 2.0 >= d15 - d2 / d11) {
            n3 = 16;
            dArray[0] = (d16 / 2.0 - d15 + d2) / d3;
        } else if (d17 / 2.0 >= d15 - d2 / d13) {
            n3 = 64;
            dArray[0] = 0.0;
        } else if (stringBuffer != null) {
            stringBuffer.setLength(0);
            stringBuffer.append("no lunar eclipse at tjd = " + d5);
        }
        dArray[8] = dArray[0];
        dArray[1] = (d17 / 2.0 - d15 + d2) / d3;
        if (n3 != 0) {
            dArray[7] = 180.0 - SMath.abs(d8);
        }
        for (n2 = 0; n2 < NSAROS_LUNAR; ++n2) {
            double d18 = (d - Swecl.saros_data_lunar[n2].tstart) / 6585.3213;
            if (d18 < 0.0) continue;
            int n7 = (int)d18;
            if ((d18 - (double)n7) * 6585.3213 < 2.0) {
                dArray[9] = Swecl.saros_data_lunar[n2].series_no;
                dArray[10] = (double)n7 + 1.0;
                break;
            }
            int n8 = n7 + 1;
            if (!(((double)n8 - d18) * 6585.3213 < 2.0)) continue;
            dArray[9] = Swecl.saros_data_lunar[n2].series_no;
            dArray[10] = (double)n8 + 1.0;
            break;
        }
        if (n2 == NSAROS_LUNAR) {
            dArray[10] = -9.9999999E7;
            dArray[9] = -9.9999999E7;
        }
        return n3;
    }

    int swe_lun_eclipse_when(double d, int n, int n2, double[] dArray, int n3, StringBuffer stringBuffer) {
        int n4;
        double d2;
        double d3;
        int n5;
        double d4;
        int n6;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        DblObj dblObj = new DblObj();
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[10];
        double[] dArray5 = new double[3];
        DblObj dblObj2 = new DblObj();
        double d5 = 0.08333333333333333;
        double d6 = 0.006944444444444445;
        DblObj dblObj3 = new DblObj(0.0);
        DblObj dblObj4 = new DblObj(0.0);
        double[] dArray6 = new double[20];
        double[] dArray7 = new double[6];
        double[] dArray8 = new double[6];
        int n11 = 1;
        SweDate.swi_set_tid_acc(d, n &= 7, 0);
        int n12 = 0x800 | n;
        int n13 = n12 | 0x1000;
        if (n2 == 0) {
            n2 = 84;
        }
        if (n3 != 0) {
            n11 = -1;
        }
        double d7 = (int)((d - 2451545.0) / 365.2425 * 12.3685);
        d7 -= (double)n11;
        while (true) {
            n9 = 0;
            for (n6 = 0; n6 <= 9; ++n6) {
                dArray[n6] = 0.0;
            }
            double d8 = d7 + 0.5;
            double d9 = d8 / 1236.85;
            double d10 = d9 * d9;
            double d11 = d10 * d9;
            double d12 = d11 * d9;
            double d13 = this.sl.swe_degnorm(160.7108 + 390.67050274 * d8 - 0.0016341 * d10 - 2.27E-6 * d11 + 1.1E-8 * d12);
            double d14 = d13;
            if (d14 > 180.0) {
                d14 -= 180.0;
            }
            if (d14 > 21.0 && d14 < 159.0) {
                d7 += (double)n11;
                continue;
            }
            d4 = 2451550.09765 + 29.530588853 * d8 + 1.337E-4 * d10 - 1.5E-7 * d11 + 7.3E-10 * d12;
            double d15 = this.sl.swe_degnorm(2.5534 + 29.10535669 * d8 - 2.18E-5 * d10 - 1.1E-7 * d11);
            double d16 = this.sl.swe_degnorm(201.5643 + 385.81693528 * d8 + 0.1017438 * d10 + 1.239E-5 * d11 + 5.8E-8 * d12);
            double d17 = this.sl.swe_degnorm(124.7746 - 1.5637558 * d8 + 0.0020691 * d10 + 2.15E-6 * d11);
            double d18 = 1.0 - 0.002516 * d9 - 7.4E-6 * d10;
            double d19 = this.sl.swe_degnorm(299.77 + 0.107408 * d8 - 0.009173 * d10);
            double d20 = (d13 *= 0.0174532925199433) - 0.02665 * SMath.sin(d17 *= 0.0174532925199433) * 0.0174532925199433;
            d4 = d4 - 0.4075 * SMath.sin(d16 *= 0.0174532925199433) + 0.1721 * d18 * SMath.sin(d15 *= 0.0174532925199433) + 0.0161 * SMath.sin(2.0 * d16) - 0.0097 * SMath.sin(2.0 * d20) + 0.0073 * d18 * SMath.sin(d16 - d15) - 0.005 * d18 * SMath.sin(d16 + d15) - 0.0023 * SMath.sin(d16 - 2.0 * d20) + 0.0021 * d18 * SMath.sin(2.0 * d15) + 0.0012 * SMath.sin(d16 + 2.0 * d20) + 6.0E-4 * d18 * SMath.sin(2.0 * d16 + d15) - 4.0E-4 * SMath.sin(3.0 * d16) - 3.0E-4 * d18 * SMath.sin(d15 + 2.0 * d20) + 3.0E-4 * SMath.sin(d19 *= 0.0174532925199433) - 2.0E-4 * d18 * SMath.sin(d15 - 2.0 * d20) - 2.0E-4 * d18 * SMath.sin(2.0 * d16 - d15) - 2.0E-4 * SMath.sin(d17);
            double d21 = 0.1;
            if (d4 < 2000000.0 || d4 > 2500000.0) {
                d21 = 5.0;
            }
            double d22 = 4.0;
            n5 = 0;
            for (d3 = d21; d3 > 0.001; d3 /= d22) {
                n6 = 0;
                d2 = d4 - d3;
                while (n6 <= 2) {
                    if (this.sw.swe_calc(d2, 0, n13, dArray2, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d2, 1, n13, dArray3, stringBuffer) == -1) {
                        return -1;
                    }
                    for (n4 = 0; n4 < 3; ++n4) {
                        int n14 = n4;
                        dArray2[n14] = dArray2[n14] - dArray3[n4];
                        dArray3[n4] = -dArray3[n4];
                    }
                    double d23 = SMath.sqrt(this.sl.square_sum(dArray2));
                    double d24 = SMath.sqrt(this.sl.square_sum(dArray3));
                    for (n4 = 0; n4 < 3; ++n4) {
                        dArray7[n4] = dArray2[n4] / d23;
                        dArray8[n4] = dArray3[n4] / d24;
                    }
                    dArray5[n6] = SMath.acos(this.sl.swi_dot_prod_unit(dArray7, dArray8)) * 57.2957795130823;
                    double d25 = SMath.asin(4.263523251942522E-5 / d24) * 57.2957795130823;
                    double d26 = SMath.asin(0.004652472638342832 / d23) * 57.2957795130823;
                    int n15 = n6++;
                    dArray5[n15] = dArray5[n15] - (d25 + d26);
                    d2 += d3;
                }
                this.find_maximum(dArray5[0], dArray5[1], dArray5[2], d3, dblObj, dblObj2);
                d4 += dblObj.val + d3;
                ++n5;
            }
            double d27 = d4 - SweDate.getDeltaT(d4);
            if ((n9 = this.swe_lun_eclipse_how(d4 -= SweDate.getDeltaT(d27 = d4 - SweDate.getDeltaT(d27)), n, null, dArray6, stringBuffer)) == -1) {
                return n9;
            }
            if (n9 == 0) {
                d7 += (double)n11;
                continue;
            }
            dArray[0] = d4;
            if (n3 != 0 && dArray[0] >= d - 1.0E-4 || n3 == 0 && dArray[0] <= d + 1.0E-4) {
                d7 += (double)n11;
                continue;
            }
            if ((n2 & 0x40) == 0 && (n9 & 0x40) != 0) {
                d7 += (double)n11;
                continue;
            }
            if ((n2 & 0x10) == 0 && (n9 & 0x10) != 0) {
                d7 += (double)n11;
                continue;
            }
            if ((n2 & 4) != 0 || (n9 & 4) == 0) break;
            d7 += (double)n11;
        }
        int n16 = (n9 & 0x40) != 0 ? 0 : ((n9 & 0x10) != 0 ? 1 : 2);
        double d28 = d5;
        double d29 = d6;
        for (int i = 0; i <= n16; ++i) {
            if (i == 0) {
                n7 = 6;
                n8 = 7;
            } else if (i == 1) {
                n7 = 2;
                n8 = 3;
            } else if (i == 2) {
                n7 = 4;
                n8 = 5;
            }
            n6 = 0;
            d2 = d4 - d28;
            while (n6 <= 2) {
                n10 = this.lun_eclipse_how(d2, n, dArray6, dArray4, stringBuffer);
                if (n10 == -1) {
                    return n10;
                }
                if (i == 0) {
                    dArray5[n6] = dArray4[2] / 2.0 + 1.1618815109677577E-5 / dArray4[4] - dArray4[0];
                } else if (i == 1) {
                    dArray5[n6] = dArray4[1] / 2.0 + 1.1618815109677577E-5 / dArray4[3] - dArray4[0];
                } else if (i == 2) {
                    dArray5[n6] = dArray4[1] / 2.0 - 1.1618815109677577E-5 / dArray4[3] - dArray4[0];
                }
                ++n6;
                d2 += d28;
            }
            this.find_zero(dArray5[0], dArray5[1], dArray5[2], d28, dblObj3, dblObj4);
            d29 = (dblObj3.val + d28) / 2.0;
            dArray[n7] = d4 + dblObj3.val + d28;
            dArray[n8] = d4 + dblObj4.val + d28;
            n4 = 0;
            d3 = d29 / 2.0;
            while (n4 < 3) {
                for (n5 = n7; n5 <= n8; n5 += n8 - n7) {
                    n6 = 0;
                    d2 = dArray[n5] - d3;
                    while (n6 < 2) {
                        n10 = this.lun_eclipse_how(d2, n, dArray6, dArray4, stringBuffer);
                        if (n10 == -1) {
                            return n10;
                        }
                        if (i == 0) {
                            dArray5[n6] = dArray4[2] / 2.0 + 1.1618815109677577E-5 / dArray4[4] - dArray4[0];
                        } else if (i == 1) {
                            dArray5[n6] = dArray4[1] / 2.0 + 1.1618815109677577E-5 / dArray4[3] - dArray4[0];
                        } else if (i == 2) {
                            dArray5[n6] = dArray4[1] / 2.0 - 1.1618815109677577E-5 / dArray4[3] - dArray4[0];
                        }
                        ++n6;
                        d2 += d3;
                    }
                    dblObj3.val = dArray5[1] / ((dArray5[1] - dArray5[0]) / d3);
                    int n17 = n5;
                    dArray[n17] = dArray[n17] - dblObj3.val;
                }
                ++n4;
                d3 /= 2.0;
            }
        }
        return n9;
    }

    int swe_lun_eclipse_when_loc(double d, int n, double[] dArray, double[] dArray2, double[] dArray3, int n2, StringBuffer stringBuffer) {
        int n3 = 0;
        int n4 = 0;
        DblObj dblObj = new DblObj();
        DblObj dblObj2 = new DblObj();
        double d2 = 0.0;
        if (dArray != null && (dArray[2] < -500.0 || dArray[2] > 25000.0)) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("location for eclipses must be between -500 and 25000 m above sea");
            }
            return -1;
        }
        n &= 0xFFF3FFFF;
        while (true) {
            int n5;
            if ((n3 = this.swe_lun_eclipse_when(d, n, 0, dArray2, n2, stringBuffer)) == -1) {
                return -1;
            }
            n3 = 0;
            block10: for (n5 = 7; n5 >= 0; --n5) {
                if (n5 == 1 || dArray2[n5] == 0.0) continue;
                n4 = this.swe_lun_eclipse_how(dArray2[n5], n, dArray, dArray3, stringBuffer);
                if (n4 == -1) {
                    return -1;
                }
                if (!(dArray3[6] > 0.0)) continue;
                n3 |= 0x80;
                switch (n5) {
                    case 0: {
                        n3 |= 0x100;
                        continue block10;
                    }
                    case 2: {
                        n3 |= 0x200;
                        continue block10;
                    }
                    case 3: {
                        n3 |= 0x1000;
                        continue block10;
                    }
                    case 4: {
                        n3 |= 0x400;
                        continue block10;
                    }
                    case 5: {
                        n3 |= 0x800;
                        continue block10;
                    }
                    case 6: {
                        n3 |= 0x2000;
                        continue block10;
                    }
                    case 7: {
                        n3 |= 0x4000;
                        continue block10;
                    }
                }
            }
            if ((n3 & 0x80) == 0) {
                if (n2 != 0) {
                    d = dArray2[0] - 25.0;
                    continue;
                }
                d = dArray2[0] + 25.0;
                continue;
            }
            if (this.swe_rise_trans(dArray2[6] - 0.001, 1, null, n, 8193, dArray, 0.0, 0.0, dblObj, stringBuffer) == -1) {
                return -1;
            }
            if (this.swe_rise_trans(dArray2[6] - 0.001, 1, null, n, 8194, dArray, 0.0, 0.0, dblObj2, stringBuffer) == -1) {
                return -1;
            }
            if (dblObj2.val < dArray2[6] || dblObj2.val > dblObj.val && dblObj.val > dArray2[7]) {
                if (n2 != 0) {
                    d = dArray2[0] - 25.0;
                    continue;
                }
                d = dArray2[0] + 25.0;
                continue;
            }
            d2 = dArray2[0];
            if (dblObj.val > dArray2[6] && dblObj.val < dArray2[7]) {
                dArray2[6] = 0.0;
                for (n5 = 2; n5 <= 5; ++n5) {
                    if (!(dblObj.val > dArray2[n5])) continue;
                    dArray2[n5] = 0.0;
                }
                dArray2[8] = dblObj.val;
                if (dblObj.val > dArray2[0]) {
                    d2 = dblObj.val;
                }
            }
            if (dblObj2.val > dArray2[6] && dblObj2.val < dArray2[7]) {
                dArray2[7] = 0.0;
                for (n5 = 2; n5 <= 5; ++n5) {
                    if (!(dblObj2.val < dArray2[n5])) continue;
                    dArray2[n5] = 0.0;
                }
                dArray2[9] = dblObj2.val;
                if (dblObj2.val < dArray2[0]) {
                    d2 = dblObj2.val;
                }
            }
            dArray2[0] = d2;
            n4 = this.swe_lun_eclipse_how(d2, n, dArray, dArray3, stringBuffer);
            if (n4 == -1) {
                return -1;
            }
            if (n4 != 0) break;
            if (n2 != 0) {
                d = dArray2[0] - 25.0;
                continue;
            }
            d = dArray2[0] + 25.0;
        }
        return n3 |= n4 & 0x54;
    }

    int swe_pheno(double d, int n, int n2, double[] dArray, StringBuffer stringBuffer) {
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double d2 = 0.0;
        double[] dArray7 = new double[2];
        n2 &= 0xFFF3FFFF;
        if (n == 144340) {
            n = 9;
        }
        for (int i = 0; i < 20; ++i) {
            dArray[i] = 0.0;
        }
        if (n > 10000 && n <= 10004) {
            n = n - 10000 - 1 + 17;
        }
        int n3 = (n2 &= 0x8677) & 0x477;
        n3 |= 8;
        int n4 = n2 & 7;
        if (this.sw.swe_calc(d, n, n2 | 0x1000, dArray2, stringBuffer) == -1) {
            return -1;
        }
        if (this.sw.swe_calc(d, n, n2, dArray5, stringBuffer) == -1) {
            return -1;
        }
        if (n == 1 && this.sw.swe_calc(d, 0, n2 | 0x1000, dArray4, stringBuffer) == -1) {
            return -1;
        }
        if (n != 0 && n != 14 && n != 10 && n != 11 && n != 12 && n != 13) {
            d2 = dArray5[2] * 1.4959787066E11 / 2.99792458E8 / 86400.0;
            if ((n2 & 0x10) != 0) {
                d2 = 0.0;
            }
            if (this.sw.swe_calc(d - d2, n, n3 | 0x1000, dArray3, stringBuffer) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d - d2, n, n3, dArray6, stringBuffer) == -1) {
                return -1;
            }
            dArray[0] = SMath.acos(this.sl.swi_dot_prod_unit(dArray2, dArray3)) * 57.2957795130823;
            dArray[1] = (1.0 + SMath.cos(dArray[0] * 0.0174532925199433)) / 2.0;
        }
        double d3 = n < 21 ? SwephData.pla_diam[n] : (n > 10000 ? this.swed.ast_diam * 1000.0 : 0.0);
        dArray[3] = dArray5[2] < d3 / 2.0 / 1.4959787066E11 ? 180.0 : SMath.asin(d3 / 2.0 / 1.4959787066E11 / dArray5[2]) * 2.0 * 57.2957795130823;
        if (n > 10000 || n < 21 && mag_elem[n][0] < 99.0) {
            if (n == 0) {
                double d4 = dArray[3] / (SMath.asin(SwephData.pla_diam[0] / 2.0 / 1.4959787066E11) * 2.0 * 57.2957795130823);
                d4 *= d4;
                dArray[4] = mag_elem[n][0] - 2.5 * this.log10(d4);
            } else if (n == 1) {
                dArray[4] = -21.62 + 5.0 * this.log10(dArray5[2] * 1.49597870691E11 / 6378136.6) / this.log10(10.0) + 0.026 * SMath.abs(dArray[0]) + 4.0E-9 * SMath.pow(dArray[0], 4.0);
            } else if (n == 6) {
                double d5;
                double d6 = (d - d2 - 2451545.0) / 36525.0;
                double d7 = (28.075216 - 0.012998 * d6 + 4.0E-6 * d6 * d6) * 0.0174532925199433;
                double d8 = (169.50847 + 1.394681 * d6 + 4.12E-4 * d6 * d6) * 0.0174532925199433;
                double d9 = SMath.abs(SMath.sin(d7) * SMath.cos(dArray5[1] * 0.0174532925199433) * SMath.sin(dArray5[0] * 0.0174532925199433 - d8) - SMath.cos(d7) * SMath.sin(dArray5[1] * 0.0174532925199433));
                double d10 = SMath.atan2(SMath.sin(d7) * SMath.tan(dArray6[1] * 0.0174532925199433) + SMath.cos(d7) * SMath.sin(dArray6[0] * 0.0174532925199433 - d8), SMath.cos(dArray6[0] * 0.0174532925199433 - d8)) * 57.2957795130823;
                double d11 = this.sl.swe_degnorm(d10 - (d5 = SMath.atan2(SMath.sin(d7) * SMath.tan(dArray5[1] * 0.0174532925199433) + SMath.cos(d7) * SMath.sin(dArray5[0] * 0.0174532925199433 - d8), SMath.cos(dArray5[0] * 0.0174532925199433 - d8)) * 57.2957795130823));
                if (d11 > 10.0) {
                    d11 = 360.0 - d11;
                }
                dArray[4] = 5.0 * this.log10(dArray6[2] * dArray5[2]) + mag_elem[n][1] * d9 + mag_elem[n][2] * d9 * d9 + mag_elem[n][3] * d11 + mag_elem[n][0];
            } else if (n < 15) {
                dArray[4] = 5.0 * this.log10(dArray6[2] * dArray5[2]) + mag_elem[n][1] * dArray[0] / 100.0 + mag_elem[n][2] * dArray[0] * dArray[0] / 10000.0 + mag_elem[n][3] * dArray[0] * dArray[0] * dArray[0] / 1000000.0 + mag_elem[n][0];
            } else if (n < 21 || n > 10000) {
                double d12 = SMath.pow(2.718281828459, -3.33 * SMath.pow(SMath.tan(dArray[0] * 0.0174532925199433 / 2.0), 0.63));
                double d13 = SMath.pow(2.718281828459, -1.87 * SMath.pow(SMath.tan(dArray[0] * 0.0174532925199433 / 2.0), 1.22));
                if (n < 21) {
                    dArray7[0] = mag_elem[n][0];
                    dArray7[1] = mag_elem[n][1];
                } else if (n == 11566) {
                    dArray7[0] = 16.9;
                    dArray7[1] = 0.15;
                } else {
                    dArray7[0] = this.swed.ast_H;
                    dArray7[1] = this.swed.ast_G;
                }
                dArray[4] = 5.0 * this.log10(dArray6[2] * dArray5[2]) + dArray7[0] - 2.5 * this.log10((1.0 - dArray7[1]) * d12 + dArray7[1] * d13);
            } else {
                dArray[4] = 0.0;
            }
        }
        if (n != 0 && n != 14) {
            if (this.sw.swe_calc(d, 0, n2 | 0x1000, dArray3, stringBuffer) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d, 0, n2, dArray6, stringBuffer) == -1) {
                return -1;
            }
            dArray[2] = SMath.acos(this.sl.swi_dot_prod_unit(dArray2, dArray3)) * 57.2957795130823;
        }
        if (n == 1) {
            double[] dArray8 = new double[6];
            if (this.sw.swe_calc(d, n, n4 | 0x10 | 0x800 | 0x2000, dArray8, stringBuffer) == -1) {
                return -1;
            }
            double d14 = 6378136.6 / dArray8[2] / 1.49597870691E11;
            dArray[5] = SMath.asin(d14) / 0.0174532925199433;
            if ((n2 & 0x8000) != 0) {
                if (this.sw.swe_calc(d, n, n4 | 0x1000 | 0x8000, dArray8, stringBuffer) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(d, n, n4 | 0x1000, dArray2, stringBuffer) == -1) {
                    return -1;
                }
                dArray[5] = SMath.acos(this.sl.swi_dot_prod_unit(dArray8, dArray2)) / 0.0174532925199433;
            }
        }
        return 0;
    }

    int swe_pheno_ut(double d, int n, int n2, double[] dArray, StringBuffer stringBuffer) {
        SweDate.swi_set_tid_acc(d, n2, 0);
        return this.swe_pheno(d + SweDate.getDeltaT(d), n, n2, dArray, stringBuffer);
    }

    private int find_maximum(double d, double d2, double d3, double d4, DblObj dblObj, DblObj dblObj2) {
        double d5 = d2;
        double d6 = (d3 - d) / 2.0;
        double d7 = (d3 + d) / 2.0 - d5;
        double d8 = -d6 / 2.0 / d7;
        double d9 = (4.0 * d7 * d5 - d6 * d6) / 4.0 / d7;
        dblObj.val = (d8 - 1.0) * d4;
        if (dblObj2 != null) {
            dblObj2.val = d9;
        }
        return 0;
    }

    private int find_zero(double d, double d2, double d3, double d4, DblObj dblObj, DblObj dblObj2) {
        double d5 = (d3 - d) / 2.0;
        double d6 = d2;
        double d7 = (d3 + d) / 2.0 - d6;
        if (d5 * d5 - 4.0 * d7 * d6 < 0.0) {
            return -1;
        }
        double d8 = (-d5 + SMath.sqrt(d5 * d5 - 4.0 * d7 * d6)) / 2.0 / d7;
        double d9 = (-d5 - SMath.sqrt(d5 * d5 - 4.0 * d7 * d6)) / 2.0 / d7;
        dblObj.val = (d8 - 1.0) * d4;
        dblObj2.val = (d9 - 1.0) * d4;
        return 0;
    }

    private double rdi_twilight(int n) {
        double d = 0.0;
        if ((n & 0x400) != 0) {
            d = 6.0;
        }
        if ((n & 0x800) != 0) {
            d = 12.0;
        }
        if ((n & 0x1000) != 0) {
            d = 18.0;
        }
        return d;
    }

    int swe_rise_trans(double d, int n, StringBuffer stringBuffer, int n2, int n3, double[] dArray, double d2, double d3, DblObj dblObj, StringBuffer stringBuffer2) {
        return this.swe_rise_trans_true_hor(d, n, stringBuffer, n2, n3, dArray, d2, d3, 0.0, dblObj, stringBuffer2);
    }

    int swe_rise_trans_true_hor(double d, int n, StringBuffer stringBuffer, int n2, int n3, double[] dArray, double d2, double d3, double d4, DblObj dblObj, StringBuffer stringBuffer2) {
        int n4;
        double d5;
        double d6;
        double d7;
        boolean bl;
        int n5 = -1;
        double d8 = d + SweDate.getDeltaT(d);
        double[] dArray2 = new double[6];
        double[][] dArray3 = new double[20][6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[4];
        double[] dArray6 = new double[20];
        double[] dArray7 = new double[20];
        double[] dArray8 = new double[6];
        double[] dArray9 = new double[6];
        DblObj dblObj2 = new DblObj();
        DblObj dblObj3 = new DblObj();
        double d9 = 0.0;
        int n6 = n2;
        int n7 = 14;
        double d10 = 0.08333333333333333;
        boolean bl2 = false;
        boolean bl3 = bl = stringBuffer != null && stringBuffer.length() > 0;
        if (dArray[2] < -500.0 || dArray[2] > 25000.0) {
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("location for swe_rise_trans() must be between -500 and 25000 m above sea");
            }
            return -1;
        }
        SweDate.swi_set_tid_acc(d, n2, 0);
        if (n == 144340) {
            n = 9;
        }
        n6 &= 0x57;
        dblObj.val = 0.0;
        n6 |= 0x8800;
        this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
        if ((n3 & 0xC) != 0) {
            return this.calc_mer_trans(d, n, n2, n3, dArray, stringBuffer, dblObj, stringBuffer2);
        }
        if ((n3 & 3) == 0) {
            n3 |= 1;
        }
        if (n == 0 && (n3 & 0x1C00) != 0) {
            d4 = -this.rdi_twilight(n3 |= 0x300);
        }
        if (bl && this.sw.swe_fixstar(stringBuffer, d8, n6, dArray2, stringBuffer2) == -1) {
            return -1;
        }
        int n8 = 0;
        double d11 = d - d10;
        while (n8 <= n7) {
            dArray6[n8] = d11;
            if (!bl && this.sw.swe_calc(d7 = d11 + SweDate.getDeltaT(d11), n, n6, dArray2, stringBuffer2) == -1) {
                return -1;
            }
            if (n8 == 0) {
                d9 = bl ? 0.0 : ((n3 & 0x100) != 0 ? 0.0 : (n < 21 && n >= 0 ? SwephData.pla_diam[n] : (n > 10000 ? this.swed.ast_diam * 1000.0 : 0.0)));
            }
            d6 = dArray2[2];
            if ((n3 & 0x4000) != 0) {
                if (n == 0) {
                    d6 = 1.0;
                } else if (n == 1) {
                    d6 = 0.00257;
                }
            }
            d5 = SMath.asin(d9 / 2.0 / 1.4959787066E11 / d6) * 57.2957795130823;
            this.swe_azalt(d11, 1, dArray, d2, d3, dArray2, dArray3[n8]);
            if ((n3 & 0x2000) != 0) {
                double[] dArray10 = dArray3[n8];
                dArray10[1] = dArray10[1] - d5;
            } else {
                double[] dArray11 = dArray3[n8];
                dArray11[1] = dArray11[1] + d5;
            }
            if ((n3 & 0x200) != 0) {
                double[] dArray12 = dArray3[n8];
                dArray12[1] = dArray12[1] - d4;
                dArray7[n8] = dArray3[n8][1];
            } else {
                this.swe_azalt_rev(d11, 1, dArray, dArray3[n8], dArray2);
                this.swe_azalt(d11, 1, dArray, d2, d3, dArray2, dArray3[n8]);
                double[] dArray13 = dArray3[n8];
                dArray13[1] = dArray13[1] - d4;
                double[] dArray14 = dArray3[n8];
                dArray14[2] = dArray14[2] - d4;
                dArray7[n8] = dArray3[n8][2];
            }
            int n9 = 0;
            if (n8 > 1) {
                dArray9[0] = dArray3[n8 - 2][1];
                dArray9[1] = dArray3[n8 - 1][1];
                dArray9[2] = dArray3[n8][1];
                if (dArray9[1] > dArray9[0] && dArray9[1] > dArray9[2]) {
                    n9 = 1;
                }
                if (dArray9[1] < dArray9[0] && dArray9[1] < dArray9[2]) {
                    n9 = 2;
                }
            }
            if (n9 != 0) {
                double d12 = d10;
                double d13 = d11 - d12;
                this.find_maximum(dArray9[0], dArray9[1], dArray9[2], d12, dblObj2, dblObj3);
                d13 += dblObj2.val + d12;
                d12 /= 3.0;
                while (d12 > 1.0E-4) {
                    double d14 = d13 - d12;
                    for (n4 = 0; n4 < 3; ++n4) {
                        d7 = d14 + SweDate.getDeltaT(d14);
                        if (!bl && this.sw.swe_calc(d7, n, n6, dArray2, stringBuffer2) == -1) {
                            return -1;
                        }
                        this.swe_azalt(d14, 1, dArray, d2, d3, dArray2, dArray4);
                        dArray4[1] = dArray4[1] - d4;
                        dArray9[n4] = dArray4[1];
                        d14 += d12;
                    }
                    this.find_maximum(dArray9[0], dArray9[1], dArray9[2], d12, dblObj2, dblObj3);
                    d13 += dblObj2.val + d12;
                    d12 /= 3.0;
                }
                dArray5[++n5] = d13;
            }
            ++n8;
            d11 += d10;
        }
        block3: for (n4 = 0; n4 <= n5; ++n4) {
            for (int i = 1; i <= n7; ++i) {
                if (!(dArray5[n4] < dArray6[i])) continue;
                for (int j = n7; j >= i; --j) {
                    dArray6[j + 1] = dArray6[j];
                    dArray7[j + 1] = dArray7[j];
                }
                dArray6[i] = dArray5[n4];
                if (!bl && this.sw.swe_calc(d7 = dArray6[i] + SweDate.getDeltaT(dArray6[i]), n, n6, dArray2, stringBuffer2) == -1) {
                    return -1;
                }
                d6 = dArray2[2];
                if ((n3 & 0x4000) != 0) {
                    if (n == 0) {
                        d6 = 1.0;
                    } else if (n == 1) {
                        d6 = 0.00257;
                    }
                }
                d5 = SMath.asin(d9 / 2.0 / 1.4959787066E11 / d6) * 57.2957795130823;
                this.swe_azalt(dArray6[i], 1, dArray, d2, d3, dArray2, dArray4);
                dArray4[1] = (n3 & 0x2000) != 0 ? dArray4[1] - d5 : dArray4[1] + d5;
                if ((n3 & 0x200) != 0) {
                    dArray4[1] = dArray4[1] - d4;
                    dArray7[i] = dArray4[1];
                } else {
                    this.swe_azalt_rev(dArray6[i], 1, dArray, dArray4, dArray2);
                    this.swe_azalt(dArray6[i], 1, dArray, d2, d3, dArray2, dArray4);
                    dArray4[1] = dArray4[1] - d4;
                    dArray4[2] = dArray4[2] - d4;
                    dArray7[i] = dArray4[2];
                }
                ++n7;
                continue block3;
            }
        }
        dblObj.val = 0.0;
        for (n8 = 1; n8 <= n7; ++n8) {
            if (dArray7[n8 - 1] * dArray7[n8] >= 0.0 || dArray7[n8 - 1] < dArray7[n8] && (n3 & 1) == 0 || dArray7[n8 - 1] > dArray7[n8] && (n3 & 2) == 0) continue;
            dArray9[0] = dArray7[n8 - 1];
            dArray9[1] = dArray7[n8];
            dArray8[0] = dArray6[n8 - 1];
            dArray8[1] = dArray6[n8];
            for (n4 = 0; n4 < 20; ++n4) {
                double d15;
                d11 = (dArray8[0] + dArray8[1]) / 2.0;
                if (!bl && this.sw.swe_calc(d7 = d11 + SweDate.getDeltaT(d11), n, n6, dArray2, stringBuffer2) == -1) {
                    return -1;
                }
                d6 = dArray2[2];
                if ((n3 & 0x4000) != 0) {
                    if (n == 0) {
                        d6 = 1.0;
                    } else if (n == 1) {
                        d6 = 0.00257;
                    }
                }
                d5 = SMath.asin(d9 / 2.0 / 1.4959787066E11 / d6) * 57.2957795130823;
                this.swe_azalt(d11, 1, dArray, d2, d3, dArray2, dArray4);
                dArray4[1] = (n3 & 0x2000) != 0 ? dArray4[1] - d5 : dArray4[1] + d5;
                if ((n3 & 0x200) != 0) {
                    dArray4[1] = dArray4[1] - d4;
                    d15 = dArray4[1];
                } else {
                    this.swe_azalt_rev(d11, 1, dArray, dArray4, dArray2);
                    this.swe_azalt(d11, 1, dArray, d2, d3, dArray2, dArray4);
                    dArray4[1] = dArray4[1] - d4;
                    dArray4[2] = dArray4[2] - d4;
                    d15 = dArray4[2];
                }
                if (d15 * dArray9[0] <= 0.0) {
                    dArray9[1] = d15;
                    dArray8[1] = d11;
                    continue;
                }
                dArray9[0] = d15;
                dArray8[0] = d11;
            }
            if (!(d11 > d)) continue;
            dblObj.val = d11;
            return 0;
        }
        if (stringBuffer2 != null) {
            stringBuffer2.setLength(0);
            stringBuffer2.append("rise or set not found for planet ").append(n);
        }
        return -2;
    }

    private int calc_mer_trans(double d, int n, int n2, int n3, double[] dArray, StringBuffer stringBuffer, DblObj dblObj, StringBuffer stringBuffer2) {
        double d2 = d + SweDate.getDeltaT(d);
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        int n4 = n2;
        boolean bl = stringBuffer != null && stringBuffer.length() > 0;
        n4 &= 7;
        dblObj.val = 0.0;
        n4 |= 0x8800;
        double d3 = this.sl.swe_sidtime(d) + dArray[0] / 15.0;
        if (d3 >= 24.0) {
            d3 -= 24.0;
        }
        if (d3 < 0.0) {
            d3 += 24.0;
        }
        d3 *= 15.0;
        if (bl ? this.sw.swe_fixstar(stringBuffer, d2, n4, dArray2, stringBuffer2) == -1 : this.sw.swe_calc(d2, n, n4, dArray2, stringBuffer2) == -1) {
            return -1;
        }
        dArray3[0] = dArray2[0];
        dArray3[1] = dArray2[1];
        double d4 = d;
        double d5 = d3;
        if ((n3 & 8) != 0) {
            d5 = this.sl.swe_degnorm(d5 + 180.0);
        }
        for (int i = 0; i < 4; ++i) {
            double d6;
            double d7;
            double d8 = this.sl.swe_degnorm(dArray3[0] - d5);
            if (i > 0 && d8 > 180.0) {
                d8 -= 360.0;
            }
            if ((d7 = this.sl.swe_sidtime(d4 += d8 / 361.0) + dArray[0] / 15.0) >= 24.0) {
                d7 -= 24.0;
            }
            if (d7 < 0.0) {
                d7 += 24.0;
            }
            d5 = d7 *= 15.0;
            if ((n3 & 8) != 0) {
                d5 = this.sl.swe_degnorm(d5 + 180.0);
            }
            if (bl || this.sw.swe_calc(d6 = d4 + SweDate.getDeltaT(d4), n, n4, dArray3, stringBuffer2) != -1) continue;
            return -1;
        }
        dblObj.val = d4;
        return 0;
    }

    int swe_nod_aps(double d, int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, StringBuffer stringBuffer) {
        int n4;
        double d2;
        double[] dArray5;
        double d3;
        double d4;
        int n5;
        double d5 = (d - 2451545.0) / 36525.0;
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[24];
        double[] dArray8 = new double[6];
        double[] dArray9 = new double[6];
        int n6 = 0;
        double[][] dArray10 = new double[3][6];
        double[] dArray11 = new double[6];
        double[] dArray12 = new double[6];
        double[][] dArray13 = new double[3][6];
        double[][] dArray14 = new double[3][6];
        double[][] dArray15 = new double[3][6];
        double[][] dArray16 = new double[3][6];
        double[] dArray17 = new double[6];
        double[] dArray18 = new double[6];
        PlanData planData = this.swed.pldat[0];
        PlanData planData2 = this.swed.pldat[10];
        PlanData planData3 = new PlanData();
        double[] dArray19 = planData2.x;
        double[] dArray20 = planData.x;
        boolean bl = false;
        boolean bl2 = (n2 & 0x410) == 0;
        boolean bl3 = (n2 & 0x10) == 0 && (n2 & 0x200) == 0;
        boolean bl4 = (n3 & 0x100) != 0;
        boolean bl5 = false;
        n2 &= 0xFFF3FFFF;
        if (n == 144340) {
            n = 9;
        }
        double[] dArray21 = dArray7;
        double[] dArray22 = dArray7;
        double[] dArray23 = dArray7;
        double[] dArray24 = dArray7;
        this.sw.swi_force_app_pos_etc();
        n3 %= 256;
        int n7 = n;
        if (n == 0) {
            n7 = 14;
        }
        if (n == 1) {
            bl3 = false;
            if ((n2 & 8) == 0) {
                bl2 = false;
            }
        }
        int n8 = n2 & 0x47 | 0x100 | 0x10;
        if (n7 != 1) {
            n8 |= 8;
        }
        if (n == 10 || n == 11 || n == 12 || n == 13 || n < 0 || n >= 23 && n <= 10000) {
            int n9;
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("nodes/apsides for planet " + n + " are not implemented");
            }
            if (dArray != null) {
                for (n9 = 0; n9 <= 5; ++n9) {
                    dArray[n9] = 0.0;
                }
            }
            if (dArray2 != null) {
                for (n9 = 0; n9 <= 5; ++n9) {
                    dArray2[n9] = 0.0;
                }
            }
            if (dArray4 != null) {
                for (n9 = 0; n9 <= 5; ++n9) {
                    dArray4[n9] = 0.0;
                }
            }
            if (dArray3 != null) {
                for (n9 = 0; n9 <= 5; ++n9) {
                    dArray3[n9] = 0.0;
                }
            }
            return -1;
        }
        for (n5 = 0; n5 < 24; ++n5) {
            dArray7[n5] = 0.0;
        }
        if ((n3 == 0 || (n3 & 1) != 0) && (n >= 0 && n <= 8 || n == 14)) {
            double d6;
            double d7;
            double d8;
            double d9;
            if (n == 1) {
                DblObj dblObj = new DblObj();
                dblObj.val = dArray21[0];
                DblObj dblObj2 = new DblObj();
                dblObj2.val = dArray21[3];
                DblObj dblObj3 = new DblObj();
                dblObj3.val = dArray23[12];
                DblObj dblObj4 = new DblObj();
                dblObj4.val = dArray23[15];
                this.sm.swi_mean_lunar_elements(d, dblObj, dblObj2, dblObj3, dblObj4);
                dArray21[0] = dblObj.val;
                dArray21[3] = dblObj2.val;
                dArray23[12] = dblObj3.val;
                dArray23[15] = dblObj4.val;
                d9 = 5.1453964;
                d8 = 0.0;
                d4 = 0.054900489;
                d7 = 0.0;
                d3 = 0.002569555290487047;
                d6 = 0.0;
            } else {
                int n10 = ipl_to_elem[n];
                double[] dArray25 = el_incl[n10];
                d9 = dArray25[0] + dArray25[1] * d5 + dArray25[2] * d5 * d5 + dArray25[3] * d5 * d5 * d5;
                d8 = dArray25[1] / 36525.0;
                dArray25 = el_sema[n10];
                d3 = dArray25[0] + dArray25[1] * d5 + dArray25[2] * d5 * d5 + dArray25[3] * d5 * d5 * d5;
                d6 = dArray25[1] / 36525.0;
                dArray25 = el_ecce[n10];
                d4 = dArray25[0] + dArray25[1] * d5 + dArray25[2] * d5 * d5 + dArray25[3] * d5 * d5 * d5;
                d7 = dArray25[1] / 36525.0;
                dArray25 = el_node[n10];
                dArray21[0] = dArray25[0] + dArray25[1] * d5 + dArray25[2] * d5 * d5 + dArray25[3] * d5 * d5 * d5;
                dArray21[3] = dArray25[1] / 36525.0;
                dArray25 = el_peri[n10];
                dArray23[12] = dArray25[0] + dArray25[1] * d5 + dArray25[2] * d5 * d5 + dArray25[3] * d5 * d5 * d5;
                dArray23[15] = dArray25[1] / 36525.0;
            }
            dArray22[6] = this.sl.swe_degnorm(dArray21[0] + 180.0);
            dArray22[9] = dArray21[3];
            double d10 = dArray23[12] = this.sl.swe_degnorm(dArray23[12] - dArray21[0]);
            double d11 = dArray23[15] = this.sl.swe_degnorm(dArray23[12] + dArray23[15] - dArray21[3]);
            this.sl.swe_cotrans(dArray23, 12, dArray23, 12, -d9);
            this.sl.swe_cotrans(dArray23, 15, dArray23, 15, -d9 - d8);
            dArray23[12] = this.sl.swe_degnorm(dArray23[12] + dArray21[0]);
            dArray23[15] = this.sl.swe_degnorm(dArray23[15] + dArray21[0] + dArray21[3]);
            dArray23[15] = this.sl.swe_degnorm(dArray23[15] - dArray23[12]);
            dArray23[14] = d3 * (1.0 - d4);
            dArray23[17] = (d3 + d6) * (1.0 - d4 - d7) - dArray23[14];
            dArray24[18] = this.sl.swe_degnorm(dArray23[12] + 180.0);
            dArray24[19] = -dArray23[13];
            dArray24[21] = dArray23[15];
            dArray24[22] = -dArray23[16];
            if (bl4) {
                dArray24[20] = d3 * d4 * 2.0;
                dArray24[23] = (d3 + d6) * (d4 + d7) * 2.0 - dArray24[20];
            } else {
                dArray24[20] = d3 * (1.0 + d4);
                dArray24[23] = (d3 + d6) * (1.0 + d4 + d7) - dArray24[20];
            }
            double d12 = SMath.atan(SMath.tan(-d10 * 0.0174532925199433 / 2.0) * SMath.sqrt((1.0 - d4) / (1.0 + d4))) * 2.0;
            double d13 = SMath.atan(SMath.tan(-d11 * 0.0174532925199433 / 2.0) * SMath.sqrt((1.0 - d4 - d7) / (1.0 + d4 + d7))) * 2.0;
            dArray21[2] = d3 * (SMath.cos(d12) - d4) / SMath.cos(d10 * 0.0174532925199433);
            dArray21[5] = (d3 + d6) * (SMath.cos(d13) - d4 - d7) / SMath.cos(d11 * 0.0174532925199433);
            dArray21[5] = dArray21[5] - dArray21[2];
            d12 = SMath.atan(SMath.tan((180.0 - d10) * 0.0174532925199433 / 2.0) * SMath.sqrt((1.0 - d4) / (1.0 + d4))) * 2.0;
            d13 = SMath.atan(SMath.tan((180.0 - d11) * 0.0174532925199433 / 2.0) * SMath.sqrt((1.0 - d4 - d7) / (1.0 + d4 + d7))) * 2.0;
            dArray22[8] = d3 * (SMath.cos(d12) - d4) / SMath.cos((180.0 - d10) * 0.0174532925199433);
            dArray22[11] = (d3 + d6) * (SMath.cos(d13) - d4 - d7) / SMath.cos((180.0 - d11) * 0.0174532925199433);
            dArray22[11] = dArray22[11] - dArray22[8];
            n5 = 0;
            dArray5 = dArray7;
            n6 = 0;
            while (n5 < 4) {
                int n11 = 0 + n6;
                dArray5[n11] = dArray5[n11] * 0.0174532925199433;
                int n12 = 1 + n6;
                dArray5[n12] = dArray5[n12] * 0.0174532925199433;
                int n13 = 3 + n6;
                dArray5[n13] = dArray5[n13] * 0.0174532925199433;
                int n14 = 4 + n6;
                dArray5[n14] = dArray5[n14] * 0.0174532925199433;
                this.sl.swi_polcart_sp(dArray5, n6, dArray5, n6);
                ++n5;
                n6 += 6;
            }
        } else {
            int n15;
            int n16;
            double d14;
            double d15;
            if (this.sw.swe_calc(d, n7, n8, dArray6, stringBuffer) == -1) {
                return -1;
            }
            int n17 = n2 & 7 | 0x20 | 0x800 | 0x1000 | 0x10 | 0x40 | 0x100;
            bl5 = false;
            if (n7 != 1) {
                if ((n3 & 4) != 0 && dArray6[2] > 6.0) {
                    n17 |= 0x4000;
                    bl5 = true;
                } else {
                    n17 |= 8;
                }
            }
            if (n7 == 1) {
                d2 = 1.0E-4;
                d15 = 1.0E-15;
                d14 = 8.997011693402468E-10;
            } else {
                double d16 = n7 >= 2 && n7 <= 9 || n7 == 14 ? 1.0 / plmass[ipl_to_elem[n]] : 0.0;
                d2 = 0.001 * dArray6[2];
                d15 = 1.0E-15 * d2 / 1.0E-4;
                d14 = 1.32712440017987E20 * (1.0 + d16) / 1.4959787066E11 / 1.4959787066E11 / 1.4959787066E11 * 86400.0 * 86400.0;
            }
            if ((n2 & 0x100) != 0) {
                n16 = 0;
                n15 = 2;
            } else {
                n15 = 0;
                n16 = 0;
                d2 = 0.0;
            }
            n5 = n16;
            d5 = d - d2;
            while (n5 <= n15) {
                if (n16 == n15) {
                    d5 = d;
                }
                if (this.sw.swe_calc(d5, n7, n17, dArray10[n5], stringBuffer) == -1) {
                    return -1;
                }
                if (n7 == 14) {
                    if (this.sw.swe_calc(d5, 1, n17 & 0xFFFFBFF7, dArray12, stringBuffer) == -1) {
                        return -1;
                    }
                    for (n4 = 0; n4 <= 2; ++n4) {
                        double[] dArray26 = dArray10[n5];
                        int n18 = n4;
                        dArray26[n18] = dArray26[n18] + dArray12[n4] / 82.30055985272827;
                    }
                }
                this.sw.swi_plan_for_osc_elem(n8, d5, dArray10[n5]);
                ++n5;
                d5 += d2;
            }
            for (n5 = n16; n5 <= n15; ++n5) {
                if (SMath.abs(dArray10[n5][5]) < d15) {
                    dArray10[n5][5] = d15;
                }
                double d17 = dArray10[n5][2] / dArray10[n5][5];
                double d18 = dArray10[n5][5] / SMath.abs(dArray10[n5][5]);
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray13[n5][n4] = (dArray10[n5][n4] - d17 * dArray10[n5][n4 + 3]) * d18;
                    dArray14[n5][n4] = -dArray13[n5][n4];
                }
            }
            for (n5 = n16; n5 <= n15; ++n5) {
                double d19 = SMath.sqrt(dArray13[n5][0] * dArray13[n5][0] + dArray13[n5][1] * dArray13[n5][1]);
                double d20 = dArray13[n5][0] / d19;
                double d21 = dArray13[n5][1] / d19;
                this.sl.swi_cross_prod(dArray10[n5], 0, dArray10[n5], 3, dArray11, 0);
                d19 = dArray11[0] * dArray11[0] + dArray11[1] * dArray11[1];
                double d22 = d19 + dArray11[2] * dArray11[2];
                double d23 = SMath.sqrt(d22);
                d19 = SMath.sqrt(d19);
                double d24 = d19 / d23;
                double d25 = SMath.sqrt(1.0 - d24 * d24);
                if (dArray11[2] < 0.0) {
                    d25 = -d25;
                }
                double d26 = dArray10[n5][0] * d20 + dArray10[n5][1] * d21;
                double d27 = dArray10[n5][2] / d24;
                double d28 = SMath.atan2(d27, d26);
                d23 = SMath.sqrt(this.sl.square_sum(dArray10[n5]));
                double d29 = this.sl.square_sum(dArray10[n5], 3);
                d3 = 1.0 / (2.0 / d23 - d29 / d14);
                double d30 = d22 / d14;
                d4 = SMath.sqrt(1.0 - d30 / d3);
                double d31 = 1.0 / d4 * (1.0 - d23 / d3);
                double d32 = 1.0 / d4 / SMath.sqrt(d3 * d14) * this.sw.dot_prod(dArray10[n5], dArray10[n5], 3);
                double d33 = 2.0 * SMath.atan(SMath.sqrt((1.0 + d4) / (1.0 - d4)) * d32 / (1.0 + d31));
                dArray15[n5][0] = this.sl.swi_mod2PI(d28 - d33);
                dArray15[n5][1] = 0.0;
                dArray15[n5][2] = d3 * (1.0 - d4);
                this.sl.swi_polcart(dArray15[n5], dArray15[n5]);
                this.sl.swi_coortrf2(dArray15[n5], dArray15[n5], -d24, d25);
                this.sl.swi_cartpol(dArray15[n5], dArray15[n5]);
                double[] dArray27 = dArray15[n5];
                dArray27[0] = dArray27[0] + SMath.atan2(d21, d20);
                dArray16[n5][0] = this.sl.swi_mod2PI(dArray15[n5][0] + Math.PI);
                dArray16[n5][1] = -dArray15[n5][1];
                dArray16[n5][2] = bl4 ? d3 * d4 * 2.0 : d3 * (1.0 + d4);
                this.sl.swi_polcart(dArray15[n5], dArray15[n5]);
                this.sl.swi_polcart(dArray16[n5], dArray16[n5]);
                d33 = this.sl.swi_mod2PI(d33 - d28);
                double d34 = this.sl.swi_mod2PI(d33 + Math.PI);
                d31 = SMath.cos(2.0 * SMath.atan(SMath.tan(d33 / 2.0) / SMath.sqrt((1.0 + d4) / (1.0 - d4))));
                double d35 = SMath.cos(2.0 * SMath.atan(SMath.tan(d34 / 2.0) / SMath.sqrt((1.0 + d4) / (1.0 - d4))));
                double d36 = d3 * (1.0 - d4 * d31);
                double d37 = d3 * (1.0 - d4 * d35);
                double d38 = SMath.sqrt(this.sl.square_sum(dArray13[n5]));
                double d39 = SMath.sqrt(this.sl.square_sum(dArray14[n5]));
                n4 = 0;
                while (n4 <= 2) {
                    double[] dArray28 = dArray13[n5];
                    int n19 = n4;
                    dArray28[n19] = dArray28[n19] * (d36 / d38);
                    double[] dArray29 = dArray14[n5];
                    int n20 = n4++;
                    dArray29[n20] = dArray29[n20] * (d37 / d39);
                }
            }
            for (n5 = 0; n5 <= 2; ++n5) {
                if ((n2 & 0x100) != 0) {
                    dArray23[n5 + 12] = dArray15[1][n5];
                    dArray23[n5 + 3 + 12] = (dArray15[2][n5] - dArray15[0][n5]) / d2 / 2.0;
                    dArray24[n5 + 18] = dArray16[1][n5];
                    dArray24[n5 + 3 + 18] = (dArray16[2][n5] - dArray16[0][n5]) / d2 / 2.0;
                    dArray21[n5] = dArray13[1][n5];
                    dArray21[n5 + 3] = (dArray13[2][n5] - dArray13[0][n5]) / d2 / 2.0;
                    dArray22[n5 + 6] = dArray14[1][n5];
                    dArray22[n5 + 3 + 6] = (dArray14[2][n5] - dArray14[0][n5]) / d2 / 2.0;
                    continue;
                }
                dArray23[n5 + 12] = dArray15[0][n5];
                dArray23[n5 + 3 + 12] = 0.0;
                dArray24[n5 + 18] = dArray16[0][n5];
                dArray24[n5 + 3 + 18] = 0.0;
                dArray21[n5] = dArray13[0][n5];
                dArray21[n5 + 3] = 0.0;
                dArray22[n5 + 6] = dArray14[0][n5];
                dArray22[n5 + 3 + 6] = 0.0;
            }
            bl = true;
        }
        if (n7 == 1 && (n2 & 0x4008) != 0) {
            this.sw.swi_force_app_pos_etc();
            if (this.sw.swe_calc(d, 0, n8, dArray6, stringBuffer) == -1) {
                return -1;
            }
        } else if (this.sw.swe_calc(d, n7, n8 | n2 & 0x8000, dArray6, stringBuffer) == -1) {
            return -1;
        }
        if ((n2 & 0x8000) != 0) {
            if (this.sw.swi_get_observer(d, n2, false, dArray8, stringBuffer) != 0) {
                return -1;
            }
        } else {
            for (n5 = 0; n5 <= 5; ++n5) {
                dArray8[n5] = 0.0;
            }
        }
        if ((n2 & 0x4008) != 0) {
            if ((n2 & 8) != 0 && (n2 & 4) == 0) {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray8[n5] = dArray19[n5];
                }
            }
        } else if (n == 0 && (n2 & 4) == 0) {
            for (n5 = 0; n5 <= 5; ++n5) {
                dArray8[n5] = dArray19[n5];
            }
        } else {
            for (n5 = 0; n5 <= 5; ++n5) {
                int n21 = n5;
                dArray8[n21] = dArray8[n21] + dArray20[n5];
            }
        }
        Epsilon epsilon = (n2 & 0x20) != 0 ? this.swed.oec2000 : this.swed.oec;
        int n22 = 0;
        dArray5 = dArray7;
        n6 = 0;
        while (n22 < 4) {
            if (n7 == 14 && n22 <= 1) {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray5[n5 + n6] = 0.0;
                }
            } else {
                if (bl && (n2 & 0x40) == 0) {
                    this.sl.swi_coortrf2(dArray5, n6, dArray5, n6, -this.swed.nut.snut, this.swed.nut.cnut);
                    if ((n2 & 0x100) != 0) {
                        this.sl.swi_coortrf2(dArray5, 3 + n6, dArray5, 3 + n6, -this.swed.nut.snut, this.swed.nut.cnut);
                    }
                }
                this.sl.swi_coortrf2(dArray5, n6, dArray5, n6, -epsilon.seps, epsilon.ceps);
                this.sl.swi_coortrf2(dArray5, 3 + n6, dArray5, 3 + n6, -epsilon.seps, epsilon.ceps);
                if (bl && (n2 & 0x40) == 0) {
                    this.sw.swi_nutate(dArray5, n6, n2, true);
                }
                this.sl.swi_precess(dArray5, n6, d, n2, 1);
                if ((n2 & 0x100) != 0) {
                    this.sw.swi_precess_speed(dArray5, n6, d, n2, 1);
                }
                if (n7 == 1) {
                    for (n5 = 0; n5 <= 5; ++n5) {
                        int n23 = n5 + n6;
                        dArray5[n23] = dArray5[n23] + dArray20[n5];
                    }
                } else if ((n2 & 4) == 0 && !bl5) {
                    for (n4 = 0; n4 <= 5; ++n4) {
                        int n24 = n4 + n6;
                        dArray5[n24] = dArray5[n24] + dArray19[n4];
                    }
                }
                for (n4 = 0; n4 <= 5; ++n4) {
                    int n25 = n4 + n6;
                    dArray5[n25] = dArray5[n25] - dArray8[n4];
                }
                if (n == 0 && (n2 & 0x4008) == 0) {
                    for (n4 = 0; n4 <= 5; ++n4) {
                        dArray5[n4 + n6] = -dArray5[n4 + n6];
                    }
                }
                d2 = SMath.sqrt(this.sl.square_sum(dArray5, n6)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                if (bl3) {
                    this.sw.swi_deflect_light(dArray5, n6, d2, n2);
                }
                if (bl2) {
                    this.sw.swi_aberr_light(dArray5, n6, dArray8, n2);
                    if ((n2 & 0x100) != 0) {
                        if (this.sw.swe_calc(d - d2, n7, n8 | n2 & 0x8000, dArray18, stringBuffer) == -1) {
                            return -1;
                        }
                        if ((n2 & 0x8000) != 0) {
                            for (n5 = 0; n5 <= 5; ++n5) {
                                dArray17[n5] = this.swed.topd.xobs[n5];
                            }
                        } else {
                            for (n5 = 0; n5 <= 5; ++n5) {
                                dArray17[n5] = 0.0;
                            }
                        }
                        if ((n2 & 0x4008) != 0) {
                            if ((n2 & 8) != 0 && (n2 & 4) == 0) {
                                for (n5 = 0; n5 <= 5; ++n5) {
                                    dArray17[n5] = dArray19[n5];
                                }
                            }
                        } else if (n == 0 && (n2 & 4) == 0) {
                            for (n5 = 0; n5 <= 5; ++n5) {
                                dArray17[n5] = dArray19[n5];
                            }
                        } else {
                            for (n5 = 0; n5 <= 5; ++n5) {
                                int n26 = n5;
                                dArray17[n26] = dArray17[n26] + dArray20[n5];
                            }
                        }
                        for (n5 = 3; n5 <= 5; ++n5) {
                            int n27 = n5 + n6;
                            dArray5[n27] = dArray5[n27] + (dArray8[n5] - dArray17[n5]);
                        }
                        if (this.sw.swe_calc(d, 0, n8 | n2 & 0x8000, dArray18, stringBuffer) == -1) {
                            return -1;
                        }
                    }
                }
                for (n4 = 0; n4 <= 5; ++n4) {
                    dArray9[n4] = dArray5[n4 + n6];
                }
                if ((n2 & 0x20) == 0) {
                    this.sl.swi_precess(dArray5, n6, d, n2, -1);
                    if ((n2 & 0x100) != 0) {
                        this.sw.swi_precess_speed(dArray5, n6, d, n2, -1);
                    }
                }
                if ((n2 & 0x40) == 0) {
                    this.sw.swi_nutate(dArray5, n6, n2, false);
                }
                for (n4 = 0; n4 <= 5; ++n4) {
                    planData3.xreturn[18 + n4] = dArray5[n4 + n6];
                }
                this.sl.swi_coortrf2(dArray5, n6, dArray5, n6, epsilon.seps, epsilon.ceps);
                if ((n2 & 0x100) != 0) {
                    this.sl.swi_coortrf2(dArray5, 3 + n6, dArray5, 3 + n6, epsilon.seps, epsilon.ceps);
                }
                if ((n2 & 0x40) == 0) {
                    this.sl.swi_coortrf2(dArray5, n6, dArray5, n6, this.swed.nut.snut, this.swed.nut.cnut);
                    if ((n2 & 0x100) != 0) {
                        this.sl.swi_coortrf2(dArray5, 3 + n6, dArray5, 3 + n6, this.swed.nut.snut, this.swed.nut.cnut);
                    }
                }
                for (n4 = 0; n4 <= 5; ++n4) {
                    planData3.xreturn[6 + n4] = dArray5[n4 + n6];
                }
                if ((n2 & 0x10000) != 0) {
                    if ((this.swed.sidd.sid_mode & 0x100) != 0) {
                        if (this.sw.swi_trop_ra2sid_lon(dArray9, planData3.xreturn, 6, planData3.xreturn, 18, n2, stringBuffer) != 0) {
                            return -1;
                        }
                    } else if ((this.swed.sidd.sid_mode & 0x200) != 0) {
                        if (this.sw.swi_trop_ra2sid_lon_sosy(dArray9, planData3.xreturn, 6, planData3.xreturn, 18, n2, stringBuffer) != 0) {
                            return -1;
                        }
                    } else {
                        this.sl.swi_cartpol_sp(planData3.xreturn, 6, planData3.xreturn, 0);
                        planData3.xreturn[0] = planData3.xreturn[0] - this.sw.swe_get_ayanamsa(d) * 0.0174532925199433;
                        this.sl.swi_polcart_sp(planData3.xreturn, 0, planData3.xreturn, 6);
                    }
                }
                if ((n2 & 0x1000) != 0 && (n2 & 0x800) != 0) {
                    for (n4 = 0; n4 <= 5; ++n4) {
                        dArray5[n4 + n6] = planData3.xreturn[18 + n4];
                    }
                } else if ((n2 & 0x1000) != 0) {
                    for (n4 = 0; n4 <= 5; ++n4) {
                        dArray5[n4 + n6] = planData3.xreturn[6 + n4];
                    }
                } else {
                    this.sl.swi_cartpol_sp(planData3.xreturn, 18, planData3.xreturn, 12);
                    this.sl.swi_cartpol_sp(planData3.xreturn, 6, planData3.xreturn, 0);
                    if ((n2 & 0x2000) == 0) {
                        for (n4 = 0; n4 < 2; ++n4) {
                            int n28 = n4;
                            planData3.xreturn[n28] = planData3.xreturn[n28] * 57.2957795130823;
                            int n29 = n4 + 3;
                            planData3.xreturn[n29] = planData3.xreturn[n29] * 57.2957795130823;
                            int n30 = n4 + 12;
                            planData3.xreturn[n30] = planData3.xreturn[n30] * 57.2957795130823;
                            int n31 = n4 + 15;
                            planData3.xreturn[n31] = planData3.xreturn[n31] * 57.2957795130823;
                        }
                    }
                    if ((n2 & 0x800) != 0) {
                        for (n4 = 0; n4 <= 5; ++n4) {
                            dArray5[n4 + n6] = planData3.xreturn[12 + n4];
                        }
                    } else {
                        for (n4 = 0; n4 <= 5; ++n4) {
                            dArray5[n4 + n6] = planData3.xreturn[n4];
                        }
                    }
                }
            }
            ++n22;
            n6 += 6;
        }
        for (n5 = 0; n5 <= 5; ++n5) {
            if (n5 > 2 && (n2 & 0x100) == 0) {
                dArray24[n5 + 18] = 0.0;
                dArray23[n5 + 12] = 0.0;
                dArray22[n5 + 6] = 0.0;
                dArray21[n5] = 0.0;
            }
            if (dArray != null) {
                dArray[n5] = dArray21[n5];
            }
            if (dArray2 != null) {
                dArray2[n5] = dArray22[n5 + 6];
            }
            if (dArray3 != null) {
                dArray3[n5] = dArray23[n5 + 12];
            }
            if (dArray4 == null) continue;
            dArray4[n5] = dArray24[n5 + 18];
        }
        return 0;
    }

    int swe_nod_aps_ut(double d, int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, StringBuffer stringBuffer) {
        SweDate.swi_set_tid_acc(d, n2, 0);
        return this.swe_nod_aps(d + SweDate.getDeltaT(d), n, n2, n3, dArray, dArray2, dArray3, dArray4, stringBuffer);
    }

    int swe_gauquelin_sector(double d, int n, StringBuffer stringBuffer, int n2, int n3, double[] dArray, double d2, double d3, DblObj dblObj, StringBuffer stringBuffer2) {
        DblObj dblObj2 = new DblObj();
        boolean bl = true;
        boolean bl2 = true;
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[2];
        int n4 = n2 & 7;
        boolean bl3 = stringBuffer != null && stringBuffer.length() > 0;
        int n5 = 0;
        boolean bl4 = false;
        if (n3 < 0 || n3 > 5) {
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("invalid method: ").append(n3);
            }
            return -1;
        }
        if (n == 144340) {
            n = 9;
        }
        if (n3 == 0 || n3 == 1) {
            double d4 = d + SweDate.getDeltaT(d);
            double d5 = this.sl.swi_epsiln(d4, n2) * 57.2957795130823;
            this.sl.swi_nutation(d4, n2, dArray4);
            dArray4[0] = dArray4[0] * 57.2957795130823;
            dArray4[1] = dArray4[1] * 57.2957795130823;
            double d6 = this.sl.swe_degnorm(this.sl.swe_sidtime0(d, d5 + dArray4[1], dArray4[0]) * 15.0 + dArray[0]);
            if (bl3 ? this.sw.swe_fixstar(stringBuffer, d4, n2, dArray3, stringBuffer2) == -1 : this.sw.swe_calc(d4, n, n2, dArray3, stringBuffer2) == -1) {
                return -1;
            }
            if (n3 == 1) {
                dArray3[1] = 0.0;
            }
            dblObj.val = this.sw.swe_house_pos(d6, dArray[1], d5 + dArray4[1], 71, dArray3, null);
            return 0;
        }
        if (n3 == 2 || n3 == 4) {
            n5 |= 0x200;
        }
        if (n3 == 2 || n3 == 3) {
            n5 |= 0x100;
        }
        dblObj2.val = dArray2[0];
        int n6 = this.swe_rise_trans(d, n, stringBuffer, n4, 1 | n5, dArray, d2, d3, dblObj2, stringBuffer2);
        dArray2[0] = dblObj2.val;
        if (n6 == -1) {
            return -1;
        }
        if (n6 == -2) {
            bl = false;
        }
        dblObj2.val = dArray2[1];
        n6 = this.swe_rise_trans(d, n, stringBuffer, n4, 2 | n5, dArray, d2, d3, dblObj2, stringBuffer2);
        dArray2[1] = dblObj2.val;
        if (n6 == -1) {
            return -1;
        }
        if (n6 == -2) {
            bl2 = false;
        }
        if (dArray2[0] < dArray2[1] && bl) {
            bl4 = false;
            double d7 = d - 1.2;
            if (bl2) {
                d7 = dArray2[1] - 1.2;
            }
            bl2 = true;
            dblObj2.val = dArray2[1];
            n6 = this.swe_rise_trans(d7, n, stringBuffer, n4, 2 | n5, dArray, d2, d3, dblObj2, stringBuffer2);
            dArray2[1] = dblObj2.val;
            if (n6 == -1) {
                return -1;
            }
            if (n6 == -2) {
                bl2 = false;
            }
        } else if (dArray2[0] >= dArray2[1] && bl2) {
            bl4 = true;
            double d8 = d - 1.2;
            if (bl) {
                d8 = dArray2[0] - 1.2;
            }
            bl = true;
            dblObj2.val = dArray2[0];
            n6 = this.swe_rise_trans(d8, n, stringBuffer, n4, 1 | n5, dArray, d2, d3, dblObj2, stringBuffer2);
            dArray2[0] = dblObj2.val;
            if (n6 == -1) {
                return -1;
            }
            if (n6 == -2) {
                bl = false;
            }
        }
        if (bl && bl2) {
            dblObj.val = bl4 ? (d - dArray2[0]) / (dArray2[1] - dArray2[0]) * 18.0 + 1.0 : (d - dArray2[1]) / (dArray2[0] - dArray2[1]) * 18.0 + 19.0;
            return 0;
        }
        dblObj.val = 0.0;
        if (stringBuffer2 != null) {
            stringBuffer2.setLength(0);
            stringBuffer2.append("rise or set not found for planet ").append(n);
        }
        return -1;
    }
}

