/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.Serializable;
import java.util.Locale;
import swisseph.DblObj;
import swisseph.SMath;
import swisseph.SweDate;
import swisseph.Swecl;
import swisseph.Swemmoon;
import swisseph.SwissData;
import swisseph.SwissEph;
import swisseph.SwissLib;

public class SweHel
implements Serializable {
    private SwissEph sw;
    private Swemmoon sm;
    private SwissLib sl;
    private Swecl sc;
    private SwissData swed;
    private static final int PLSV = 0;
    private static final double criticalangle = 0.0;
    private static final double BNIGHT = 1479.0;
    private static final double BNIGHT_FACTOR = 1.0;
    private static final double Min2Deg = 0.016666666666666666;
    private static final int DONE = 1;
    private static final int MaxTryHours = 4;
    private static final int TimeStepDefault = 1;
    private static final int LocalMinStep = 8;
    private static final double Y2D = 365.25;
    private static final double D2Y = 0.0027378507871321013;
    private static final double D2H = 24.0;
    private static final double H2S = 3600.0;
    private static final double D2S = 86400.0;
    private static final double S2H = 2.777777777777778E-4;
    private static final double JC2D = 36525.0;
    private static final double M2S = 60.0;
    private static final boolean USE_DELTA_T_VR = false;
    private static final int REFR_SINCLAIR = 0;
    private static final int REFR_BENNETTH = 1;
    private static final int FormAstroRefrac = 0;
    private static final int GravitySource = 2;
    private static final int REarthSource = 1;
    private static final int StartYear = 1820;
    private static final double Average = 1.80546834626888;
    private static final double Periodicy = 1443.67123144531;
    private static final double Amplitude = 3.75606495492684;
    private static final double phase = 0.0;
    private static final int MAX_COUNT_SYNPER = 5;
    private static final int MAX_COUNT_SYNPER_MAX = 1000000;
    private static final double AvgRadiusMoon = 0.2590166666666667;
    private static final double Ra = 6378136.6;
    private static final double Rb = 6356752.314;
    private static final double nL2erg = 1.02E-15;
    private static final double erg2nL = 9.803921568627451E14;
    private static final double MoonDistance = 384410.4978;
    private static final double scaleHwater = 3000.0;
    private static final double scaleHrayleigh = 8515.0;
    private static final double scaleHaerosol = 3745.0;
    private static final double scaleHozone = 20000.0;
    private static final double astr2tau = 0.921034037197618;
    private static final double tau2astr = 1.0857362047581298;
    private static final double C2K = 273.15;
    private static final double DELTA = 18.36;
    private static final double TempNulDiff = 1.0E-6;
    private static final double PressRef = 1000.0;
    private static final double MD = 28.964;
    private static final double MW = 18.016;
    private static final double GCR = 8314.472;
    private static final double LapseSA = 0.0065;
    private static final double LapseDA = 0.0098;
    private static final double LowestAppAlt = -3.5;
    private static final double epsilon = 0.001;
    private static final int staticAirmass = 0;
    private static final double GOpticMag = 1.0;
    private static final double GOpticTrans = 0.8;
    private static final double GBinocular = 1.0;
    private static final double GOpticDia = 50.0;
    double[] call_swe_fixstar_mag__dmag = new double[]{0.0};
    StringBuffer call_swe_fixstar_mag__star_save = new StringBuffer();
    private double sunRA_tjdlast;
    private double sunRA_ralast;
    private double koz__koz_last;
    private double koz__alts_last;
    private double koz__sunra_last;
    private double ka__alts_last;
    private double ka__sunra_last;
    private double ka__ka_last;
    private double Deltam__alts_last;
    private double Deltam__alto_last;
    private double Deltam__sunra_last;
    private double Deltam__deltam_last;
    private double[] tcon = new double[]{0.0, 0.0, 2451550.0, 2451550.0, 2451604.0, 2451670.0, 2451980.0, 2452280.0, 2451727.0, 2452074.0, 2451673.0, 2451877.0, 2451675.0, 2451868.0, 2451581.0, 2451768.0, 2451568.0, 2451753.0};

    public SweHel() {
        this(null, null, null, null);
    }

    public SweHel(SwissEph swissEph, SwissLib swissLib, Swemmoon swemmoon, SwissData swissData) {
        this.sw = swissEph;
        this.sl = swissLib;
        this.sm = swemmoon;
        this.swed = swissData;
        if (swissEph == null) {
            this.sw = new SwissEph();
        }
        if (swissLib == null) {
            this.sl = new SwissLib();
        }
        if (swemmoon == null) {
            this.sm = new Swemmoon();
        }
        if (swissData == null) {
            this.swed = new SwissData();
        }
        this.sc = new Swecl(this.sw, this.sl, this.sm, this.swed);
    }

    private double Tanh(double d) {
        return (SMath.exp(d) - SMath.exp(-d)) / (SMath.exp(d) + SMath.exp(-d));
    }

    private double CVA(double d, double d2) {
        if (d > 1479.0) {
            return 40.0 / d2 * SMath.pow(10.0, 8.28 * SMath.pow(d, -0.29)) / 60.0 / 60.0;
        }
        return SMath.min(900.0, 380.0 / d2 * SMath.pow(10.0, 0.3 * SMath.pow(d, -0.29))) / 60.0 / 60.0;
    }

    private double PupilDia(double d, double d2) {
        return (0.534 - 0.00211 * d - (0.236 - 0.00127 * d) * this.Tanh(0.4 * SMath.log(d2) / SMath.log(10.0) - 2.2)) * 10.0;
    }

    private double OpticFactor(double d, double d2, double[] dArray, double d3, String string, int n, int n2) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = dArray[0];
        double d9 = dArray[1];
        double d10 = dArray[2];
        double d11 = dArray[3];
        double d12 = dArray[4];
        double d13 = dArray[5];
        double d14 = d9;
        if (d14 <= 1.0E-8) {
            d14 = 1.0E-8;
        }
        double d15 = this.PupilDia(23.0, d);
        if (d11 == 1.0) {
            d13 = 1.0;
            d12 = d15;
        }
        double d16 = 0.7;
        double d17 = 0.5;
        double d18 = 0.0;
        if (string.equals("moon")) {
            // empty if block
        }
        double d19 = 1.0;
        if (d10 == 0.0) {
            d19 = 1.41;
        }
        if (d <= 1479.0 && (n2 & 0x4000) == 0) {
            d7 = SMath.pow(10.0, 0.48 * d2);
            d6 = SMath.min(1.0, (1.0 - SMath.pow(d15 / 124.4, 4.0)) / (1.0 - SMath.pow(d12 / d11 / 124.4, 4.0)));
            d5 = SMath.pow(10.0, -0.4 * (1.0 - d17 / 2.0));
            d4 = SMath.pow(10.0, -0.4 * (1.0 - d16 / 2.0));
        } else {
            d7 = SMath.pow(10.0, 0.4 * d2);
            d6 = SMath.min(1.0, SMath.pow(d12 / d11 / d15, 2.0) * (1.0 - SMath.exp(-SMath.pow(d15 / 6.2, 2.0))) / (1.0 - SMath.exp(-SMath.pow(d12 / d11 / 6.2, 2.0))));
            d5 = 1.0;
            d4 = 1.0;
        }
        double d20 = 1.0 / d13;
        double d21 = SMath.max(1.0, SMath.pow(d15 / (d11 * this.PupilDia(d8, d)), 2.0));
        double d22 = SMath.pow(d15 / d12, 2.0);
        double d23 = (1.0 + 0.03 * SMath.pow(d11 * d18 / this.CVA(d, d14), 2.0)) / SMath.pow(d14, 2.0);
        double d24 = SMath.pow(d11, 2.0);
        if (n == 0) {
            return d19 * d7 * d20 * d21 * d22 * d23 * d6 * d5;
        }
        return d19 * d20 * d21 * d22 * d24 * d6 * d4;
    }

    private int DeterObject(StringBuffer stringBuffer) {
        return this.DeterObject(stringBuffer.toString());
    }

    private int DeterObject(String string) {
        String string2 = string.toLowerCase();
        int n = -1;
        if (string2.startsWith("sun")) {
            return 0;
        }
        if (string2.startsWith("venus")) {
            return 3;
        }
        if (string2.startsWith("mars")) {
            return 4;
        }
        if (string2.startsWith("mercur")) {
            return 2;
        }
        if (string2.startsWith("jupiter")) {
            return 5;
        }
        if (string2.startsWith("saturn")) {
            return 6;
        }
        if (string2.startsWith("uranus")) {
            return 7;
        }
        if (string2.startsWith("neptun")) {
            return 8;
        }
        if (string2.startsWith("moon")) {
            return 1;
        }
        n = SwissLib.atoi(string2);
        if (n > 0) {
            return n += 10000;
        }
        return -1;
    }

    int call_swe_fixstar(StringBuffer stringBuffer, double d, int n, double[] dArray, StringBuffer stringBuffer2) {
        StringBuffer stringBuffer3 = new StringBuffer(stringBuffer);
        int n2 = this.sw.swe_fixstar(stringBuffer3, d, n, dArray, stringBuffer2);
        return n2;
    }

    int call_swe_fixstar_mag(StringBuffer stringBuffer, double[] dArray, int n, StringBuffer stringBuffer2) {
        StringBuffer stringBuffer3 = new StringBuffer();
        if (stringBuffer.equals(this.call_swe_fixstar_mag__star_save)) {
            dArray[n] = this.call_swe_fixstar_mag__dmag[0];
            return 0;
        }
        this.call_swe_fixstar_mag__star_save.setLength(0);
        this.call_swe_fixstar_mag__star_save.append(stringBuffer);
        stringBuffer3.setLength(0);
        stringBuffer3.append(stringBuffer);
        int n2 = this.sw.swe_fixstar_mag(stringBuffer3, this.call_swe_fixstar_mag__dmag, stringBuffer2);
        dArray[n] = this.call_swe_fixstar_mag__dmag[0];
        return n2;
    }

    int call_swe_rise_trans(double d, int n, String string, int n2, int n3, double[] dArray, double d2, double d3, double[] dArray2, StringBuffer stringBuffer) {
        int n4 = n2 & 7;
        StringBuffer stringBuffer2 = new StringBuffer(string);
        DblObj dblObj = new DblObj();
        dblObj.val = dArray2[0];
        int n5 = this.sc.swe_rise_trans(d, n, stringBuffer2, n4, n3, dArray, d2, d3, dblObj, stringBuffer);
        dArray2[0] = dblObj.val;
        return n5;
    }

    private int calc_rise_and_set(double d, int n, double[] dArray, double[] dArray2, int n2, int n3, double[] dArray3, StringBuffer stringBuffer) {
        int n4;
        int n5 = 0;
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        double d2 = 0.0027378507871321013;
        double d3 = d;
        double d4 = (double)((int)d3) - dArray[0] / 15.0 / 24.0;
        int n6 = n4 = n3 & 7;
        n4 |= 0x800;
        if ((n3 & 0x100) == 0) {
            n4 |= 0x50;
        }
        if (this.sw.swe_calc_ut(d3, 0, n4, dArray4, stringBuffer) == 0) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("error in calc_rise_and_set(): calc(sun) failed ");
            }
            return -1;
        }
        if (this.sw.swe_calc_ut(d3, n, n4, dArray5, stringBuffer) == 0) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("error in calc_rise_and_set(): calc(sun) failed ");
            }
            return -1;
        }
        d4 -= this.sl.swe_degnorm(dArray4[0] - dArray5[0]) / 360.0 + 0.0;
        this.sc.swe_azalt(d3, 1, dArray, dArray2[0], dArray2[1], dArray5, dArray6);
        if ((n2 & 1) != 0) {
            if (dArray6[2] > 0.0) {
                while (d4 - d3 < 0.5) {
                    d4 += 1.0;
                }
                while (d4 - d3 > 1.5) {
                    d4 -= 1.0;
                }
            } else {
                while (d4 - d3 < 0.0) {
                    d4 += 1.0;
                }
                while (d4 - d3 > 1.0) {
                    d4 -= 1.0;
                }
            }
        } else if (dArray6[2] > 0.0) {
            while (d3 - d4 > 0.5) {
                d4 += 1.0;
            }
            while (d3 - d4 < -0.5) {
                d4 -= 1.0;
            }
        } else {
            while (d3 - d4 > 0.0) {
                d4 += 1.0;
            }
            while (d3 - d4 < -1.0) {
                d4 -= 1.0;
            }
        }
        if (this.sw.swe_calc_ut(d4, n, n4, dArray5, stringBuffer) == -1) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("error in calc_rise_and_set(): calc(sun) failed ");
            }
            return -1;
        }
        double d5 = SMath.asin(0.004652472637378737 / dArray5[2]) / 0.0174532925199433;
        if ((n2 & 0x100) != 0) {
            d5 = 0.0;
        }
        double d6 = -(0.575 + d5);
        double d7 = SMath.acos(-SMath.tan(dArray[1] * 0.0174532925199433) * SMath.tan(dArray5[1] * 0.0174532925199433)) * 57.2957795130823;
        double d8 = (n2 & 1) != 0 ? d4 - d7 / 360.0 : d4 + d7 / 360.0;
        n4 = n6 | 0x100 | 0x800;
        if (n == 1) {
            n4 |= 0x8000;
        }
        if ((n3 & 0x100) == 0) {
            n4 |= 0x50;
        }
        for (int i = 0; i < 2; ++i) {
            if (this.sw.swe_calc_ut(d8, n, n4, dArray5, stringBuffer) == -1) {
                return -1;
            }
            this.sc.swe_azalt(d8, 1, dArray, dArray2[0], dArray2[1], dArray5, dArray6);
            dArray5[0] = dArray5[0] - dArray5[3] * d2;
            dArray5[1] = dArray5[1] - dArray5[4] * d2;
            this.sc.swe_azalt(d8 - d2, 1, dArray, dArray2[0], dArray2[1], dArray5, dArray7);
            d8 -= (dArray6[1] - d6) / (dArray6[1] - dArray7[1]) * d2;
        }
        dArray3[0] = d8;
        return n5;
    }

    private int my_rise_trans(double d, int n, String string, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer) {
        int n4 = 0;
        if (string != null && !"".equals(string)) {
            n = this.DeterObject(string);
        }
        n4 = n != -1 && SMath.abs(dArray[1]) < 63.0 ? this.calc_rise_and_set(d, n, dArray, dArray2, n2, n3, dArray3, stringBuffer) : this.call_swe_rise_trans(d, n, string, n3, n2, dArray, dArray2[0], dArray2[1], dArray3, stringBuffer);
        return n4;
    }

    private int RiseSet(double d, double[] dArray, double[] dArray2, String string, int n, int n2, int n3, double[] dArray3, StringBuffer stringBuffer) {
        int n4;
        int n5 = n;
        if (n3 == 0) {
            n5 |= 0x100;
        }
        int n6 = (n4 = this.DeterObject(string)) != -1 ? this.my_rise_trans(d, n4, "", n5, n2, dArray, dArray2, dArray3, stringBuffer) : this.my_rise_trans(d, -1, string, n5, n2, dArray, dArray2, dArray3, stringBuffer);
        return n6;
    }

    private double SunRA(double d, int n, StringBuffer stringBuffer) {
        boolean bl = true;
        if (d == this.sunRA_tjdlast) {
            return this.sunRA_ralast;
        }
        SweDate sweDate = new SweDate(d, bl);
        int n2 = sweDate.getMonth();
        int n3 = sweDate.getDay();
        this.sunRA_tjdlast = d;
        this.sunRA_ralast = this.sl.swe_degnorm(((double)n2 + (double)(n3 - 1) / 30.4 - 3.69) * 30.0);
        return this.sunRA_ralast;
    }

    private double Kelvin(double d) {
        return d + 273.15;
    }

    private double TopoAltfromAppAlt(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        if (d >= -3.5) {
            d4 = d > 17.904104638432 ? 0.97 / SMath.tan(d * 0.0174532925199433) : (34.46 + 4.23 * d + 0.004 * d * d) / (1.0 + 0.505 * d + 0.0845 * d * d);
            d4 = (d3 - 80.0) / 930.0 / (1.0 + 8.0E-5 * (d4 + 39.0) * (d2 - 10.0)) * d4;
            d5 = d - d4 * 0.016666666666666666;
        } else {
            d5 = d;
        }
        return d5;
    }

    private double AppAltfromTopoAlt(double d, double d2, double d3, int n) {
        int n2 = 2;
        double d4 = d;
        double d5 = 0.0;
        double d6 = d4;
        double d7 = d5;
        if ((n & 0x100) != 0) {
            n2 = 5;
        }
        for (int i = 0; i <= n2; ++i) {
            d5 = d4 - this.TopoAltfromAppAlt(d4, d2, d3);
            double d8 = d4 - d6;
            d6 = d5 - d7 - d8;
            d8 = d8 != 0.0 && d6 != 0.0 ? d4 - d8 * (d + d5 - d4) / d6 : d + d5;
            d6 = d4;
            d7 = d5;
            d4 = d8;
        }
        double d9 = d + d5;
        if (d9 < -3.5) {
            d9 = d;
        }
        return d9;
    }

    private double HourAngle(double d, double d2, double d3) {
        double d4 = d * 0.0174532925199433;
        double d5 = d2 * 0.0174532925199433;
        double d6 = d3 * 0.0174532925199433;
        double d7 = (SMath.sin(d4) - SMath.sin(d6) * SMath.sin(d5)) / SMath.cos(d6) / SMath.cos(d5);
        if (d7 < -1.0) {
            d7 = -1.0;
        }
        if (d7 > 1.0) {
            d7 = 1.0;
        }
        return SMath.acos(d7) / 0.0174532925199433 / 15.0;
    }

    private double DeltaTSE(double d, int n) {
        boolean bl = true;
        if (n != 0) {
            double d2 = (SweDate.getJulDay(1820, 1, 1, 0.0, bl) - d) / 365.25;
            return d2 * d2 / 100.0 / 2.0 * (double)n * 365.25 / 1000.0;
        }
        return SweDate.getDeltaT(d) * 86400.0;
    }

    private double DeltaTVR(double d, int n) {
        boolean bl = true;
        double d2 = (SweDate.getJulDay(1820, 1, 1, 0.0, bl) - d) / 365.25;
        double d3 = n == 0 ? (d2 * d2 / 100.0 / 2.0 * 1.80546834626888 + 863.0213265669036 * (SMath.cos(Math.PI * 2 * d2 / 1443.67123144531) - 1.0)) * 365.25 : d2 * d2 / 100.0 / 2.0 * (double)n * 365.25;
        return d3 / 1000.0;
    }

    private double DeltaT(double d, int n) {
        return this.DeltaTSE(d, n);
    }

    private int ObjectLoc(double d, double[] dArray, double[] dArray2, String string, int n, int n2, double[] dArray3, StringBuffer stringBuffer) {
        return this.ObjectLoc(d, dArray, dArray2, new StringBuffer(string), n, n2, dArray3, stringBuffer);
    }

    private int ObjectLoc(double d, double[] dArray, double[] dArray2, StringBuffer stringBuffer, int n, int n2, double[] dArray3, StringBuffer stringBuffer2) {
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        int n3 = 2048;
        int n4 = n2 & 7;
        n3 |= n4;
        if ((n2 & 0x100) == 0) {
            n3 |= 0x50;
        }
        if (n < 5) {
            n3 |= 0x8000;
        }
        if (n == 7) {
            n = 0;
        }
        double d2 = d + this.DeltaT(d, 0) / 86400.0;
        int n5 = this.DeterObject(stringBuffer);
        if (n5 != -1 ? this.sw.swe_calc(d2, n5, n3, dArray4, stringBuffer2) == -1 : this.call_swe_fixstar(stringBuffer, d2, n3, dArray4, stringBuffer2) == -1) {
            return -1;
        }
        if (n == 2 || n == 5) {
            dArray3[0] = dArray4[1];
        } else if (n == 3 || n == 6) {
            dArray3[0] = dArray4[0];
        } else {
            dArray5[0] = dArray4[0];
            dArray5[1] = dArray4[1];
            this.sc.swe_azalt(d, 1, dArray, dArray2[0], dArray2[1], dArray5, dArray6);
            if (n == 0) {
                dArray3[0] = dArray6[1];
            }
            if (n == 4) {
                dArray3[0] = this.AppAltfromTopoAlt(dArray6[1], dArray2[0], dArray2[1], n2);
            }
            if (n == 1) {
                dArray6[0] = dArray6[0] + 180.0;
                if (dArray6[0] >= 360.0) {
                    dArray6[0] = dArray6[0] - 360.0;
                }
                dArray3[0] = dArray6[0];
            }
        }
        return 0;
    }

    private int azalt_cart(double d, double[] dArray, double[] dArray2, StringBuffer stringBuffer, int n, double[] dArray3, StringBuffer stringBuffer2) {
        return this.azalt_cart(d, dArray, dArray2, stringBuffer, n, dArray3, 0, stringBuffer2);
    }

    private int azalt_cart(double d, double[] dArray, double[] dArray2, StringBuffer stringBuffer, int n, double[] dArray3, int n2, StringBuffer stringBuffer2) {
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        int n3 = 2048;
        int n4 = n & 7;
        n3 |= n4;
        if ((n & 0x100) == 0) {
            n3 |= 0x50;
        }
        n3 |= 0x8000;
        double d2 = d + this.DeltaT(d, 0) / 86400.0;
        int n5 = this.DeterObject(stringBuffer);
        if (n5 != -1 ? this.sw.swe_calc(d2, n5, n3, dArray4, stringBuffer2) == -1 : this.call_swe_fixstar(stringBuffer, d2, n3, dArray4, stringBuffer2) == -1) {
            return -1;
        }
        dArray5[0] = dArray4[0];
        dArray5[1] = dArray4[1];
        this.sc.swe_azalt(d, 1, dArray, dArray2[0], dArray2[1], dArray5, dArray6);
        dArray3[n2] = dArray6[0];
        dArray3[1 + n2] = dArray6[1];
        dArray3[2 + n2] = dArray6[2];
        dArray6[1] = dArray6[2];
        dArray6[2] = 1.0;
        this.sl.swi_polcart(dArray6, dArray6);
        dArray3[3 + n2] = dArray6[0];
        dArray3[4 + n2] = dArray6[1];
        dArray3[5 + n2] = dArray6[2];
        return 0;
    }

    private double DistanceAngle(double d, double d2, double d3, double d4) {
        double d5 = d4 - d2;
        double d6 = d3 - d;
        double d7 = SMath.sin(d6 / 2.0);
        double d8 = SMath.sin(d5 / 2.0);
        double d9 = d7 * d7 + SMath.cos(d) * SMath.cos(d3) * d8 * d8;
        if (d9 > 1.0) {
            d9 = 1.0;
        }
        return 2.0 * SMath.asin(SMath.sqrt(d9));
    }

    private double kW(double d, double d2, double d3) {
        double d4 = 0.031;
        return d4 *= 0.94 * (d3 / 100.0) * SMath.exp(d2 / 15.0) * SMath.exp(-1.0 * d / 3000.0);
    }

    private double kOZ(double d, double d2, double d3) {
        if (d == this.koz__alts_last && d2 == this.koz__sunra_last) {
            return this.koz__koz_last;
        }
        this.koz__alts_last = d;
        this.koz__sunra_last = d2;
        double d4 = 0.031;
        double d5 = d3 * 0.0174532925199433;
        double d6 = d4 * (3.0 + 0.4 * (d5 * SMath.cos(d2 * 0.0174532925199433) - SMath.cos(3.0 * d5))) / 3.0;
        double d7 = (100.0 - 11.6 * SMath.min(6.0, SMath.max(-d - 12.0, 0.0))) / 100.0;
        this.koz__koz_last = d6 * d7;
        return this.koz__koz_last;
    }

    private double kR(double d, double d2) {
        double d3 = -d - 12.0;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d3 > 6.0) {
            d3 = 6.0;
        }
        double d4 = 1.0 - 0.166667 * d3;
        double d5 = 0.55 + (d4 - 1.0) * 0.04;
        return 0.1066 * SMath.exp(-1.0 * d2 / 8515.0) * SMath.pow(d5 / 0.55, -4.0);
    }

    private int Sgn(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    private double ka(double d, double d2, double d3, double d4, double d5, double d6, double d7, StringBuffer stringBuffer) {
        double d8;
        double d9 = this.Sgn(d3);
        if (d == this.ka__alts_last && d2 == this.ka__sunra_last) {
            return this.ka__ka_last;
        }
        this.ka__alts_last = d;
        this.ka__sunra_last = d2;
        double d10 = 1.0 - 0.166667 * SMath.min(6.0, SMath.max(-d - 12.0, 0.0));
        double d11 = 0.55 + (d10 - 1.0) * 0.04;
        if (d7 != 0.0) {
            if (d7 >= 1.0) {
                double d12 = 3.912 / d7;
                double d13 = d12 - (this.kW(d4, d5, d6) / 3000.0 + this.kR(d, d4) / 8515.0) * 1000.0 * 0.921034037197618;
                d8 = d13 * 3745.0 / 1000.0 * 1.0857362047581298;
                if (d8 < 0.0 && stringBuffer != null) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("The provided Meteorological range is too long, when taking into acount other atmospheric parameters");
                }
            } else {
                d8 = d7 - this.kW(d4, d5, d6) - this.kR(d, d4) - this.kOZ(d, d2, d3);
                if (d8 < 0.0 && stringBuffer != null) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("The provided atmosphic coeefficent (ktot) is too low, when taking into acount other atmospheric parameters");
                }
            }
        } else {
            if (d6 <= 1.0E-8) {
                d6 = 1.0E-8;
            }
            if (d6 >= 99.99999999) {
                d6 = 99.99999999;
            }
            d8 = 0.1 * SMath.exp(-1.0 * d4 / 3745.0) * SMath.pow(1.0 - 0.32 / SMath.log(d6 / 100.0), 1.33) * (1.0 + 0.33 * d9 * SMath.sin(d2 * 0.0174532925199433));
            d8 *= SMath.pow(d11 / 0.55, -1.3);
        }
        this.ka__ka_last = d8;
        return d8;
    }

    private double kt(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, StringBuffer stringBuffer) {
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (n == 2 || n == 4) {
            d8 = this.kR(d, d4);
        }
        if (n == 1 || n == 4) {
            d9 = this.kW(d4, d5, d6);
        }
        if (n == 3 || n == 4) {
            d10 = this.kOZ(d, d2, d3);
        }
        if (n == 0 || n == 4) {
            d11 = this.ka(d, d2, d3, d4, d5, d6, d7, stringBuffer);
        }
        if (d11 < 0.0) {
            d11 = 0.0;
        }
        return d9 + d8 + d10 + d11;
    }

    private double Airmass(double d, double d2) {
        double d3 = (90.0 - d) * 0.0174532925199433;
        if (d3 > 1.5707963267948966) {
            d3 = 1.5707963267948966;
        }
        double d4 = 1.0 / (SMath.cos(d3) + 0.025 * SMath.exp(-11.0 * SMath.cos(d3)));
        return d2 / 1013.0 * d4;
    }

    private double Xext(double d, double d2, double d3) {
        return d3 / 1013.0 / (SMath.cos(d2) + 0.01 * SMath.sqrt(d / 1000.0) * SMath.exp(-30.0 / SMath.sqrt(d / 1000.0) * SMath.cos(d2)));
    }

    private double Xlay(double d, double d2, double d3) {
        double d4 = SMath.sin(d2) / (1.0 + d / 6378136.6);
        return d3 / 1013.0 / SMath.sqrt(1.0 - d4 * d4);
    }

    private double TempEfromTempS(double d, double d2, double d3) {
        return d - d3 * d2;
    }

    private double PresEfromPresS(double d, double d2, double d3) {
        return d2 * SMath.exp(-0.28404373326 / (this.Kelvin(d) + 3.25 * d3 / 1000.0) / 8.31441 * d3);
    }

    private double Deltam(double d, double d2, double d3, double d4, double d5, double[] dArray, int n, StringBuffer stringBuffer) {
        double d6;
        double d7 = this.PresEfromPresS(dArray[1], dArray[0], d5);
        double d8 = this.TempEfromTempS(dArray[1], d5, 0.0065);
        double d9 = this.AppAltfromTopoAlt(d, d8, d7, n);
        if (d2 == this.Deltam__alts_last && d == this.Deltam__alto_last && d3 == this.Deltam__sunra_last) {
            return this.Deltam__deltam_last;
        }
        this.Deltam__alts_last = d2;
        this.Deltam__alto_last = d;
        this.Deltam__sunra_last = d3;
        double d10 = (90.0 - d9) * 0.0174532925199433;
        if (d10 > 1.5707963267948966) {
            d10 = 1.5707963267948966;
        }
        double d11 = this.Xext(8515.0, d10, dArray[0]);
        double d12 = this.Xext(3000.0, d10, dArray[0]);
        double d13 = this.Xext(3745.0, d10, dArray[0]);
        double d14 = this.Xlay(20000.0, d10, dArray[0]);
        this.Deltam__deltam_last = d6 = this.kR(d2, d5) * d11 + this.kt(d2, d3, d4, d5, dArray[1], dArray[2], dArray[3], 0, stringBuffer) * d13 + this.kOZ(d2, d3, d4) * d14 + this.kW(d5, dArray[1], dArray[2]) * d12;
        return d6;
    }

    private double Bn(double d, double d2, double d3, double d4, double d5, double d6, double[] dArray, int n, StringBuffer stringBuffer) {
        double d7 = this.PresEfromPresS(dArray[1], dArray[0], d6);
        double d8 = this.TempEfromTempS(dArray[1], d6, 0.0065);
        double d9 = this.AppAltfromTopoAlt(d, d8, d7, n);
        double d10 = 1.0E-13;
        if (d9 < 10.0) {
            d9 = 10.0;
        }
        double d11 = (90.0 - d9) * 0.0174532925199433;
        SweDate sweDate = new SweDate(d2, true);
        double d12 = sweDate.getYear();
        double d13 = sweDate.getMonth();
        double d14 = sweDate.getDay();
        double d15 = d10 * (1.0 + 0.3 * SMath.cos(6.283 * (d12 + ((d14 - 1.0) / 30.4 + d13 - 1.0) / 12.0 - 1990.33) / 11.1));
        double d16 = this.Deltam(d, d3, d4, d5, d6, dArray, n, stringBuffer);
        double d17 = d15 * (0.4 + 0.6 / SMath.sqrt(1.0 - 0.96 * SMath.pow(SMath.sin(d11), 2.0))) * SMath.pow(10.0, -0.4 * d16);
        return SMath.max(d17, 0.0) * 9.803921568627451E14;
    }

    private int Magnitude(double d, double[] dArray, StringBuffer stringBuffer, int n, double[] dArray2, int n2, StringBuffer stringBuffer2) {
        double[] dArray3 = new double[20];
        int n3 = n & 7;
        dArray2[n2] = -99.0;
        int n4 = this.DeterObject(stringBuffer);
        int n5 = 0x8800 | n3;
        if ((n & 0x100) == 0) {
            n5 |= 0x50;
        }
        if (n4 != -1) {
            this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
            if (this.sw.swe_pheno_ut(d, n4, n5, dArray3, stringBuffer2) == -1) {
                return -1;
            }
            dArray2[n2] = dArray3[4];
        } else if (this.call_swe_fixstar_mag(stringBuffer, dArray2, n2, stringBuffer2) == -1) {
            return -1;
        }
        return 0;
    }

    private double MoonsBrightness(double d, double d2) {
        double d3 = 2.302585092994;
        return -21.62 + 5.0 * SMath.log(d / 6378.1366) / d3 + 0.026 * SMath.abs(d2) + 4.0E-9 * SMath.pow(d2, 4.0);
    }

    private double MoonPhase(double d, double d2, double d3) {
        double d4 = d * 0.0174532925199433;
        double d5 = d2 * 0.0174532925199433;
        double d6 = d3 * 0.0174532925199433;
        return 180.0 - SMath.acos(SMath.cos(d6 - d5) * SMath.cos(d4 + 0.016580627893946133)) / 0.0174532925199433;
    }

    private double Bm(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double[] dArray, int n, StringBuffer stringBuffer) {
        double d10 = -11.05;
        double d11 = 0.0;
        if (d3 > -0.26) {
            double d12 = this.DistanceAngle(d * 0.0174532925199433, d2 * 0.0174532925199433, d3 * 0.0174532925199433, d4 * 0.0174532925199433) / 0.0174532925199433;
            double d13 = this.Deltam(d3, d5, d7, d8, d9, dArray, n, stringBuffer);
            double d14 = this.Deltam(d, d5, d7, d8, d9, dArray, n, stringBuffer);
            double d15 = SMath.pow(10.0, -0.4 * d13);
            double d16 = 6.2E7 / d12 / d12 + SMath.pow(10.0, 6.15 - d12 / 40.0) + SMath.pow(10.0, 5.36) * (1.06 + SMath.pow(SMath.cos(d12 * 0.0174532925199433), 2.0));
            d11 = d16 * d15 + 440000.0 * (1.0 - d15);
            double d17 = this.MoonPhase(d3, d4, d6);
            double d18 = this.MoonsBrightness(384410.4978, d17);
            d11 *= SMath.pow(10.0, -0.4 * (d18 - d10 + 43.27));
            d11 *= 1.0 - SMath.pow(10.0, -0.4 * d14);
        }
        d11 = SMath.max(d11, 0.0) * 9.803921568627451E14;
        return d11;
    }

    private double Btwi(double d, double d2, double d3, double d4, double d5, double d6, double d7, double[] dArray, int n, StringBuffer stringBuffer) {
        double d8 = -11.05;
        double d9 = -26.74;
        double d10 = this.PresEfromPresS(dArray[1], dArray[0], d7);
        double d11 = this.TempEfromTempS(dArray[1], d7, 0.0065);
        double d12 = this.AppAltfromTopoAlt(d, d11, d10, n);
        double d13 = 90.0 - d12;
        double d14 = this.DistanceAngle(d * 0.0174532925199433, d2 * 0.0174532925199433, d3 * 0.0174532925199433, d4 * 0.0174532925199433) / 0.0174532925199433;
        double d15 = this.Deltam(d, d3, d5, d6, d7, dArray, n, stringBuffer);
        double d16 = this.kt(d3, d5, d6, d7, dArray[1], dArray[2], dArray[3], 4, stringBuffer);
        double d17 = SMath.pow(10.0, -0.4 * (d9 - d8 + 32.5 - d3 - d13 / (360.0 * d16)));
        d17 = d17 * (100.0 / d14) * (1.0 - SMath.pow(10.0, -0.4 * d15));
        d17 = SMath.max(d17, 0.0) * 9.803921568627451E14;
        return d17;
    }

    private double Bday(double d, double d2, double d3, double d4, double d5, double d6, double d7, double[] dArray, int n, StringBuffer stringBuffer) {
        double d8 = -11.05;
        double d9 = -26.74;
        double d10 = this.DistanceAngle(d * 0.0174532925199433, d2 * 0.0174532925199433, d3 * 0.0174532925199433, d4 * 0.0174532925199433) / 0.0174532925199433;
        double d11 = this.Deltam(d3, d3, d5, d6, d7, dArray, n, stringBuffer);
        double d12 = this.Deltam(d, d3, d5, d6, d7, dArray, n, stringBuffer);
        double d13 = SMath.pow(10.0, -0.4 * d11);
        double d14 = 6.2E7 / d10 / d10 + SMath.pow(10.0, 6.15 - d10 / 40.0) + SMath.pow(10.0, 5.36) * (1.06 + SMath.pow(SMath.cos(d10 * 0.0174532925199433), 2.0));
        double d15 = d14 * d13 + 440000.0 * (1.0 - d13);
        d15 *= SMath.pow(10.0, -0.4 * (d9 - d8 + 43.27));
        d15 *= 1.0 - SMath.pow(10.0, -0.4 * d12);
        d15 = SMath.max(d15, 0.0) * 9.803921568627451E14;
        return d15;
    }

    private double Bcity(double d, double d2) {
        double d3 = d;
        d3 = SMath.max(d3, 0.0);
        return d3;
    }

    private double Bsky(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double[] dArray, int n, StringBuffer stringBuffer) {
        double d11 = 0.0;
        d11 = d6 < -3.0 ? (d11 += this.Btwi(d, d2, d6, d7, d8, d9, d10, dArray, n, stringBuffer)) : (d6 > 4.0 ? (d11 += this.Bday(d, d2, d6, d7, d8, d9, d10, dArray, n, stringBuffer)) : (d11 += SMath.min(this.Bday(d, d2, d6, d7, d8, d9, d10, dArray, n, stringBuffer), this.Btwi(d, d2, d6, d7, d8, d9, d10, dArray, n, stringBuffer))));
        if (d11 < 2.0E8) {
            d11 += this.Bm(d, d2, d3, d4, d6, d7, d8, d9, d10, dArray, n, stringBuffer);
        }
        if (d6 <= 0.0) {
            d11 += this.Bcity(0.0, dArray[0]);
        }
        if (d11 < 5000.0) {
            d11 += this.Bn(d, d5, d6, d8, d9, d10, dArray, n, stringBuffer);
        }
        return d11;
    }

    private void default_heliacal_parameters(double[] dArray, double[] dArray2, double[] dArray3, int n) {
        if (dArray[0] <= 0.0) {
            dArray[0] = 1013.25 * SMath.pow(1.0 - 0.0065 * dArray2[2] / 288.0, 5.255);
            if (dArray[1] == 0.0) {
                dArray[1] = 15.0 - 0.0065 * dArray2[2];
            }
            if (dArray[2] == 0.0) {
                dArray[2] = 40.0;
            }
        }
        if (dArray3[0] == 0.0) {
            dArray3[0] = 36.0;
        }
        if (dArray3[1] == 0.0) {
            dArray3[1] = 1.0;
        }
        if ((n & 0x200) == 0) {
            for (int i = 2; i <= 5; ++i) {
                dArray3[i] = 0.0;
            }
        }
        if (dArray3[3] == 0.0) {
            dArray3[2] = 1.0;
            dArray3[3] = 1.0;
        }
    }

    private double VisLimMagn(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double[] dArray2, int n, int[] nArray, StringBuffer stringBuffer) {
        double d11;
        double d12;
        double d13 = 2.302585092994;
        double d14 = this.Bsky(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, dArray2, n, stringBuffer);
        double d15 = this.Deltam(d, d6, d8, d9, d10, dArray2, n, stringBuffer);
        double d16 = this.OpticFactor(d14, d15, dArray, d5, "", 1, n);
        double d17 = this.OpticFactor(d14, d15, dArray, d5, "", 0, n);
        if (d14 < 1479.0 && (n & 0x4000) == 0) {
            d12 = 1.5848931924611E-10;
            d11 = 0.012589254117942;
            if (nArray != null) {
                nArray[0] = 1;
            }
        } else {
            d12 = 4.4668359215096E-9;
            d11 = 1.2589254117942E-6;
            if (nArray != null) {
                nArray[0] = 0;
            }
        }
        if (nArray != null && 1479.0 > d14 && 1479.0 < d14) {
            nArray[0] = nArray[0] | 2;
        }
        double d18 = d12 * SMath.pow(1.0 + SMath.sqrt(d11 * (d14 /= d16)), 2.0) * d17;
        return -16.57 - 2.5 * (SMath.log(d18) / d13);
    }

    public int swe_vis_limit_mag(double d, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, double[] dArray4, StringBuffer stringBuffer2) {
        int n2 = 0;
        int[] nArray = new int[]{0};
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        double[] dArray8 = new double[1];
        double[] dArray9 = new double[1];
        double[] dArray10 = new double[1];
        SweDate.swi_set_tid_acc(d, n, 0);
        double d2 = this.SunRA(d, n, stringBuffer2);
        this.default_heliacal_parameters(dArray2, dArray, dArray3, n);
        this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
        for (int i = 0; i < 7; ++i) {
            dArray4[i] = 0.0;
        }
        if (this.ObjectLoc(d, dArray, dArray2, stringBuffer, 0, n, dArray5, stringBuffer2) == -1) {
            return -1;
        }
        if (dArray5[0] < 0.0 && stringBuffer2 != null) {
            stringBuffer2.setLength(0);
            stringBuffer2.append("object is below local horizon");
            dArray4[0] = -100.0;
            return -2;
        }
        if (this.ObjectLoc(d, dArray, dArray2, stringBuffer, 1, n, dArray6, stringBuffer2) == -1) {
            return -1;
        }
        if ((n & 0x1000) != 0) {
            dArray9[0] = -90.0;
            dArray10[0] = 0.0;
        } else {
            if (this.ObjectLoc(d, dArray, dArray2, "sun", 0, n, dArray9, stringBuffer2) == -1) {
                return -1;
            }
            if (this.ObjectLoc(d, dArray, dArray2, "sun", 1, n, dArray10, stringBuffer2) == -1) {
                return -1;
            }
        }
        if (stringBuffer.toString().startsWith("moon") || (n & 0x1000) != 0 || (n & 0x2000) != 0) {
            dArray7[0] = -90.0;
            dArray8[0] = 0.0;
        } else {
            if (this.ObjectLoc(d, dArray, dArray2, "moon", 0, n, dArray7, stringBuffer2) == -1) {
                return -1;
            }
            if (this.ObjectLoc(d, dArray, dArray2, "moon", 1, n, dArray8, stringBuffer2) == -1) {
                return -1;
            }
        }
        dArray4[0] = this.VisLimMagn(dArray3, dArray5[0], dArray6[0], dArray7[0], dArray8[0], d, dArray9[0], dArray10[0], d2, dArray[1], dArray[2], dArray2, n, nArray, stringBuffer2);
        dArray4[1] = dArray5[0];
        dArray4[2] = dArray6[0];
        dArray4[3] = dArray9[0];
        dArray4[4] = dArray10[0];
        dArray4[5] = dArray7[0];
        dArray4[6] = dArray8[0];
        if (this.Magnitude(d, dArray, stringBuffer, n, dArray4, 7, stringBuffer2) == -1) {
            return -1;
        }
        n2 = nArray[0];
        return n2;
    }

    private int TopoArcVisionis(double d, double[] dArray, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double[] dArray2, int n, double[] dArray3, StringBuffer stringBuffer) {
        double d11;
        double d12;
        double d13 = 0.0;
        double d14 = 45.0;
        double d15 = d - this.VisLimMagn(dArray, d2, d3, d4, d5, d6, d2 - d14, d7, d8, d9, d10, dArray2, n, null, stringBuffer);
        if (d15 * (d12 = d - this.VisLimMagn(dArray, d2, d3, d4, d5, d6, d2 - d13, d7, d8, d9, d10, dArray2, n, null, stringBuffer)) <= 0.0) {
            while (SMath.abs(d13 - d14) > 0.001) {
                d11 = (d13 + d14) / 2.0;
                double d16 = d2 - d11;
                double d17 = d7;
                double d18 = d - this.VisLimMagn(dArray, d2, d3, d4, d5, d6, d16, d17, d8, d9, d10, dArray2, n, null, stringBuffer);
                if (d15 * d18 > 0.0) {
                    d14 = d11;
                    d15 = d18;
                    continue;
                }
                d13 = d11;
                d12 = d18;
            }
            d11 = (d13 + d14) / 2.0;
        } else {
            d11 = 99.0;
        }
        if (d11 < d2) {
            d11 = d2;
        }
        dArray3[0] = d11;
        return 0;
    }

    public int swe_topo_arcus_visionis(double d, double[] dArray, double[] dArray2, double[] dArray3, int n, double d2, double d3, double d4, double d5, double d6, double d7, double[] dArray4, StringBuffer stringBuffer) {
        SweDate.swi_set_tid_acc(d, n, 0);
        double d8 = this.SunRA(d, n, stringBuffer);
        if (stringBuffer != null && stringBuffer.length() > 0) {
            return -1;
        }
        return this.TopoArcVisionis(d2, dArray3, d4, d3, d7, d6, d, d5, d8, dArray[1], dArray[2], dArray2, n, dArray4, stringBuffer);
    }

    private int HeliacalAngle(double d, double[] dArray, double d2, double d3, double d4, double d5, double d6, double[] dArray2, double[] dArray3, int n, double[] dArray4, StringBuffer stringBuffer) {
        double d7;
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        double[] dArray8 = new double[1];
        double[] dArray9 = new double[1];
        double d8 = this.SunRA(d5, n, stringBuffer);
        double d9 = dArray2[1];
        double d10 = dArray2[2];
        double d11 = 2.0;
        double d12 = 20.0;
        double d13 = 0.0;
        double d14 = 10000.0;
        for (double d15 = d11; d15 <= d12; d15 += 1.0) {
            if (this.TopoArcVisionis(d, dArray, d15, d2, d3, d4, d5, d6, d8, d9, d10, dArray3, n, dArray9, stringBuffer) == -1) {
                return -1;
            }
            if (!(dArray9[0] < d14)) continue;
            d14 = dArray9[0];
            d13 = d15;
        }
        double d16 = d13 - 1.0;
        double d17 = d13 + 1.0;
        if (this.TopoArcVisionis(d, dArray, d17, d2, d3, d4, d5, d6, d8, d9, d10, dArray3, n, dArray5, stringBuffer) == -1) {
            return -1;
        }
        if (this.TopoArcVisionis(d, dArray, d16, d2, d3, d4, d5, d6, d8, d9, d10, dArray3, n, dArray6, stringBuffer) == -1) {
            return -1;
        }
        while (SMath.abs(d17 - d16) > 0.1) {
            d7 = (d17 + d16) / 2.0;
            double d18 = 0.025;
            double d19 = d7 + d18;
            if (this.TopoArcVisionis(d, dArray, d7, d2, d3, d4, d5, d6, d8, d9, d10, dArray3, n, dArray7, stringBuffer) == -1) {
                return -1;
            }
            if (this.TopoArcVisionis(d, dArray, d19, d2, d3, d4, d5, d6, d8, d9, d10, dArray3, n, dArray8, stringBuffer) == -1) {
                return -1;
            }
            if (dArray7[0] >= dArray8[0]) {
                d16 = d7;
                dArray6[0] = dArray7[0];
                continue;
            }
            d17 = d7;
            dArray5[0] = dArray7[0];
        }
        d7 = (d17 + d16) / 2.0;
        dArray7[0] = (dArray5[0] + dArray6[0]) / 2.0;
        dArray4[1] = dArray7[0];
        dArray4[2] = d7 - dArray7[0];
        dArray4[0] = d7;
        return 0;
    }

    public int swe_heliacal_angle(double d, double[] dArray, double[] dArray2, double[] dArray3, int n, double d2, double d3, double d4, double d5, double d6, double[] dArray4, StringBuffer stringBuffer) {
        if (dArray[2] < -500.0 || dArray[2] > 25000.0) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append(String.format(Locale.US, "location for heliacal events must be between %.0f and %.0f m above sea", -500.0, 25000.0));
            }
            return -1;
        }
        SweDate.swi_set_tid_acc(d, n, 0);
        return this.HeliacalAngle(d2, dArray3, d3, d6, d5, d, d4, dArray, dArray2, n, dArray4, stringBuffer);
    }

    private double WidthMoon(double d, double d2, double d3, double d4, double d5) {
        double d6 = d + d5;
        return 0.27245 * d5 * (1.0 + SMath.sin(d6 * 0.0174532925199433) * SMath.sin(d5 * 0.0174532925199433)) * (1.0 - SMath.cos((d3 - d6) * 0.0174532925199433) * SMath.cos((d4 - d2) * 0.0174532925199433));
    }

    private double LengthMoon(double d, double d2) {
        if (d2 == 0.0) {
            d2 = 0.5180333333333333;
        }
        double d3 = d * 60.0;
        double d4 = d2 * 60.0;
        return (d4 - 0.3 * (d4 + d3) / 2.0 / d3) / 60.0;
    }

    private double qYallop(double d, double d2) {
        double d3 = d * 60.0;
        return (d2 - (11.8371 - 6.3226 * d3 + 0.7319 * d3 * d3 - 0.1018 * d3 * d3 * d3)) / 10.0;
    }

    private double crossing(double d, double d2, double d3, double d4) {
        return (d3 - d) / (d2 - d - (d4 - d3));
    }

    private int DeterTAV(double[] dArray, double d, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, double[] dArray4, StringBuffer stringBuffer2) {
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        double[] dArray8 = new double[1];
        double[] dArray9 = new double[1];
        double[] dArray10 = new double[1];
        double d2 = this.SunRA(d, n, stringBuffer2);
        if (this.Magnitude(d, dArray2, stringBuffer, n, dArray5, 0, stringBuffer2) == -1) {
            return -1;
        }
        if (this.ObjectLoc(d, dArray2, dArray3, stringBuffer, 0, n, dArray6, stringBuffer2) == -1) {
            return -1;
        }
        if (this.ObjectLoc(d, dArray2, dArray3, stringBuffer, 1, n, dArray8, stringBuffer2) == -1) {
            return -1;
        }
        if (stringBuffer.toString().startsWith("moon")) {
            dArray10[0] = -90.0;
            dArray9[0] = 0.0;
        } else {
            if (this.ObjectLoc(d, dArray2, dArray3, "moon", 0, n, dArray10, stringBuffer2) == -1) {
                return -1;
            }
            if (this.ObjectLoc(d, dArray2, dArray3, "moon", 1, n, dArray9, stringBuffer2) == -1) {
                return -1;
            }
        }
        if (this.ObjectLoc(d, dArray2, dArray3, "sun", 1, n, dArray7, stringBuffer2) == -1) {
            return -1;
        }
        if (this.TopoArcVisionis(dArray5[0], dArray, dArray6[0], dArray8[0], dArray10[0], dArray9[0], d, dArray7[0], d2, dArray2[1], dArray2[2], dArray3, n, dArray4, stringBuffer2) == -1) {
            return -1;
        }
        return 0;
    }

    private double x2min(double d, double d2, double d3) {
        double d4 = d + d3 - 2.0 * d2;
        if (d4 == 0.0) {
            return 0.0;
        }
        return -(d - d3) / 2.0 / d4;
    }

    private double funct2(double d, double d2, double d3, double d4) {
        return (d + d3 - 2.0 * d2) / 2.0 * d4 * d4 + (d - d3) / 2.0 * d4 + d2;
    }

    private void strcpy_VBsafe(StringBuffer stringBuffer, String string) {
        stringBuffer.setLength(0);
        for (int i = 0; i < Math.min(string.length(), 30); ++i) {
            stringBuffer.append(string.charAt(i));
        }
    }

    public int swe_heliacal_pheno_ut(double d, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, int n2, double[] dArray4, StringBuffer stringBuffer2) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        double[] dArray8 = new double[1];
        double[] dArray9 = new double[1];
        double[] dArray10 = new double[1];
        double[] dArray11 = new double[1];
        double[] dArray12 = new double[1];
        double d9 = 0.0;
        double[] dArray13 = new double[1];
        double[] dArray14 = new double[1];
        double[] dArray15 = new double[1];
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double[] dArray16 = new double[30];
        double[] dArray17 = new double[1];
        int n3 = 0;
        boolean bl = false;
        StringBuffer stringBuffer3 = new StringBuffer();
        int n4 = n2 & 7;
        if (dArray[2] < -500.0 || dArray[2] > 25000.0) {
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append(String.format(Locale.US, "location for heliacal events must be between %.0f and %.0f m above sea", -500.0, 25000.0));
            }
            return -1;
        }
        SweDate.swi_set_tid_acc(d, n2, 0);
        double d13 = this.SunRA(d, n2, stringBuffer2);
        this.strcpy_VBsafe(stringBuffer3, stringBuffer.toString());
        this.default_heliacal_parameters(dArray2, dArray, dArray3, n2);
        this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
        n3 = this.ObjectLoc(d, dArray, dArray2, "sun", 1, n2, dArray5, stringBuffer2);
        if (n3 == 0) {
            n3 = this.ObjectLoc(d, dArray, dArray2, "sun", 0, n2, dArray6, stringBuffer2);
        }
        if (n3 == 0) {
            n3 = this.ObjectLoc(d, dArray, dArray2, stringBuffer3, 1, n2, dArray8, stringBuffer2);
        }
        if (n3 == 0) {
            n3 = this.ObjectLoc(d, dArray, dArray2, stringBuffer3, 0, n2, dArray9, stringBuffer2);
        }
        if (n3 == 0) {
            n3 = this.ObjectLoc(d, dArray, dArray2, stringBuffer3, 7, n2, dArray11, stringBuffer2);
        }
        if (n3 == -1) {
            return -1;
        }
        double d14 = this.AppAltfromTopoAlt(dArray9[0], dArray2[1], dArray2[0], n2);
        double d15 = dArray5[0] - dArray8[0];
        double d16 = dArray9[0] - dArray6[0];
        double d17 = dArray11[0] - dArray9[0];
        if (this.Magnitude(d, dArray, stringBuffer3, n2, dArray12, 0, stringBuffer2) == -1) {
            return -1;
        }
        double d18 = d16 + d17;
        double d19 = SMath.acos(SMath.cos(d18 * 0.0174532925199433) * SMath.cos(d15 * 0.0174532925199433)) / 0.0174532925199433;
        int n5 = this.DeterObject(stringBuffer3);
        if (n5 == -1) {
            d8 = d19;
            d7 = 100.0;
        } else {
            n3 = this.sw.swe_pheno_ut(d, n5, n4 | 0x8800, dArray16, stringBuffer2);
            if (n3 == -1) {
                return -1;
            }
            d8 = dArray16[2];
            d7 = dArray16[1] * 100.0;
        }
        double d20 = this.kt(dArray6[0], d13, dArray[1], dArray[2], dArray2[1], dArray2[2], dArray2[3], 4, stringBuffer2);
        double d21 = 0.0;
        double d22 = 0.0;
        double d23 = 0.0;
        d9 = 0.0;
        if (n5 == 1) {
            d21 = this.WidthMoon(dArray9[0], dArray8[0], dArray6[0], dArray5[0], d17);
            d9 = this.LengthMoon(d21, 0.0);
            d22 = this.qYallop(d21, d18);
            if (d22 > 0.216) {
                d23 = 1.0;
            }
            if (d22 < 0.216 && d22 > -0.014) {
                d23 = 2.0;
            }
            if (d22 < -0.014 && d22 > -0.16) {
                d23 = 3.0;
            }
            if (d22 < -0.16 && d22 > -0.232) {
                d23 = 4.0;
            }
            if (d22 < -0.232 && d22 > -0.293) {
                d23 = 5.0;
            }
            if (d22 < -0.293) {
                d23 = 6.0;
            }
        }
        int n6 = 2;
        if (n == 1 || n == 4) {
            n6 = 1;
        }
        if ((n3 = this.RiseSet(d - 0.16666666666666666, dArray, dArray2, "sun", n6, n2, 0, dArray14, stringBuffer2)) == -1) {
            return -1;
        }
        n3 = this.RiseSet(d - 0.16666666666666666, dArray, dArray2, stringBuffer3.toString(), n6, n2, 0, dArray13, stringBuffer2);
        if (n3 == -1) {
            return -1;
        }
        double d24 = 9.9999999E7;
        if (n3 == -2) {
            d6 = 0.0;
            bl = true;
        } else {
            d6 = dArray13[0] - dArray14[0];
            if (n5 == 1) {
                d24 = (dArray13[0] * 4.0 + dArray14[0] * 5.0) / 9.0;
            }
        }
        if (!(n != 3 && n != 4 || n5 != -1 && n5 < 4)) {
            d5 = 9.9999999E7;
            d4 = 9.9999999E7;
            d3 = 9.9999999E7;
            d2 = 0.0;
            d10 = 0.0;
            this.goto_output_heliacal_pheno(dArray4, dArray9, d14, dArray11, dArray8, dArray6, dArray5, d16, d18, d15, d19, d20, d10, d5, d4, d3, d24, d21, d22, d23, d17, dArray12, dArray13, dArray14, d6, d2, d9, d8, d7);
        }
        dArray15[0] = 199.0;
        double d25 = 0.0;
        double d26 = 0.0;
        double d27 = 0.0;
        double d28 = 0.0;
        d4 = 0.0;
        double d29 = -6.944444444444444E-4;
        if (n6 == 2) {
            d29 = -d29;
        }
        double d30 = dArray14[0] - d29;
        do {
            double d31;
            d26 = d11;
            d11 = dArray15[0];
            d12 = d25;
            n3 = this.ObjectLoc(d30 += d29, dArray, dArray2, "sun", 0, n2, dArray7, stringBuffer2);
            if (n3 == 0) {
                n3 = this.ObjectLoc(d30, dArray, dArray2, stringBuffer3, 0, n2, dArray10, stringBuffer2);
            }
            if (n3 != 0) {
                return -1;
            }
            d25 = dArray10[0] - dArray7[0];
            if (this.DeterTAV(dArray3, d30, dArray, dArray2, stringBuffer3, n2, dArray15, stringBuffer2) == -1) {
                return -1;
            }
            if (d11 < dArray15[0] && d4 == 0.0) {
                double d32 = d30 + (double)(this.Sgn(d29) * 8) / 24.0 / 60.0;
                if (dArray13[0] != 0.0) {
                    d32 = d29 > 0.0 ? SMath.min(d32, dArray13[0]) : SMath.max(d32, dArray13[0]);
                }
                if (this.DeterTAV(dArray3, d32, dArray, dArray2, stringBuffer3, n2, dArray17, stringBuffer2) == -1) {
                    return -1;
                }
                if (dArray17[0] > dArray15[0]) {
                    double d33 = this.x2min(dArray15[0], d11, d26);
                    d4 = d30 - (1.0 - d33) * d29;
                    d10 = this.funct2(dArray15[0], d11, d26, d33);
                }
            }
            if (d25 > dArray15[0] && d28 == 0.0 && d4 == 0.0) {
                d31 = this.crossing(d12, d25, d11, dArray15[0]);
                d28 = d30 - d29 * (1.0 - d31);
            }
            if (!(d25 < dArray15[0]) || d27 != 0.0 || d28 == 0.0) continue;
            d31 = this.crossing(d12, d25, d11, dArray15[0]);
            d27 = d30 - d29 * (1.0 - d31);
        } while (SMath.abs(d30 - dArray14[0]) <= 0.16666666666666666 && d27 == 0.0 && (d4 == 0.0 || n != 3 && n != 4 || stringBuffer3.toString().startsWith("moon") || stringBuffer3.toString().startsWith("venus") || stringBuffer3.toString().startsWith("mercury")));
        if (n6 == 2) {
            d5 = d28;
            d3 = d27;
        } else {
            d5 = d27;
            d3 = d28;
        }
        if (d5 == 0.0 && d3 == 0.0) {
            if (n6 == 1) {
                d5 = d4 - 1.0E-6;
            } else {
                d3 = d4 + 1.0E-6;
            }
        }
        if (!bl) {
            if (n6 == 1) {
                d5 = SMath.max(d5, dArray13[0]);
            } else {
                d3 = SMath.min(d3, dArray13[0]);
            }
        }
        d2 = 9.9999999E7;
        if (d3 != 0.0 && d5 != 0.0) {
            d2 = d3 - d5;
        }
        if (d3 == 0.0) {
            d3 = 9.9999999E7;
        }
        if (d4 == 0.0) {
            d4 = 9.9999999E7;
        }
        if (d5 == 0.0) {
            d5 = 9.9999999E7;
        }
        this.goto_output_heliacal_pheno(dArray4, dArray9, d14, dArray11, dArray8, dArray6, dArray5, d16, d18, d15, d19, d20, d10, d5, d4, d3, d24, d21, d22, d23, d17, dArray12, dArray13, dArray14, d6, d2, d9, d8, d7);
        return 0;
    }

    private void goto_output_heliacal_pheno(double[] dArray, double[] dArray2, double d, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double[] dArray7, double[] dArray8, double[] dArray9, double d16, double d17, double d18, double d19, double d20) {
        dArray[0] = dArray2[0];
        dArray[1] = d;
        dArray[2] = dArray3[0];
        dArray[3] = dArray4[0];
        dArray[4] = dArray5[0];
        dArray[5] = dArray6[0];
        dArray[6] = d2;
        dArray[7] = d3;
        dArray[8] = d4;
        dArray[9] = d5;
        dArray[10] = d6;
        dArray[11] = d7;
        dArray[12] = d8;
        dArray[13] = d9;
        dArray[14] = d10;
        dArray[15] = d11;
        dArray[16] = d12;
        dArray[17] = d13;
        dArray[18] = d14;
        dArray[19] = d15;
        dArray[20] = dArray7[0];
        dArray[21] = dArray8[0];
        dArray[22] = dArray9[0];
        dArray[23] = d16;
        dArray[24] = d17;
        dArray[25] = d18;
        dArray[26] = d19;
        dArray[27] = d20;
    }

    private double get_synodic_period(int n) {
        switch (n) {
            case 1: {
                return 29.530588853;
            }
            case 2: {
                return 115.8775;
            }
            case 3: {
                return 583.9214;
            }
            case 4: {
                return 779.9361;
            }
            case 5: {
                return 398.884;
            }
            case 6: {
                return 378.0919;
            }
            case 7: {
                return 369.656;
            }
            case 8: {
                return 367.4867;
            }
            case 9: {
                return 366.7207;
            }
        }
        return 366.0;
    }

    private int moon_event_arc_vis(double d, double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, double[] dArray4, StringBuffer stringBuffer) {
        double d2;
        double d3;
        double d4;
        double[] dArray5 = new double[20];
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        double[] dArray8 = new double[1];
        double[] dArray9 = new double[1];
        double[] dArray10 = new double[1];
        double d5 = 90.0;
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = n2 & 0x78000;
        int n4 = n2 & 7;
        dArray4[0] = d;
        if (n3 == 0) {
            n3 = 32768;
        }
        if (n3 != 32768) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("error: in valid AV kind for the moon");
            }
            return -1;
        }
        if (n == 1 || n == 2) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("error: the moon has no morning first or evening last");
            }
            return -1;
        }
        stringBuffer2.append("moon");
        int n5 = 1;
        int n6 = 0x8800 | n4;
        if ((n2 & 0x100) == 0) {
            n6 |= 0x50;
        }
        int n7 = 1;
        if (n == 3) {
            n = 2;
        } else {
            n = 1;
            n7 = -n7;
        }
        double d6 = d;
        if (n == 1) {
            d6 += 30.0;
        }
        this.sw.swe_pheno_ut(d6, n5, n6, dArray5, stringBuffer);
        double d7 = dArray5[0];
        boolean bl = false;
        do {
            d4 = d7;
            this.sw.swe_pheno_ut(d6 += (double)n7, n5, n6, dArray5, stringBuffer);
            d7 = dArray5[0];
            if (!(d7 > d4)) continue;
            bl = true;
        } while (!bl || bl && d7 > d4);
        double d8 = d6 -= (double)n7;
        d6 -= (double)n7;
        double d9 = 199.0;
        do {
            int n8;
            if ((n8 = this.RiseSet(d6 += (double)n7, dArray, dArray2, stringBuffer2.toString(), n, n2, 0, dArray7, stringBuffer)) != 0) {
                return n8;
            }
            double d10 = dArray7[0];
            dArray6[0] = 199.0;
            d2 = dArray6[0];
            do {
                d2 = d9;
                d9 = dArray6[0];
                d3 = d5;
                dArray7[0] = dArray7[0] - 6.944444444444445E-4 * (double)this.Sgn(n7);
                if (this.ObjectLoc(dArray7[0], dArray, dArray2, "sun", 0, n2, dArray9, stringBuffer) == -1) {
                    return -1;
                }
                if (this.ObjectLoc(dArray7[0], dArray, dArray2, stringBuffer2, 0, n2, dArray10, stringBuffer) == -1) {
                    return -1;
                }
                d5 = dArray10[0] - dArray9[0];
                if (this.DeterTAV(dArray3, dArray7[0], dArray, dArray2, stringBuffer2, n2, dArray6, stringBuffer) == -1) {
                    return -1;
                }
                double d11 = dArray7[0] - 0.005555555555555556 * (double)this.Sgn(n7);
                if (this.DeterTAV(dArray3, d11, dArray, dArray2, stringBuffer2, n2, dArray8, stringBuffer) != -1) continue;
                return -1;
            } while ((dArray6[0] <= d9 || dArray8[0] < dArray6[0]) && SMath.abs(dArray7[0] - d10) < 0.08333333333333333);
        } while (d3 < d9 && SMath.abs(d6 - d8) < 15.0);
        if (!(SMath.abs(d6 - d8) < 15.0)) {
            stringBuffer.setLength(0);
            stringBuffer.append("no date found for lunar event");
            return -1;
        }
        dArray7[0] = dArray7[0] + (1.0 - this.x2min(dArray6[0], d9, d2)) * (double)this.Sgn(n7) / 60.0 / 24.0;
        dArray4[0] = dArray7[0];
        return 0;
    }

    private int heliacal_ut_arc_vis(double d, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, int n2, double[] dArray4, StringBuffer stringBuffer2) {
        double d2;
        double d3;
        double d4;
        double d5;
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[2];
        double[] dArray7 = new double[2];
        double[] dArray8 = new double[3];
        double[] dArray9 = new double[]{0.0};
        double[] dArray10 = new double[1];
        double d6 = d;
        double[] dArray11 = new double[1];
        double[] dArray12 = new double[1];
        double[] dArray13 = new double[1];
        double d7 = 0.0;
        int n3 = 0;
        int n4 = n;
        StringBuffer stringBuffer3 = new StringBuffer();
        dArray4[0] = d;
        int n5 = this.DeterObject(stringBuffer);
        double d8 = dArray2[0];
        double d9 = dArray2[1];
        n3 = this.Magnitude(d, dArray, stringBuffer, n2, dArray9, 0, stringBuffer3);
        if (n3 == -1) {
            return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
        }
        int n6 = n2 & 7;
        int n7 = 0x8800 | n6;
        if ((n2 & 0x100) == 0) {
            n7 |= 0x50;
        }
        switch (n5) {
            case 2: {
                d5 = 1.0;
                d4 = 100.0;
                break;
            }
            case 3: {
                d5 = 64.0;
                d4 = 384.0;
                break;
            }
            case 4: {
                d5 = 128.0;
                d4 = 640.0;
                break;
            }
            case 5: {
                d5 = 64.0;
                d4 = 384.0;
                break;
            }
            case 6: {
                d5 = 64.0;
                d4 = 256.0;
                break;
            }
            default: {
                d5 = 64.0;
                d4 = 256.0;
            }
        }
        int n8 = n4;
        if (n8 == 2) {
            d5 = -d5;
        }
        if (n8 == 4) {
            n8 = 1;
            d5 = -d5;
        }
        if (n8 == 3) {
            n8 = 2;
        }
        n8 |= 0x100;
        double d10 = d;
        double d11 = d10 + d4;
        d10 -= 1.0;
        if (d5 < 0.0) {
            double d12 = d10;
            d10 = d11;
            d11 = d12;
        }
        double d13 = d10 - d5;
        boolean bl = false;
        double d14 = 199.0;
        double d15 = -5.55;
        do {
            double d16;
            double d17;
            if (SMath.abs(d5) == 1.0) {
                bl = true;
            }
            do {
                d16 = d13;
                d17 = d14;
                n3 = this.my_rise_trans(d13 += d5, 0, "", n8, n2, dArray, dArray2, dArray10, stringBuffer3);
                if (n3 == -1) {
                    return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
                }
                d3 = dArray10[0] + this.DeltaT(dArray10[0], 0) / 86400.0;
                n3 = this.sw.swe_calc(d3, 0, n7, dArray5, stringBuffer3);
                if (n3 == -1) {
                    return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
                }
                dArray6[0] = dArray5[0];
                dArray6[1] = dArray5[1];
                this.sc.swe_azalt(dArray10[0], 1, dArray, d8, d9, dArray6, dArray7);
                double d18 = this.HourAngle(dArray7[1], dArray5[1], dArray[1]);
                double d19 = d15;
                if ((n2 & 0x20000) != 0) {
                    d19 = -7.0;
                }
                if ((n2 & 0x40000) != 0) {
                    d19 = -9.0;
                }
                double d20 = this.HourAngle(d19, dArray5[1], dArray[1]);
                double d21 = d20 - d18;
                if (n4 == 2 || n4 == 3) {
                    d21 = -d21;
                }
                if ((n3 = this.sw.swe_calc(d3 = (d2 = dArray10[0] - d21 / 24.0) + this.DeltaT(d2, 0) / 86400.0, 0, n7, dArray5, stringBuffer3)) == -1) {
                    return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
                }
                dArray6[0] = dArray5[0];
                dArray6[1] = dArray5[1];
                this.sc.swe_azalt(d2, 1, dArray, d8, d9, dArray6, dArray7);
                double d22 = dArray7[0] + 180.0;
                if (d22 >= 360.0) {
                    d22 -= 360.0;
                }
                double d23 = dArray7[1];
                if (n5 != -1) {
                    n3 = this.sw.swe_calc(d3, n5, n7, dArray5, stringBuffer3);
                    if (n3 == -1) {
                        return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
                    }
                    n3 = this.Magnitude(d2, dArray, stringBuffer, n2, dArray9, 0, stringBuffer3);
                    if (n3 == -1) {
                        return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
                    }
                } else {
                    n3 = this.call_swe_fixstar(stringBuffer, d3, n7, dArray5, stringBuffer3);
                    if (n3 == -1) {
                        return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
                    }
                }
                dArray6[0] = dArray5[0];
                dArray6[1] = dArray5[1];
                this.sc.swe_azalt(d2, 1, dArray, d8, d9, dArray6, dArray7);
                double d24 = dArray7[0] + 180.0;
                if (d24 >= 360.0) {
                    d24 -= 360.0;
                }
                double d25 = dArray7[1];
                double d26 = d25 - d23;
                n3 = this.HeliacalAngle(dArray9[0], dArray3, d24, -1.0, 0.0, d2, d22, dArray, dArray2, n2, dArray8, stringBuffer3);
                if (n3 == -1) {
                    return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
                }
                double d27 = dArray8[1];
                d15 = dArray8[2];
                d14 = d26 - d27;
            } while ((d17 > 0.0 || d14 < 0.0) && (d11 - d13) * (double)this.Sgn(d5) > 0.0);
            if (bl || !((d11 - d13) * (double)this.Sgn(d5) > 0.0)) continue;
            d14 = d17;
            d5 = (int)(SMath.abs(d5) / 2.0) * this.Sgn(d5);
            d13 = d16;
        } while (!bl && (d11 - d13) * (double)this.Sgn(d5) > 0.0);
        double d28 = (d11 - d13) * (double)this.Sgn(d5);
        if (d28 <= 0.0 || d28 >= d4) {
            dArray4[0] = d6;
            n3 = -2;
            stringBuffer3.setLength(0);
            stringBuffer3.append("heliacal event not found within maxlength " + d4 + "\n");
            return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
        }
        double d29 = 6.944444444444444E-4;
        if (d5 < 0.0) {
            d29 = -d29;
        }
        if ((n2 & 0x8000) != 0) {
            double d30 = d29;
            d7 = 0.0;
            double d31 = d2;
            if (this.DeterTAV(dArray3, d31, dArray, dArray2, stringBuffer, n2, dArray11, stringBuffer3) == -1) {
                return -1;
            }
            if (this.DeterTAV(dArray3, d31 += d30, dArray, dArray2, stringBuffer, n2, dArray12, stringBuffer3) == -1) {
                return -1;
            }
            if (dArray12[0] > dArray11[0]) {
                d31 = d2;
                d30 = -d30;
                dArray13[0] = dArray11[0];
            } else {
                dArray13[0] = dArray12[0];
                dArray12[0] = dArray11[0];
            }
            do {
                dArray11[0] = dArray12[0];
                dArray12[0] = dArray13[0];
                if (this.DeterTAV(dArray3, d31 += d30, dArray, dArray2, stringBuffer, n2, dArray13, stringBuffer3) == -1) {
                    return -1;
                }
                if (!(dArray12[0] < dArray13[0])) continue;
                double d32 = this.x2min(dArray13[0], dArray12[0], dArray11[0]);
                d7 = d31 - (1.0 - d32) * d30;
            } while (d7 == 0.0);
            d2 = d7;
        }
        if ((n2 & 0x10000) != 0) {
            double d33;
            double d34;
            do {
                d33 = d2;
                d3 = (d2 -= d29) + this.DeltaT(d2, 0) / 86400.0;
                if (n5 != -1 ? (n3 = this.sw.swe_calc(d3, n5, n7, dArray5, stringBuffer3)) == -1 : (n3 = this.call_swe_fixstar(stringBuffer, d3, n7, dArray5, stringBuffer3)) == -1) {
                    return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
                }
                dArray6[0] = dArray5[0];
                dArray6[1] = dArray5[1];
                this.sc.swe_azalt(d2, 1, dArray, d8, d9, dArray6, dArray7);
            } while ((d34 = dArray7[1]) > 0.0);
            d2 = (d2 + d33) / 2.0;
        }
        if (d2 < -9999999.0 || d2 > 9999999.0) {
            dArray4[0] = d10;
            stringBuffer3.setLength(0);
            stringBuffer3.append("no heliacal date found");
            n3 = -1;
            return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
        }
        dArray4[0] = d2;
        return this.goto_swe_heliacal_err1(stringBuffer3, stringBuffer2, n3);
    }

    private int goto_swe_heliacal_err1(StringBuffer stringBuffer, StringBuffer stringBuffer2, int n) {
        if (stringBuffer2 != null && stringBuffer.length() != 0) {
            stringBuffer2.setLength(0);
            stringBuffer2.append(stringBuffer);
        }
        return n;
    }

    private int get_asc_obl(double d, int n, String string, int n2, double[] dArray, boolean bl, double[] dArray2, StringBuffer stringBuffer) {
        return this.get_asc_obl(d, n, new StringBuffer(string), n2, dArray, bl, dArray2, stringBuffer);
    }

    private int get_asc_obl(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, boolean bl, double[] dArray2, StringBuffer stringBuffer2) {
        int n3;
        int n4;
        int n5 = n2 & 7;
        double[] dArray3 = new double[6];
        String string = "";
        StringBuffer stringBuffer3 = new StringBuffer(stringBuffer);
        if (n == -1 ? (n4 = this.sw.swe_fixstar(stringBuffer3, d, n5 | 0x800, dArray3, stringBuffer2)) == -1 : (n3 = this.sw.swe_calc(d, n, n5 | 0x800, dArray3, stringBuffer2)) == -1) {
            return -1;
        }
        double d2 = SMath.tan(dArray[1] * 0.0174532925199433) * SMath.tan(dArray3[1] * 0.0174532925199433);
        if (SMath.abs(d2) > 1.0) {
            string = stringBuffer != null && stringBuffer.length() > 0 ? stringBuffer.toString() : this.sw.swe_get_planet_name(n);
            stringBuffer2.setLength(0);
            stringBuffer2.append(string + " is circumpolar, cannot calculate heliacal event");
            return -2;
        }
        d2 = SMath.asin(d2) / 0.0174532925199433;
        dArray2[0] = bl ? dArray3[0] + d2 : dArray3[0] - d2;
        dArray2[0] = this.sl.swe_degnorm(dArray2[0]);
        return 0;
    }

    private int get_asc_obl_diff(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, boolean bl, boolean bl2, double[] dArray2, StringBuffer stringBuffer2) {
        int n3 = 0;
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        n3 = this.get_asc_obl(d, 0, "", n2, dArray, bl, dArray3, stringBuffer2);
        if (n3 != 0) {
            return n3;
        }
        if (bl2) {
            bl = !bl;
        }
        if ((n3 = this.get_asc_obl(d, n, stringBuffer, n2, dArray, bl, dArray4, stringBuffer2)) != 0) {
            return n3;
        }
        dArray2[0] = this.sl.swe_degnorm(dArray3[0] - dArray4[0]);
        if (bl2) {
            dArray2[0] = this.sl.swe_degnorm(dArray2[0] - 180.0);
        }
        if (dArray2[0] > 180.0) {
            dArray2[0] = dArray2[0] - 360.0;
        }
        return 0;
    }

    private int find_conjunct_sun(double d, int n, int n2, int n3, double[] dArray, StringBuffer stringBuffer) {
        int n4 = n2 & 7;
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double d2 = 0.0;
        if (n >= 4 && n3 >= 3) {
            d2 = 180.0;
        }
        int n5 = (n3 - 1) / 2 + n * 2;
        double d3 = this.tcon[n5];
        double d4 = this.get_synodic_period(n);
        double d5 = d3 + (SMath.floor((d - d3) / d4) + 1.0) * d4;
        double d6 = 100.0;
        while (d6 > 0.5) {
            if (this.sw.swe_calc(d5, n, n4 | 0x100, dArray2, stringBuffer) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d5, 0, n4 | 0x100, dArray3, stringBuffer) == -1) {
                return -1;
            }
            d6 = this.sl.swe_degnorm(dArray2[0] - dArray3[0] - d2);
            if (d6 > 180.0) {
                d6 -= 360.0;
            }
            d5 -= d6 / (dArray2[3] - dArray3[3]);
        }
        dArray[0] = d5;
        return 0;
    }

    private int get_asc_obl_with_sun(double d, int n, StringBuffer stringBuffer, int n2, int n3, double d2, double[] dArray, double[] dArray2, StringBuffer stringBuffer2) {
        boolean bl = false;
        int n4 = n2 & 7;
        double[] dArray3 = new double[]{1.0};
        double[] dArray4 = new double[1];
        boolean bl2 = false;
        boolean bl3 = false;
        if (n3 == 2 || n3 == 3) {
            bl2 = true;
        }
        if (n3 == 1 || n3 == 2) {
            bl3 = true;
        }
        if (n3 == 5) {
            bl2 = true;
        }
        if (n3 == 5 || n3 == 6) {
            bl = true;
            if (n != 1) {
                bl3 = true;
            }
        }
        double d3 = d;
        double d4 = -9.99999999E8;
        int n5 = this.get_asc_obl_diff(d3, n, stringBuffer, n4, dArray, bl2, bl, dArray3, stringBuffer2);
        if (n5 != 0) {
            return n5;
        }
        double d5 = 20.0;
        int n6 = 0;
        while (!(d4 != -9.99999999E8 && !(SMath.abs(dArray3[0]) + SMath.abs(d4) > 180.0) && (!bl3 || d4 < 0.0 && dArray3[0] >= 0.0) && (bl3 || d4 >= 0.0 && dArray3[0] < 0.0))) {
            if (++n6 > 5000) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("loop in get_asc_obl_with_sun() (1)");
                return -1;
            }
            d4 = dArray3[0];
            d3 += 10.0;
            if (d2 > 0.0 && d3 - d > d2) {
                return -2;
            }
            n5 = this.get_asc_obl_diff(d3, n, stringBuffer, n4, dArray, bl2, bl, dArray3, stringBuffer2);
            if (n5 == 0) continue;
            return n5;
        }
        d = d3 - d5;
        n5 = this.get_asc_obl_diff(d3 = d + (d5 /= 2.0), n, stringBuffer, n4, dArray, bl2, bl, dArray4, stringBuffer2);
        if (n5 != 0) {
            return n5;
        }
        n6 = 0;
        while (SMath.abs(dArray3[0]) > 1.0E-5) {
            if (++n6 > 5000) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("loop in get_asc_obl_with_sun() (2)");
                return -1;
            }
            if (d4 * dArray4[0] >= 0.0) {
                d4 = dArray4[0];
                d = d3;
            } else {
                dArray3[0] = dArray4[0];
            }
            if ((n5 = this.get_asc_obl_diff(d3 = d + (d5 /= 2.0), n, stringBuffer, n4, dArray, bl2, bl, dArray4, stringBuffer2)) == 0) continue;
            return n5;
        }
        dArray2[0] = d3;
        return 0;
    }

    private int get_heliacal_day(double d, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, int n2, double[] dArray4, StringBuffer stringBuffer2) {
        double d2;
        int n3;
        int n4 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[30];
        double[] dArray7 = new double[1];
        int n5 = this.DeterObject(stringBuffer);
        switch (n2) {
            case 1: {
                n4 = 1;
                d3 = 1.0;
                d4 = -1.0;
                break;
            }
            case 2: {
                n4 = 2;
                d3 = -1.0;
                d4 = 1.0;
                break;
            }
            case 3: {
                n4 = 2;
                d3 = 1.0;
                d4 = 1.0;
                break;
            }
            case 4: {
                n4 = 1;
                d3 = -1.0;
                d4 = -1.0;
            }
        }
        double d5 = 1.0;
        switch (n5) {
            case 1: {
                n3 = 16;
                d2 = 1.0;
                break;
            }
            case 2: {
                n3 = 60;
                d -= 0.0 * d3;
                d2 = 5.0;
                d5 = 5.0;
                break;
            }
            case 3: {
                n3 = 300;
                d -= 30.0 * d3;
                d2 = 5.0;
                if (n2 < 3) break;
                d2 = 15.0;
                d5 = 3.0;
                break;
            }
            case 4: {
                n3 = 400;
                d2 = 15.0;
                d5 = 5.0;
                break;
            }
            case 6: {
                n3 = 300;
                d2 = 20.0;
                d5 = 5.0;
                break;
            }
            case -1: {
                n3 = 300;
                if (this.call_swe_fixstar_mag(stringBuffer, dArray7, 0, stringBuffer2) == -1) {
                    return -1;
                }
                d2 = 15.0;
                d5 = 10.0;
                if (dArray7[0] > 2.0) {
                    d2 = 15.0;
                }
                if (!(dArray7[0] < 0.0)) break;
                d5 = 3.0;
                break;
            }
            default: {
                n3 = 300;
                d2 = 15.0;
                d5 = 3.0;
            }
        }
        double d6 = d + (double)n3 * d3;
        int n6 = -2;
        for (double d7 = d; d3 > 0.0 && d7 < d6 || d3 < 0.0 && d7 > d6; d7 += d2 * d3) {
            double d8 = -100.0;
            int n7 = this.my_rise_trans(d7, 0, "", n4, n, dArray, dArray2, dArray5, stringBuffer2);
            if (n7 == -1) {
                return -1;
            }
            if (n7 == -2) {
                n6 = n7;
                continue;
            }
            n7 = this.swe_vis_limit_mag(dArray5[0], dArray, dArray2, dArray3, stringBuffer, n, dArray6, stringBuffer2);
            if (n7 == -1) {
                return -1;
            }
            if (n6 == -2 && n7 >= 0 && d2 > 1.0) {
                n6 = n7;
                d7 -= d2 * d3;
                d2 = 1.0;
                if (n5 < 4 && n5 != -1) continue;
                d2 = 5.0;
                continue;
            }
            n6 = n7;
            if (n7 == -2) continue;
            d8 = dArray6[0] - dArray6[7];
            while (n7 != -2) {
                double d9;
                double d10 = dArray6[0] - dArray6[7];
                if (!(d9 < 0.0)) break;
                dArray5[0] = d10 < -1.0 ? dArray5[0] + 0.003472222222222222 * d4 * d5 : (d10 < -0.5 ? dArray5[0] + 0.001388888888888889 * d4 * d5 : (d10 < -0.1 ? dArray5[0] + 6.944444444444445E-4 * d4 * d5 : dArray5[0] + 6.944444444444445E-4 * d4));
                n7 = this.swe_vis_limit_mag(dArray5[0], dArray, dArray2, dArray3, stringBuffer, n, dArray6, stringBuffer2);
                if (n7 != -1) continue;
                return -1;
            }
            if (!((d8 = dArray6[0] - dArray6[7]) > 0.0)) continue;
            if ((n5 >= 4 || n5 == -1) && d2 > 1.0) {
                d7 -= d2 * d3;
                d2 = 1.0;
                continue;
            }
            dArray4[0] = dArray5[0];
            return 0;
        }
        stringBuffer2.setLength(0);
        stringBuffer2.append("heliacal event does not happen");
        return -2;
    }

    private int time_optimum_visibility(double d, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, double[] dArray4, int n2, StringBuffer stringBuffer2) {
        double[] dArray5 = new double[10];
        dArray4[n2] = d;
        int n3 = this.swe_vis_limit_mag(d, dArray, dArray2, dArray3, stringBuffer, n, dArray5, stringBuffer2);
        if (n3 == -1) {
            return -1;
        }
        int n4 = n3;
        double d2 = dArray5[0] - dArray5[7];
        double d3 = n3 & 1;
        int n5 = 0;
        double d4 = 0.0011574074074074073;
        while (n5 < 3) {
            while ((n3 = this.swe_vis_limit_mag(d - d4, dArray, dArray2, dArray3, stringBuffer, n, dArray5, stringBuffer2)) >= 0 && dArray5[0] > dArray5[7] && dArray5[0] - dArray5[7] > d2) {
                d -= d4;
                d2 = dArray5[0] - dArray5[7];
                n4 = n3;
                d3 = n3 & 1;
            }
            if (n3 == -1) {
                return -1;
            }
            while ((n3 = this.swe_vis_limit_mag(d + d4, dArray, dArray2, dArray3, stringBuffer, n, dArray5, stringBuffer2)) >= 0 && dArray5[0] > dArray5[7] && dArray5[0] - dArray5[7] > d2) {
                d += d4;
                d2 = dArray5[0] - dArray5[7];
                n4 = n3;
                d3 = n3 & 1;
            }
            if (n3 == -1) {
                return -1;
            }
            ++n5;
            d4 /= 10.0;
        }
        dArray4[n2] = d;
        if (n3 >= 0) {
            double d5 = n3 & 1;
            if (d3 != d5) {
                return -2;
            }
            if ((n4 & 2) != 0) {
                return -2;
            }
        }
        return 0;
    }

    private int time_limit_invisible(double d, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, int n2, double[] dArray4, int n3, StringBuffer stringBuffer2) {
        int n4;
        int n5 = 3;
        double d2 = 0.0;
        double[] dArray5 = new double[10];
        double d3 = 0.0011574074074074073;
        dArray4[n3] = d;
        if (stringBuffer.toString().equals("moon")) {
            d3 *= 10.0;
            n5 = 4;
        }
        if ((n4 = this.swe_vis_limit_mag(d + d2 * (double)n2, dArray, dArray2, dArray3, stringBuffer, n, dArray5, stringBuffer2)) == -1) {
            return -1;
        }
        int n6 = n4;
        double d4 = n4 & 1;
        int n7 = 0;
        d2 = d3;
        while (n7 < n5) {
            while ((n4 = this.swe_vis_limit_mag(d + d2 * (double)n2, dArray, dArray2, dArray3, stringBuffer, n, dArray5, stringBuffer2)) >= 0 && dArray5[0] > dArray5[7]) {
                d += d2 * (double)n2;
                n6 = n4;
                d4 = n4 & 1;
            }
            ++n7;
            d2 /= 10.0;
        }
        dArray4[n3] = d;
        stringBuffer2.setLength(0);
        if (n4 >= 0) {
            double d5 = n4 & 1;
            if (d4 != d5) {
                return -2;
            }
            if ((n6 & 2) != 0) {
                return -2;
            }
        }
        return 0;
    }

    private int get_acronychal_day(double d, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, int n2, double[] dArray4, StringBuffer stringBuffer2) {
        int n3;
        int n4;
        double[] dArray5 = new double[]{d};
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        double[] dArray8 = new double[30];
        int n5 = this.DeterObject(stringBuffer);
        n |= 0x4000;
        if (n2 == 3 || n2 == 5) {
            n4 = 1;
            n3 = -1;
        } else {
            n4 = 2;
            n3 = 1;
        }
        double d2 = 999.0;
        while (SMath.abs(d2) > 3.4722222222222224E-4) {
            int n6;
            dArray5[0] = dArray5[0] + 0.7 * (double)n3;
            if (n3 < 0) {
                dArray5[0] = dArray5[0] - 1.0;
            }
            if ((n6 = this.my_rise_trans(dArray5[0], n5, stringBuffer.toString(), n4, n, dArray, dArray2, dArray5, stringBuffer2)) == -1) {
                return -1;
            }
            n6 = this.swe_vis_limit_mag(dArray5[0], dArray, dArray2, dArray3, stringBuffer, n, dArray8, stringBuffer2);
            while (dArray8[0] < dArray8[7]) {
                dArray5[0] = dArray5[0] + 0.006944444444444444 * (double)(-n3);
                n6 = this.swe_vis_limit_mag(dArray5[0], dArray, dArray2, dArray3, stringBuffer, n, dArray8, stringBuffer2);
            }
            n6 = this.time_limit_invisible(dArray5[0], dArray, dArray2, dArray3, stringBuffer, n | 0x1000, n3, dArray7, 0, stringBuffer2);
            if (n6 == -1) {
                return -1;
            }
            n6 = this.time_limit_invisible(dArray5[0], dArray, dArray2, dArray3, stringBuffer, n | 0x2000, n3, dArray6, 0, stringBuffer2);
            if (n6 == -1) {
                return -1;
            }
            d2 = SMath.abs(dArray6[0] - dArray7[0]);
        }
        if (this.azalt_cart(dArray6[0], dArray, dArray2, new StringBuffer("sun"), n, dArray8, stringBuffer2) == -1) {
            return -1;
        }
        dArray4[0] = dArray6[0];
        if (dArray8[1] < -12.0) {
            stringBuffer2.setLength(0);
            stringBuffer2.append("acronychal rising/setting not available, " + dArray8[1]);
            return 0;
        }
        stringBuffer2.setLength(0);
        stringBuffer2.append("solar altitude, " + dArray8[1]);
        return 0;
    }

    private int get_heliacal_details(double d, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, int n2, double[] dArray4, StringBuffer stringBuffer2) {
        boolean bl = false;
        int n3 = this.time_optimum_visibility(d, dArray, dArray2, dArray3, stringBuffer, n2, dArray4, 1, stringBuffer2);
        if (n3 == -1) {
            return -1;
        }
        if (n3 == -2) {
            n3 = 0;
            bl = true;
        }
        int n4 = 1;
        if (n == 1 || n == 4) {
            n4 = -1;
        }
        boolean bl2 = false;
        n3 = this.time_limit_invisible(d, dArray, dArray2, dArray3, stringBuffer, n2, n4, dArray4, 0, stringBuffer2);
        if (n3 == -1) {
            return -1;
        }
        if (n3 == -2) {
            n3 = 0;
            bl2 = true;
        }
        boolean bl3 = false;
        n3 = this.time_limit_invisible(dArray4[1], dArray, dArray2, dArray3, stringBuffer, n2, n4 *= -1, dArray4, 2, stringBuffer2);
        if (n3 == -1) {
            return -1;
        }
        if (n3 == -2) {
            n3 = 0;
            bl3 = true;
        }
        if (n == 2 || n == 3) {
            d = dArray4[2];
            dArray4[2] = dArray4[0];
            dArray4[0] = d;
            boolean bl4 = bl2;
            bl2 = bl3;
            boolean bl5 = bl3 = bl4;
        }
        if (bl || bl2 || bl3) {
            stringBuffer2.setLength(0);
            stringBuffer2.append("return values [");
            if (bl2) {
                stringBuffer2.append("0,");
            }
            if (bl) {
                stringBuffer2.append("1,");
            }
            if (bl3) {
                stringBuffer2.append("2,");
            }
            stringBuffer2.append("] are uncertain due to change between photopic and scotopic vision");
        }
        return 0;
    }

    private int heliacal_ut_vis_lim(double d, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, int n2, double[] dArray4, StringBuffer stringBuffer2) {
        double[] dArray5 = new double[10];
        double d2 = 1.0;
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        int n3 = 0;
        int n4 = n;
        StringBuffer stringBuffer3 = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            dArray4[i] = 0.0;
        }
        dArray4[0] = d;
        int n5 = this.DeterObject(stringBuffer);
        int n6 = n2 & 7;
        int n7 = 0x8800 | n6;
        if ((n2 & 0x100) == 0) {
            n7 |= 0x50;
        }
        dArray6[0] = n5 == 2 ? d - 30.0 : d - 50.0;
        int n8 = n2;
        if (n5 == 2 || n5 == 3 || n4 <= 2) {
            if (n5 == -1 ? (n3 = this.get_asc_obl_with_sun(dArray6[0], n5, stringBuffer, n2, n4, 0.0, dArray, dArray6, stringBuffer3)) != 0 : (n3 = this.find_conjunct_sun(dArray6[0], n5, n2, n4, dArray6, stringBuffer3)) == -1) {
                return this.goto_swe_heliacal_err2(stringBuffer3, stringBuffer2, n3);
            }
            n3 = this.get_heliacal_day(dArray6[0], dArray, dArray2, dArray3, stringBuffer, n8, n4, dArray7, stringBuffer3);
            if (n3 != 0) {
                return this.goto_swe_heliacal_err2(stringBuffer3, stringBuffer2, n3);
            }
        } else {
            n3 = this.get_asc_obl_with_sun(dArray6[0], n5, stringBuffer, n2, n4, 0.0, dArray, dArray6, stringBuffer3);
            if (n3 != 0) {
                return this.goto_swe_heliacal_err2(stringBuffer3, stringBuffer2, n3);
            }
            dArray7 = dArray6;
            n3 = this.get_acronychal_day(dArray6[0], dArray, dArray2, dArray3, stringBuffer, n8, n4, dArray7, stringBuffer3);
            if (n3 != 0) {
                return this.goto_swe_heliacal_err2(stringBuffer3, stringBuffer2, n3);
            }
        }
        dArray4[0] = dArray7[0];
        if ((n2 & 0x400) == 0 && (n5 == 2 || n5 == 3 || n4 <= 2) && (n3 = this.get_heliacal_details(dArray7[0], dArray, dArray2, dArray3, stringBuffer, n4, n8, dArray4, stringBuffer3)) == -1) {
            return this.goto_swe_heliacal_err2(stringBuffer3, stringBuffer2, n3);
        }
        return this.goto_swe_heliacal_err2(stringBuffer3, stringBuffer2, n3);
    }

    int goto_swe_heliacal_err2(StringBuffer stringBuffer, StringBuffer stringBuffer2, int n) {
        if (stringBuffer2 != null && stringBuffer.length() != 0) {
            stringBuffer2.append(stringBuffer);
        }
        return n;
    }

    private int moon_event_vis_lim(double d, double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, double[] dArray4, StringBuffer stringBuffer) {
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n3 = n2 & 7;
        dArray4[0] = d;
        if (n == 1 || n == 2) {
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("error: the moon has no morning first or evening last");
            }
            return -1;
        }
        stringBuffer3.append("moon");
        int n4 = 1;
        int n5 = 0x8800 | n3;
        if ((n2 & 0x100) == 0) {
            n5 |= 0x50;
        }
        int n6 = n2;
        n6 &= 0xFFFFFEFF;
        dArray5[0] = d - 30.0;
        int n7 = this.find_conjunct_sun(dArray5[0], n4, n2, n, dArray5, stringBuffer2);
        if (n7 == -1) {
            return -1;
        }
        n7 = this.get_heliacal_day(dArray5[0], dArray, dArray2, dArray3, stringBuffer3, n6, n, dArray5, stringBuffer2);
        if (n7 != 0) {
            return this.goto_moon_event_err(stringBuffer2, stringBuffer, n7);
        }
        dArray4[0] = dArray5[0];
        n7 = this.time_optimum_visibility(dArray5[0], dArray, dArray2, dArray3, stringBuffer3, n2, dArray5, 0, stringBuffer2);
        if (n7 == -1) {
            return this.goto_moon_event_err(stringBuffer2, stringBuffer, n7);
        }
        dArray4[1] = dArray5[0];
        int n8 = 1;
        if (n == 4) {
            n8 = -1;
        }
        if ((n7 = this.time_limit_invisible(dArray5[0], dArray, dArray2, dArray3, stringBuffer3, n2, n8, dArray5, 0, stringBuffer2)) == -1) {
            return this.goto_moon_event_err(stringBuffer2, stringBuffer, n7);
        }
        dArray4[2] = dArray5[0];
        n7 = this.time_limit_invisible(dArray4[1], dArray, dArray2, dArray3, stringBuffer3, n2, n8 *= -1, dArray5, 0, stringBuffer2);
        dArray4[0] = dArray5[0];
        if (n7 == -1) {
            return this.goto_moon_event_err(stringBuffer2, stringBuffer, n7);
        }
        if (n == 3) {
            n7 = this.my_rise_trans(dArray5[0], 0, "", 2, n2, dArray, dArray2, dArray6, stringBuffer2);
            if (n7 == -1) {
                return -1;
            }
            if (dArray6[0] < dArray4[1]) {
                dArray4[0] = dArray6[0];
            }
        } else {
            n7 = this.my_rise_trans(dArray4[1], 0, "", 1, n2, dArray, dArray2, dArray6, stringBuffer2);
            if (n7 == -1) {
                return -1;
            }
            if (dArray4[0] > dArray6[0]) {
                dArray4[0] = dArray6[0];
            }
        }
        if (n == 4) {
            dArray5[0] = dArray4[0];
            dArray4[0] = dArray4[2];
            dArray4[2] = dArray5[0];
        }
        return this.goto_moon_event_err(stringBuffer2, stringBuffer, n7);
    }

    int goto_moon_event_err(StringBuffer stringBuffer, StringBuffer stringBuffer2, int n) {
        if (stringBuffer2 != null && stringBuffer.length() != 0) {
            stringBuffer2.append(stringBuffer);
        }
        return n;
    }

    private int MoonEventJDut(double d, double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, double[] dArray4, StringBuffer stringBuffer) {
        int n3 = n2 & 0x78000;
        if (n3 != 0) {
            return this.moon_event_arc_vis(d, dArray, dArray2, dArray3, n, n2, dArray4, stringBuffer);
        }
        return this.moon_event_vis_lim(d, dArray, dArray2, dArray3, n, n2, dArray4, stringBuffer);
    }

    private int heliacal_ut(double d, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, int n2, double[] dArray4, StringBuffer stringBuffer2) {
        int n3 = n2 & 0x78000;
        if (n3 != 0) {
            return this.heliacal_ut_arc_vis(d, dArray, dArray2, dArray3, stringBuffer, n, n2, dArray4, stringBuffer2);
        }
        return this.heliacal_ut_vis_lim(d, dArray, dArray2, dArray3, stringBuffer, n, n2, dArray4, stringBuffer2);
    }

    public int swe_heliacal_ut(double d, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer, int n, int n2, double[] dArray4, StringBuffer stringBuffer2) {
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        double d2 = d;
        int n3 = 5;
        String[] stringArray = new String[]{"", "morning first", "evening last", "evening first", "morning last", "acronychal rising", "acronychal setting"};
        if (dArray[2] < -500.0 || dArray[2] > 25000.0) {
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append(String.format(Locale.US, "location for heliacal events must be between %.0f and %.0f m above sea", -500.0, 25000.0));
            }
            return -1;
        }
        SweDate.swi_set_tid_acc(d, n2, 0);
        if ((n2 & 0x80) != 0) {
            n3 = 1000000;
        }
        stringBuffer4.setLength(0);
        if (stringBuffer2 != null) {
            stringBuffer2.setLength(0);
        }
        this.strcpy_VBsafe(stringBuffer3, stringBuffer.toString());
        this.default_heliacal_parameters(dArray2, dArray, dArray3, n2);
        this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
        int n4 = this.DeterObject(stringBuffer3);
        if (n4 == 1) {
            if (n == 1 || n == 2) {
                if (stringBuffer2 != null) {
                    stringBuffer2.setLength(0);
                    stringBuffer2.append(stringArray[n] + " (event type " + n + ") does not exist for the moon\n");
                }
                return -1;
            }
            double d3 = d2;
            int n5 = this.MoonEventJDut(d3, dArray, dArray2, dArray3, n, n2, dArray4, stringBuffer4);
            while (n5 != -2 && dArray4[0] < d2) {
                stringBuffer4.setLength(0);
                n5 = this.MoonEventJDut(d3 += 15.0, dArray, dArray2, dArray3, n, n2, dArray4, stringBuffer4);
            }
            if (stringBuffer2 != null && stringBuffer4.length() != 0) {
                stringBuffer2.setLength(0);
                stringBuffer2.append(stringBuffer4);
            }
            return n5;
        }
        if (!((n2 & 0x78000) != 0 || n4 != -1 && n4 < 4 || n != 3 && n != 4)) {
            if (stringBuffer2 != null) {
                String string = n4 == -1 ? stringBuffer3.toString() : this.sw.swe_get_planet_name(n4);
                stringBuffer2.setLength(0);
                stringBuffer2.append(stringArray[n] + " (event type " + n + ") does not exist for " + string + "\n");
            }
            return -1;
        }
        if ((n2 & 0x78000) != 0) {
            if (n4 == -1 || n4 >= 4) {
                if (n == 5) {
                    n = 3;
                }
                if (n == 6) {
                    n = 4;
                }
            }
        } else if (n == 5 || n == 6) {
            if (stringBuffer2 != null) {
                String string = n4 == -1 ? stringBuffer3.toString() : this.sw.swe_get_planet_name(n4);
                stringBuffer2.setLength(0);
                stringBuffer2.append(stringArray[n] + " (event type " + n + ") is not provided for " + string + "\n");
            }
            return -1;
        }
        double d4 = this.get_synodic_period(n4);
        double d5 = d2 + d4 * (double)n3;
        double d6 = d4 * 0.6;
        if (n4 == 2) {
            d6 = 30.0;
        }
        int n6 = -2;
        int n7 = 0;
        for (double d7 = d2; d7 < d5 && n6 == -2; d7 += d6) {
            stringBuffer4.setLength(0);
            n6 = this.heliacal_ut(d7, dArray, dArray2, dArray3, stringBuffer3, n, n2, dArray4, stringBuffer4);
            while (n6 != -2 && dArray4[0] < d2) {
                stringBuffer4.setLength(0);
                n6 = this.heliacal_ut(d7 += d6, dArray, dArray2, dArray3, stringBuffer3, n, n2, dArray4, stringBuffer4);
            }
            ++n7;
        }
        if ((n2 & 0x800) != 0 && (n6 == -2 || dArray4[0] > d2 + d4 * 1.5)) {
            stringBuffer4.setLength(0);
            stringBuffer4.append("no heliacal date found within this synodic period");
            n6 = -2;
        } else if (n6 == -2) {
            stringBuffer4.setLength(0);
            stringBuffer4.append("no heliacal date found within " + n3 + " synodic periods");
            n6 = -1;
        }
        if (stringBuffer2 != null && stringBuffer4.length() != 0) {
            stringBuffer2.setLength(0);
            stringBuffer2.append(stringBuffer4);
        }
        return n6;
    }
}

