/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.Serializable;
import swisseph.SMath;
import swisseph.SwissEph;
import swisseph.SwissephException;
import swisseph.TransitCalculator;

class Extensions
implements Serializable {
    SwissEph sw;
    protected double[] maxBaryDist = new double[]{0.009570999, 1.028809521, 0.466604085, 0.728698831, 0.728698831, 4.955912195, 8.968685733, 19.893326756, 30.326750627, 41.499626899, 0.002569555, 0.002774851, 1.0, 0.002782378, 0.0, 0.05, 31.901319663, 3.012409508, 3.721614106, 3.326307148, 2.570197288};

    Extensions(SwissEph swissEph) {
        this.sw = swissEph;
    }

    double getTransit(TransitCalculator transitCalculator, double d, boolean bl, double d2) throws IllegalArgumentException, SwissephException {
        boolean bl2;
        double d3;
        double d4;
        d = transitCalculator.preprocessDate(d, bl);
        double d5 = transitCalculator.getOffset();
        if (!transitCalculator.rollover) {
            d4 = transitCalculator.getMinOffset();
            d3 = transitCalculator.getMaxOffset();
            if (d5 < d4 || d5 > d3) {
                throw new SwissephException(d, 3072, "No transit possible due to offset out of range.");
            }
        }
        d4 = transitCalculator.getMaxSpeed();
        d3 = transitCalculator.getMinSpeed();
        double d6 = d;
        boolean bl3 = false;
        boolean bl4 = d4 < 0.0;
        boolean bl5 = bl2 = d3 < 0.0;
        if (!bl4 && !bl2) {
            d3 = d4;
        }
        if (bl4 && bl2) {
            d4 = d3;
        }
        double d7 = transitCalculator.getDegreePrecision(d) / 2.0;
        double d8 = transitCalculator.getTimePrecision(d7);
        double d9 = transitCalculator.calc(d);
        if (transitCalculator.checkIdenticalResult(d5, d9)) {
            return d9;
        }
        if (d4 == 0.0 && d3 == 0.0) {
            throw new SwissephException(d, 3072, "No transit possible due to lack of variation of speed or position.");
        }
        do {
            double d10;
            if (transitCalculator.rollover) {
                while (d9 >= transitCalculator.rolloverVal) {
                    d9 -= transitCalculator.rolloverVal;
                }
                while (d9 < 0.0) {
                    d9 += transitCalculator.rolloverVal;
                }
            }
            boolean bl6 = d9 >= d5;
            d6 = d;
            double d11 = d9;
            if (transitCalculator.rollover && !bl6) {
                d9 += transitCalculator.rolloverVal;
            }
            if (SMath.abs((d = transitCalculator.getNextJD(d, d9, d5, d3, d4, bl)) - d6) < d8) {
                d = d6 + (bl ? -d8 : d8);
            }
            if (d == d6) {
                return d;
            }
            d9 = transitCalculator.calc(d);
            if (d9 == Double.POSITIVE_INFINITY) {
                return d;
            }
            if (transitCalculator.rollover && d9 >= transitCalculator.rolloverVal) {
                d9 %= transitCalculator.rolloverVal;
            }
            while (transitCalculator.rollover && d9 < 0.0) {
                d9 += transitCalculator.rolloverVal;
            }
            if (transitCalculator.checkIdenticalResult(d5, d9)) {
                return d9;
            }
            boolean bl7 = true;
            if (transitCalculator.rollover) {
                double d12;
                d10 = d9 - d11;
                if (d10 < 0.0) {
                    d10 += transitCalculator.rolloverVal;
                }
                if ((d12 = d11 - d9) < 0.0) {
                    d12 += transitCalculator.rolloverVal;
                }
                bl7 = SMath.abs(d10 / d4) < SMath.abs(d12 / d3);
            } else {
                bl7 = d11 <= d9;
            }
            bl3 = transitCalculator.checkResult(d5, d11, d9, bl6, bl7);
            if (!bl3) continue;
            if (transitCalculator.rollover) {
                if (transitCalculator.rollover && SMath.abs(d9 - d11) > 300.0) {
                    if (d9 > d11) {
                        d11 += transitCalculator.rolloverVal;
                    } else {
                        d9 += transitCalculator.rolloverVal;
                    }
                    if (d5 < 10.0) {
                        d5 += transitCalculator.rolloverVal;
                    }
                }
                if (d9 - d11 < 0.0 && d5 - d11 > 0.0) {
                    d9 += transitCalculator.rolloverVal;
                } else if (d9 - d11 > 0.0 && d5 - d11 < 0.0) {
                    d5 += transitCalculator.rolloverVal;
                }
            }
            d10 = d6 + (d - d6) * (d5 - d11) / (d9 - d11);
            if (bl) {
                return SMath.max(d10, d);
            }
            return SMath.min(d10, d);
        } while (!(bl && d < d2) && (bl || !(d > d2)));
        throw new SwissephException(d, 786432, -1, "User time limit of " + d2 + " has been reached.");
    }
}

