/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRStyledText;

public class SimplePdfTextRenderer
extends AbstractPdfTextRenderer {
    private float yLine = 0.0f;

    public SimplePdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont) {
        this(jasperReportsContext, ignoreMissingFont, true, false);
    }

    public SimplePdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont, boolean defaultIndentFirstLine, boolean defaultJustifyLastLine) {
        super(jasperReportsContext, ignoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine);
    }

    @Override
    public void initialize(JRPdfExporter pdfExporter, PdfContentByte pdfContentByte, JRPrintText text, JRStyledText styledText, int offsetX, int offsetY) {
        super.initialize(pdfExporter, pdfContentByte, text, styledText, offsetX, offsetY);
        this.yLine = (float)(pdfExporter.getCurrentPageFormat().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset - text.getLeadingOffset();
    }

    @Override
    public void render() {
        super.render();
    }

    @Override
    protected void renderParagraph(AttributedCharacterIterator allParagraphs, int paragraphStart, String paragraphText) {
        AttributedString paragraph = null;
        if (paragraphText == null) {
            paragraphText = " ";
            paragraph = new AttributedString(paragraphText, new AttributedString(allParagraphs, paragraphStart, paragraphStart + paragraphText.length()).getIterator().getAttributes());
        } else {
            paragraph = new AttributedString(allParagraphs, paragraphStart, paragraphStart + paragraphText.length());
        }
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(this.pdfExporter.getPhrase(paragraph, paragraphText, this.text), (float)(this.x + this.leftPadding), this.yLine, (float)(this.x + this.width - this.rightPadding), (float)(this.pdfExporter.getCurrentPageFormat().getPageHeight() - this.y - this.height + this.bottomPadding), 0.0f, this.horizontalAlignment == 3 && this.isLastParagraph && this.justifyLastLine ? 8 : this.horizontalAlignment);
        colText.setLeading(0.0f, this.text.getLineSpacingFactor());
        colText.setRunDirection(this.text.getRunDirectionValue() == RunDirectionEnum.LTR ? 2 : 3);
        try {
            colText.go();
        }
        catch (DocumentException e) {
            throw new JRRuntimeException(e);
        }
        this.yLine = colText.getYLine();
    }

    @Override
    protected AttributedString getAttributedString() {
        return this.styledText.getAttributedString();
    }

    @Override
    public void draw() {
    }
}

